/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.ui;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IJ2eeProjectFilter;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.web.IClientSource;
import com.tssap.j2ee.model.web.IServerSource;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JspTab
extends JavaLaunchConfigurationTab {
    private static final String EMPTY_STRING = "";
    private static ILabelProvider j2eeLabelProvider = new J2eeModelLabelProvider();
    private static ILabelProvider woLabelProvider = new NodeWrapperLabelProvider();
    private String mode;
    private static final Image TAB_IMAGE = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"launch_config/web_object.gif");
    private Text earProjectName;
    private Button browseEarProject;
    private Button jspSelection;
    private Button servletSelection;
    private Text jspName;
    private Text jspFileName;
    private Text servletName;
    private Text servletQualName;
    private Text webModuleName;
    private Text webContextRoot;
    private Button browseJsp;
    private Button browseServlet;

    public JspTab(String mode) {
        this.mode = mode;
    }

    public void createControl(Composite parent) {
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)4);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            mainPane.getComposite().setLayoutData((Object)gd);
        }
        mainPane.setMargin(5, 5);
        mainPane.setSpacing(5, 5);
        mainPane.addPlaceholder(4, 1);
        mainPane.addTextLabel("Enterprise Application Project : ", mainPane.createGridLayoutData(4, 1));
        this.earProjectName = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        this.browseEarProject = mainPane.addPushButton("Browse ...");
        this.browseEarProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JspTab.this.doBrowseEarProject();
            }
        });
        mainPane.addPlaceholder(4, 1);
        SelectionAdapter jspServletListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JspTab.this.doHandleJspServletSelection();
            }
        };
        this.jspSelection = mainPane.addRadioButton("JSP ", mainPane.createGridLayoutData(1, 1, 1, 2));
        this.jspSelection.addSelectionListener((SelectionListener)jspServletListener);
        this.jspName = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        this.browseJsp = mainPane.addPushButton("Browse ...", mainPane.createGridLayoutData(1, 1, 1, 2));
        this.browseJsp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JspTab.this.doBrowseJsp();
            }
        });
        this.browseJsp.setEnabled(false);
        this.jspFileName = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        this.servletSelection = mainPane.addRadioButton("Servlet ", mainPane.createGridLayoutData(1, 1, 1, 2));
        this.servletSelection.addSelectionListener((SelectionListener)jspServletListener);
        this.servletName = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        this.browseServlet = mainPane.addPushButton("Browse ...", mainPane.createGridLayoutData(1, 1, 1, 5));
        this.browseServlet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JspTab.this.doBrowseServlet();
            }
        });
        this.browseServlet.setEnabled(false);
        this.servletQualName = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        mainPane.addTextLabel("Web Module : ");
        this.webModuleName = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, 2, 1));
        mainPane.addTextLabel("Context Root : ");
        this.webContextRoot = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, 2, 1));
        this.setControl((Control)mainPane.getComposite());
    }

    public String getName() {
        return "Web Object";
    }

    public Image getImage() {
        return TAB_IMAGE;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.earProjectName.setText(config.getAttribute("JSP.LAUNCH.EAR_PROJECT", EMPTY_STRING));
            this.webModuleName.setText(config.getAttribute("JSP.LAUNCH.WEB_MODULE", EMPTY_STRING));
            this.webContextRoot.setText(config.getAttribute("JSP.LAUNCH.WEB_APP_CONTEXT_ROOT", EMPTY_STRING));
            this.jspName.setText(config.getAttribute("JSP.LAUNCH.ATTR_JSP_NAME", EMPTY_STRING));
            this.jspFileName.setText(config.getAttribute("JSP.LAUNCH.ATTR_JSP_FILE_NAME", EMPTY_STRING));
            this.jspSelection.setSelection(config.getAttribute("JSP.LAUNCH.ATTR_JSP_SELECTED", false));
            this.browseJsp.setEnabled(config.getAttribute("JSP.LAUNCH.ATTR_JSP_SELECTED", false));
            this.servletName.setText(config.getAttribute("JSP.LAUNCH.ATTR_SERVLET_NAME", EMPTY_STRING));
            this.servletQualName.setText(config.getAttribute("JSP.LAUNCH.ATTR_SERVLET_QAUL_NAME", EMPTY_STRING));
            this.servletSelection.setSelection(config.getAttribute("JSP.LAUNCH.ATTR_SERVLET_SELECTED", false));
            this.browseServlet.setEnabled(config.getAttribute("JSP.LAUNCH.ATTR_SERVLET_SELECTED", false));
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException ex) {
            EnginePlugin.getTracer().warning("Could not initialize from configuration !", (Throwable)ex);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("JSP.LAUNCH.EAR_PROJECT", this.earProjectName.getText());
        configuration.setAttribute("JSP.LAUNCH.WEB_MODULE", this.webModuleName.getText());
        configuration.setAttribute("JSP.LAUNCH.WEB_APP_CONTEXT_ROOT", this.webContextRoot.getText());
        configuration.setAttribute("JSP.LAUNCH.ATTR_JSP_NAME", this.jspName.getText());
        configuration.setAttribute("JSP.LAUNCH.ATTR_JSP_FILE_NAME", this.jspFileName.getText());
        configuration.setAttribute("JSP.LAUNCH.ATTR_JSP_SELECTED", this.jspSelection.getSelection());
        configuration.setAttribute("JSP.LAUNCH.ATTR_SERVLET_NAME", this.servletName.getText());
        configuration.setAttribute("JSP.LAUNCH.ATTR_SERVLET_QAUL_NAME", this.servletQualName.getText());
        configuration.setAttribute("JSP.LAUNCH.ATTR_SERVLET_SELECTED", this.servletSelection.getSelection());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.webModuleName.getText());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean validFlag = true;
        this.setErrorMessage(null);
        if (this.earProjectName.getText().equals(EMPTY_STRING)) {
            this.setErrorMessage("Please choose an enterprise application !");
            validFlag = false;
        } else if (!this.jspSelection.getSelection() && !this.servletSelection.getSelection()) {
            this.setErrorMessage("Please choose either a jsp or a servlet !");
            validFlag = false;
        } else {
            if (this.jspSelection.getSelection() && this.jspName.getText().equals(EMPTY_STRING)) {
                this.setErrorMessage("Please select a jsp !");
                validFlag = false;
            }
            if (this.servletSelection.getSelection() && this.servletName.getText().equals(EMPTY_STRING)) {
                this.setErrorMessage("Please select a servlet !");
                validFlag = false;
            }
        }
        return validFlag;
    }

    private void doHandleJspServletSelection() {
        if (this.earProjectName.getText().equals(EMPTY_STRING)) {
            this.jspSelection.setSelection(false);
            this.servletSelection.setSelection(false);
        }
        this.jspName.setEnabled(this.jspSelection.getSelection());
        this.jspName.setText(EMPTY_STRING);
        this.jspFileName.setText(EMPTY_STRING);
        this.browseJsp.setEnabled(this.jspSelection.getSelection());
        this.servletName.setEnabled(this.servletSelection.getSelection());
        this.servletName.setText(EMPTY_STRING);
        this.servletQualName.setText(EMPTY_STRING);
        this.browseServlet.setEnabled(this.servletSelection.getSelection());
        this.webModuleName.setText(EMPTY_STRING);
        this.webContextRoot.setText(EMPTY_STRING);
    }

    private void doBrowseEarProject() {
        IEarProject selectedProject;
        Object[] projects = J2eeProjectManager.getEarProjects((IJ2eeProjectFilter)new IJ2eeProjectFilter(){

            public boolean accept(IJ2eeProject prj) {
                return prj instanceof IEarProject && EnginePlugin.getReferencedJsps((IEarProject)prj).length + EnginePlugin.getReferencedServlets((IEarProject)prj).length > 0;
            }
        });
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), j2eeLabelProvider);
        dialog.setTitle("Choose Ear Project");
        dialog.setMessage("Ear Project:");
        dialog.setElements(projects);
        dialog.setMultipleSelection(false);
        String selectEarProjectName = this.earProjectName.getText();
        IEarProject preSelectedProject = J2eeProjectManager.getEarProject((String)selectEarProjectName);
        if (preSelectedProject != null) {
            dialog.setInitialSelections(new Object[]{preSelectedProject});
        }
        if (dialog.open() == 0 && (selectedProject = (IEarProject)dialog.getFirstResult()) != null) {
            String projectName = selectedProject.getName();
            this.earProjectName.setText(projectName);
            this.jspSelection.setSelection(false);
            this.jspName.setText(EMPTY_STRING);
            this.jspFileName.setText(EMPTY_STRING);
            this.browseJsp.setEnabled(false);
            this.servletSelection.setSelection(false);
            this.servletName.setText(EMPTY_STRING);
            this.servletQualName.setText(EMPTY_STRING);
            this.browseServlet.setEnabled(false);
            this.webModuleName.setText(EMPTY_STRING);
            this.webContextRoot.setText(EMPTY_STRING);
            this.updateLaunchConfigurationDialog();
        }
    }

    private WebSourceInfo doBrowseJspOrServlet(String dialogTitle, String dialogText, WebObjectContentProvider contentProvider) {
        WebSourceInfo wsInfo = null;
        String earName = this.earProjectName.getText();
        IEarProject earProject = J2eeProjectManager.getEarProject((String)earName);
        if (earProject != null) {
            Object selectedSource;
            StructuredObjectSelectionDialog dialog = new StructuredObjectSelectionDialog(this.getShell(), dialogTitle, dialogText);
            dialog.setLabelProvider(woLabelProvider);
            dialog.setTreeInput((Object)"Any input");
            dialog.setExpandTreeLevel(5);
            dialog.setPreGrayedObjects(contentProvider.getGrayedElements());
            Object[] selectedSources = dialog.openDialog((ITreeContentProvider)contentProvider, false, 5);
            if (selectedSources != null && selectedSources.length > 0 && (selectedSource = selectedSources[0]) instanceof NodeWrapper) {
                NodeWrapper webSourceNode = (NodeWrapper)selectedSource;
                NodeWrapper embraceWebModNode = webSourceNode != null ? webSourceNode.getParent() : null;
                NodeWrapper embraceEarProjNode = embraceWebModNode != null ? embraceWebModNode.getParent() : null;
                String webModName = EMPTY_STRING;
                String webModContextRoot = EMPTY_STRING;
                IWebModule webModule = null;
                IEarProject earProj = null;
                if (webSourceNode.getContent() instanceof IClientSource) {
                    IClientSource clientSource = (IClientSource)webSourceNode.getContent();
                    String jspName = clientSource.getName();
                    webModName = clientSource.getProject().getName();
                    String jspUrlPart = clientSource.getFile().getProjectRelativePath().toString();
                    String WC_FOLDER = "webContent/";
                    if (jspUrlPart.startsWith("webContent/")) {
                        jspUrlPart = jspUrlPart.substring("webContent/".length());
                    }
                    wsInfo = new WebSourceInfo(jspName, jspUrlPart);
                }
                if (webSourceNode.getContent() instanceof IServerSource) {
                    IServerSource serverSource = (IServerSource)webSourceNode.getContent();
                    String servletName = serverSource.getName();
                    webModName = serverSource.getProject().getName();
                    String servletUrlPart = serverSource.getIType().getFullyQualifiedName();
                    wsInfo = new WebSourceInfo(servletName, servletUrlPart);
                }
                if (embraceWebModNode.getContent() instanceof IWebModule) {
                    webModule = (IWebModule)embraceWebModNode.getContent();
                    webModName = webModule.getName();
                }
                if (embraceEarProjNode.getContent() instanceof IEarProject && (earProj = (IEarProject)embraceEarProjNode.getContent()) != null && webModule != null && earProj.getModule((IJ2eeProject)webModule) != null && earProj.getModule((IJ2eeProject)webModule).getWeb() != null && earProj.getModule((IJ2eeProject)webModule).getWeb().getContextRoot().getValue() != null) {
                    webModContextRoot = earProj.getModule((IJ2eeProject)webModule).getWeb().getContextRoot().getValue();
                }
                this.webModuleName.setText(webModName);
                this.webContextRoot.setText(webModContextRoot);
            }
        }
        return wsInfo;
    }

    private void doBrowseJsp() {
        WebSourceInfo selectedWS;
        String earName = this.earProjectName.getText();
        IEarProject earProj = J2eeProjectManager.getEarProject((String)earName);
        if (earProj != null && (selectedWS = this.doBrowseJspOrServlet("Choose Jsp", "Jsp :", new JspContentProvider(earProj))) != null) {
            this.jspName.setText(selectedWS.getName());
            this.jspFileName.setText(selectedWS.getUrlPart());
            this.updateLaunchConfigurationDialog();
        }
    }

    private void doBrowseServlet() {
        WebSourceInfo selectedWS;
        String earName = this.earProjectName.getText();
        IEarProject earProj = J2eeProjectManager.getEarProject((String)earName);
        if (earProj != null && (selectedWS = this.doBrowseJspOrServlet("Choose Servlet", "Servlet :", new ServletContentProvider(earProj))) != null) {
            this.servletName.setText(selectedWS.getName());
            this.servletQualName.setText(selectedWS.getUrlPart());
            this.updateLaunchConfigurationDialog();
        }
    }

    private static class WebSourceInfo {
        private String name;
        private String urlPart;

        public WebSourceInfo(String name, String urlPart) {
            this.name = name;
            this.urlPart = urlPart;
        }

        public String getName() {
            return this.name;
        }

        public String getUrlPart() {
            return this.urlPart;
        }
    }

    private static class NodeWrapperLabelProvider
    extends LabelProvider {
        private NodeWrapperLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof NodeWrapper) {
                NodeWrapper node = (NodeWrapper)element;
                image = j2eeLabelProvider.getImage(node.getContent());
            }
            return image;
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof NodeWrapper) {
                NodeWrapper node = (NodeWrapper)element;
                text = j2eeLabelProvider.getText(node.getContent());
            } else {
                text = " ??? ";
            }
            return text;
        }
    }

    private static class NodeWrapper {
        private Object content;
        private NodeWrapper parent;
        private boolean hasChildren;

        public NodeWrapper(Object content, NodeWrapper parent, boolean hasChildren) {
            this.content = content;
            this.parent = parent;
            this.hasChildren = hasChildren;
        }

        public Object getContent() {
            return this.content;
        }

        public boolean hasChildren() {
            return this.hasChildren;
        }

        public NodeWrapper getParent() {
            return this.parent;
        }
    }

    private static class ServletContentProvider
    extends WebObjectContentProvider {
        public ServletContentProvider(IEarProject earProject) {
            super(earProject);
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = null;
            if (parentElement instanceof NodeWrapper) {
                NodeWrapper parentNode = (NodeWrapper)parentElement;
                if (parentNode.getContent() instanceof IWebModule) {
                    IWebModule webModule = (IWebModule)((NodeWrapper)parentElement).getContent();
                    IServerSource[] realChildren = webModule.getReferencedServerSources(3);
                    NodeWrapper[] wrappedChildren = new NodeWrapper[realChildren.length];
                    int i = 0;
                    while (i < realChildren.length) {
                        wrappedChildren[i] = new NodeWrapper(realChildren[i], parentNode, false);
                        ++i;
                    }
                    children = wrappedChildren;
                } else {
                    children = super.getChildren(parentElement);
                }
            }
            return children;
        }
    }

    private static class JspContentProvider
    extends WebObjectContentProvider {
        public JspContentProvider(IEarProject earProject) {
            super(earProject);
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = null;
            if (parentElement instanceof NodeWrapper) {
                NodeWrapper parentNode = (NodeWrapper)parentElement;
                if (parentNode.getContent() instanceof IWebModule) {
                    IWebModule webMod = (IWebModule)((NodeWrapper)parentElement).getContent();
                    IClientSource[] realChildren = webMod.getReferencedClientSources(10);
                    NodeWrapper[] wrappedChildren = new NodeWrapper[realChildren.length];
                    int i = 0;
                    while (i < realChildren.length) {
                        wrappedChildren[i] = new NodeWrapper(realChildren[i], parentNode, false);
                        ++i;
                    }
                    children = wrappedChildren;
                } else {
                    children = super.getChildren(parentElement);
                }
            }
            return children;
        }
    }

    private static class WebObjectContentProvider
    implements ITreeContentProvider {
        private NodeWrapper earProjectNode;
        private NodeWrapper[] webModuleNodes;

        public WebObjectContentProvider(IEarProject earProject) {
            this.earProjectNode = new NodeWrapper(earProject, null, true);
            IWebModule[] webModules = earProject.getReferencedWebModules();
            this.webModuleNodes = new NodeWrapper[webModules.length];
            int i = 0;
            while (i < webModules.length) {
                this.webModuleNodes[i] = new NodeWrapper(webModules[i], this.earProjectNode, true);
                ++i;
            }
        }

        public Object[] getChildren(Object parentElement) {
            NodeWrapper[] children = null;
            if (parentElement.equals(this.earProjectNode)) {
                children = this.webModuleNodes;
            }
            return children;
        }

        public Object getParent(Object element) {
            NodeWrapper parent = null;
            if (element instanceof NodeWrapper) {
                parent = ((NodeWrapper)element).getParent();
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            return true;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new Object[]{this.earProjectNode};
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getGrayedElements() {
            ArrayList<NodeWrapper> elList = new ArrayList<NodeWrapper>();
            elList.add(this.earProjectNode);
            int wap = 0;
            while (wap < this.webModuleNodes.length) {
                elList.add(this.webModuleNodes[wap]);
                ++wap;
            }
            return elList.toArray();
        }
    }
}

