/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.ui;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.debug.SourceLocation;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.swt.program.Program;

public class JspLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final char URL_SEPARATOR = '/';
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTM_EXTENSION = "htm";
    private static final String SERVLET_PATH = "servlet/";
    private static final String URL_DEFAULT_PART = "???";
    private IJavaProject project;
    private static ILaunch currentLaunch = null;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$engine$ui$JspLaunchMainClass;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        URL url2call = this.createURL(configuration);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (mode.equals("debug")) {
            monitor.beginTask(LaunchingMessages.getString((String)"JavaRemoteApplicationLaunchConfigurationDelegate.Connecting..._1"), -1);
            if (this.isConnected()) {
                this.disconnect();
            }
            this.connect(configuration, launch, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            this.startExplorer(url2call.toString());
            this.setDefaultSourceLocator(launch, configuration);
            EnginePlugin.getDefault().setCurrentDebuggedProject(JavaRuntime.getJavaProject((ILaunchConfiguration)configuration));
        }
        if (mode.equals("run")) {
            monitor.beginTask(MessageFormat.format(LaunchingMessages.getString((String)"JavaLocalApplicationLaunchConfigurationDelegate.Launching_{0}..._1"), configuration.getName()), 3);
            String mainTypeName = (class$com$sap$ide$eclipse$j2ee$engine$ui$JspLaunchMainClass == null ? (class$com$sap$ide$eclipse$j2ee$engine$ui$JspLaunchMainClass = JspLaunchConfigurationDelegate.class$("com.sap.ide.eclipse.j2ee.engine.ui.JspLaunchMainClass")) : class$com$sap$ide$eclipse$j2ee$engine$ui$JspLaunchMainClass).getName();
            monitor.subTask(LaunchingMessages.getString((String)"JavaLocalApplicationLaunchConfigurationDelegate.Verifying_launch_attributes..._1"));
            IVMInstall vm = JavaRuntime.getDefaultVMInstall();
            IVMRunner runner = vm.getVMRunner(mode);
            if (runner != null) {
                File workingDir = this.verifyWorkingDirectory(configuration);
                String workingDirName = null;
                if (workingDir != null) {
                    workingDirName = workingDir.getAbsolutePath();
                }
                String pgmArgs = this.getProgramArguments(configuration);
                String vmArgs = this.getVMArguments(configuration);
                ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
                Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
                String[] classpath = this.getClasspath(configuration);
                VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
                runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
                runConfig.setVMArguments(execArgs.getVMArgumentsArray());
                runConfig.setWorkingDirectory(workingDirName);
                runConfig.setVMSpecificAttributesMap(vmAttributesMap);
                String[] bootpath = this.getBootpath(configuration);
                runConfig.setBootClassPath(bootpath);
                if (monitor.isCanceled()) {
                    return;
                }
                this.prepareStopInMain(configuration);
                monitor.worked(1);
                monitor.subTask(LaunchingMessages.getString((String)"JavaLocalApplicationLaunchConfigurationDelegate.Creating_source_locator..._2"));
                this.setDefaultSourceLocator(launch, configuration);
                monitor.worked(1);
                runner.run(runConfig, launch, monitor);
            }
            this.startExplorer(url2call.toString());
        }
        monitor.done();
    }

    protected URL createURL(ILaunchConfiguration configuration) throws CoreException {
        URL createdURL = null;
        try {
            String ctxName;
            String httpHost = configuration.getAttribute("JSP.LAUNCH.ATTR_INST_HOST", "localhost");
            String httpPort = configuration.getAttribute("JSP.LAUNCH.ATTR_INST_HTTP_PORT", "50000");
            int realHttpPort = Integer.parseInt(httpPort);
            String fileSpec = "";
            String debugId = configuration.getAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_SRV_ID", "");
            if (configuration.getAttribute("JSP.LAUNCH.ATTR_CREATE_URL_EXT", false)) {
                String debugExtension = EnginePlugin.getDefault().getDebugUrlExt(debugId);
                fileSpec = fileSpec + debugExtension;
            }
            if ((ctxName = configuration.getAttribute("JSP.LAUNCH.WEB_APP_CONTEXT_ROOT", URL_DEFAULT_PART)).length() == 0 || ctxName.charAt(0) != '/') {
                ctxName = '/' + ctxName;
            }
            fileSpec = fileSpec + ctxName + '/';
            if (configuration.getAttribute("JSP.LAUNCH.ATTR_JSP_SELECTED", false)) {
                String jspName = configuration.getAttribute("JSP.LAUNCH.ATTR_JSP_FILE_NAME", URL_DEFAULT_PART);
                fileSpec = fileSpec + jspName;
            } else if (configuration.getAttribute("JSP.LAUNCH.ATTR_SERVLET_SELECTED", false)) {
                String servletName = configuration.getAttribute("JSP.LAUNCH.ATTR_SERVLET_QAUL_NAME", URL_DEFAULT_PART);
                fileSpec = fileSpec + SERVLET_PATH + servletName;
            }
            createdURL = new URL(HTTP_PROTOCOL, httpHost, realHttpPort, fileSpec);
        }
        catch (MalformedURLException ex) {
            EnginePlugin.getTracer().error("Malformed URL ", (Throwable)ex);
        }
        return createdURL;
    }

    protected void startExplorer(String url) throws CoreException {
        Program explorer = Program.findProgram((String)HTM_EXTENSION);
        if (explorer != null) {
            if (!explorer.execute(url)) {
                this.abort("Could not start explorer on url = " + url.toString(), null, 150);
            }
        } else {
            this.abort("Could not find executable for file extension = htm", null, 150);
        }
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        if (javaProject != null) {
            JavaUISourceLocator sourceLocator = new JavaUISourceLocator(javaProject);
            IJavaSourceLocation[] sourceLocations = sourceLocator.getSourceLocations();
            IJavaSourceLocation[] newLocations = new IJavaSourceLocation[sourceLocations.length + 1];
            System.arraycopy(sourceLocations, 0, newLocations, 0, sourceLocations.length);
            newLocations[sourceLocations.length] = new SourceLocation();
            sourceLocator.setSourceLocations(newLocations);
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    protected boolean isConnected() {
        IDebugTarget dt;
        boolean connected = false;
        if (currentLaunch != null && (dt = currentLaunch.getDebugTarget()) != null && !dt.isDisconnected()) {
            connected = true;
        }
        return connected;
    }

    protected void disconnect() {
        IDebugTarget dt;
        if (currentLaunch != null && (dt = currentLaunch.getDebugTarget()) != null && !dt.isDisconnected()) {
            try {
                dt.disconnect();
            }
            catch (DebugException e) {
                EnginePlugin.getTracer().error("Cannot disconnect from VM", (Throwable)e);
            }
        }
    }

    protected void connect(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String connectorId = this.getVMConnectorId(configuration);
        IVMConnector connector = null;
        connector = connectorId == null ? JavaRuntime.getDefaultVMConnector() : JavaRuntime.getVMConnector((String)connectorId);
        if (connector == null) {
            this.abort("The VM Connector ist not available.", null, 119);
        }
        HashMap<String, String> attrMap = new HashMap<String, String>(2);
        String serverDebugHost = configuration.getAttribute("JSP.LAUNCH.ATTR_INST_HOST", "localhost");
        attrMap.put("hostname", serverDebugHost);
        String serverDebugPort = configuration.getAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_PORT", "50021");
        attrMap.put("port", serverDebugPort);
        connector.connect(attrMap, monitor, launch);
        currentLaunch = launch;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

