/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.ui;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.util.DispatcherProcessNode;
import com.sap.ide.eclipse.j2ee.engine.util.ProcessNode;
import com.sap.ide.eclipse.j2ee.engine.util.ProcessNodeManagement;
import com.sap.ide.eclipse.j2ee.engine.util.ServerProcessNode;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class EngineTab
extends JavaLaunchConfigurationTab {
    private static final String EMPTY_STRING = "";
    private ILabelProvider labelProvider = new InnerLabelProvider();
    private InnerTreeContentProvider treeContentProvider = new InnerTreeContentProvider();
    private static final Image TAB_IMAGE = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"launch_config/instance.gif");
    private static final Image CLUSTER_IMAGE = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/cluster_controller_gray.gif");
    private static final Image INSTANCE_IMAGE = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/instance_gray.gif");
    private static final Image PROCESS_IMAGE = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/process_gray.gif");
    private boolean isDebugTab;
    private Text instanceName;
    private Button selectInstance;
    private Text host;
    private Text httpPort;
    private Text debugPort;
    private Text debugServer;
    private Text debugServerId;
    private Button debugServerUrlExt;

    public EngineTab(String mode) {
        this.isDebugTab = mode.equals("debug");
    }

    public void createControl(Composite parent) {
        IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)4);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            mainPane.getComposite().setLayoutData((Object)gd);
        }
        mainPane.setMargin(5, 5);
        mainPane.setSpacing(5, 5);
        mainPane.addPlaceholder(4, 1);
        mainPane.addTextLabel("Instance : ");
        this.instanceName = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false, 2, 1));
        this.selectInstance = mainPane.addPushButton("Select ...", mainPane.createGridLayoutData(1, 1, 1, 5));
        this.selectInstance.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EngineTab.this.doSelectInstance();
            }
        });
        mainPane.addTextLabel("Host : ");
        this.host = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, 2, 1));
        mainPane.addTextLabel("HTTP Port : ");
        this.httpPort = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, 2, 1));
        if (this.isDebugTab) {
            mainPane.addTextLabel("Debug Port : ");
            this.debugPort = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, 2, 1));
            mainPane.addTextLabel("Debug Server : ");
            this.debugServer = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false));
            this.debugServerId = mainPane.addTextField(true, mainPane.createGridLayoutData(4, 1, true, false));
            this.debugServerUrlExt = mainPane.addCheckBox("Generate URL extension to enable multi user debugging if more than one server nodes exist", false, mainPane.createGridLayoutData(4, 1, true, false, 4, 1));
            this.debugServerUrlExt.setEnabled(false);
            this.debugServerUrlExt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    EngineTab.super.updateLaunchConfigurationDialog();
                }
            });
        }
        this.setControl((Control)mainPane.getComposite());
    }

    public String getName() {
        return "J2EE engine";
    }

    public Image getImage() {
        return TAB_IMAGE;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.instanceName.setText(config.getAttribute("JSP.LAUNCH.ATTR_INST_NAME", EMPTY_STRING));
            this.host.setText(config.getAttribute("JSP.LAUNCH.ATTR_INST_HOST", EMPTY_STRING));
            this.httpPort.setText(config.getAttribute("JSP.LAUNCH.ATTR_INST_HTTP_PORT", EMPTY_STRING));
            if (this.isDebugTab) {
                this.debugPort.setText(config.getAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_PORT", EMPTY_STRING));
                this.debugServer.setText(config.getAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_SRV", EMPTY_STRING));
                this.debugServerId.setText(config.getAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_SRV_ID", EMPTY_STRING));
                this.debugServerUrlExt.setSelection(config.getAttribute("JSP.LAUNCH.ATTR_CREATE_URL_EXT", false));
            }
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException ex) {
            EnginePlugin.getTracer().warning("Could not initialize from configuration !", (Throwable)ex);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("JSP.LAUNCH.ATTR_INST_NAME", this.instanceName.getText());
        configuration.setAttribute("JSP.LAUNCH.ATTR_INST_HOST", this.host.getText());
        configuration.setAttribute("JSP.LAUNCH.ATTR_INST_HTTP_PORT", this.httpPort.getText());
        if (this.isDebugTab) {
            configuration.setAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_PORT", this.debugPort.getText());
            configuration.setAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_SRV", this.debugServer.getText());
            configuration.setAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_SRV_ID", this.debugServerId.getText());
            configuration.setAttribute("JSP.LAUNCH.ATTR_CREATE_URL_EXT", this.debugServerUrlExt.getSelection());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
        ArrayList<String> al = new ArrayList<String>();
        al.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <runtimeClasspathEntry containerPath=\"ECLIPSE_HOME/plugins/com.sap.ide.eclipse.j2ee.engine/plugin.jar\" path=\"3\" type=\"3\"/> ");
        al.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?> <runtimeClasspathEntry containerPath=\"JRE_LIB\" path=\"2\" sourceAttachmentPath=\"JRE_SRC\" sourceRootPath=\"JRE_SRCROOT\" type=\"3\"/> ");
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, al);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        try {
            DispatcherProcessNode[] dispatchers = ProcessNodeManagement.getAllDispatcherNodes();
            if (dispatchers.length > 0) {
                config.setAttribute("JSP.LAUNCH.ATTR_INST_NAME", dispatchers[0].getInstanceName());
                config.setAttribute("JSP.LAUNCH.ATTR_INST_HOST", dispatchers[0].getHost());
                config.setAttribute("JSP.LAUNCH.ATTR_INST_HTTP_PORT", dispatchers[0].getHttpPort());
                ServerProcessNode[] servers = ProcessNodeManagement.getAllServerNodes();
                if (this.isDebugTab && servers.length > 0) {
                    config.setAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_PORT", servers[0].getDebugPort());
                    config.setAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_SRV", servers[0].getProcessName());
                    config.setAttribute("JSP.LAUNCH.ATTR_INST_DEBUG_SRV_ID", servers[0].getClusterId());
                    config.setAttribute("JSP.LAUNCH.ATTR_CREATE_URL_EXT", servers.length > 1);
                }
            }
        }
        catch (JStartupClusterControlException ex) {
            EnginePlugin.getTracer().warning("Could not set defaults !", (Throwable)ex);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean validFlag = true;
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.instanceName.getText().equals(EMPTY_STRING)) {
            this.setErrorMessage("Please select an j2ee engine instance !");
            validFlag = false;
        } else {
            try {
                String instName = this.instanceName.getText();
                if (!this.isDebugTab) {
                    ServerProcessNode[] serverNodes = ProcessNodeManagement.getAllServerNodes();
                    int totNumOfServers = 0;
                    int totNumOfRLBServers = 0;
                    int i = 0;
                    while (i < serverNodes.length) {
                        ServerProcessNode serverNode = serverNodes[i];
                        if (serverNode.getInstanceName().equals(instName) && serverNode.getProcessState() == 3) {
                            ++totNumOfServers;
                            if (serverNode.isLoadBalanceRestricted()) {
                                ++totNumOfRLBServers;
                            }
                        }
                        ++i;
                    }
                    if (totNumOfServers > 0) {
                        if (totNumOfServers == totNumOfRLBServers) {
                            this.setErrorMessage("At least one server node must run in normal mode (not in restricted load balancing) !");
                            validFlag = false;
                        }
                    } else {
                        this.setErrorMessage("No running server node belongs to the selected j2ee engine instance !");
                        validFlag = false;
                    }
                } else {
                    String procName = this.debugServer.getText();
                    ProcessNode procNode = ProcessNodeManagement.createNode(instName, procName);
                    if (procNode instanceof ServerProcessNode) {
                        ServerProcessNode serverNode = (ServerProcessNode)procNode;
                        if (serverNode.isDebugModeOn()) {
                            if (this.debugServerUrlExt.getSelection()) {
                                if (!serverNode.isLoadBalanceRestricted()) {
                                    this.setErrorMessage("The selected server node does not run in restricted load balancing mode !\nPlease configure it correctly so that the URL extension can be used.");
                                } else if (serverNode.getProcessState() != 7) {
                                    this.setErrorMessage("The selected server node is in state " + serverNode.getProcessStateString() + " !" + "\nIt has to be switched to state Debugging (by choosing \"Reserve for debugging\" in the J2EE engine view).");
                                }
                            } else {
                                this.setMessage("Single server debugging. The cluster will freeze during debugging.");
                            }
                        } else {
                            this.setErrorMessage("The selected server does node not run in debug mode !\nPlease choose the according context menu action in the J2EE engine view.");
                            validFlag = false;
                        }
                    } else {
                        this.setErrorMessage("No valid server node selected !");
                        validFlag = false;
                    }
                }
            }
            catch (JStartupClusterControlException e2) {
                this.setErrorMessage("Could not acces server nodes !\n" + e2.getMessage());
                validFlag = false;
            }
            catch (IllegalArgumentException e3) {
                this.setErrorMessage("Could not acces server nodes !\n" + e3.getMessage());
                validFlag = false;
            }
        }
        return validFlag;
    }

    private void doSelectInstance() {
        if (this.isDebugTab) {
            Object selectedSource;
            StructuredObjectSelectionDialog dialog = new StructuredObjectSelectionDialog(this.getShell(), "Choose instance", "Instances :");
            dialog.setLabelProvider(this.labelProvider);
            dialog.setTreeInput((Object)"Any input");
            dialog.setExpandTreeLevel(3);
            dialog.setPreGrayedObjects(this.treeContentProvider.getGrayElements());
            Object[] selectedSources = dialog.openDialog((ITreeContentProvider)this.treeContentProvider, false, 5);
            if (selectedSources != null && selectedSources.length > 0 && (selectedSource = selectedSources[0]) instanceof ServerProcessNode) {
                ServerProcessNode procNode = (ServerProcessNode)selectedSource;
                this.instanceName.setText(procNode.getInstanceName());
                this.host.setText(procNode.getHost());
                String httpPortText = EMPTY_STRING;
                try {
                    DispatcherProcessNode[] dispatcher = ProcessNodeManagement.getAllDispatcherNodes();
                    int d = 0;
                    while (d < dispatcher.length) {
                        DispatcherProcessNode disp = dispatcher[d];
                        if (disp.getInstanceName().equals(procNode.getInstanceName())) {
                            httpPortText = disp.getHttpPort();
                        }
                        ++d;
                    }
                }
                catch (JStartupClusterControlException e) {
                    EnginePlugin.getTracer().warning("Could not find dispatcher nodes ! ", (Throwable)e);
                }
                this.httpPort.setText(httpPortText);
                this.debugPort.setText(procNode.getDebugPort());
                this.debugServer.setText(procNode.getProcessName());
                this.debugServerId.setText(procNode.getClusterId());
                this.debugServerUrlExt.setSelection(this.treeContentProvider.getNumberOfServers() > 1);
                this.updateLaunchConfigurationDialog();
            }
        } else {
            DispatcherProcessNode selectedDispatcher;
            Object[] dispatchers = new DispatcherProcessNode[]{};
            try {
                dispatchers = ProcessNodeManagement.getAllDispatcherNodes();
            }
            catch (JStartupClusterControlException e) {
                EnginePlugin.getTracer().warning("Could not find dispatcher nodes ! ", (Throwable)e);
            }
            DispatcherProcessNode preselDispatcher = null;
            int disp = 0;
            while (disp < dispatchers.length) {
                DispatcherProcessNode dispatcher = dispatchers[disp];
                String currentInstanceName = this.instanceName.getText();
                if (dispatcher.getInstanceName().equals(currentInstanceName)) {
                    preselDispatcher = dispatcher;
                }
                ++disp;
            }
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), this.labelProvider);
            dialog.setTitle("Choose J2EE engine instance");
            dialog.setMessage("Instance:");
            dialog.setElements(dispatchers);
            dialog.setMultipleSelection(false);
            if (preselDispatcher != null) {
                dialog.setInitialSelections(new Object[]{preselDispatcher});
            }
            if (dialog.open() == 0 && (selectedDispatcher = (DispatcherProcessNode)dialog.getFirstResult()) != null) {
                this.instanceName.setText(selectedDispatcher.getInstanceName());
                this.host.setText(selectedDispatcher.getHost());
                this.httpPort.setText(selectedDispatcher.getHttpPort());
                this.updateLaunchConfigurationDialog();
            }
        }
    }

    private static class InnerTreeContentProvider
    implements ITreeContentProvider {
        private DispatcherProcessNode[] instanceNodes = new DispatcherProcessNode[0];
        private ServerProcessNode[] serverNodes = new ServerProcessNode[0];

        public InnerTreeContentProvider() {
            try {
                this.instanceNodes = ProcessNodeManagement.getAllDispatcherNodes();
                this.serverNodes = ProcessNodeManagement.getAllServerNodes();
            }
            catch (JStartupClusterControlException e) {
                EnginePlugin.getTracer().warning("Could not compute server nodes !", (Throwable)e);
            }
        }

        public Object[] getChildren(Object parentElement) {
            ProcessNode dispNode;
            ArrayList<ServerProcessNode> childList = new ArrayList<ServerProcessNode>();
            if (parentElement instanceof ProcessNode && (dispNode = (ProcessNode)parentElement).getProcessType() == 2) {
                String instName = dispNode.getInstanceName();
                int srv = 0;
                while (srv < this.serverNodes.length) {
                    ServerProcessNode srvNode = this.serverNodes[srv];
                    if (instName.equals(srvNode.getInstanceName())) {
                        childList.add(srvNode);
                    }
                    ++srv;
                }
            }
            return childList.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ProcessNode) {
                ProcessNode procNode = (ProcessNode)element;
                return procNode.getProcessType() == 2;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.instanceNodes;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getGrayElements() {
            ArrayList<ProcessNode> grayElList = new ArrayList<ProcessNode>();
            int inst = 0;
            while (inst < this.instanceNodes.length) {
                grayElList.add(this.instanceNodes[inst]);
                ++inst;
            }
            if (EnginePlugin.getDefault().getTotalNumberOfServers() > 1) {
                int s = 0;
                while (s < this.serverNodes.length) {
                    ServerProcessNode server = this.serverNodes[s];
                    if (server.getProcessState() != 7) {
                        grayElList.add(server);
                    }
                    ++s;
                }
            } else if (this.serverNodes.length == 1 && !this.serverNodes[0].isDebugModeOn()) {
                grayElList.add(this.serverNodes[0]);
            }
            return grayElList.toArray();
        }

        public int getNumberOfServers() {
            return this.serverNodes.length;
        }
    }

    private static class InnerLabelProvider
    extends LabelProvider {
        private InnerLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = super.getImage(element);
            if (element instanceof ProcessNode) {
                ProcessNode procNode = (ProcessNode)element;
                image = procNode.getProcessType() == 2 ? INSTANCE_IMAGE : PROCESS_IMAGE;
            }
            return image;
        }

        public String getText(Object element) {
            String text = super.getText(element);
            if (element instanceof ServerProcessNode) {
                ServerProcessNode serverNode = (ServerProcessNode)element;
                text = serverNode.getProcessName() + " " + serverNode.getProcessStateString() + " (dbg mode = " + (serverNode.isDebugModeOn() ? "ON)" : "OFF)");
            } else if (element instanceof DispatcherProcessNode) {
                DispatcherProcessNode dispatcherNode = (DispatcherProcessNode)element;
                text = dispatcherNode.getInstanceName();
            }
            return text;
        }
    }
}

