/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.installation;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.installation.ILocalEngine;
import com.sap.ide.eclipse.j2ee.engine.installation.LocalEngine;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class LocalEngineRecognition {
    private static ILocalEngine[] localEngines = null;

    private LocalEngineRecognition() {
    }

    public static ILocalEngine[] get() throws Exception {
        return LocalEngineRecognition.get(false);
    }

    public static ILocalEngine[] get(boolean forceSearch) throws Exception {
        if (localEngines == null || forceSearch) {
            localEngines = LocalEngineRecognition.search();
        }
        return localEngines;
    }

    public static ILocalEngine[] search() throws Exception {
        localEngines = new ILocalEngine[0];
        String localHost = "";
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            EnginePlugin.getTracer().error("Cannot acces local host", (Throwable)ex);
            throw ex;
        }
        if (localHost.equals("")) {
            throw new Exception("Cannot resolve name of local host !");
        }
        localHost = localHost.toUpperCase();
        String usrSapPath = "\\\\" + localHost + "\\sapmnt";
        File usrSap = new File(usrSapPath);
        File[] systemDirs = usrSap.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.length() == 3;
            }
        });
        if (systemDirs == null || systemDirs.length == 0) {
            throw new Exception("No system could be found under " + usrSapPath);
        }
        Vector<ILocalEngine> localEngineVec = new Vector<ILocalEngine>();
        int syst = 0;
        while (systemDirs != null && syst < systemDirs.length) {
            File systemDir = systemDirs[syst];
            String systemName = systemDir.getName().toUpperCase();
            File profileDir = new File(systemDir, "SYS\\profile");
            if (profileDir.exists()) {
                InnerProfilenameFilter filter = new InnerProfilenameFilter(systemName, localHost);
                File[] profiles = profileDir.listFiles(filter);
                Object locEngine = null;
                File scsProfile = null;
                File j2eeProfile = null;
                int p = 0;
                while (p < profiles.length & locEngine == null) {
                    ILocalEngine localEngine;
                    String profileName = profiles[p].getName().toUpperCase();
                    if (profileName.startsWith(systemName + "_JC")) {
                        j2eeProfile = profiles[p];
                    }
                    if (profileName.toUpperCase().startsWith(systemName + "_SCS")) {
                        scsProfile = profiles[p];
                    }
                    if (j2eeProfile != null && scsProfile != null && (localEngine = LocalEngine.create(j2eeProfile, scsProfile)) != null) {
                        localEngineVec.add(localEngine);
                    }
                    ++p;
                }
            }
            ++syst;
        }
        localEngines = localEngineVec.toArray(new ILocalEngine[0]);
        return localEngines;
    }

    private static class InnerProfilenameFilter
    implements FilenameFilter {
        private String systemName;
        private String localHost;

        public InnerProfilenameFilter(String sysName, String host) {
            this.systemName = sysName.toUpperCase();
            this.localHost = host.toUpperCase();
        }

        public boolean accept(File dir, String name) {
            String convertedName = name.toUpperCase();
            return convertedName.startsWith(this.systemName) && convertedName.endsWith(this.localHost);
        }
    }
}

