/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.installation;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.installation.AbstractEngineInstallation;
import com.sap.ide.eclipse.j2ee.engine.installation.ILocalEngine;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class LocalEngine
extends AbstractEngineInstallation
implements ILocalEngine {
    private static final String HOST_PROP = "SAPGLOBALHOST";
    private static final String MS_PORT_PROP = "rdisp/msserv";
    private static final String INSTANCE_NUMER_PROP = "SAPSYSTEM";
    private static final String SYSTEM_NAME_PROP = "SAPSYSTEMNAME";
    private static final String DIR_EXECUTABLE = "DIR_EXECUTABLE";
    private String systemName;
    private int j2eeInstNumber;
    private int scsInstNumber;
    private File j2eeProfile;
    private File scsProfile;
    private String executableDirectory;

    protected LocalEngine(String localHost, int msPort, String systemName, int j2eeInstNumber, int scsInstNumber, File j2eeProfile, File scsProfile, String execDir) {
        super(localHost, msPort);
        this.systemName = systemName;
        this.j2eeInstNumber = j2eeInstNumber;
        this.scsInstNumber = scsInstNumber;
        this.j2eeProfile = j2eeProfile;
        this.scsProfile = scsProfile;
        this.executableDirectory = execDir;
    }

    public static ILocalEngine create(File j2eeProfile, File scsProfile) {
        Properties j2eeProperties = LocalEngine.readProperties(j2eeProfile);
        int locJ2eeInstNumber = Integer.parseInt(j2eeProperties.getProperty(INSTANCE_NUMER_PROP, "-1"));
        String locHost = j2eeProperties.getProperty(HOST_PROP, "");
        String locSystemName = j2eeProperties.getProperty(SYSTEM_NAME_PROP, "???");
        String locExecDir = j2eeProperties.getProperty(DIR_EXECUTABLE, "");
        Properties scsProperties = LocalEngine.readProperties(scsProfile);
        int locScsInstNumber = Integer.parseInt(scsProperties.getProperty(INSTANCE_NUMER_PROP, "-1"));
        int locMsPort = Integer.parseInt(scsProperties.getProperty(MS_PORT_PROP, "0"));
        LocalEngine newEngine = new LocalEngine(locHost, locMsPort, locSystemName, locJ2eeInstNumber, locScsInstNumber, j2eeProfile, scsProfile, locExecDir);
        return newEngine;
    }

    private static Properties readProperties(File profile) {
        Properties readProperties = new Properties();
        try {
            FileInputStream fileInStream = new FileInputStream(profile);
            StringBuffer strBuffer = new StringBuffer(0);
            InputStreamReader inStrReader = new InputStreamReader((InputStream)fileInStream, "US-ASCII");
            char[] inputBuffer = new char[1000];
            int readBytes = 0;
            while (readBytes > -1) {
                readBytes = inStrReader.read(inputBuffer);
                if (readBytes <= 0) continue;
                strBuffer.append(inputBuffer, 0, readBytes);
            }
            int pos = strBuffer.toString().indexOf(92);
            while (pos >= 0) {
                strBuffer.replace(pos, pos, "\\");
                pos = strBuffer.toString().indexOf(92, pos + 2);
            }
            readProperties.load(new ByteArrayInputStream(strBuffer.toString().getBytes()));
            fileInStream.close();
        }
        catch (FileNotFoundException ex) {
            EnginePlugin.getTracer().warning("Property file not found !", (Throwable)ex);
        }
        catch (IOException ex) {
            EnginePlugin.getTracer().error("Read Properties", (Throwable)ex);
        }
        return readProperties;
    }

    private void startExecutables() {
        String[] envp = null;
        File execDir = new File(this.getExecutableDirectory());
        Runtime rt = Runtime.getRuntime();
        String realCommand = new File(this.getExecutableDirectory(), "startsap").getAbsolutePath();
        String[] cmdArray = new String[]{realCommand, "name=" + this.getSystemName(), "nr=" + this.getScsInstNumber(), "sapdiahost=" + this.getMsHost()};
        try {
            Process scsProc = rt.exec(cmdArray, envp, execDir);
        }
        catch (IOException ex) {
            EnginePlugin.getTracer().error("Failed to start local engine (SCS)", (Throwable)ex);
        }
        cmdArray = new String[]{realCommand, "name=" + this.getSystemName(), "nr=" + this.getJ2eeInstNumber(), "sapdiahost=" + this.getMsHost()};
        try {
            Process j2eeProc = rt.exec(cmdArray, envp, execDir);
        }
        catch (IOException ex) {
            EnginePlugin.getTracer().error("Failed to start local engine (J2EE)", (Throwable)ex);
        }
        if (this.getClusterController() != null) {
            this.getClusterController().exit();
        }
    }

    private void stopExecutables() {
        String[] envp = null;
        File execDir = new File(this.getExecutableDirectory());
        Runtime rt = Runtime.getRuntime();
        String realCommand = new File(this.getExecutableDirectory(), "stopsap").getAbsolutePath();
        String[] cmdArray = new String[]{realCommand, "name=" + this.getSystemName(), "nr=" + this.getJ2eeInstNumber(), "sapdiahost=" + this.getMsHost()};
        try {
            Process j2eeProc = rt.exec(cmdArray, envp, execDir);
        }
        catch (IOException ex) {
            EnginePlugin.getTracer().error("Failed to start local engine (J2EE)", (Throwable)ex);
        }
        cmdArray = new String[]{realCommand, "name=" + this.getSystemName(), "nr=" + this.getScsInstNumber(), "sapdiahost=" + this.getMsHost()};
        try {
            Process scsProc = rt.exec(cmdArray, envp, execDir);
        }
        catch (IOException ex) {
            EnginePlugin.getTracer().error("Failed to start local engine (SCS)", (Throwable)ex);
        }
        if (this.getClusterController() != null) {
            this.getClusterController().exit();
        }
    }

    public void start() {
        this.startExecutables();
    }

    public void stop() {
        this.stopExecutables();
    }

    public String getSystemName() {
        return this.systemName;
    }

    public int getJ2eeInstNumber() {
        return this.j2eeInstNumber;
    }

    public int getScsInstNumber() {
        return this.scsInstNumber;
    }

    public File getJ2eeProfile() {
        return this.j2eeProfile;
    }

    public File getScsProfile() {
        return this.scsProfile;
    }

    public String getExecutableDirectory() {
        return this.executableDirectory;
    }
}

