/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.installation;

import com.sap.bc.proj.jstartup.api.JStartupClusterController;
import com.sap.bc.proj.jstartup.api.JStartupClusterControllerFactory;
import com.sap.bc.proj.jstartup.api.JStartupInitialFactory;
import com.sap.bc.proj.jstartup.api.JStartupInstantiationException;
import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.installation.IEngineInstallation;
import java.io.IOException;
import java.net.ConnectException;

public abstract class AbstractEngineInstallation
implements IEngineInstallation {
    private String msHost;
    private int msPort;

    protected AbstractEngineInstallation(String msHost, int msPort) {
        this.msHost = msHost;
        this.msPort = msPort;
        try {
            JStartupClusterControllerFactory clusCtrlFac = JStartupInitialFactory.getInitialFactory().getClusterControllerFactory();
            clusCtrlFac.createClusterController(msHost, msPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JStartupClusterController getClusterController() {
        JStartupClusterController clusterController = null;
        try {
            JStartupClusterControllerFactory clusCtrlFac = JStartupInitialFactory.getInitialFactory().getClusterControllerFactory();
            clusterController = clusCtrlFac.getClusterController(this.msHost, this.msPort);
        }
        catch (ConnectException ex1) {
            EnginePlugin.getTracer().warning("Getting the cluster controller leads to a connect exception (i.e. the cluster cannot be reached/is down) !", (Throwable)ex1);
        }
        catch (IOException ex2) {
            EnginePlugin.getTracer().error("Getting the cluster controller leads to an i/o exception !", (Throwable)ex2);
        }
        catch (JStartupInstantiationException ex3) {
            EnginePlugin.getTracer().error("Getting the cluster controller leads to a jstartup framework exception !", (Throwable)ex3);
        }
        return clusterController;
    }

    public String getMsHost() {
        return this.msHost;
    }

    public int getMsPort() {
        return this.msPort;
    }
}

