/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.debug;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.tssap.j2ee.model.ear.IEarProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceListenerImpl
implements IResourceChangeListener {
    private IResourceDeltaVisitor myDeltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    ResourceListenerImpl.this.processFileModification(delta);
                }
            }
            return false;
        }
    };

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event == null || event.getDelta() == null || event.getType() != 1) {
                return;
            }
            event.getDelta().accept(this.myDeltaVisitor);
        }
        catch (CoreException resourceException) {
            EnginePlugin.getTracer().warning("Cannot accept delta visitor ", (Throwable)resourceException);
        }
    }

    private void processFileModification(IResourceDelta fileDelta) {
        IFile file = (IFile)fileDelta.getResource();
        IEarProject project = EnginePlugin.getDefault().getCurrentDebuggedProject();
        if (file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("jsp") && project != null && file.getProject().getName().equals(project.getProject().getName())) {
            switch (fileDelta.getKind()) {
                case 1: {
                    String appName = project.getDescriptor().getDisplayName().getValue();
                    String ctxName = "";
                    String projName = file.getProject().getName();
                    break;
                }
                case 2: {
                    EnginePlugin.getDefault().removeJspResource(file.getName().substring(0, file.getName().length() - 4));
                    break;
                }
            }
        }
    }
}

