/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.admin.ui.internal;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlInstance;
import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.AbstractComponent;
import com.tssap.util.ui.pane.IGridLayoutPane;

public class InstanceComponent
extends AbstractComponent {
    JStartupClusterInstance clusterInstance;
    private static final String TITLE = "Instance";

    public InstanceComponent(JStartupClusterInstance instance) {
        super(2, TITLE);
        this.clusterInstance = instance;
    }

    public void initContainer(IGridLayoutPane userArea) {
        this.addDataToUserArea("Name ", this.clusterInstance.getName(), userArea);
        this.addDataToUserArea("Host ", this.clusterInstance.getHost(), userArea);
        String type = "";
        switch (this.clusterInstance.getMessageType()) {
            case 2: {
                this.addDataToUserArea("Type ", "Cluster Monitor", userArea);
                break;
            }
            case 1: {
                this.addDataToUserArea("Type ", "Cluster Instance", userArea);
                try {
                    JStartupControlInstance ctrlInstance = this.clusterInstance.getControlInstance();
                    if (ctrlInstance == null) break;
                    this.addDataToUserArea("System Name ", ctrlInstance.getSAPSystemName(), userArea);
                    this.addDataToUserArea("State ", ctrlInstance.getStateString(), userArea);
                    this.addDataToUserArea("System Number ", ctrlInstance.getSAPSystem(), userArea);
                    this.addDataToUserArea("Message Srv Host ", ctrlInstance.getMSHost(), userArea);
                    this.addDataToUserArea("Message Srv Port ", ctrlInstance.getMSPort(), userArea);
                    break;
                }
                catch (JStartupClusterControlException ex) {
                    this.addDataToUserArea("Error: get controller ", ex.getMessage(), userArea);
                    EnginePlugin.getTracer().error("Cannot get controller", (Throwable)ex);
                }
            }
        }
    }
}

