/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.admin.ui.internal;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterController;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlProcess;
import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.admin.db.AdminDbNode;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.AbstractComponent;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.AdminTreeErrorNode;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.ClusterControllerNode;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.ClusterInstanceNode;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.ControlProcessNode;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.ControllerComponent;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.ErrorComponent;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.InstallationNode;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.InstanceComponent;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.LocalEngineComponent;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.ProcessComponent;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.RemoteEngineComponent;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.SimpleTreeNode;
import com.sap.ide.eclipse.j2ee.engine.installation.IEngineInstallation;
import com.sap.ide.eclipse.j2ee.engine.installation.ILocalEngine;
import com.sap.ide.eclipse.j2ee.engine.installation.IRemoteEngine;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.reuse.IReuseable;
import com.tssap.util.ui.reuse.IReuseableManager;
import java.util.Vector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class AdminTreeManager
implements IReuseableManager,
ITreeContentProvider,
ILabelProvider {
    private static Image dbBlue = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/db.gif");
    private static Image clusterGray = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/cluster_gray.gif");
    private static Image clusterControllerGray = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/cluster_controller_gray.gif");
    private static Image clusterControllerError = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/cluster_controller_error.gif");
    private static Image instanceGray = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/instance_gray.gif");
    private static Image instanceGreen = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/instance_green.gif");
    private static Image instanceYellow = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/instance_yellow.gif");
    private static Image instanceRed = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/instance_red.gif");
    private static Image instanceError = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/instance_error.gif");
    private static Image processGray = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/process_gray.gif");
    private static Image processGreen = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/process_green.gif");
    private static Image processYellow = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/process_yellow.gif");
    private static Image processRed = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/process_red.gif");
    private static Image processError = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/process_error.gif");
    private static Image monitor = SapIdeUtilImages.createImageFromIconsDirectory((String)"com.sap.ide.eclipse.j2ee.engine", (String)"view/monitor.gif");

    public IReuseable getReusable(Object obj) {
        AbstractComponent reuseableComponent = null;
        if (obj instanceof InstallationNode) {
            InstallationNode node = (InstallationNode)obj;
            if (node.getInstallation() instanceof IRemoteEngine) {
                IRemoteEngine remoteEngine = (IRemoteEngine)node.getInstallation();
                reuseableComponent = new RemoteEngineComponent(remoteEngine);
            }
            if (node.getInstallation() instanceof ILocalEngine) {
                ILocalEngine localEngine = (ILocalEngine)node.getInstallation();
                reuseableComponent = new LocalEngineComponent(localEngine);
            }
        }
        if (obj instanceof ClusterControllerNode) {
            JStartupClusterController controller = ((ClusterControllerNode)obj).getClusterController();
            reuseableComponent = new ControllerComponent(controller);
        }
        if (obj instanceof ClusterInstanceNode) {
            JStartupClusterInstance instance = ((ClusterInstanceNode)obj).getClusterInstance();
            reuseableComponent = new InstanceComponent(instance);
        }
        if (obj instanceof ControlProcessNode) {
            JStartupControlProcess process = ((ControlProcessNode)obj).getControlProcess();
            reuseableComponent = new ProcessComponent(process);
        }
        if (obj instanceof AdminTreeErrorNode) {
            AdminTreeErrorNode errorNode = (AdminTreeErrorNode)obj;
            reuseableComponent = new ErrorComponent(errorNode.getDetail());
        }
        return reuseableComponent;
    }

    public Object[] getChildren(Object parentElement) {
        String errorDetailText;
        Vector<SimpleTreeNode> children = new Vector<SimpleTreeNode>();
        if (parentElement instanceof InstallationNode) {
            IEngineInstallation engine = ((InstallationNode)parentElement).getInstallation();
            JStartupClusterController clusterController = engine.getClusterController();
            if (clusterController != null) {
                children.add(new ClusterControllerNode((InstallationNode)parentElement, clusterController));
            } else {
                children.add(new AdminTreeErrorNode((InstallationNode)parentElement, "N/A", "", clusterControllerError));
            }
        }
        if (parentElement instanceof ClusterControllerNode) {
            JStartupClusterController clusterController = ((ClusterControllerNode)parentElement).getClusterController();
            try {
                JStartupClusterInstance[] instances = clusterController.getInstances();
                int i = 0;
                while (i < instances.length) {
                    children.add(new ClusterInstanceNode((ClusterControllerNode)parentElement, instances[i]));
                    ++i;
                }
            }
            catch (JStartupClusterControlException ex) {
                String errorText = "Exception : " + ex.getMessage();
                errorDetailText = errorText + "\nNested Exception : " + ex.getNestedException().getMessage();
                children.add(new AdminTreeErrorNode((ClusterControllerNode)parentElement, errorText, errorDetailText));
                EnginePlugin.getTracer().error("Can not retrieve cluster instances", (Throwable)ex);
            }
        }
        if (parentElement instanceof ClusterInstanceNode) {
            JStartupClusterInstance instance = ((ClusterInstanceNode)parentElement).getClusterInstance();
            try {
                JStartupControlInstance controlInstance = instance.getControlInstance();
                if (controlInstance != null) {
                    JStartupControlProcess[] processes = controlInstance.getProcesses();
                    int p = 0;
                    while (p < processes.length) {
                        children.add(new ControlProcessNode((ClusterInstanceNode)parentElement, processes[p]));
                        ++p;
                    }
                }
            }
            catch (JStartupClusterControlException ex) {
                String errorText = "Exception : " + ex.getMessage();
                errorDetailText = errorText + "\n Inner exception : " + ex.getNestedException().getMessage();
                children.add(new AdminTreeErrorNode((ClusterInstanceNode)parentElement, errorText, errorDetailText));
                EnginePlugin.getTracer().error("Can not retrieve cluster instances", (Throwable)ex);
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof SimpleTreeNode) {
            parent = ((SimpleTreeNode)element).getParent();
        }
        return parent;
    }

    public boolean hasChildren(Object obj) {
        boolean childFlag = false;
        if (obj instanceof InstallationNode) {
            childFlag = true;
        }
        if (obj instanceof ClusterControllerNode) {
            childFlag = true;
        }
        if (obj instanceof ClusterInstanceNode) {
            JStartupClusterInstance instance = ((ClusterInstanceNode)obj).getClusterInstance();
            childFlag = instance.getMessageType() == 1;
        }
        if (obj instanceof ControlProcessNode) {
            childFlag = false;
        }
        return childFlag;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = new Object[]{};
        if (inputElement instanceof TreeInput) {
            IEngineInstallation engine = ((TreeInput)inputElement).getEngine();
            elements = new Object[]{new InstallationNode(engine)};
        } else {
            elements = new Object[]{new AdminTreeErrorNode(null, "Tree input does not represent engine installation !")};
        }
        return elements;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof InstallationNode) {
            image = clusterGray;
        }
        if (element instanceof AdminDbNode) {
            image = dbBlue;
        }
        if (element instanceof ClusterControllerNode) {
            image = clusterControllerGray;
        }
        if (element instanceof ClusterInstanceNode) {
            JStartupClusterInstance instance = ((ClusterInstanceNode)element).getClusterInstance();
            if (instance.getMessageType() == 2) {
                image = monitor;
            }
            if (instance.getMessageType() == 1) {
                try {
                    JStartupControlInstance ctrlInstance = instance.getControlInstance();
                    switch (ctrlInstance.getState()) {
                        case 0: {
                            image = instanceGray;
                            break;
                        }
                        case 7: 
                        case 8: {
                            image = instanceRed;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: {
                            image = instanceYellow;
                            break;
                        }
                        case 5: {
                            image = instanceGreen;
                            break;
                        }
                        default: {
                            image = instanceError;
                            break;
                        }
                    }
                }
                catch (JStartupClusterControlException ex) {
                    EnginePlugin.getTracer().error("Can not refresh instance", (Throwable)ex);
                    image = instanceError;
                }
            }
        }
        if (element instanceof ControlProcessNode) {
            JStartupControlProcess process = ((ControlProcessNode)element).getControlProcess();
            switch (process.getState()) {
                case 0: {
                    image = processGray;
                    break;
                }
                case 6: {
                    image = processRed;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 10: {
                    image = processYellow;
                    break;
                }
                case 3: 
                case 7: {
                    image = processGreen;
                    break;
                }
                default: {
                    image = processError;
                }
            }
        }
        if (element instanceof AdminTreeErrorNode) {
            AdminTreeErrorNode node = (AdminTreeErrorNode)element;
            image = node.getImage();
        }
        return image;
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof InstallationNode) {
            IEngineInstallation installation = ((InstallationNode)element).getInstallation();
            text = installation instanceof ILocalEngine ? "Local engine" : (installation instanceof IRemoteEngine ? "Remote engine" : "Engine");
        }
        if (element instanceof AdminDbNode) {
            text = "Database";
        }
        if (element instanceof ClusterControllerNode) {
            JStartupClusterController controller = ((ClusterControllerNode)element).getClusterController();
            text = controller.getMsHost() + ":" + controller.getMsPort();
        }
        if (element instanceof ClusterInstanceNode) {
            JStartupClusterInstance clusterInstance = ((ClusterInstanceNode)element).getClusterInstance();
            text = clusterInstance.getName();
            if (clusterInstance.getMessageType() == 2) {
                text = "Monitor " + clusterInstance.getHost();
            }
            if (clusterInstance.getMessageType() == 1) {
                try {
                    JStartupControlInstance ctrlInstance = clusterInstance.getControlInstance();
                    text = ctrlInstance != null ? ctrlInstance.getSAPSystemName() + " instance " + ctrlInstance.getSAPSystem() + " on " + clusterInstance.getHost() : "Cluster instance " + clusterInstance.getName();
                }
                catch (JStartupClusterControlException ex) {
                    EnginePlugin.getTracer().error("Cannot compute controller ! ", (Throwable)ex);
                    text = "Cluster instance " + clusterInstance.getName();
                }
            }
        }
        if (element instanceof ControlProcessNode) {
            JStartupControlProcess process = ((ControlProcessNode)element).getControlProcess();
            text = process.getName();
        }
        if (element instanceof AdminTreeErrorNode) {
            AdminTreeErrorNode error = (AdminTreeErrorNode)element;
            text = error.getText();
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object createTreeInput(IEngineInstallation engine) {
        return new TreeInput(engine);
    }

    private static class TreeInput {
        private IEngineInstallation engine;

        public TreeInput(IEngineInstallation engine) {
            this.engine = engine;
        }

        public IEngineInstallation getEngine() {
            return this.engine;
        }
    }
}

