/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.admin.ui;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.AdminTreeManager;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.AdminTreeSorter;
import com.sap.ide.eclipse.j2ee.engine.installation.EngineCreatorByPreferences;
import com.sap.ide.eclipse.j2ee.engine.installation.IEngineInstallation;
import com.tssap.util.action.path.DefaultPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import com.tssap.util.ui.reuse.IReuseableManager;
import com.tssap.util.ui.reuse.tree.TreeSelector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class ProcessManagementView
extends ViewPart {
    private TreeSelector treeSelector;
    private AdminTreeManager treeManager;
    private AdminTreeSorter treeSorter;
    private IEngineInstallation currentlyShownEngine;

    public void createPartControl(Composite parent) {
        this.getTreeSelector().setReusableManager((IReuseableManager)this.getTreeManager());
        this.getTreeSelector().setTreeContentProvider((ITreeContentProvider)this.getTreeManager());
        this.getTreeSelector().setTreeLabelProvider((ILabelProvider)this.getTreeManager());
        this.getTreeSelector().setSplitterWeight(1);
        this.getTreeSelector().setViewerSorter((ViewerSorter)this.getTreeSorter());
        this.getTreeSelector().createPartControl(parent);
        String host = EnginePlugin.getDefault().getMessageServerHost();
        int port = EnginePlugin.getDefault().getMessageServerPort();
        IEngineInstallation engine = EngineCreatorByPreferences.getCurrentlyConfiguredEngine();
        this.setCurrentlyShownEngine(engine);
        Object treeInput = this.getTreeManager().createTreeInput(engine);
        this.getTreeSelector().setTreeInput(treeInput);
        this.getTreeSelector().getTreeViewer().expandAll();
        RebuildTreeAction rebuildTreeAction = new RebuildTreeAction();
        ImageDescriptor rebuildImgDesc = SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_REFRESH);
        rebuildTreeAction.setImageDescriptor(rebuildImgDesc);
        rebuildTreeAction.setToolTipText("Refresh tree");
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)rebuildTreeAction);
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new DefaultPathProvider());
        DynamicContextMenu contextMenu = new DynamicContextMenu((IMenuFactory)menuFactory);
        ContextMenu.setContextMenuToStructuredViewer((StructuredViewer)this.getTreeSelector().getTreeViewer(), (IContextMenu)contextMenu);
    }

    public void setFocus() {
        if (this.getTreeSelector().getTreeViewer() != null && this.getTreeSelector().getTreeViewer().getTree() != null) {
            this.getTreeSelector().getTreeViewer().getTree().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.getCurrentlyShownEngine() != null && this.getCurrentlyShownEngine().getClusterController() != null) {
            this.getCurrentlyShownEngine().getClusterController().exit();
        }
    }

    private TreeSelector getTreeSelector() {
        if (this.treeSelector == null) {
            this.treeSelector = new TreeSelector("", false);
        }
        return this.treeSelector;
    }

    private AdminTreeManager getTreeManager() {
        if (this.treeManager == null) {
            this.treeManager = new AdminTreeManager();
        }
        return this.treeManager;
    }

    private AdminTreeSorter getTreeSorter() {
        if (this.treeSorter == null) {
            this.treeSorter = new AdminTreeSorter();
        }
        return this.treeSorter;
    }

    private void setCurrentlyShownEngine(IEngineInstallation installation) {
        this.currentlyShownEngine = installation;
    }

    public IEngineInstallation getCurrentlyShownEngine() {
        return this.currentlyShownEngine;
    }

    private class RebuildTreeAction
    extends Action {
        private RebuildTreeAction() {
        }

        public void run() {
            if (ProcessManagementView.this.getCurrentlyShownEngine() != null && ProcessManagementView.this.getCurrentlyShownEngine().getClusterController() != null) {
                ProcessManagementView.this.getCurrentlyShownEngine().getClusterController().exit();
            }
            IEngineInstallation engine = EngineCreatorByPreferences.getCurrentlyConfiguredEngine();
            ProcessManagementView.this.setCurrentlyShownEngine(engine);
            ISelection sel = ProcessManagementView.this.getTreeSelector().getTreeViewer().getSelection();
            Object newTreeInput = ProcessManagementView.this.getTreeManager().createTreeInput(engine);
            ProcessManagementView.this.getTreeSelector().getTreeViewer().setInput(newTreeInput);
            ProcessManagementView.this.getTreeSelector().getTreeViewer().setSelection(sel, true);
            ProcessManagementView.this.getTreeSelector().getTreeViewer().expandAll();
        }
    }
}

