/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.admin.action.internal;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterController;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlProcess;
import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.admin.action.internal.InstanceAction;
import com.sap.ide.eclipse.j2ee.engine.admin.ui.internal.ClusterInstanceNode;

public class InstanceStartupAfterOflineDeployment
extends InstanceAction {
    public static final int SHUTDOWN_TIMEOUT = 60000;

    public InstanceStartupAfterOflineDeployment() {
        super("engine_instance_startup_after_offline_deployment", "Restart after offline deployment", null);
    }

    public void runOnClusterController(String name, JStartupClusterController clusterController) {
        try {
            clusterController.shutdownCluster(true, 60000L);
            clusterController.restartCluster(2000L);
        }
        catch (JStartupClusterControlException ex) {
            EnginePlugin.getTracer().warning("Exception during restart after offline", (Throwable)ex);
        }
    }

    public boolean isEnabled(Object object) {
        boolean sdmIsUp = false;
        boolean engineIsProductive = false;
        boolean engineIsDown = true;
        if (object instanceof ClusterInstanceNode) {
            JStartupClusterInstance clusterInstance = ((ClusterInstanceNode)object).getClusterInstance();
            try {
                JStartupControlInstance ctrlInstance = clusterInstance.getControlInstance();
                JStartupControlProcess[] processes = ctrlInstance.getProcesses();
                int i = 0;
                while (i < processes.length) {
                    JStartupControlProcess process = processes[i];
                    if (process.getType() == 3) {
                        boolean bl = engineIsProductive = engineIsProductive || process.getDebuggable() == 0;
                    }
                    if (process.getType() == 4) {
                        sdmIsUp = process.getState() == 3;
                    } else {
                        engineIsDown = engineIsDown && process.getState() == 6;
                    }
                    ++i;
                }
            }
            catch (JStartupClusterControlException ex) {
                EnginePlugin.getTracer().warning("Cannot get processes !", (Throwable)ex);
            }
        }
        return !engineIsProductive && sdmIsUp && engineIsDown;
    }
}

