/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine.actions;

import com.sap.ide.eclipse.j2ee.engine.EnginePlugin;
import com.sap.ide.eclipse.j2ee.engine.debug.JspBreakpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ManageBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private List fMarkers;
    private String fAddLabel;
    private String fRemoveLabel;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public ManageBreakpointRulerAction(IVerticalRulerInfo rulerInfo, ITextEditor editor) {
        this.fRuler = rulerInfo;
        this.fTextEditor = editor;
        this.fAddLabel = "Add Breakpoint";
        this.fRemoveLabel = "Remove Breakpoint";
    }

    public void update() {
        this.fMarkers = this.getMarkers();
        this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = ManageBreakpointRulerAction.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile);
        if (resource == null) {
            resource = (IResource)input.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ManageBreakpointRulerAction.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        return resource;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected void setAnnotationModel(AbstractMarkerAnnotationModel model) {
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException x) {
                EnginePlugin.getTracer().warning("Cannot get line offset ", (Throwable)x);
            }
        }
        return false;
    }

    protected List getMarkers() {
        ArrayList<IMarker> breakpoints = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            try {
                IMarker[] markers = null;
                if (resource instanceof IFile) {
                    markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                } else {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    markers = root.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                }
                if (markers != null) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    int i = 0;
                    while (i < markers.length) {
                        IBreakpoint breakpoint = breakpointManager.getBreakpoint(markers[i]);
                        if (breakpoint != null && breakpointManager.isRegistered(breakpoint) && this.includesRulerLine(model.getMarkerPosition(markers[i]), document)) {
                            breakpoints.add(markers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                EnginePlugin.getTracer().error("Error getting markers from jsp!", (Throwable)x);
            }
        }
        return breakpoints;
    }

    protected void addMarker() {
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        IResource jspFile = null;
        IDocument document = this.getDocument();
        int rulerLine = this.fRuler.getLineOfLastMouseButtonActivity();
        try {
            if (editorInput instanceof IFileEditorInput) {
                jspFile = (IResource)editorInput.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ManageBreakpointRulerAction.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
            }
            if (jspFile != null) {
                int lineNumber = new BreakpointLocationVerifier().getValidBreakpointLocation(document, rulerLine);
                String classPattern = "jsp_" + jspFile.getName().substring(0, jspFile.getName().length() - 4);
                if (lineNumber > 0 && jspFile.exists() && this.breakpointExists(jspFile.getName().substring(0, jspFile.getName().length() - 4), lineNumber) == null) {
                    HashMap attributes = new HashMap(10);
                    new JspBreakpoint(jspFile, this.getQualifiedName(jspFile.getProjectRelativePath()), classPattern, lineNumber, -1, -1, 0, true, attributes);
                }
            }
        }
        catch (DebugException e) {
            EnginePlugin.getTracer().error("Error adding breakpoint to jsp!", (Throwable)e);
        }
        catch (CoreException e) {
            EnginePlugin.getTracer().error("Error adding breakpoint to jsp!", (Throwable)e);
        }
    }

    protected IJavaBreakpoint breakpointExists(String typeName, int lineNumber) throws CoreException {
        String modelId = JDIDebugPlugin.getUniqueIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            IJavaBreakpoint breakpoint = (IJavaBreakpoint)breakpoints[i];
            String brTypeName = EnginePlugin.getNameFromMarker(breakpoint.getMarker());
            if ((brTypeName = brTypeName.substring(0, brTypeName.length() - 4)).equals(typeName) && EnginePlugin.getLineNumberFromMarker(breakpoint.getMarker()) == lineNumber) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    protected void removeMarkers(List markers) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Iterator e = markers.iterator();
            while (e.hasNext()) {
                IMarker marker = (IMarker)e.next();
                IBreakpoint breakpoint = breakpointManager.getBreakpoint(marker);
                String resName = EnginePlugin.getNameFromMarker(breakpoint.getMarker());
                if (!resName.endsWith(".jsp")) continue;
                breakpointManager.removeBreakpoint(breakpoint, true);
            }
        }
        catch (CoreException e) {
            EnginePlugin.getTracer().error("Error occurred when removing a breakpoint from jsp!", (Throwable)e);
        }
    }

    protected String getQualifiedName(IPath path) {
        String extension = path.getFileExtension();
        IPath packagePath = path.removeLastSegments(1);
        String packageName = packagePath.toString().replace('/', '.');
        String typeName = path.lastSegment();
        typeName = typeName.substring(0, typeName.length() - extension.length() - 1);
        String qualifiedName = null;
        qualifiedName = packageName.length() > 0 ? packageName + "." + typeName : typeName;
        return qualifiedName;
    }

    public IJavaElement getJavaElement(IResource file) throws JavaModelException {
        IJavaProject project = JavaModelManager.getJavaModelManager().getJavaModel().findJavaProject(file.getProject());
        if (project == null || file == null) {
            return null;
        }
        IPath path = file.getProjectRelativePath();
        if (path.isAbsolute()) {
            path = path.makeRelative();
        }
        return project.findElement(path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

