/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.j2ee.engine;

import com.sap.bc.proj.jstartup.api.JStartupClusterControlException;
import com.sap.bc.proj.jstartup.api.JStartupClusterController;
import com.sap.bc.proj.jstartup.api.JStartupClusterControllerFactory;
import com.sap.bc.proj.jstartup.api.JStartupClusterInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlInstance;
import com.sap.bc.proj.jstartup.api.JStartupControlProcess;
import com.sap.bc.proj.jstartup.api.JStartupInitialFactory;
import com.sap.bc.proj.jstartup.api.JStartupInstantiationException;
import com.sap.ide.eclipse.debugExtensionPlugin.DebugExtensionPlugin;
import com.sap.ide.eclipse.debugExtensionPlugin.DebugSourceLocatorListener;
import com.sap.ide.eclipse.j2ee.engine.admin.action.ProcessContainer;
import com.sap.ide.eclipse.j2ee.engine.debug.DebugSourceLocatorListenerImpl;
import com.sap.ide.eclipse.j2ee.engine.util.DispatcherProcessNode;
import com.sap.ide.eclipse.j2ee.engine.util.ProcessNode;
import com.sap.ide.eclipse.j2ee.engine.util.ProcessNodeManagement;
import com.sap.ide.eclipse.j2ee.engine.util.SdmProcessNode;
import com.sap.ide.eclipse.j2ee.engine.util.ServerProcessNode;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.dd.IApplication;
import com.tssap.j2ee.model.ear.dd.IModule;
import com.tssap.j2ee.model.web.IClientSource;
import com.tssap.j2ee.model.web.IServerSource;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.IWebSource;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EnginePlugin
extends AbstractUIPlugin {
    public static final String DEBUG_URL_PREFIX = "@@@DEBUG@@@";
    public static final int REMOTE_INSTALLATION_TYPE = 0;
    public static final int LOCAL_INSTALLATION_TYPE = 1;
    public static final String INSTALLATION_TYPE_KEY = "InstType";
    public static final String MESSAGE_SERVER_HOST_KEY = "MsgSrvHost";
    public static final String MESSAGE_SERVER_PORT_KEY = "MsgSrvPort";
    public static final String SYSTEM_ID_KEY = "SystemId";
    public static final String SCS_INSTANCE_KEY = "ScsInst";
    public static final String J2EE_INSTANCE_KEY = "J2eeInst";
    public static final String SCS_PROFILE_KEY = "ScsProfile";
    public static final String J2EE_PROFILE_KEY = "J2eeProfile";
    public static final int INSTALLATION_TYPE_DEFAULT = 0;
    public static final String MESSAGE_SERVER_HOST_DEFAULT = "localhost";
    public static final String MESSAGE_SERVER_PORT_DEFAULT = "3601";
    public static final String SYSTEM_ID_DEFAULT = "";
    public static final String SCS_INSTANCE_DEFAULT = "";
    public static final String J2EE_INSTANCE_DEFAULT = "";
    public static final String SCS_PROFILE_DEFAULT = "";
    public static final String J2EE_PROFILE_DEFAULT = "";
    public static final String JSP_EXT = ".jsp";
    public static final String JAVA_EXT = ".java";
    private static TracerI pluginTracer = TracingManager.getTracer((Class)(class$com$sap$ide$eclipse$j2ee$engine$EnginePlugin == null ? (class$com$sap$ide$eclipse$j2ee$engine$EnginePlugin = EnginePlugin.class$("com.sap.ide.eclipse.j2ee.engine.EnginePlugin")) : class$com$sap$ide$eclipse$j2ee$engine$EnginePlugin));
    public static final char separatorChar = '/';
    public static final String ATTR_JSP_SERVLET_NAME = "ATTR_JSP_NAME";
    public static final String ATTR_WEB_PROJECT = "ATTR_WEB_PROJECT_NAME";
    public static final String ATTR_EAR_PROJECT = "ATTR_EAR_PROJECT_NAME";
    public static final String ATTR_DEBUG_SERVER = "ATTR_DEBUG_SERVER";
    private static EnginePlugin plugin;
    private Hashtable jspResources = new Hashtable(11);
    private IEarProject project;
    private String debugServer;
    private static final int CC_NEVER_TRIED = 0;
    private static final int CC_SUCCESFULLY_GOT = 1;
    private static final int CC_TRIED_BUT_WITH_ERROR = 2;
    private int clusterControllerState = 0;
    public static final int SERVER_STATE_UNDEFINED = -1;
    static /* synthetic */ Class class$com$sap$ide$eclipse$j2ee$engine$EnginePlugin;

    public EnginePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        DebugExtensionPlugin.getDefault().addDebugSourceLocatorListener((DebugSourceLocatorListener)new DebugSourceLocatorListenerImpl());
    }

    public static EnginePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public String getHttpHost() {
        String httpHost = "";
        try {
            DispatcherProcessNode[] dispProcNodes = ProcessNodeManagement.getAllDispatcherNodes();
            if (dispProcNodes.length > 0) {
                httpHost = dispProcNodes[0].getHost();
            }
        }
        catch (JStartupClusterControlException e) {
            EnginePlugin.getTracer().error("Could not determine HTTP host !", (Throwable)e);
        }
        return httpHost;
    }

    public String getSDMHost() {
        String sdmHost = "";
        try {
            SdmProcessNode sdmProcNodes = ProcessNodeManagement.getSdmNode();
            if (sdmProcNodes != null) {
                sdmHost = sdmProcNodes.getHost();
            }
        }
        catch (JStartupClusterControlException e) {
            EnginePlugin.getTracer().error("Could not determine SDM host !", (Throwable)e);
        }
        return sdmHost;
    }

    public String getHttpPort() {
        String httpPort = "";
        try {
            DispatcherProcessNode[] dispProcNodes = ProcessNodeManagement.getAllDispatcherNodes();
            if (dispProcNodes.length > 0) {
                httpPort = dispProcNodes[0].getHttpPort();
            }
        }
        catch (JStartupClusterControlException e) {
            EnginePlugin.getTracer().error("Could not determine HTTP port !", (Throwable)e);
        }
        return httpPort;
    }

    public String getSdmPort() {
        String sdmPort = "";
        try {
            SdmProcessNode sdmProcNodes = ProcessNodeManagement.getSdmNode();
            if (sdmProcNodes != null) {
                sdmPort = sdmProcNodes.getSdmPort();
            }
        }
        catch (JStartupClusterControlException e) {
            EnginePlugin.getTracer().error("Could not determine SDM port !", (Throwable)e);
        }
        return sdmPort;
    }

    public JStartupClusterInstance[] getClusterInstances() {
        ArrayList<JStartupClusterInstance> realClusterInstList = new ArrayList<JStartupClusterInstance>();
        JStartupClusterController clusterController = this.getClusterController();
        if (clusterController != null) {
            try {
                JStartupClusterInstance[] allInstances = clusterController.getInstances();
                if (allInstances != null) {
                    int i = 0;
                    while (i < allInstances.length) {
                        JStartupClusterInstance instance = allInstances[i];
                        if (instance.getMessageType() == 1) {
                            realClusterInstList.add(instance);
                        }
                        ++i;
                    }
                }
            }
            catch (JStartupClusterControlException e) {
                EnginePlugin.getTracer().error("Error on getting cluster instances from cluster controller", (Throwable)e);
            }
        }
        JStartupClusterInstance[] clusterInstances = realClusterInstList.toArray(new JStartupClusterInstance[0]);
        return clusterInstances;
    }

    public JStartupClusterController getClusterController() {
        String msHost = this.getMessageServerHost();
        int msPort = this.getMessageServerPort();
        JStartupClusterController clusterController = null;
        try {
            JStartupClusterControllerFactory controllerFactory = JStartupInitialFactory.getInitialFactory().getClusterControllerFactory();
            clusterController = controllerFactory.getClusterController(msHost, msPort);
            this.setClusterControllerState(1);
        }
        catch (ConnectException ex1) {
            EnginePlugin.getTracer().warning("Got a ConnectException while trying to connect to the cluster controller !", (Throwable)ex1);
            this.setClusterControllerState(2);
        }
        catch (IOException ex2) {
            EnginePlugin.getTracer().error("Got an i/o exception while trying to reach the cluster controller !", (Throwable)ex2);
            this.setClusterControllerState(2);
        }
        catch (JStartupInstantiationException ex3) {
            EnginePlugin.getTracer().error("Got a startup framework exception while trying to reach the cluster controller !", (Throwable)ex3);
            this.setClusterControllerState(2);
            return null;
        }
        return clusterController;
    }

    public String getMessageServerHost() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getString(MESSAGE_SERVER_HOST_KEY);
    }

    public int getMessageServerPort() {
        IPreferenceStore store = this.getPreferenceStore();
        String msPortAsString = store.getString(MESSAGE_SERVER_PORT_KEY);
        int msPort = 0;
        try {
            msPort = Integer.parseInt(msPortAsString);
        }
        catch (NumberFormatException nex) {
            EnginePlugin.getTracer().error("Error when converting message server port", (Throwable)nex);
        }
        return msPort;
    }

    public IFile getJspResource(String jspName) {
        IFile result;
        if (this.jspResources.containsKey(jspName = jspName.toLowerCase()) && (result = (IFile)this.jspResources.get(jspName)).exists()) {
            return result;
        }
        IEarProject earProject = this.getCurrentDebuggedProject();
        if (earProject != null) {
            IWebSource[] sources = EnginePlugin.getReferencedJsps(earProject);
            int j = 0;
            while (j < sources.length) {
                if (sources[j].getName().toLowerCase().indexOf(jspName) != -1) {
                    this.jspResources.put(jspName, sources[j].getFile());
                    return sources[j].getFile();
                }
                ++j;
            }
        }
        IEarProject[] allEarProjects = J2eeProjectManager.getEarProjects();
        int i = 0;
        while (i < allEarProjects.length) {
            IWebSource[] sources = EnginePlugin.getReferencedJsps(allEarProjects[i]);
            int j = 0;
            while (j < sources.length) {
                if (sources[j].getName().toLowerCase().indexOf(jspName) != -1) {
                    this.jspResources.put(jspName, sources[j].getFile());
                    return sources[j].getFile();
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void removeJspResource(String jspName) {
        this.jspResources.remove(jspName);
    }

    public static String getNameFromMarker(IMarker marker) {
        return marker.getResource().getName();
    }

    public static int getLineNumberFromMarker(IMarker marker) throws CoreException {
        Integer lineNumber;
        if (marker != null && (lineNumber = (Integer)marker.getAttribute("lineNumber")) != null) {
            return lineNumber;
        }
        return -1;
    }

    public void setCurrentDebuggedProject(IJavaProject project) {
        String name = project.getProject().getName();
        this.setCurrentDebuggedProject(J2eeProjectManager.getEarProject((String)name));
    }

    public void setCurrentDebuggedProject(IEarProject project) {
        this.project = project;
    }

    public IEarProject getCurrentDebuggedProject() {
        return this.project;
    }

    public void showErrorMessage(final String title, final String message) {
        Runnable errorShow = new Runnable(){

            public void run() {
                Shell shell = null;
                if (EnginePlugin.this.getWorkbench().getActiveWorkbenchWindow() == null) {
                    IWorkbenchWindow[] windows = EnginePlugin.this.getWorkbench().getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        shell = windows[i].getShell();
                        ++i;
                    }
                } else {
                    shell = EnginePlugin.this.getWorkbench().getActiveWorkbenchWindow().getShell();
                }
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        };
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(errorShow);
    }

    public void showInformationMessage(final String title, final String text) {
        Runnable infoShow = new Runnable(){

            public void run() {
                Shell shell = null;
                if (EnginePlugin.this.getWorkbench().getActiveWorkbenchWindow() == null) {
                    IWorkbenchWindow[] windows = EnginePlugin.this.getWorkbench().getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        shell = windows[i].getShell();
                        ++i;
                    }
                } else {
                    shell = EnginePlugin.this.getWorkbench().getActiveWorkbenchWindow().getShell();
                }
                MessageDialog.openInformation((Shell)shell, (String)title, (String)text);
            }
        };
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(infoShow);
    }

    private IWebModule getWebModule(IWebSource wsource) {
        IWebModule[] webMods = J2eeProjectManager.getWebModules();
        int i = 0;
        while (i < webMods.length) {
            if (webMods[i].getReferenced(wsource) != null) {
                return webMods[i];
            }
            ++i;
        }
        return null;
    }

    public static IWebSource[] getReferencedJsps(IEarProject earProject) {
        ArrayList<IClientSource> jspList = new ArrayList<IClientSource>();
        if (earProject != null) {
            IWebModule[] webModules = earProject.getReferencedWebModules();
            int p = 0;
            while (p < webModules.length) {
                IWebModule project = webModules[p];
                IClientSource[] webSources = webModules[p].getReferencedClientSources(10);
                int w = 0;
                while (w < webSources.length) {
                    jspList.add(webSources[w]);
                    ++w;
                }
                ++p;
            }
        }
        IWebSource[] refJsps = jspList.toArray(new IWebSource[0]);
        return refJsps;
    }

    public static IWebSource[] getReferencedServlets(IEarProject earProject) {
        ArrayList<IServerSource> servletList = new ArrayList<IServerSource>();
        if (earProject != null) {
            IWebModule[] webModule = earProject.getReferencedWebModules();
            int p = 0;
            while (p < webModule.length) {
                IWebModule project = webModule[p];
                IServerSource[] webSources = webModule[p].getReferencedServerSources(3);
                int w = 0;
                while (w < webSources.length) {
                    servletList.add(webSources[w]);
                    ++w;
                }
                ++p;
            }
        }
        IWebSource[] refServlets = servletList.toArray(new IWebSource[0]);
        return refServlets;
    }

    public static String getContextRoot(IEarProject earProject, IWebProject webProject) {
        String contextRoot = "";
        if (earProject != null) {
            IApplication descriptor = earProject.getDescriptor();
            if (descriptor != null) {
                IModule[] modules = descriptor.getModules();
                int i = 0;
                while (i < modules.length) {
                    if (modules[i].getWeb() != null && modules[i].getWeb().getContextRoot() != null) {
                        return modules[i].getWeb().getContextRoot().getValue();
                    }
                    ++i;
                }
            } else {
                EnginePlugin.getTracer().error("getContextRootName()", "Error getting EAR descriptor. Returned \"null\"!");
            }
        }
        return contextRoot;
    }

    public static TracerI getTracer() {
        return pluginTracer;
    }

    public JStartupControlProcess[] getDebugEnabledServers() throws Exception {
        JStartupControlProcess[] enabledServers = new JStartupControlProcess[]{};
        JStartupClusterInstance[] insts = this.getClusterInstances();
        if (insts.length > 0) {
            JStartupControlProcess[] procs = insts[0].getControlInstance().getProcesses();
            Vector<JStartupControlProcess> enabledServersVec = new Vector<JStartupControlProcess>();
            int numOfServers = 0;
            JStartupControlProcess lastDebuggableServer = null;
            int p = 0;
            while (p < procs.length) {
                JStartupControlProcess process = procs[p];
                if (process.getType() == 3) {
                    ++numOfServers;
                    if (process.getDebugMode() > 0) {
                        lastDebuggableServer = process;
                    }
                    if (process.getState() == 7) {
                        enabledServersVec.add(process);
                    }
                }
                ++p;
            }
            if (numOfServers == 1 && lastDebuggableServer != null) {
                enabledServersVec.clear();
                enabledServersVec.add(lastDebuggableServer);
            }
            enabledServers = enabledServersVec.toArray(enabledServers);
        }
        return enabledServers;
    }

    public int getServersCount() {
        int serverCount = 0;
        JStartupClusterInstance[] instances = this.getClusterInstances();
        int inst = 0;
        while (inst < instances.length) {
            JStartupClusterInstance instance = instances[inst];
            JStartupControlProcess[] procs = new JStartupControlProcess[]{};
            try {
                procs = instance.getControlInstance().getProcesses();
            }
            catch (JStartupClusterControlException ex) {
                EnginePlugin.getTracer().warning("Cannot get processes", (Throwable)ex);
            }
            int i = 0;
            while (i < procs.length) {
                if (procs[i].getType() == 3 && procs[i].getState() == 3) {
                    ++serverCount;
                }
                ++i;
            }
            ++inst;
        }
        return serverCount;
    }

    public int getNumberOfServers(int state) {
        int numOfServers = 0;
        try {
            ServerProcessNode[] servers = ProcessNodeManagement.getAllServerNodes();
            int srv = 0;
            while (srv < servers.length) {
                ServerProcessNode node = servers[srv];
                if (state == -1 || node.getProcessState() == state) {
                    ++numOfServers;
                }
                ++srv;
            }
        }
        catch (JStartupClusterControlException ex) {
            EnginePlugin.getTracer().warning("Could not count number of servers", (Throwable)ex);
        }
        return numOfServers;
    }

    public int getTotalNumberOfServers() {
        return this.getNumberOfServers(-1);
    }

    public int getNumberOfRunningServers() {
        return this.getNumberOfServers(3);
    }

    public int getNumberOfDebuggingServers() {
        return this.getNumberOfServers(7);
    }

    public int getNumberOfStoppedServers() {
        return this.getNumberOfServers(6);
    }

    public String getServerDebugPort(ServerProcessNode serverNode) {
        return serverNode.getDebugPort();
    }

    public String getServerDebugPort(String serverName) {
        String debugPort = "";
        try {
            ServerProcessNode defaultNode = (ServerProcessNode)ProcessNodeManagement.createNode(serverName);
            debugPort = this.getServerDebugPort(defaultNode);
        }
        catch (IllegalArgumentException ex) {
            EnginePlugin.getTracer().warning("Cannot determine debug host!", (Throwable)ex);
        }
        catch (JStartupClusterControlException ex) {
            EnginePlugin.getTracer().warning("Cannot determine debug host!", (Throwable)ex);
        }
        return debugPort;
    }

    public String getServerDebugHost(ProcessNode serverNode) {
        return serverNode.getHost();
    }

    public String getServerDebugHost(String serverName) {
        String debugHost = "";
        try {
            ProcessNode defaultNode = ProcessNodeManagement.createNode(serverName);
            debugHost = this.getServerDebugHost(defaultNode);
        }
        catch (IllegalArgumentException ex) {
            EnginePlugin.getTracer().warning("Cannot determine debug host!", (Throwable)ex);
        }
        catch (JStartupClusterControlException ex) {
            EnginePlugin.getTracer().warning("Cannot determine debug host!", (Throwable)ex);
        }
        return debugHost;
    }

    public String getDebugUrlExt(String clusterId) {
        String urlExt = "";
        if (this.getTotalNumberOfServers() > 1) {
            urlExt = "/@@@DEBUG@@@" + clusterId;
        }
        return urlExt;
    }

    public String getServerDebugUrlExt(ServerProcessNode serverNode) {
        return this.getDebugUrlExt(serverNode.getClusterId());
    }

    public String getServerDebugUrlExt(String serverName) {
        String urlExt = "";
        try {
            ServerProcessNode defaultNode = (ServerProcessNode)ProcessNodeManagement.createNode(serverName);
            urlExt = this.getServerDebugUrlExt(defaultNode);
        }
        catch (IllegalArgumentException ex) {
            EnginePlugin.getTracer().warning("Cannot compute debug url extension!", (Throwable)ex);
        }
        catch (JStartupClusterControlException ex) {
            EnginePlugin.getTracer().warning("Cannot compute debug url extension!", (Throwable)ex);
        }
        return urlExt;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        store.setDefault(INSTALLATION_TYPE_KEY, 0);
        store.setDefault(MESSAGE_SERVER_HOST_KEY, MESSAGE_SERVER_HOST_DEFAULT);
        store.setDefault(MESSAGE_SERVER_PORT_KEY, MESSAGE_SERVER_PORT_DEFAULT);
        store.setDefault(SYSTEM_ID_KEY, "");
        store.setDefault(J2EE_INSTANCE_KEY, "");
        store.setDefault(SCS_INSTANCE_KEY, "");
        store.setDefault(J2EE_PROFILE_KEY, "");
        store.setDefault(SCS_PROFILE_KEY, "");
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        if (this.getClusterControllerState() == 1) {
            JStartupClusterController controller = this.getClusterController();
            try {
                if (controller != null) {
                    JStartupClusterInstance[] instances = controller.getInstances();
                    int i = 0;
                    while (i < instances.length) {
                        JStartupControlInstance ctrlInstance;
                        JStartupClusterInstance instance = instances[i];
                        if (instance.getMessageType() == 1 && (ctrlInstance = instance.getControlInstance()) != null) {
                            JStartupControlProcess[] procs = ctrlInstance.getProcesses();
                            int p = 0;
                            while (p < procs.length) {
                                JStartupControlProcess process = procs[p];
                                if (process.getState() == 7 && ProcessContainer.getInstance().containsProcess(process.getName())) {
                                    process.disableDebugSession();
                                }
                                ++p;
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (JStartupClusterControlException e) {
                EnginePlugin.getTracer().warning("Could not release reserved processes", (Throwable)e);
            }
            if (controller != null) {
                controller.exit();
            }
        }
    }

    private int getClusterControllerState() {
        return this.clusterControllerState;
    }

    private void setClusterControllerState(int i) {
        this.clusterControllerState = i;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.getPreferenceStore().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.getPreferenceStore().removePropertyChangeListener(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

