/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport.app;

import com.sapportals.portal.transport.app.EpaException;
import com.sapportals.portal.transport.app.IPackageEntry;
import com.sapportals.portal.transport.app.PackageDescriptorParseException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PackageDescriptorHandler {
    private static final String CLASSNAME = "[" + (class$com$sapportals$portal$transport$app$PackageDescriptorHandler == null ? (class$com$sapportals$portal$transport$app$PackageDescriptorHandler = PackageDescriptorHandler.class$("com.sapportals.portal.transport.app.PackageDescriptorHandler")) : class$com$sapportals$portal$transport$app$PackageDescriptorHandler).getName() + "]";
    public static final String E_PACKAGE = "package";
    public static final String E_HEAD = "head";
    public static final String E_PROPERTY = "property";
    public static final String E_BODY = "body";
    public static final String E_TRANSPORTOBJECT = "transportObject";
    public static final String E_OBJECTURL = "objectURL";
    public static final String E_OBJECTTYPE = "objectType";
    public static final String E_IMPORTHANDLERFACTORY = "importHandlerFactory";
    public static final String E_TRANSPORTFILE = "transportFile";
    public static final String E_DEPENDENCIES = "dependencies";
    public static final String E_DEPENDENCY = "dependency";
    public static final String A_NAME = "name";
    public static final String A_FORMAT = "format";
    public static final String A_OBJECTTYPE = "objectType";
    public static final String A_VERSION = "version";
    public static final String A_KEY = "key";
    public static final String A_VALUE = "value";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String LATIN1_ENCODING = "ISO-8859-1";
    public static final String VERSION_10 = "1.0";
    public static final String VERSION_20 = "2.0";
    public static final String VERSION_21 = "2.1";
    public static final String CURRENT_VERSION = "2.1";
    private static final int INITIAL_LIST_CAPACITY = 100;
    protected List objectList;
    protected Properties properties = new Properties();
    protected String version;
    protected Document document;
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;
    static /* synthetic */ Class class$com$sapportals$portal$transport$app$PackageDescriptorHandler;

    public PackageDescriptorHandler() {
        this.objectList = new ArrayList(100);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.transformerFactory = TransformerFactory.newInstance();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
    }

    public void addEntry(IPackageEntry anEntry) {
        this.objectList.add(anEntry);
    }

    public void setPackageProperty(String aKey, String aValue) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(aKey, aValue);
    }

    public Properties getPackageProperties() {
        return this.properties;
    }

    public List getEntries() {
        return this.objectList;
    }

    public void write(OutputStream os) throws EpaException {
        try {
            this.createDocument();
            Element packageElement = this.document.createElement(E_PACKAGE);
            packageElement.setAttribute(A_VERSION, "2.1");
            this.document.appendChild(packageElement);
            packageElement.appendChild(this.createHeadElement());
            packageElement.appendChild(this.createBodyElement());
            this.writeDocument(os, DEFAULT_ENCODING);
        }
        catch (Exception ex) {
            throw new EpaException("Failed to create package descriptor.", (Throwable)ex);
        }
    }

    public void read(InputStream is) throws EpaException {
        try {
            DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
            this.document = builder.parse(is);
            this.parseVersion();
            this.parseDocumentHead();
            this.parseDocumentBody();
        }
        catch (EpaException tEx) {
            throw tEx;
        }
        catch (Exception ex) {
            throw new EpaException("Failed to read package descriptor.", (Throwable)ex);
        }
    }

    protected void createDocument() throws ParserConfigurationException {
        DocumentBuilder builder = this.documentBuilderFactory.newDocumentBuilder();
        this.document = builder.newDocument();
    }

    protected Element createHeadElement() {
        Element el = this.document.createElement(E_HEAD);
        if (this.properties != null) {
            String key = null;
            Element propertyEl = null;
            TreeSet sortedKeySet = new TreeSet();
            Enumeration enumeration = ((Hashtable)this.properties).keys();
            while (enumeration.hasMoreElements()) {
                sortedKeySet.add(enumeration.nextElement());
            }
            Iterator it = sortedKeySet.iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                propertyEl = this.document.createElement(E_PROPERTY);
                propertyEl.setAttribute(A_KEY, key);
                propertyEl.setAttribute(A_VALUE, this.properties.getProperty(key));
                el.appendChild(propertyEl);
            }
        }
        return el;
    }

    protected Element createBodyElement() {
        Element bodyEl = this.document.createElement(E_BODY);
        Iterator it = this.objectList.iterator();
        while (it.hasNext()) {
            IPackageEntry entry = (IPackageEntry)it.next();
            Element entryElement = this.createEntryElement(entry);
            bodyEl.appendChild(entryElement);
        }
        return bodyEl;
    }

    protected Element createEntryElement(IPackageEntry anEntry) {
        Element transportObjectEl = this.document.createElement(E_TRANSPORTOBJECT);
        Element el = this.createSingleValueElement(E_OBJECTURL, anEntry.getObjectUrl());
        transportObjectEl.appendChild(el);
        el = this.createSingleValueElement("objectType", anEntry.getObjectType());
        transportObjectEl.appendChild(el);
        el = this.createSingleValueElement(E_IMPORTHANDLERFACTORY, anEntry.getImportHandlerFactoryName());
        transportObjectEl.appendChild(el);
        el = this.createSingleValueElement(E_TRANSPORTFILE, anEntry.getFileName());
        transportObjectEl.appendChild(el);
        return transportObjectEl;
    }

    protected void writeDocument(OutputStream os, String encoding) throws TransformerException {
        Transformer transformer;
        if (this.document != null) {
            transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
        } else {
            throw new IllegalStateException(CLASSNAME + " writeDocument: document is null.");
        }
        DOMSource domSource = new DOMSource(this.document);
        StreamResult streamResult = new StreamResult(os);
        transformer.transform(domSource, streamResult);
    }

    protected Element createSingleValueElement(String elementName, String value) {
        Element el = this.document.createElement(elementName);
        Text textNode = this.document.createTextNode(value);
        el.appendChild(textNode);
        return el;
    }

    protected void parseVersion() {
        this.version = this.document.getDocumentElement().getAttribute(A_VERSION);
        if (this.version == null) {
            this.version = VERSION_10;
        }
    }

    protected void parseDocumentHead() throws PackageDescriptorParseException {
        NodeList headNodes = this.document.getDocumentElement().getElementsByTagName(E_HEAD);
        if (headNodes == null || headNodes.getLength() == 0) {
            return;
        }
        Element headEl = (Element)headNodes.item(0);
        NodeList propertyNodes = headEl.getElementsByTagName(E_PROPERTY);
        Element propertyEl = null;
        int i = 0;
        while (i < propertyNodes.getLength()) {
            propertyEl = (Element)propertyNodes.item(i);
            this.properties.setProperty(propertyEl.getAttribute(A_KEY), propertyEl.getAttribute(A_VALUE));
            ++i;
        }
    }

    protected void parseDocumentBody() throws PackageDescriptorParseException {
        NodeList bodyNodes = this.document.getDocumentElement().getElementsByTagName(E_BODY);
        Element bodyEl = (Element)bodyNodes.item(0);
        NodeList entryNodes = bodyEl.getElementsByTagName(E_TRANSPORTOBJECT);
        int i = 0;
        while (i < entryNodes.getLength()) {
            IPackageEntry entry = this.parseEntryElement((Element)entryNodes.item(i));
            this.objectList.add(entry);
            ++i;
        }
    }

    protected IPackageEntry parseEntryElement(Element entryEl) throws PackageDescriptorParseException {
        Element el = (Element)entryEl.getElementsByTagName(E_OBJECTURL).item(0);
        String objectUrl = this.parseSingleValueElement(el);
        el = (Element)entryEl.getElementsByTagName("objectType").item(0);
        String objectType = this.parseSingleValueElement(el);
        String importHandlerFactoryName = null;
        NodeList nodeList = entryEl.getElementsByTagName(E_IMPORTHANDLERFACTORY);
        if (nodeList != null && nodeList.getLength() > 0) {
            el = (Element)nodeList.item(0);
            importHandlerFactoryName = this.parseSingleValueElement(el);
        } else {
            importHandlerFactoryName = this.getImportHandlerFactoryByObjectType(objectType);
        }
        el = (Element)entryEl.getElementsByTagName(E_TRANSPORTFILE).item(0);
        String fileName = this.parseSingleValueElement(el);
        if (fileName != null) {
            fileName = fileName.trim().replace('\\', '/');
        }
        return new Entry(objectUrl, objectType, importHandlerFactoryName, fileName);
    }

    private String parseSingleValueElement(Element element) {
        String value = null;
        if (element.hasChildNodes()) {
            value = element.getFirstChild().getNodeValue();
        }
        return value;
    }

    protected String getImportHandlerFactoryByObjectType(String aObjectType) {
        String ocArchive = "com.sapportals.portal.application.applicationrepository.Archive";
        String importHandlerArchive = "com.sap.portal.runtime.system.repository.application_repository";
        String importHandlerPcdGl = "com.sap.portal.pcd.glservice.generic_layer";
        if (aObjectType.equals("com.sapportals.portal.application.applicationrepository.Archive")) {
            return "com.sap.portal.runtime.system.repository.application_repository";
        }
        return "com.sap.portal.pcd.glservice.generic_layer";
    }

    public void setPackageProperties(Properties pProperties) {
        this.properties = pProperties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Entry
    implements IPackageEntry {
        private String objectUrl;
        private String objectType;
        private String importHandlerFactoryName;
        private String fileName;

        public Entry(String aObjectUrl, String aObjectType, String aImportHandlerFactoryName, String aFileName) {
            this.objectUrl = aObjectUrl;
            this.objectType = aObjectType;
            this.importHandlerFactoryName = aImportHandlerFactoryName;
            this.fileName = aFileName;
        }

        public String getObjectUrl() {
            return this.objectUrl;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getImportHandlerFactoryName() {
            return this.importHandlerFactoryName;
        }
    }
}

