/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport.app;

import com.sapportals.portal.transport.app.EpaManifest;
import com.sapportals.portal.transport.app.IEpaOutput;
import com.sapportals.portal.transport.app.IPackageEntry;
import com.sapportals.portal.transport.app.PackageDescriptorHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EpaOutputStream
extends OutputStream
implements IEpaOutput {
    private ZipOutputStream zipOs;
    private PackageDescriptorHandler packageDesc;
    private boolean isClosed;
    private boolean isFinished;

    public EpaOutputStream(OutputStream aOutputStream) throws IOException {
        this(aOutputStream, null);
    }

    public EpaOutputStream(OutputStream aOutputStream, Manifest aManifest) throws IOException {
        Manifest epaManifest = null;
        epaManifest = aManifest == null ? new EpaManifest() : (aManifest instanceof EpaManifest ? aManifest : new EpaManifest(aManifest));
        this.zipOs = new JarOutputStream(aOutputStream, epaManifest);
        this.packageDesc = new PackageDescriptorHandler();
    }

    public void setPackageProperties(Properties pProperties) {
        this.packageDesc.setPackageProperties(pProperties);
    }

    public void write(int b) throws IOException {
        this.ensureWritePossible();
        this.zipOs.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureWritePossible();
        this.zipOs.write(b, off, len);
    }

    public OutputStream putNextEntry(IPackageEntry aEntry) throws IOException {
        this.packageDesc.addEntry(aEntry);
        String zipEntryName = aEntry.getFileName().trim().replace(File.separatorChar, '/');
        ZipEntry zipEntry = new ZipEntry("EPT/" + zipEntryName);
        this.zipOs.putNextEntry(zipEntry);
        return this;
    }

    public void finish() throws IOException {
        if (this.isFinished) {
            return;
        }
        ZipEntry packageDescEntry = new ZipEntry("PACKAGE-INF/package.xml");
        this.zipOs.putNextEntry(packageDescEntry);
        this.packageDesc.write(this.zipOs);
        this.zipOs.closeEntry();
        this.zipOs.finish();
        this.isFinished = true;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (!this.isFinished) {
            this.finish();
        }
        this.zipOs.close();
        this.isClosed = true;
    }

    private void ensureWritePossible() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed.");
        }
        if (this.isFinished) {
            throw new IOException("Stream finished.");
        }
    }
}

