/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport.app;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class EpaManifest
extends Manifest {
    public static final String CREATION_DATE = "Creation-Date";
    public static final String CREATION_TIME = "Creation-Time";
    public static final String CREATION_TIMEZONE = "Creation-TimeZone";
    public static final String CREATOR = "Creator";
    public static final String CREATOR_VERSION = "Creator-Version";
    public static final String CREATOR_CONTEXT = "Creator-Context";
    public static final String JAVA_VERSION = "Java-Version";
    public static final String JAVA_VM = "Java-VM";
    public static final String OS_NAME = "OS-Name";
    private static final DateFormat DATE_DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat TIME_DATEFORMAT = new SimpleDateFormat("HHmmss");
    private static final DateFormat DATETIME_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String VAL_JAVA_VERSION = System.getProperty("java.version", "");
    private static final String VAL_JAVA_VM;
    private static final String VAL_OS_NAME;
    private static final NumberFormat TZ_HOURS_NUMBERFORMAT;
    private static final NumberFormat TZ_MINUTES_NUMBERFORMAT;

    public EpaManifest() {
        this.addEpaManifestAttributes(this.getMainAttributes());
    }

    public EpaManifest(InputStream aInputStream) throws IOException {
        super(aInputStream);
    }

    public EpaManifest(Manifest aManifest) {
        super(aManifest);
        this.addEpaManifestAttributes(this.getMainAttributes());
    }

    private void addEpaManifestAttributes(Attributes theAttributes) {
        theAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        Date now = new Date();
        theAttributes.putValue(CREATION_DATE, DATE_DATEFORMAT.format(now));
        theAttributes.putValue(CREATION_TIME, TIME_DATEFORMAT.format(now));
        Calendar calendarNow = Calendar.getInstance();
        calendarNow.setTime(now);
        String timeZoneString = EpaManifest.timeZoneToString(TimeZone.getDefault(), calendarNow);
        theAttributes.putValue(CREATION_TIMEZONE, timeZoneString);
        Package creatorPackage = this.getClass().getPackage();
        if (creatorPackage != null) {
            String implementationVersion;
            String implementationTitle = creatorPackage.getImplementationTitle();
            if (implementationTitle != null) {
                theAttributes.putValue(CREATOR, implementationTitle);
            }
            if ((implementationVersion = creatorPackage.getImplementationVersion()) != null) {
                theAttributes.putValue(CREATOR_VERSION, implementationVersion);
            }
        }
        theAttributes.putValue(JAVA_VERSION, VAL_JAVA_VERSION);
        theAttributes.putValue(JAVA_VM, VAL_JAVA_VM);
        theAttributes.putValue(OS_NAME, VAL_OS_NAME);
    }

    private static String timeZoneToString(TimeZone aTimeZone, Calendar aCalendar) {
        StringBuffer sb = new StringBuffer(100);
        TimeZone tz = null;
        tz = aTimeZone == null ? TimeZone.getDefault() : aTimeZone;
        String tzId = tz.getID();
        if (tzId != null) {
            sb.append(tzId);
            sb.append(" ");
        }
        int offsetMillis = tz.getOffset(aCalendar.get(0), aCalendar.get(1), aCalendar.get(2), aCalendar.get(5), aCalendar.get(7), EpaManifest.getMillisInDay(aCalendar));
        int offsetHours = offsetMillis / 3600000;
        int offsetMinutes = offsetMillis % 3600000 / 60000;
        sb.append("[GMT");
        sb.append(TZ_HOURS_NUMBERFORMAT.format(offsetHours));
        if (offsetMinutes > 0) {
            sb.append(":");
            sb.append(TZ_MINUTES_NUMBERFORMAT.format(offsetMinutes));
        }
        sb.append("]");
        return sb.toString();
    }

    private static int getMillisInDay(Calendar aCalendar) {
        return aCalendar.get(11) * 3600000 + aCalendar.get(12) * 60000 + aCalendar.get(13) * 1000 + aCalendar.get(14);
    }

    public static void main(String[] args) {
        TimeZone defaultTz = TimeZone.getDefault();
        Calendar now = Calendar.getInstance();
        Calendar summerDay = Calendar.getInstance();
        summerDay.set(1, 2003);
        summerDay.set(2, 6);
        summerDay.set(5, 1);
        Calendar winterDay = Calendar.getInstance();
        winterDay.set(1, 2003);
        winterDay.set(2, 10);
        winterDay.set(5, 24);
        System.out.println("Default timezone: " + defaultTz.toString());
        System.out.print("Timezone for summer day: ");
        System.out.println(EpaManifest.timeZoneToString(defaultTz, summerDay));
        System.out.print("Timezone for winter day: ");
        System.out.println(EpaManifest.timeZoneToString(defaultTz, winterDay));
        System.out.println();
        System.out.println();
        String[] availableTimeZoneIds = TimeZone.getAvailableIDs();
        int i = 0;
        while (i < availableTimeZoneIds.length) {
            TimeZone tz = TimeZone.getTimeZone(availableTimeZoneIds[i]);
            System.out.println("------  Timezone: " + tz.toString() + " ------------");
            System.out.print("Timezone for summer day: ");
            System.out.println(EpaManifest.timeZoneToString(tz, summerDay));
            System.out.print("Timezone for winter day: ");
            System.out.println(EpaManifest.timeZoneToString(tz, winterDay));
            System.out.println();
            System.out.println();
            ++i;
        }
        System.out.println();
        System.out.println("Parse test for non-existing TZ:");
        TimeZone gibtsnet = TimeZone.getTimeZone("XXXXX");
        System.out.println(gibtsnet);
    }

    public void setCreatorContext(String pCreatorContext) {
        this.getMainAttributes().putValue(CREATOR_CONTEXT, pCreatorContext);
    }

    static {
        StringBuffer sb = new StringBuffer(200);
        sb.append(System.getProperty("java.vm.name", ""));
        sb.append(" (");
        sb.append(System.getProperty("java.vm.version", ""));
        sb.append(") ");
        sb.append(System.getProperty("java.vm.vendor", ""));
        VAL_JAVA_VM = sb.toString();
        sb.setLength(0);
        sb.append(System.getProperty("os.name", ""));
        sb.append(" (");
        sb.append(System.getProperty("os.version", ""));
        sb.append(") ");
        sb.append(System.getProperty("os.arch", ""));
        VAL_OS_NAME = sb.toString();
        Object var0 = null;
        TZ_HOURS_NUMBERFORMAT = new DecimalFormat("+00;-00");
        TZ_MINUTES_NUMBERFORMAT = new DecimalFormat("00");
    }
}

