/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport.app;

import com.sapportals.portal.transport.app.EpaException;
import com.sapportals.portal.transport.app.IPackageEntry;
import com.sapportals.portal.transport.app.PackageDescriptorHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EpaFile {
    private ZipFile zipFile;
    private File file;
    private PackageDescriptorHandler packageDesc;
    private boolean isClosed;

    public EpaFile(File aEpaFile) throws IOException {
        this.file = aEpaFile;
        this.zipFile = new ZipFile(aEpaFile);
        this.isClosed = false;
    }

    public List getEntries() throws IOException {
        this.ensureOpen();
        if (this.packageDesc == null) {
            this.readPackageDescriptor();
        }
        return this.packageDesc.getEntries();
    }

    public Properties getProperties() throws IOException {
        this.ensureOpen();
        if (this.packageDesc == null) {
            this.readPackageDescriptor();
        }
        return this.packageDesc.getPackageProperties();
    }

    public InputStream getInputStream(IPackageEntry aPackageEntry) throws IOException {
        this.ensureOpen();
        ZipEntry zipEntry = null;
        String entryFileName = aPackageEntry.getFileName();
        zipEntry = entryFileName.indexOf(47) < 0 ? new ZipEntry("EPT/" + entryFileName) : new ZipEntry(entryFileName);
        return this.zipFile.getInputStream(zipEntry);
    }

    public PackageDescriptorHandler getPackageDescriptor() throws IOException {
        if (this.packageDesc == null) {
            this.readPackageDescriptor();
        }
        return this.packageDesc;
    }

    public void close() throws IOException {
        this.ensureOpen();
        this.zipFile.close();
        this.isClosed = true;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new EpaException("EPA file " + this.getAbsolutePath() + " is already closed.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readPackageDescriptor() throws IOException {
        InputStream is = null;
        ZipEntry zipEntry = this.zipFile.getEntry("PACKAGE-INF/package.xml");
        if (zipEntry == null) {
            throw new EpaException("File " + this.getAbsolutePath() + " does not contain a package descriptor entry (" + "PACKAGE-INF/package.xml" + ")");
        }
        try {
            is = this.zipFile.getInputStream(zipEntry);
            PackageDescriptorHandler newPackageDescriptor = new PackageDescriptorHandler();
            newPackageDescriptor.read(is);
            this.packageDesc = newPackageDescriptor;
            Object var5_4 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (IOException ioEx) {}
    }
}

