/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport.app;

import com.sapportals.portal.transport.app.FileUtils;
import com.sapportals.portal.transport.app.IEpaOutput;
import com.sapportals.portal.transport.app.IPackageEntry;
import com.sapportals.portal.transport.app.IPackageFileConstants;
import com.sapportals.portal.transport.app.PackageDescriptorHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class DiscreteEpaOutput
implements IEpaOutput {
    private File destination;
    private File eptDir;
    private boolean closed = false;
    private boolean initialized = false;
    private OutputStream currentEntryOs;
    private PackageDescriptorHandler packageDesc;

    public DiscreteEpaOutput(File aDestination) {
        this.destination = aDestination;
        this.packageDesc = new PackageDescriptorHandler();
    }

    public void setPackageProperties(Properties pProperties) {
        this.packageDesc.setPackageProperties(pProperties);
    }

    public OutputStream putNextEntry(IPackageEntry aEntry) throws IOException {
        this.ensureOpen();
        this.init();
        this.packageDesc.addEntry(aEntry);
        if (this.currentEntryOs != null) {
            try {
                this.currentEntryOs.close();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
        }
        File entryFile = new File(this.eptDir, aEntry.getFileName().trim());
        this.currentEntryOs = new FileOutputStream(entryFile);
        return this.currentEntryOs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        block9: {
            File packageDescFile;
            if (this.closed) return;
            if (this.currentEntryOs != null) {
                try {
                    this.currentEntryOs.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!(packageDescFile = new File(this.destination, IPackageFileConstants.PACKAGE_DESC_FILENAME)).getParentFile().mkdir()) {
                throw new IOException("Failed to create PACKAGE-INF directory for destination " + this.destination);
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(packageDescFile);
                this.packageDesc.write(os);
                Object var4_4 = null;
                if (os == null) break block9;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (os == null) throw throwable;
                try {
                    ((OutputStream)os).close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            ((OutputStream)os).close();
        }
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("EPA Output for destination " + this.destination + " is already closed.");
        }
    }

    private void init() throws IOException {
        if (!this.initialized) {
            if (this.destination.exists()) {
                FileUtils.delTree((File)this.destination);
            }
            if (!this.destination.mkdirs()) {
                throw new IOException("Failed to create destination directory " + this.destination);
            }
            this.eptDir = new File(this.destination, "EPT");
            if (!this.eptDir.mkdir()) {
                throw new IOException("Failed to create EPT directory " + this.eptDir);
            }
            this.initialized = true;
        }
    }
}

