/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.devconf.OfflineException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IActionResult;
import com.sap.tc.devconf.update.IUpdateWSFilterAction;
import com.sap.tc.devconf.update.impl.AbstractAction;
import com.sap.tc.devconf.update.impl.ActionResult;
import com.sap.tc.devconf.update.impl.DevconfUpdateTexts;
import com.sap.tc.devconf.update.impl.ServerDefinitionAction;
import com.sap.tc.devconf.update.impl.UpdateActionMessage;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.VfsFilterType;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.text.MessageFormat;
import java.util.ArrayList;

class UpdateWSFilterAction
extends AbstractAction
implements IUpdateWSFilterAction {
    Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$UpdateWSFilterAction == null ? (class$com$sap$tc$devconf$update$impl$UpdateWSFilterAction = UpdateWSFilterAction.class$("com.sap.tc.devconf.update.impl.UpdateWSFilterAction")) : class$com$sap$tc$devconf$update$impl$UpdateWSFilterAction));
    private final IUpdateWSFilterAction.FilterActionKind m_kindOfAction;
    private final String m_path;
    private final String m_serverURL;
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$UpdateWSFilterAction;

    public UpdateWSFilterAction(DevelopmentConfiguration config, String serverURL, String path, IUpdateWSFilterAction.FilterActionKind kindOfAction) {
        super(config);
        if (kindOfAction != IUpdateWSFilterAction.FilterActionKind.DELETE && kindOfAction != IUpdateWSFilterAction.FilterActionKind.ADD && kindOfAction != IUpdateWSFilterAction.FilterActionKind.ADD_READONLY) {
            String m = "Internal Error: Illegal kindOfAction=" + kindOfAction + " for constructor of UpdateWSFilterAction";
            IllegalArgumentException ex = new IllegalArgumentException(m);
            this.LOCATION.traceThrowableT(300, "UpdateWSFilterAction", "Throwing: " + m, (Throwable)ex);
            throw ex;
        }
        this.m_path = path;
        this.m_serverURL = serverURL;
        this.m_kindOfAction = kindOfAction;
    }

    public String getServerURL() {
        return this.m_serverURL;
    }

    public String getWorkspace() {
        return this.m_path;
    }

    public IUpdateWSFilterAction.FilterActionKind getKindOfAction() {
        return this.m_kindOfAction;
    }

    public String describe() {
        String m;
        if (this.m_kindOfAction == IUpdateWSFilterAction.FilterActionKind.DELETE) {
            m = DevconfUpdateTexts.getString("UpdateWSFilterAction.ACTION_DELETE");
        } else if (this.m_kindOfAction == IUpdateWSFilterAction.FilterActionKind.ADD) {
            m = DevconfUpdateTexts.getString("UpdateWSFilterAction.ACTION_ADD");
        } else if (this.m_kindOfAction == IUpdateWSFilterAction.FilterActionKind.ADD_READONLY) {
            m = DevconfUpdateTexts.getString("UpdateWSFilterAction.ACTION_ADD_READONLY");
        } else {
            String msg = "Internal Error: Illegal kindOfAction=" + this.m_kindOfAction + " stored in UpdateWSFilterAction";
            IllegalStateException ex = new IllegalStateException(msg);
            this.LOCATION.traceThrowableT(300, "UpdateWSFilterAction", "Throwing: " + msg, (Throwable)ex);
            throw ex;
        }
        return MessageFormat.format(m, this.m_path, this.m_serverURL);
    }

    protected IActionResult _execute() throws FatalConfigurationUpdateException {
        String thisMethod = "_execute";
        try {
            String msg;
            IClient client = this.getConfig().getDTRClient();
            if (client == null) {
                String msg2 = "Update Configuration failed. Could not update workspace filters. DTR client is null";
                this.LOCATION.infoT(thisMethod, msg2);
                throw new FatalConfigurationUpdateException(msg2);
            }
            IRepositoryServer server = client.getLogicalSystem().getRepositoryServer(this.getServerURL());
            if (server == null) {
                String msg3 = MessageFormat.format("Update Configuration failed, could not update workspace filters. Failed to find server {0} in DTR client configuration", this.getServerURL());
                this.LOCATION.infoT(thisMethod, msg3);
                throw new FatalConfigurationUpdateException(msg3);
            }
            IUpdateWSFilterAction.FilterActionKind kind = this.getKindOfAction();
            server.setFilter("ws/", VfsFilterType.EXCLUDE);
            if (kind == IUpdateWSFilterAction.FilterActionKind.ADD) {
                server.setFilter(this.getWorkspace(), VfsFilterType.INCLUDE);
                msg = "Sucessfully added include filter for workspace {0} on server {1}";
            } else if (kind == IUpdateWSFilterAction.FilterActionKind.ADD_READONLY) {
                server.setFilter(this.getWorkspace(), VfsFilterType.READONLY);
                msg = "Sucessfully added readonly filter for workspace {0} on server {1}";
            } else if (kind == IUpdateWSFilterAction.FilterActionKind.DELETE) {
                server.removeFilter(this.getWorkspace());
                msg = "Sucessfully removed filter for workspace {0} on server {1}";
            } else {
                String errorMsg = MessageFormat.format("Update Configuration failed. Unknown type of change for workspace filter: {0}", kind.toString());
                this.LOCATION.infoT(thisMethod, errorMsg);
                throw new FatalConfigurationUpdateException(errorMsg);
            }
            msg = MessageFormat.format(msg, this.getWorkspace(), this.getServerURL());
            this.LOCATION.debugT(thisMethod, msg);
            ArrayList<UpdateActionMessage> okList = new ArrayList<UpdateActionMessage>(1);
            okList.add(new UpdateActionMessage(msg, true, null));
            return new ActionResult(okList, new ArrayList(0));
        }
        catch (OfflineException e) {
            String msg = MessageFormat.format("Update Configuration failed, could not update workspace filters: {0}", ((Throwable)((Object)e)).getMessage());
            this.LOCATION.traceThrowableT(300, msg, (Throwable)((Object)e));
            throw new FatalConfigurationUpdateException(msg, (Throwable)((Object)e));
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ServerDefinitionAction)) {
            return false;
        }
        UpdateWSFilterAction other = (UpdateWSFilterAction)obj;
        if (this.m_serverURL == null) {
            return other.m_serverURL == null;
        }
        if (!this.m_serverURL.equals(other.m_serverURL)) {
            return false;
        }
        if (this.m_path == null) {
            return other.m_path == null;
        }
        if (!this.m_path.equals(other.m_path)) {
            return false;
        }
        if (this.m_kindOfAction == null) {
            return other.m_kindOfAction == null;
        }
        return this.m_kindOfAction.equals(other.m_kindOfAction);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + (this.m_serverURL == null ? 0 : this.m_serverURL.hashCode());
        hash = 37 * hash + (this.m_path == null ? 0 : this.m_path.hashCode());
        hash = 37 * hash + (this.m_kindOfAction == null ? 0 : this.m_kindOfAction.hashCode());
        return hash;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

