/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.complib.cmpconf.IConfigurationDelta;
import com.sap.tc.complib.provider.ConfigurationOutputProvider;
import com.sap.tc.complib.provider.SimpleFileConfigOutputProvider;
import com.sap.tc.devconf.update.ConfigurationUpdateException;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IConfigDeltaEvaluation;
import com.sap.tc.devconf.update.IUpdatePlan;
import com.sap.tc.devconf.update.impl.AbstractAction;
import com.sap.tc.devconf.update.impl.UpdateReport;
import com.sap.tc.logging.Location;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;

class UpdateProcessor {
    private static final String EXTENSION_BACKUP = ".bak";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$UpdateProcessor == null ? (class$com$sap$tc$devconf$update$impl$UpdateProcessor = UpdateProcessor.class$("com.sap.tc.devconf.update.impl.UpdateProcessor")) : class$com$sap$tc$devconf$update$impl$UpdateProcessor));
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$UpdateProcessor;

    UpdateProcessor() {
    }

    UpdateReport executeUpdate(com.sap.tc.devconf.impl.DevelopmentConfiguration config, IConfigDeltaEvaluation evaluation) throws ConfigurationUpdateException, FatalConfigurationUpdateException {
        String thisMethod = "executeUpdate";
        UpdateReport report = new UpdateReport();
        IConfigurationDelta confDelta = evaluation.getComparisonResult().getConfigurationDelta();
        if (confDelta == null) {
            return report;
        }
        DevelopmentConfiguration oldConfig = confDelta.getOldConfiguration();
        String configRootFolderPath = config.getConfigurationRootFolder();
        String configFile = Util.concatenatePath((String)configRootFolderPath, (String)".confdef", (char)File.separatorChar);
        String backupFile = Util.concatenatePath((String)configRootFolderPath, (String)".confdef.bak", (char)File.separatorChar);
        try {
            Util.copyFileContent((String)configFile, (String)backupFile);
        }
        catch (Throwable e) {
            String m = MessageFormat.format("Failed to create backup copy {0} of configuration file {1}: {2}", backupFile, configFile, e.getMessage());
            LOCATION.traceThrowableT(300, thisMethod, m, e);
            throw new ConfigurationUpdateException(m, e);
        }
        SimpleFileConfigOutputProvider outputProvider = new SimpleFileConfigOutputProvider(configFile);
        try {
            oldConfig.serialize((ConfigurationOutputProvider)outputProvider);
        }
        catch (Throwable e) {
            String m = MessageFormat.format("Failed to persist the new configuration to file {0}: {1}", configFile, e.getMessage());
            LOCATION.traceThrowableT(300, thisMethod, m, e);
            this.restoreBackup(thisMethod, configFile, backupFile, e);
            throw new ConfigurationUpdateException(m, e);
        }
        IUpdatePlan plan = evaluation.getUpdatePlan();
        Iterator iter = plan.getActionsBeforeSwitch();
        while (iter.hasNext()) {
            AbstractAction action = (AbstractAction)iter.next();
            report.add(action.execute());
        }
        config.getDcProxyCache().clearCache(true);
        if (!config.isInOfflineMode()) {
            config.goToLocalOnlyMode();
        }
        try {
            config._reloadDefinition();
        }
        catch (Exception e) {
            if (plan.countActionsBeforeSwitch() == 0) {
                String m = MessageFormat.format("Failed to reload the new configuration from the new file {0}: {1}. Restoring backup version.", configFile, e.getMessage());
                LOCATION.traceThrowableT(300, thisMethod, m, (Throwable)e);
                this.restoreBackup(thisMethod, configFile, backupFile, e);
                ConfigurationUpdateException ex = new ConfigurationUpdateException(m, e);
                throw ex;
            }
            String m = MessageFormat.format("Fatal error during update of configuration. Configuration may be inconsistent. Failed to reload the new configuration from the new file {0}: {1}", configFile, e.getMessage());
            LOCATION.traceThrowableT(300, thisMethod, m, (Throwable)e);
            FatalConfigurationUpdateException ex = new FatalConfigurationUpdateException(m, e);
            LOCATION.throwing(thisMethod, (Throwable)((Object)ex));
            throw ex;
        }
        Iterator iter2 = plan.getActionsAfterSwitch();
        while (iter2.hasNext()) {
            AbstractAction action = (AbstractAction)iter2.next();
            report.add(action.execute());
        }
        return report;
    }

    private void restoreBackup(String theMethod, String configFile, String backupFile, Throwable cause) throws FatalConfigurationUpdateException {
        try {
            Util.copyFileContent((String)backupFile, (String)configFile);
        }
        catch (Throwable e1) {
            String m1 = MessageFormat.format("Fatal error during update of configuration. Configuration is now inconsistent. Failed to restore the backup {0} of the old configuration to file {1}: {2}. Original error: {3}", backupFile, configFile, e1.getMessage(), cause.getMessage());
            FatalConfigurationUpdateException ex = new FatalConfigurationUpdateException(m1, e1);
            LOCATION.throwing(theMethod, (Throwable)((Object)ex));
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

