/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.ConfigurationEvaluationException;
import com.sap.tc.devconf.update.IUpdatePlan;
import com.sap.tc.devconf.update.impl.AbstractAction;
import com.sap.tc.devconf.update.impl.ActionSequence;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

class UpdatePlan
implements IUpdatePlan {
    Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$UpdatePlan == null ? (class$com$sap$tc$devconf$update$impl$UpdatePlan = UpdatePlan.class$("com.sap.tc.devconf.update.impl.UpdatePlan")) : class$com$sap$tc$devconf$update$impl$UpdatePlan));
    private final TreeSet m_actionSequenceBeforeSwitch = new TreeSet();
    private final TreeSet m_actionSequenceAfterSwitch = new TreeSet();
    private final DevelopmentConfiguration m_devconf;
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$UpdatePlan;

    public UpdatePlan(DevelopmentConfiguration devconf) {
        this.m_devconf = devconf;
    }

    public void add(AbstractAction action) throws ConfigurationEvaluationException {
        if (ActionSequence.isToBeExecutedAfterUpdate(action)) {
            this._add(action, this.m_actionSequenceAfterSwitch);
        } else {
            this._add(action, this.m_actionSequenceBeforeSwitch);
        }
    }

    private void _add(AbstractAction action, Set actions) throws ConfigurationEvaluationException {
        if (action.getConfig() != this.m_devconf) {
            String msg = MessageFormat.format("Illegal attempt to store update action for wrong configuration. Update plan is for {0}, new action is for {1}", this.m_devconf.getConfigurationRootFolder(), action.getConfig().getConfigurationRootFolder());
            ConfigurationEvaluationException e = new ConfigurationEvaluationException("Illegal attempt to a");
            this.LOCATION.throwing("addAction", (Throwable)((Object)e));
            throw e;
        }
        actions.add(action);
    }

    public Iterator getActions() {
        TreeSet allActions = new TreeSet(this.m_actionSequenceBeforeSwitch);
        allActions.addAll(this.m_actionSequenceAfterSwitch);
        return Collections.unmodifiableSet(allActions).iterator();
    }

    protected DevelopmentConfiguration getDevconf() {
        return this.m_devconf;
    }

    public Iterator getActionsAfterSwitch() {
        return Collections.unmodifiableSet(this.m_actionSequenceAfterSwitch).iterator();
    }

    public Iterator getActionsBeforeSwitch() {
        return Collections.unmodifiableSet(this.m_actionSequenceBeforeSwitch).iterator();
    }

    public int countActionsAfterSwitch() {
        return this.m_actionSequenceAfterSwitch.size();
    }

    public int countActionsBeforeSwitch() {
        return this.m_actionSequenceBeforeSwitch.size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

