/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.OfflineException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IActionResult;
import com.sap.tc.devconf.update.IServerDefinitionAction;
import com.sap.tc.devconf.update.ServerType;
import com.sap.tc.devconf.update.impl.AbstractAction;
import com.sap.tc.devconf.update.impl.ActionResult;
import com.sap.tc.devconf.update.impl.DevconfUpdateTexts;
import com.sap.tc.devconf.update.impl.UpdateActionMessage;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.IServer;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;

class ServerDefinitionAction
extends AbstractAction
implements IServerDefinitionAction {
    Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$ServerDefinitionAction == null ? (class$com$sap$tc$devconf$update$impl$ServerDefinitionAction = ServerDefinitionAction.class$("com.sap.tc.devconf.update.impl.ServerDefinitionAction")) : class$com$sap$tc$devconf$update$impl$ServerDefinitionAction));
    private final ServerType m_serverType;
    private final IServerDefinitionAction.ServerActionKind m_kindOfAction;
    private final String m_serverURL;
    private final IConnectionContext m_context;
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$ServerDefinitionAction;

    public ServerDefinitionAction(DevelopmentConfiguration config, String serverURL, ServerType serverType, IServerDefinitionAction.ServerActionKind kindOfAction, IConnectionContext connectionContext) {
        super(config);
        this.m_kindOfAction = kindOfAction;
        this.m_serverType = serverType;
        this.m_serverURL = serverURL;
        this.m_context = connectionContext;
    }

    public ServerType getServerType() {
        return this.m_serverType;
    }

    public IServerDefinitionAction.ServerActionKind getKindOfAction() {
        return this.m_kindOfAction;
    }

    public String getServerURL() {
        return this.m_serverURL;
    }

    public String describe() {
        String action = this.m_kindOfAction == IServerDefinitionAction.ServerActionKind.DELETE ? DevconfUpdateTexts.getString("ServerDefinitionAction.ACTION_DELETE") : DevconfUpdateTexts.getString("ServerDefinitionAction.ACTION_ADD");
        return MessageFormat.format(action, this.m_serverURL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IActionResult _execute() throws FatalConfigurationUpdateException {
        String thisMethod = "_execute";
        try {
            IClient client = this.getConfig().getDTRClient();
            if (client == null) {
                String msg = "Update Configuration failed. Could not update workspace filters. DTR client is null";
                this.LOCATION.infoT(thisMethod, msg);
                throw new FatalConfigurationUpdateException(msg);
            }
            ILogicalSystem system = client.getLogicalSystem();
            if (this.getKindOfAction() == IServerDefinitionAction.ServerActionKind.DELETE) {
                if (this.getServerType() == ServerType.REPOSITORY) {
                    system.removeRepositoryServer(this.getServerURL());
                } else {
                    if (this.getServerType() != ServerType.BUILD_SERVER) {
                        String msg = MessageFormat.format("Update Configuration failed, could not update server definition. Unsupported server type {0}", this.getServerType().toString());
                        this.LOCATION.infoT(thisMethod, msg);
                        throw new FatalConfigurationUpdateException(msg);
                    }
                    system.removeBuildServer(this.getServerURL());
                }
            } else {
                IRepositoryServer server;
                if (this.getKindOfAction() != IServerDefinitionAction.ServerActionKind.ADD) {
                    String msg = MessageFormat.format("Update Configuration failed, could not update server definition. Unsupported kind of action {0}", this.getKindOfAction().toString());
                    this.LOCATION.infoT(thisMethod, msg);
                    throw new FatalConfigurationUpdateException(msg);
                }
                if (this.getServerType() == ServerType.REPOSITORY) {
                    server = system.addRepositoryServer(this.getServerURL(), this.m_context.getUserName(), this.m_context.getPassword());
                    this.setServerProperties((IServer)server, this.m_context);
                } else {
                    if (this.getServerType() != ServerType.BUILD_SERVER) {
                        String msg = MessageFormat.format("Update Configuration failed, could not update server definition. Unsupported server type {0}", this.getServerType().toString());
                        this.LOCATION.infoT(thisMethod, msg);
                        throw new FatalConfigurationUpdateException(msg);
                    }
                    server = system.addBuildServer(this.getServerURL(), this.m_context.getUserName(), this.m_context.getPassword());
                    this.setServerProperties((IServer)server, this.m_context);
                }
            }
            String msg = MessageFormat.format("Sucessfully applied action {0} for server {1} of type {2}", this.getKindOfAction(), this.getServerURL(), this.getServerType());
            this.LOCATION.debugT(thisMethod, msg);
            ArrayList<UpdateActionMessage> okList = new ArrayList<UpdateActionMessage>(1);
            okList.add(new UpdateActionMessage(msg, true, null));
            return new ActionResult(okList, new ArrayList(0));
        }
        catch (OfflineException e) {
            String msg = MessageFormat.format("Update Configuration failed, could not update server definition: {0}", ((Throwable)((Object)e)).getMessage());
            this.LOCATION.traceThrowableT(300, msg, (Throwable)((Object)e));
            throw new FatalConfigurationUpdateException(msg, (Throwable)((Object)e));
        }
        catch (MalformedURLException e) {
            String msg = MessageFormat.format("Update Configuration failed, could not update server definition for {0} : {1}", this.getServerURL(), e.getMessage());
            this.LOCATION.traceThrowableT(300, msg, (Throwable)e);
            throw new FatalConfigurationUpdateException(msg, e);
        }
    }

    private void setServerProperties(IServer server, IConnectionContext context) {
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ServerDefinitionAction)) {
            return false;
        }
        ServerDefinitionAction other = (ServerDefinitionAction)obj;
        if (this.m_serverURL == null) {
            return other.m_serverURL == null;
        }
        if (!this.m_serverURL.equals(other.m_serverURL)) {
            return false;
        }
        if (this.m_context == null) {
            return other.m_context == null;
        }
        if (!this.m_context.equals(other.m_context)) {
            return false;
        }
        if (this.m_kindOfAction == null) {
            return other.m_kindOfAction == null;
        }
        if (!this.m_kindOfAction.equals(other.m_kindOfAction)) {
            return false;
        }
        if (this.m_serverType == null) {
            return other.m_serverType == null;
        }
        return this.m_serverType.equals(other.m_serverType);
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + (this.m_serverURL == null ? 0 : this.m_serverURL.hashCode());
        hash = 37 * hash + (this.m_context == null ? 0 : this.m_context.hashCode());
        hash = 37 * hash + (this.m_kindOfAction == null ? 0 : this.m_kindOfAction.hashCode());
        hash = 37 * hash + (this.m_serverType == null ? 0 : this.m_serverType.hashCode());
        return hash;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

