/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IActionResult;
import com.sap.tc.devconf.update.IResetArchiveSyncStateAction;
import com.sap.tc.devconf.update.impl.AbstractDCsetAction;
import com.sap.tc.devconf.update.impl.ActionResult;
import com.sap.tc.devconf.update.impl.DevconfUpdateTexts;
import com.sap.tc.devconf.update.impl.UpdateActionMessage;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class ResetArchiveSyncStateAction
extends AbstractDCsetAction
implements IResetArchiveSyncStateAction {
    private static final String MSG_SUCCESS = "Sucessfully reset sync state of {0} (synched as archives)";
    private static final String MSG_ERROR = "Failed to reset sync state of {0}: {1}";
    private static final String MSG_SKIP = "Skipped resetting sync state of {0}. Component is not synched as archive.";
    static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$ResetArchiveSyncStateAction == null ? (class$com$sap$tc$devconf$update$impl$ResetArchiveSyncStateAction = ResetArchiveSyncStateAction.class$("com.sap.tc.devconf.update.impl.ResetArchiveSyncStateAction")) : class$com$sap$tc$devconf$update$impl$ResetArchiveSyncStateAction));
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$ResetArchiveSyncStateAction;

    public ResetArchiveSyncStateAction(DevelopmentConfiguration config) {
        super(config);
    }

    protected String getActionText() {
        return DevconfUpdateTexts.getString("ResetArchiveSyncStateAction.ACTION_MESSAGE");
    }

    protected IActionResult _execute() throws FatalConfigurationUpdateException {
        String thisMethod = "_execute";
        Set dcs = this.getDcSet();
        ArrayList<UpdateActionMessage> messagesOK = new ArrayList<UpdateActionMessage>(dcs.size());
        ArrayList messagesFailed = new ArrayList(dcs.size());
        Iterator iter = dcs.iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode dc = (IDevelopmentComponentNode)iter.next();
            LOCATION.debugT(thisMethod, "Update Config: Making dirty DC {0}", new Object[]{dc});
            UpdateActionMessage actionMessage = this.updateSyncState(this.getConfig(), dc);
            messagesOK.add(actionMessage);
        }
        this.getConfig().getComponentSyncDB().save();
        return new ActionResult(messagesOK, messagesFailed);
    }

    private UpdateActionMessage updateSyncState(DevelopmentConfiguration config, IDevelopmentComponentNode dc) {
        UpdateActionMessage result;
        ComponentSyncDB syncdb = config.getComponentSyncDB();
        IDCSyncEntry entry = syncdb.getEntry(dc.getCompartmentName(), dc.getName(), dc.getVendor());
        if (entry == null || entry.getMode() != SyncMode.SYNCHED_AS_ARCHIVE) {
            result = new UpdateActionMessage(MessageFormat.format(MSG_SKIP, dc), true, null);
        } else {
            List variants = entry.getVariantNames();
            Iterator iter = variants.iterator();
            while (iter.hasNext()) {
                String variant = (String)iter.next();
                entry.setBuildNumber(variant, ComponentSyncDB.GUARANTEED_TO_BE_OUTDATED);
            }
            result = new UpdateActionMessage(MessageFormat.format(MSG_SUCCESS, dc), true, null);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

