/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IActionResult;
import com.sap.tc.devconf.update.IRemoveMountpointAction;
import com.sap.tc.devconf.update.impl.AbstractAction;
import com.sap.tc.devconf.update.impl.ActionResult;
import com.sap.tc.devconf.update.impl.DevconfUpdateTexts;
import com.sap.tc.devconf.update.impl.UpdateActionMessage;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import java.text.MessageFormat;
import java.util.ArrayList;

class RemoveMointpointAction
extends AbstractAction
implements IRemoveMountpointAction {
    static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$RemoveMointpointAction == null ? (class$com$sap$tc$devconf$update$impl$RemoveMointpointAction = RemoveMointpointAction.class$("com.sap.tc.devconf.update.impl.RemoveMointpointAction")) : class$com$sap$tc$devconf$update$impl$RemoveMointpointAction));
    private final IMountPoint m_mointPoint;
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$RemoveMointpointAction;

    public RemoveMointpointAction(DevelopmentConfiguration config, IMountPoint mp) {
        super(config);
        this.m_mointPoint = mp;
    }

    public String getPath() {
        return this.m_mointPoint.getClient().getAbsoluteLocalRoot() + this.m_mointPoint.getRelativeLocalRoot();
    }

    public String describe() {
        return MessageFormat.format("Removing repository mointpoint at local path {0}", this.getPath());
    }

    protected IActionResult _execute() throws FatalConfigurationUpdateException {
        String thisMethod = "_execute";
        LOCATION.debugT(thisMethod, "removing repository mount point {0}", new Object[]{this.getPath()});
        try {
            this.getConfig().getDTRClient().deleteMountPoints(new IMountPoint[]{this.m_mointPoint}, true);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(DevconfUpdateTexts.getString("RemoveMointpointAction.MSG_ERR"), this.getPath(), e.getMessage());
            LOCATION.traceThrowableT(300, msg, (Throwable)e);
            throw new FatalConfigurationUpdateException(msg, e);
        }
        String msg = MessageFormat.format(DevconfUpdateTexts.getString("RemoveMointpointAction.MSG_SUCESS"), this.getPath());
        LOCATION.debugT(thisMethod, msg);
        ArrayList<UpdateActionMessage> okList = new ArrayList<UpdateActionMessage>(1);
        okList.add(new UpdateActionMessage(msg, true, null));
        return new ActionResult(okList, new ArrayList(0));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RemoveMointpointAction)) {
            return false;
        }
        RemoveMointpointAction other = (RemoveMointpointAction)obj;
        if (this.m_mointPoint == null) {
            return other.m_mointPoint == null;
        }
        return this.m_mointPoint.equals(other.m_mointPoint);
    }

    public int hashCode() {
        return 37 * super.hashCode() + (this.m_mointPoint == null ? 0 : this.m_mointPoint.hashCode());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

