/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.devconf.IDCOperationHandler;
import com.sap.tc.devconf.IDCOperationResult;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IActionResult;
import com.sap.tc.devconf.update.IRemoveArchivesAction;
import com.sap.tc.devconf.update.impl.AbstractDCsetAction;
import com.sap.tc.devconf.update.impl.ActionResult;
import com.sap.tc.devconf.update.impl.DevconfUpdateTexts;
import com.sap.tc.devconf.update.impl.UpdateActionMessage;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;

class RemoveArchivesAction
extends AbstractDCsetAction
implements IRemoveArchivesAction {
    static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$RemoveArchivesAction == null ? (class$com$sap$tc$devconf$update$impl$RemoveArchivesAction = RemoveArchivesAction.class$("com.sap.tc.devconf.update.impl.RemoveArchivesAction")) : class$com$sap$tc$devconf$update$impl$RemoveArchivesAction));
    private static final String SUCCESS_MSG = DevconfUpdateTexts.getString("RemoveArchivesAction.MSG_SUCCESS");
    private static final String ERROR_MSG = DevconfUpdateTexts.getString("RemoveArchivesAction.MSG_ERROR");
    private static final String MSG_SKIPPED = DevconfUpdateTexts.getString("RemoveArchivesAction.MSG_SKIPPED");
    private static final String MSG_UNKNOWN = DevconfUpdateTexts.getString("RemoveArchivesAction.MSG_UNKNOWN");
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$RemoveArchivesAction;

    public RemoveArchivesAction(DevelopmentConfiguration config) {
        super(config);
    }

    protected String getActionText() {
        return DevconfUpdateTexts.getString("RemoveArchivesAction.ACTION_MESSAGE");
    }

    protected IActionResult _execute() throws FatalConfigurationUpdateException {
        String thisMethod = "_execute()";
        Set dcs = this.getDcSet();
        ArrayList messagesOK = new ArrayList(dcs.size());
        ArrayList messagesFailed = new ArrayList(dcs.size());
        DevelopmentConfiguration conf = this.getConfig();
        IDevelopmentComponentNode[] nodes = dcs.toArray(new IDevelopmentComponentNode[dcs.size()]);
        conf.unsync(nodes, new IDCOperationHandler(){

            public boolean onOperationFinished(IDCOperationResult result) {
                LOCATION.debugT("_execute()", DevconfUpdateTexts.getString("RemoveArchivesAction.5"), new Object[]{result.getDCNode()});
                if (result.getStatus() == IDCOperationResult.Status.OK) {
                    String msg = MessageFormat.format(ERROR_MSG, result.getDCNode());
                    LOCATION.debugT("_execute()", msg);
                    UpdateActionMessage actionMessage = new UpdateActionMessage(msg, true, null);
                } else if (result.getStatus() == IDCOperationResult.Status.SKIPPED) {
                    String msg = MessageFormat.format(MSG_SKIPPED, result.getDCNode());
                    LOCATION.debugT("_execute()", msg);
                    UpdateActionMessage actionMessage = new UpdateActionMessage(msg, true, null);
                } else if (result.getStatus() == IDCOperationResult.Status.EXCEPTION) {
                    String msg = MessageFormat.format(ERROR_MSG, result.getDCNode(), result.getException() != null ? result.getException().getMessage() : DevconfUpdateTexts.getString("RemoveArchivesAction.NO_DETAILS"));
                    LOCATION.debugT("_execute()", msg);
                    UpdateActionMessage actionMessage = new UpdateActionMessage(msg, false, result.getException());
                } else {
                    String msg = MessageFormat.format(MSG_UNKNOWN, result.getDCNode(), result.getStatus().toString());
                    LOCATION.infoT("_execute()", msg);
                    UpdateActionMessage updateActionMessage = new UpdateActionMessage(msg, true, null);
                }
                return true;
            }
        });
        return new ActionResult(messagesOK, messagesFailed);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

