/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IActionResult;
import com.sap.tc.devconf.update.IMakeDCsDirtyAction;
import com.sap.tc.devconf.update.impl.AbstractDCsetAction;
import com.sap.tc.devconf.update.impl.ActionResult;
import com.sap.tc.devconf.update.impl.DevconfUpdateTexts;
import com.sap.tc.devconf.update.impl.UpdateActionMessage;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

class MakeDCsDirtyAction
extends AbstractDCsetAction
implements IMakeDCsDirtyAction {
    private static final String SUCCESS_MSG = DevconfUpdateTexts.getString("MakeDCsDirtyAction.SUCCESS");
    private static final String ERR_MSG = DevconfUpdateTexts.getString("MakeDCsDirtyAction.FAILED");
    static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$MakeDCsDirtyAction == null ? (class$com$sap$tc$devconf$update$impl$MakeDCsDirtyAction = MakeDCsDirtyAction.class$("com.sap.tc.devconf.update.impl.MakeDCsDirtyAction")) : class$com$sap$tc$devconf$update$impl$MakeDCsDirtyAction));
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$MakeDCsDirtyAction;

    public MakeDCsDirtyAction(DevelopmentConfiguration config) {
        super(config);
    }

    protected String getActionText() {
        return DevconfUpdateTexts.getString("MakeDCsDirtyAction.ACTION_MESSAGE");
    }

    protected IActionResult _execute() throws FatalConfigurationUpdateException {
        String thisMethod = "_execute";
        Set dcs = this.getDcSet();
        ArrayList<UpdateActionMessage> messagesOK = new ArrayList<UpdateActionMessage>(dcs.size());
        ArrayList<UpdateActionMessage> messagesFailed = new ArrayList<UpdateActionMessage>(dcs.size());
        Iterator iter = dcs.iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode dc = (IDevelopmentComponentNode)iter.next();
            LOCATION.debugT(thisMethod, "Update Config: Making dirty DC {0}", new Object[]{dc});
            try {
                this.getConfig().markDCasDirty(dc, false, false);
                String message = MessageFormat.format(SUCCESS_MSG, dc);
                messagesOK.add(new UpdateActionMessage(message, true, null));
            }
            catch (DevConfigException e) {
                LOCATION.traceThrowableT(300, thisMethod, "Error in config update, MakeDCsDirtyAction: ", (Throwable)((Object)e));
                String message = MessageFormat.format(ERR_MSG, dc, ((Throwable)((Object)e)).getMessage());
                messagesFailed.add(new UpdateActionMessage(message, false, (Exception)((Object)e)));
            }
        }
        this.getConfig().getComponentSyncDB().save();
        return new ActionResult(messagesOK, messagesFailed);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

