/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.complib.cmpconf.ComparatorFactory;
import com.sap.tc.complib.cmpconf.ConfigurationComparisonException;
import com.sap.tc.complib.cmpconf.IConfigComparisonResult;
import com.sap.tc.complib.cmpconf.IConfigurationComparator;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.ConfigurationEvaluationException;
import com.sap.tc.devconf.update.ConfigurationUpdateException;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IConfigDeltaEvaluation;
import com.sap.tc.devconf.update.IConfigurationUpdater;
import com.sap.tc.devconf.update.IUpdateReport;
import com.sap.tc.devconf.update.IllegalUpdateStateException;
import com.sap.tc.devconf.update.UpdateState;
import com.sap.tc.devconf.update.impl.ConfigDeltaEvaluator;
import com.sap.tc.devconf.update.impl.UpdateProcessor;
import com.sap.tc.devconf.update.impl.UpdateReport;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class ConfigurationUpdater
implements IConfigurationUpdater {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$ConfigurationUpdater == null ? (class$com$sap$tc$devconf$update$impl$ConfigurationUpdater = ConfigurationUpdater.class$("com.sap.tc.devconf.update.impl.ConfigurationUpdater")) : class$com$sap$tc$devconf$update$impl$ConfigurationUpdater));
    private final DevelopmentConfiguration m_config;
    private UpdateState m_state = UpdateState.INITIAL;
    private IConfigurationComparator m_comparator = ComparatorFactory.createComparator();
    private IConfigComparisonResult m_comparison = null;
    private IConfigDeltaEvaluation m_evaluation = null;
    private UpdateReport m_report = null;
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$ConfigurationUpdater;

    public ConfigurationUpdater(DevelopmentConfiguration config) {
        this.m_config = config;
    }

    public IConfigComparisonResult compare(com.sap.tc.complib.DevelopmentConfiguration otherConfig) throws ConfigurationComparisonException {
        this.resetState();
        this.m_comparison = this.m_comparator.compare(this.getDevelopmentConfiguration().getConfigurationData(), otherConfig);
        this.m_state = UpdateState.COMPARED;
        return this.m_comparison;
    }

    public IConfigDeltaEvaluation evaluate() throws ConfigurationEvaluationException, DevConfigException, IllegalUpdateStateException {
        String thisMethod = "evaluate";
        if (this.m_state != UpdateState.COMPARED && this.m_state != UpdateState.EVALUATED) {
            throw this.getTracedIllegalUpdateStateException(thisMethod);
        }
        ConfigDeltaEvaluator evaluator = new ConfigDeltaEvaluator(this.m_config, this.m_comparison);
        this.m_evaluation = evaluator.evaluate();
        this.m_state = UpdateState.EVALUATED;
        return this.m_evaluation;
    }

    public IUpdateReport execute() throws IllegalUpdateStateException, ConfigurationUpdateException, FatalConfigurationUpdateException {
        String thisMethod = "execute";
        if (this.m_state != UpdateState.EVALUATED) {
            throw this.getTracedIllegalUpdateStateException(thisMethod);
        }
        UpdateProcessor updater = new UpdateProcessor();
        try {
            this.m_report = updater.executeUpdate(this.m_config, this.m_evaluation);
            this.m_state = UpdateState.UPDATED;
            return this.m_report;
        }
        catch (ConfigurationUpdateException e) {
            this.m_state = UpdateState.UPDATE_FAILED;
            throw e;
        }
        catch (FatalConfigurationUpdateException e) {
            this.m_state = UpdateState.UPDATE_FAILED;
            throw e;
        }
    }

    public IDevelopmentConfiguration getDevelopmentConfiguration() {
        return this.m_config;
    }

    public IConfigComparisonResult getLastComparisonResult() throws ConfigurationComparisonException, IllegalUpdateStateException {
        if (this.m_state == UpdateState.INITIAL) {
            throw this.getTracedIllegalUpdateStateException("getLastComparisonResult");
        }
        return this.m_comparison;
    }

    public IConfigDeltaEvaluation getLastEvaluation() throws IllegalUpdateStateException {
        if (this.m_state == UpdateState.INITIAL || this.m_state == UpdateState.COMPARED) {
            throw this.getTracedIllegalUpdateStateException("getLastEvaluation");
        }
        return this.m_evaluation;
    }

    public IUpdateReport getLastIUpdateReport() throws ConfigurationComparisonException, IllegalUpdateStateException {
        if (this.m_state != UpdateState.UPDATED) {
            throw this.getTracedIllegalUpdateStateException("getLastIUpdateReport");
        }
        return this.m_report;
    }

    public UpdateState getState() {
        return this.m_state;
    }

    public void resetState() {
        this.m_report = null;
        this.m_comparison = null;
        this.m_evaluation = null;
        this.m_state = UpdateState.INITIAL;
    }

    private IllegalUpdateStateException getTracedIllegalUpdateStateException(String theMethod) throws IllegalUpdateStateException {
        String m = MessageFormat.format("Illegal state error in update of configurations. The operation {0} is not allowed in state {1}", theMethod, this.m_state.toString());
        IllegalUpdateStateException ex = new IllegalUpdateStateException(m, this.m_state);
        LOCATION.throwing(theMethod, (Throwable)((Object)ex));
        return ex;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

