/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.complib.cmpconf.AttributeID;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.IAttributeDelta;
import com.sap.tc.complib.cmpconf.ICompartmentDelta;
import com.sap.tc.complib.cmpconf.IConfigComparisonResult;
import com.sap.tc.complib.cmpconf.IConfigElementDelta;
import com.sap.tc.complib.cmpconf.IConfigurationDelta;
import com.sap.tc.complib.cmpconf.IPropertyDelta;
import com.sap.tc.complib.cmpconf.IStringAttributeDelta;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.ConfigurationEvaluationException;
import com.sap.tc.devconf.update.DeltaSeverity;
import com.sap.tc.devconf.update.IConfigDeltaEvaluation;
import com.sap.tc.devconf.update.IServerDefinitionAction;
import com.sap.tc.devconf.update.ServerType;
import com.sap.tc.devconf.update.impl.ChangeNotSupportedProblem;
import com.sap.tc.devconf.update.impl.CompartmentEvaluator;
import com.sap.tc.devconf.update.impl.ConfigDeltaEvaluation;
import com.sap.tc.devconf.update.impl.ElementDeltaEvaluation;
import com.sap.tc.devconf.update.impl.ProblemWithDCs;
import com.sap.tc.devconf.update.impl.ResetArchiveSyncStateAction;
import com.sap.tc.devconf.update.impl.ServerDefinitionAction;
import com.sap.tc.devconf.update.impl.UpdatePlan;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

class ConfigDeltaEvaluator {
    static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$ConfigDeltaEvaluator == null ? (class$com$sap$tc$devconf$update$impl$ConfigDeltaEvaluator = ConfigDeltaEvaluator.class$("com.sap.tc.devconf.update.impl.ConfigDeltaEvaluator")) : class$com$sap$tc$devconf$update$impl$ConfigDeltaEvaluator));
    private final DevelopmentConfiguration m_devconf;
    private final IConfigComparisonResult m_comparisonResult;
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$ConfigDeltaEvaluator;

    public ConfigDeltaEvaluator(DevelopmentConfiguration devconf, IConfigComparisonResult comparisonResult) {
        this.m_devconf = devconf;
        this.m_comparisonResult = comparisonResult;
    }

    public IConfigDeltaEvaluation evaluate() throws ConfigurationEvaluationException, DevConfigException {
        String thisMethod = "evaluate";
        ConfigDeltaEvaluation evaluation = new ConfigDeltaEvaluation(this.m_comparisonResult, this.m_devconf);
        IConfigurationDelta configDelta = this.m_comparisonResult.getConfigurationDelta();
        if (configDelta == null) {
            LOCATION.debugT(thisMethod, "The configurations are equivalent. Nothing differences to evaluate.");
        } else {
            this.evaluateConfigurationDelta(configDelta, evaluation);
        }
        return evaluation;
    }

    private void evaluateConfigurationDelta(IConfigurationDelta configDelta, ConfigDeltaEvaluation evaluation) throws ConfigurationEvaluationException {
        DevelopmentConfiguration config = evaluation.getConfig();
        IAttributeDelta[] attrDeltas = configDelta.getAttributeDeltas();
        int i = 0;
        while (i < attrDeltas.length) {
            IAttributeDelta delta = attrDeltas[i];
            AttributeID id = delta.getID();
            ElementDeltaEvaluation elementEval = new ElementDeltaEvaluation(null, (IConfigElementDelta)delta);
            if (id == AttributeID.CONFIG_CAPTION) {
                elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
            } else if (id == AttributeID.CONFIG_BUILD_SERVER) {
                this.evaluateBuildServerChange(evaluation, delta, elementEval);
            } else if (id == AttributeID.CONFIG_CMS_URL) {
                elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
            } else if (id == AttributeID.CONFIG_DESCRIPTION) {
                elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
            } else if (id == AttributeID.CONFIG_DOCUMENT_TYPE_VERSION) {
                elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
            } else if (id == AttributeID.CONFIG_IS_LOCAL) {
                elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
            } else if (id == AttributeID.CONFIG_NAME) {
                elementEval.setSeverity(DeltaSeverity.CRITICAL);
                elementEval.addProblem(new ChangeNotSupportedProblem("changing the name of a configuration"));
            } else if (id == AttributeID.CONFIG_NAME_SERVER_URL) {
                elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
            } else if (id == AttributeID.CONFIG_SL_LOCATION) {
                elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
            } else if (id == AttributeID.CONFIG_VERSION) {
                elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
            } else {
                String message = MessageFormat.format("Unknown configuration element found: {0} for delta: {1}", delta.getTypeName(), delta.describe());
                throw new ConfigurationEvaluationException(message);
            }
            evaluation.add(elementEval);
            ++i;
        }
        IPropertyDelta[] propDeltas = configDelta.getPropertyDeltas();
        int i2 = 0;
        while (i2 < propDeltas.length) {
            IPropertyDelta delta = propDeltas[i2];
            ElementDeltaEvaluation elementEval = new ElementDeltaEvaluation(DeltaSeverity.NON_CRITICAL, (IConfigElementDelta)delta);
            evaluation.add(elementEval);
            ++i2;
        }
        ICompartmentDelta[] compartmentDeltas = configDelta.getCompartmentDeltas();
        CompartmentEvaluator compartmentEvaluator = new CompartmentEvaluator(config);
        int i3 = 0;
        while (i3 < compartmentDeltas.length) {
            ICompartmentDelta compartmentDelta = compartmentDeltas[i3];
            compartmentEvaluator.evaluate(compartmentDelta, evaluation);
            ++i3;
        }
    }

    private void evaluateBuildServerChange(ConfigDeltaEvaluation evaluation, IAttributeDelta delta, ElementDeltaEvaluation elementEval) throws ConfigurationEvaluationException {
        UpdatePlan updatePlan = evaluation._getUpdatePlan();
        DevelopmentConfiguration config = evaluation.getConfig();
        elementEval.setSeverity(DeltaSeverity.NON_CRITICAL);
        ChangeType type = delta.getChangeType();
        IStringAttributeDelta stringDelta = (IStringAttributeDelta)delta;
        if (type == ChangeType.ADDED) {
            ServerDefinitionAction action = new ServerDefinitionAction(config, stringDelta.getNewValue(), ServerType.BUILD_SERVER, IServerDefinitionAction.ServerActionKind.ADD, new ConnectionContext(config.getUser(), config.getPassword(), null, null));
            updatePlan.add(action);
        } else if (type == ChangeType.MODIFIED) {
            ServerDefinitionAction action = new ServerDefinitionAction(config, stringDelta.getOldValue(), ServerType.BUILD_SERVER, IServerDefinitionAction.ServerActionKind.DELETE, new ConnectionContext(config.getUser(), config.getPassword(), null, null));
            evaluation._getUpdatePlan().add(action);
            action = new ServerDefinitionAction(config, stringDelta.getNewValue(), ServerType.BUILD_SERVER, IServerDefinitionAction.ServerActionKind.ADD, new ConnectionContext(config.getUser(), config.getPassword(), null, null));
            updatePlan.add(action);
            ResetArchiveSyncStateAction syncStateAction = new ResetArchiveSyncStateAction(config);
            List dcs = config.getDevelopmentComponentNodes();
            Iterator iter = dcs.iterator();
            while (iter.hasNext()) {
                IDevelopmentComponentNode dc = (IDevelopmentComponentNode)iter.next();
                if (!dc.isSynchedAsArchives()) continue;
                syncStateAction.addDC(dc);
            }
            if (!syncStateAction.getDcSet().isEmpty()) {
                updatePlan.add(syncStateAction);
            }
        } else {
            ProblemWithDCs problem = new ProblemWithDCs("The build server was removed. This change cannot be applied because archives are synched. Remove them from client and try again.");
            List dcs = config.getDevelopmentComponentNodes();
            Iterator iter = dcs.iterator();
            while (iter.hasNext()) {
                IDevelopmentComponentNode dc = (IDevelopmentComponentNode)iter.next();
                if (!dc.isSynchedAsArchives()) continue;
                problem.addSynchedDC(dc);
            }
            if (problem.countSynchedDCs() > 0) {
                elementEval.setSeverity(DeltaSeverity.CRITICAL);
                elementEval.addProblem(problem);
            } else {
                ServerDefinitionAction action = new ServerDefinitionAction(config, stringDelta.getOldValue(), ServerType.BUILD_SERVER, IServerDefinitionAction.ServerActionKind.DELETE, new ConnectionContext(config.getUser(), config.getPassword(), null, null));
                updatePlan.add(action);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

