/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.complib.cmpconf.IConfigComparisonResult;
import com.sap.tc.complib.cmpconf.IConfigElementDelta;
import com.sap.tc.complib.cmpconf.IEntityDelta;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.DeltaSeverity;
import com.sap.tc.devconf.update.IConfigDeltaEvaluation;
import com.sap.tc.devconf.update.IElementDeltaEvaluation;
import com.sap.tc.devconf.update.IUpdatePlan;
import com.sap.tc.devconf.update.impl.UpdatePlan;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ConfigDeltaEvaluation
implements IConfigDeltaEvaluation {
    static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$ConfigDeltaEvaluation == null ? (class$com$sap$tc$devconf$update$impl$ConfigDeltaEvaluation = ConfigDeltaEvaluation.class$("com.sap.tc.devconf.update.impl.ConfigDeltaEvaluation")) : class$com$sap$tc$devconf$update$impl$ConfigDeltaEvaluation));
    private final IConfigComparisonResult m_comparisonResult;
    private final UpdatePlan m_updatePlan;
    private Map m_resultsByDelta = new HashMap();
    private Map m_resultsBySeverity = new HashMap();
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$ConfigDeltaEvaluation;

    public ConfigDeltaEvaluation(IConfigComparisonResult comparisonResult, DevelopmentConfiguration devconf) {
        this.m_comparisonResult = comparisonResult;
        this.m_updatePlan = new UpdatePlan(devconf);
    }

    public IConfigComparisonResult getComparisonResult() {
        return this.m_comparisonResult;
    }

    public IElementDeltaEvaluation getResult(IConfigElementDelta delta) {
        return (IElementDeltaEvaluation)this.m_resultsByDelta.get(delta);
    }

    public DeltaSeverity getAccumulatedSeverity(IEntityDelta entityDelta) {
        return this._getAccumulatedSeverity((IConfigElementDelta)entityDelta);
    }

    public DeltaSeverity _getAccumulatedSeverity(IConfigElementDelta delta) {
        String thisMethod = "_getAccumulatedSeverity";
        DeltaSeverity maximumSeverity = null;
        IElementDeltaEvaluation res = this.getResult(delta);
        if (res == null) {
            String msg = MessageFormat.format("Internal error. No evaluation result found for delta element {0}.", delta);
            IllegalStateException e = new IllegalStateException(msg);
            LOCATION.throwing(thisMethod, (Throwable)e);
        }
        if ((maximumSeverity = res.getSeverity()) != DeltaSeverity.CRITICAL && delta instanceof IEntityDelta) {
            IEntityDelta entityDelta = (IEntityDelta)delta;
            IConfigElementDelta[] childDeltas = entityDelta.getChildren();
            int i = 0;
            while (i < childDeltas.length) {
                IConfigElementDelta childDelta = childDeltas[i];
                DeltaSeverity childSeverity = this._getAccumulatedSeverity(childDelta);
                DeltaSeverity deltaSeverity = maximumSeverity = childSeverity.compareTo(maximumSeverity) > 0 ? childSeverity : maximumSeverity;
                if (maximumSeverity == DeltaSeverity.CRITICAL) break;
                ++i;
            }
        }
        return maximumSeverity;
    }

    public IElementDeltaEvaluation[] getNonCriticalResults() {
        Set resultList = (Set)this.m_resultsBySeverity.get(DeltaSeverity.NON_CRITICAL);
        if (resultList == null) {
            return new IElementDeltaEvaluation[0];
        }
        return resultList.toArray(new IElementDeltaEvaluation[resultList.size()]);
    }

    public IElementDeltaEvaluation[] getCriticalResults() {
        Set resultList = (Set)this.m_resultsBySeverity.get(DeltaSeverity.CRITICAL);
        if (resultList == null) {
            return new IElementDeltaEvaluation[0];
        }
        return resultList.toArray(new IElementDeltaEvaluation[resultList.size()]);
    }

    public IElementDeltaEvaluation[] getResultsForApproval() {
        Set resultList = (Set)this.m_resultsBySeverity.get(DeltaSeverity.APPROVE);
        if (resultList == null) {
            return new IElementDeltaEvaluation[0];
        }
        return resultList.toArray(new IElementDeltaEvaluation[resultList.size()]);
    }

    public IUpdatePlan getUpdatePlan() {
        return this.m_updatePlan;
    }

    UpdatePlan _getUpdatePlan() {
        return this.m_updatePlan;
    }

    void add(IElementDeltaEvaluation evaluation) {
        this.m_resultsByDelta.put(evaluation.getDelta(), evaluation);
        DeltaSeverity severity = evaluation.getSeverity();
        HashSet<IElementDeltaEvaluation> evaluationList = (HashSet<IElementDeltaEvaluation>)this.m_resultsBySeverity.get(severity);
        if (evaluationList == null) {
            evaluationList = new HashSet<IElementDeltaEvaluation>();
            this.m_resultsBySeverity.put(severity, evaluationList);
        }
        evaluationList.add(evaluation);
    }

    protected DevelopmentConfiguration getConfig() {
        return this.m_updatePlan.getDevconf();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

