/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.Repository;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.cmpconf.AttributeID;
import com.sap.tc.complib.cmpconf.ChangeType;
import com.sap.tc.complib.cmpconf.IAttributeDelta;
import com.sap.tc.complib.cmpconf.ICompartmentDelta;
import com.sap.tc.complib.cmpconf.IConfigElementDelta;
import com.sap.tc.complib.cmpconf.IConfigurationDelta;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDCNodeResult;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.ConfigurationEvaluationException;
import com.sap.tc.devconf.update.DeltaSeverity;
import com.sap.tc.devconf.update.IServerDefinitionAction;
import com.sap.tc.devconf.update.IUpdateWSFilterAction;
import com.sap.tc.devconf.update.ServerType;
import com.sap.tc.devconf.update.UnknownConfigurationElementException;
import com.sap.tc.devconf.update.UnkownChangeTypeException;
import com.sap.tc.devconf.update.impl.AskDefaultBuildVariantProblem;
import com.sap.tc.devconf.update.impl.ChangeNotSupportedProblem;
import com.sap.tc.devconf.update.impl.ConfigDeltaEvaluation;
import com.sap.tc.devconf.update.impl.DevconfUpdateTexts;
import com.sap.tc.devconf.update.impl.ElementDeltaEvaluation;
import com.sap.tc.devconf.update.impl.MakeDCsDirtyAction;
import com.sap.tc.devconf.update.impl.ProblemWithDCs;
import com.sap.tc.devconf.update.impl.RemoveMointpointAction;
import com.sap.tc.devconf.update.impl.RescanLocalArchiveFolderAction;
import com.sap.tc.devconf.update.impl.RescanLocalSourceDcsAction;
import com.sap.tc.devconf.update.impl.ServerDefinitionAction;
import com.sap.tc.devconf.update.impl.UpdatePlan;
import com.sap.tc.devconf.update.impl.UpdateWSFilterAction;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CompartmentEvaluator {
    Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$CompartmentEvaluator == null ? (class$com$sap$tc$devconf$update$impl$CompartmentEvaluator = CompartmentEvaluator.class$("com.sap.tc.devconf.update.impl.CompartmentEvaluator")) : class$com$sap$tc$devconf$update$impl$CompartmentEvaluator));
    private final DevelopmentConfiguration m_config;
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$CompartmentEvaluator;

    public CompartmentEvaluator(DevelopmentConfiguration config) {
        this.m_config = config;
    }

    public void evaluate(ICompartmentDelta compartmentDelta, ConfigDeltaEvaluation evaluation) throws ConfigurationEvaluationException {
        ElementDeltaEvaluation compartmentEvaluatuion;
        String thisMessage = "evaluate";
        ChangeType kindOfChange = compartmentDelta.getChangeType();
        IConfigurationDelta configDelta = (IConfigurationDelta)compartmentDelta.getParent();
        UpdatePlan updatePlan = evaluation._getUpdatePlan();
        if (kindOfChange == ChangeType.DELETED) {
            compartmentEvaluatuion = this.handleCompartmentDeleted(compartmentDelta, updatePlan);
        } else if (kindOfChange == ChangeType.ADDED) {
            compartmentEvaluatuion = this.handleCompartmentAdded(configDelta.getNewConfiguration(), compartmentDelta, updatePlan);
        } else if (kindOfChange == ChangeType.MODIFIED) {
            this.handleCompartmentModified(evaluation, configDelta.getNewConfiguration(), compartmentDelta, updatePlan);
            compartmentEvaluatuion = new ElementDeltaEvaluation(DeltaSeverity.NON_CRITICAL, (IConfigElementDelta)compartmentDelta);
        } else {
            String msg = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.ILLEGAL_CHANGE_TYPE_1"), kindOfChange, compartmentDelta);
            UnkownChangeTypeException e = new UnkownChangeTypeException(msg, kindOfChange);
            this.LOCATION.throwing(thisMessage, (Throwable)((Object)e));
            throw new UnkownChangeTypeException(msg, kindOfChange);
        }
        evaluation.add(compartmentEvaluatuion);
    }

    private void handleCompartmentModified(ConfigDeltaEvaluation configEvaluation, com.sap.tc.complib.DevelopmentConfiguration configuration, ICompartmentDelta compartmentDelta, UpdatePlan updatePlan) throws ConfigurationEvaluationException {
        String thisMethod = "handleCompartmentModified";
        String compartmentName = compartmentDelta.getOldCompartment().getName();
        this.evaluateCompartmentAttributes(configEvaluation, compartmentDelta, updatePlan, compartmentName);
        this.evaluateBVDeltas(configEvaluation, compartmentDelta, updatePlan, compartmentName);
        compartmentDelta.getAliasMapDeltas();
        compartmentDelta.getPropertyDeltas();
        compartmentDelta.getSourceStateDelta();
        compartmentDelta.getUsageDeltas();
    }

    private void evaluateBVDeltas(ConfigDeltaEvaluation configEvaluation, ICompartmentDelta compartmentDelta, UpdatePlan updatePlan, String compartmentName) {
        compartmentDelta.getBuildVariantDeltas();
    }

    private void evaluateCompartmentAttributes(ConfigDeltaEvaluation configEvaluation, ICompartmentDelta compartmentDelta, UpdatePlan updatePlan, String compartmentName) throws ConfigurationEvaluationException, UnknownConfigurationElementException {
        String thisMethod = "evaluateCompartmentAttributes";
        IAttributeDelta[] attrDeltas = compartmentDelta.getAttributeDeltas();
        int i = 0;
        while (i < attrDeltas.length) {
            String msg;
            DeltaSeverity severity;
            IAttributeDelta attrDelta = attrDeltas[i];
            ChangeNotSupportedProblem problem = null;
            if (attrDelta.getID() == AttributeID.COMPARTMENT_DESCRIPTION) {
                severity = DeltaSeverity.NON_CRITICAL;
            } else if (attrDelta.getID() == AttributeID.COMPARTMENT_CAPTION) {
                severity = DeltaSeverity.NON_CRITICAL;
            } else if (attrDelta.getID() == AttributeID.COMPARTMENT_ARCHIVE_STATE) {
                severity = DeltaSeverity.NON_CRITICAL;
            } else if (attrDelta.getID() == AttributeID.COMPARTMENT_DEFAULT_COMPARTMENT) {
                severity = DeltaSeverity.CRITICAL;
                msg = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.ILLEGAL_CHANGE_TYPE_2"), compartmentName, attrDelta);
                problem = new ChangeNotSupportedProblem(msg);
            } else if (attrDelta.getID() == AttributeID.COMPARTMENT_LOCAL_ARCHIVE_FOLDER) {
                severity = DeltaSeverity.NON_CRITICAL;
                updatePlan.add(new RescanLocalArchiveFolderAction(this.m_config, compartmentName));
                List dcs = this.m_config.listLocallyAvailableDCs(compartmentName);
                if (!dcs.isEmpty()) {
                    MakeDCsDirtyAction action = new MakeDCsDirtyAction(this.m_config);
                    Iterator iter = dcs.iterator();
                    while (iter.hasNext()) {
                        IDevelopmentComponentNode dc = (IDevelopmentComponentNode)iter.next();
                        try {
                            IDCProxy usedProxy = dc.getDCProxy();
                            IDCNodeResult usersResult = usedProxy.listLocalAtBuildTimeUsers();
                            if (usersResult == null) continue;
                            Iterator iterator = usersResult.getExceptions().iterator();
                            while (iterator.hasNext()) {
                                Exception ex = (Exception)iterator.next();
                                String message = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.ERROR_MARK_REBUILD"), dc, ex.getMessage());
                                this.m_config.sendDCMessage(dc, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, message);
                                this.LOCATION.infoT(thisMethod, message);
                            }
                            Iterator iterator2 = usersResult.getDCNodes().iterator();
                            while (iterator2.hasNext()) {
                                IDevelopmentComponentNode node = (IDevelopmentComponentNode)iterator2.next();
                                action.addDC(node);
                            }
                        }
                        catch (DevConfigException e) {
                            this.LOCATION.traceThrowableT(300, thisMethod, (Throwable)((Object)e));
                            String message = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.ERROR_GET_USING_DCS"), dc, ((Throwable)((Object)e)).getMessage());
                            this.m_config.sendDCMessage(dc, "", DCMessageType.WARNING, DCEventType.GENERIC_DC_EVENT, message);
                            this.LOCATION.infoT(thisMethod, message);
                        }
                    }
                    if (action.getDcSet() != null && action.getDcSet().size() > 0) {
                        updatePlan.add(action);
                    }
                }
            } else if (attrDelta.getID() == AttributeID.COMPARTMENT_SC_NAME || attrDelta.getID() == AttributeID.COMPARTMENT_SC_VENDOR) {
                Compartment oldCompartment = compartmentDelta.getOldCompartment();
                Compartment newCompartment = compartmentDelta.getNewCompartment();
                if (oldCompartment.hasSourceState() && newCompartment.hasSourceState()) {
                    severity = DeltaSeverity.NON_CRITICAL;
                } else {
                    severity = DeltaSeverity.CRITICAL;
                    String msg2 = attrDelta.getID() == AttributeID.COMPARTMENT_SC_NAME ? MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.RENAMING_NOT_SUPPORTED"), compartmentName, oldCompartment.getScName(), newCompartment.getScName()) : MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.RENAME_VENDOR_NOT_SUPPORTED"), compartmentName, oldCompartment.getScVendor(), newCompartment.getScVendor());
                    problem = new ChangeNotSupportedProblem(msg2);
                }
            } else {
                msg = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.ERROR_ATTRIBUTE_UNKNOWN"), attrDelta.getID(), compartmentName);
                UnknownConfigurationElementException e = new UnknownConfigurationElementException(msg);
                this.LOCATION.throwing(thisMethod, (Throwable)((Object)e));
                throw e;
            }
            ElementDeltaEvaluation attrEvaluation = new ElementDeltaEvaluation(severity, (IConfigElementDelta)attrDelta);
            if (problem != null) {
                attrEvaluation.addProblem(problem);
            }
            configEvaluation.add(attrEvaluation);
            ++i;
        }
    }

    private ElementDeltaEvaluation handleCompartmentAdded(com.sap.tc.complib.DevelopmentConfiguration newConfig, ICompartmentDelta compartmentDelta, UpdatePlan updatePlan) throws ConfigurationEvaluationException {
        ElementDeltaEvaluation compartmentEvaluatuion;
        Compartment newCompartment = compartmentDelta.getNewCompartment();
        String impliedBV = this.getImpliedBuildVariant(newConfig, newCompartment);
        if (impliedBV == null) {
            compartmentEvaluatuion = new ElementDeltaEvaluation(DeltaSeverity.APPROVE, (IConfigElementDelta)compartmentDelta);
            String msg = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.SPECIFY_DEFUALT_BV"), newCompartment.getName());
            compartmentEvaluatuion.addProblem(new AskDefaultBuildVariantProblem(msg, newCompartment));
        } else {
            compartmentEvaluatuion = new ElementDeltaEvaluation(DeltaSeverity.NON_CRITICAL, (IConfigElementDelta)compartmentDelta);
        }
        if (newCompartment.hasSourceState()) {
            compartmentEvaluatuion = this.handleAddSourceState(compartmentDelta, updatePlan, compartmentEvaluatuion, newCompartment);
        }
        return compartmentEvaluatuion;
    }

    private ElementDeltaEvaluation handleAddSourceState(ICompartmentDelta compartmentDelta, UpdatePlan updatePlan, ElementDeltaEvaluation compartmentEvaluatuion, Compartment newCompartment) throws ConfigurationEvaluationException {
        if (newCompartment.isLocal()) {
            updatePlan.add(new RescanLocalSourceDcsAction(this.m_config));
        } else {
            SourceState sourceState = newCompartment.getSourceState();
            Repository repos = sourceState.getRepository();
            if (repos.getType() != "DTR") {
                String msg = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.UNSUPPORTED_REPOSITORY_TYPE"), repos.getType());
                ChangeNotSupportedProblem problem = new ChangeNotSupportedProblem(msg);
                compartmentEvaluatuion = new ElementDeltaEvaluation(DeltaSeverity.CRITICAL, (IConfigElementDelta)compartmentDelta);
                compartmentEvaluatuion.addProblem(problem);
            } else {
                ServerDefinitionAction addServerAction = new ServerDefinitionAction(this.m_config, repos.getURL(), ServerType.REPOSITORY, IServerDefinitionAction.ServerActionKind.ADD, null);
                updatePlan.add(addServerAction);
                String loc = sourceState.getLocation();
                if (loc != null) {
                    UpdateWSFilterAction addWSaction = new UpdateWSFilterAction(this.m_config, repos.getURL(), loc, IUpdateWSFilterAction.FilterActionKind.ADD);
                    updatePlan.add(addWSaction);
                }
                String inactiveLoc = sourceState.getInactiveLocation();
                if (loc != null) {
                    UpdateWSFilterAction addWSaction = new UpdateWSFilterAction(this.m_config, repos.getURL(), inactiveLoc, IUpdateWSFilterAction.FilterActionKind.ADD);
                    updatePlan.add(addWSaction);
                }
            }
        }
        return compartmentEvaluatuion;
    }

    private String getImpliedBuildVariant(com.sap.tc.complib.DevelopmentConfiguration newConfig, Compartment compartment) {
        String thisMethod = "getImpliedBuildVariant";
        String result = null;
        Map vMap = compartment.getBuildVariants();
        if (vMap != null) {
            Collection variants = vMap.values();
            if (variants.size() == 1) {
                String variantName = (String)vMap.keySet().iterator().next();
                this.LOCATION.debugT(thisMethod, DevconfUpdateTexts.getString("CompartmentEvaluator.DEBUG_FOUND_SINGLE_BV"), new Object[]{compartment.getName(), variantName});
                result = variantName;
            } else {
                HashSet<String> mappedBVs = new HashSet<String>();
                Collection compartments = newConfig.getCompartments().values();
                Iterator iter = compartments.iterator();
                block0: while (iter.hasNext()) {
                    Map usingBVMap;
                    Set usedCompartmentNames;
                    Compartment usingCompartmentCandidate = (Compartment)iter.next();
                    if (compartment.equals(usingCompartmentCandidate) || (usedCompartmentNames = usingCompartmentCandidate.getUsedCompartments()) == null || !usedCompartmentNames.contains(compartment.getName()) || (usingBVMap = usingCompartmentCandidate.getBuildVariants()) == null) continue;
                    Iterator iterator = usingBVMap.values().iterator();
                    while (iterator.hasNext()) {
                        String mappedBVName;
                        BuildVariant usingBV = (BuildVariant)iterator.next();
                        Map buildVariantMapping = usingBV.getVariantMapping();
                        if (buildVariantMapping == null || (mappedBVName = (String)buildVariantMapping.get(compartment.getName())) == null) continue;
                        mappedBVs.add(mappedBVName);
                        break block0;
                    }
                }
                if (mappedBVs.size() == 1) {
                    result = (String)mappedBVs.iterator().next();
                }
            }
        } else {
            this.LOCATION.debugT(thisMethod, DevconfUpdateTexts.getString("CompartmentEvaluator.DEBUG_DID_NOT_FIND_ANY_BV"), new Object[]{compartment.getName()});
        }
        return result;
    }

    private ElementDeltaEvaluation handleCompartmentDeleted(ICompartmentDelta compartmentDelta, UpdatePlan updatePlan) throws ConfigurationEvaluationException {
        ElementDeltaEvaluation compartmentEvaluatuion;
        Compartment oldCompartment = compartmentDelta.getOldCompartment();
        String compartmentName = oldCompartment.getName();
        List dcs = this.m_config.listLocallyAvailableDCs(compartmentName);
        ProblemWithDCs problem = null;
        if (dcs.size() != 0) {
            String msg = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.CANNOT_REMOVE_BECAUSE_OF_LOCAL_DCS"), compartmentName);
            problem = new ProblemWithDCs(msg);
            Iterator iter = dcs.iterator();
            while (iter.hasNext()) {
                IDevelopmentComponentNode dc = (IDevelopmentComponentNode)iter.next();
                if (dc.isLocalOnly()) {
                    if (dc.getNodeSyncState() == DCNodeSyncState.INSTALLED) continue;
                    problem.addLocalDC(dc);
                    continue;
                }
                problem.addSynchedDC(dc);
            }
        }
        if (problem != null && problem.countLocalDCs() > 0 && problem.countSynchedDCs() > 0) {
            compartmentEvaluatuion = new ElementDeltaEvaluation(DeltaSeverity.CRITICAL, (IConfigElementDelta)compartmentDelta);
            compartmentEvaluatuion.addProblem(problem);
        } else {
            compartmentEvaluatuion = new ElementDeltaEvaluation(DeltaSeverity.NON_CRITICAL, (IConfigElementDelta)compartmentDelta);
            if (oldCompartment.hasSourceState()) {
                this.planRemoveSourceState(updatePlan, oldCompartment);
            }
        }
        return compartmentEvaluatuion;
    }

    private void planRemoveSourceState(UpdatePlan updatePlan, Compartment oldCompartment) throws ConfigurationEvaluationException {
        String thisMethod = "planRemoveSourceState";
        List dcs = this.m_config.listLocallyAvailableDCs(oldCompartment.getName());
        Iterator iter = dcs.iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode dc = (IDevelopmentComponentNode)iter.next();
            if (!dc.isSynchedAsSource()) continue;
            try {
                IMountPoint mp = this.m_config.getMountPointForDC(dc.getCompartmentName(), dc.getVendor(), dc.getName());
                if (mp == null) continue;
                updatePlan.add(new RemoveMointpointAction(this.m_config, mp));
            }
            catch (SyncException e) {
                String msg = MessageFormat.format(DevconfUpdateTexts.getString("CompartmentEvaluator.ERROR_DTR_MOUNT_POINT"), dc);
                ConfigurationEvaluationException cex = new ConfigurationEvaluationException(msg, (Throwable)((Object)e));
                this.LOCATION.throwing(thisMethod, (Throwable)((Object)cex));
                throw cex;
            }
        }
        SourceState sourceState = oldCompartment.getSourceState();
        if (sourceState.getLocation() != null) {
            updatePlan.add(new UpdateWSFilterAction(this.m_config, sourceState.getRepository().getURL(), sourceState.getLocation(), IUpdateWSFilterAction.FilterActionKind.DELETE));
        }
        if (sourceState.getInactiveLocation() != null) {
            updatePlan.add(new UpdateWSFilterAction(this.m_config, sourceState.getRepository().getURL(), sourceState.getInactiveLocation(), IUpdateWSFilterAction.FilterActionKind.DELETE));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

