/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.update.impl;

import com.sap.tc.devconf.OfflineException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.update.FatalConfigurationUpdateException;
import com.sap.tc.devconf.update.IActionResult;
import com.sap.tc.devconf.update.IClientConfigurationSaveAction;
import com.sap.tc.devconf.update.impl.AbstractAction;
import com.sap.tc.devconf.update.impl.ActionResult;
import com.sap.tc.devconf.update.impl.UpdateActionMessage;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class ClientConfigurationSaveAction
extends AbstractAction
implements IClientConfigurationSaveAction {
    Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$update$impl$ClientConfigurationSaveAction == null ? (class$com$sap$tc$devconf$update$impl$ClientConfigurationSaveAction = ClientConfigurationSaveAction.class$("com.sap.tc.devconf.update.impl.ClientConfigurationSaveAction")) : class$com$sap$tc$devconf$update$impl$ClientConfigurationSaveAction));
    static /* synthetic */ Class class$com$sap$tc$devconf$update$impl$ClientConfigurationSaveAction;

    public ClientConfigurationSaveAction(DevelopmentConfiguration config) {
        super(config);
    }

    protected IActionResult _execute() throws FatalConfigurationUpdateException {
        try {
            String thisMethod = "_execute";
            IClient client = this.getConfig().getDTRClient();
            if (client == null) {
                String msg = "Update Configuration failed. Could not update workspace filters. DTR client is null";
                this.LOCATION.infoT(thisMethod, msg);
                throw new FatalConfigurationUpdateException(msg);
            }
            client.getConfiguration().saveAll();
            String msg = "Sucessfully saved the DTR client configuration";
            this.LOCATION.debugT(thisMethod, msg);
            ArrayList<UpdateActionMessage> okList = new ArrayList<UpdateActionMessage>(1);
            okList.add(new UpdateActionMessage(msg, true, null));
            return new ActionResult(okList, new ArrayList(0));
        }
        catch (OfflineException e) {
            String msg = MessageFormat.format("Update Configuration failed, could not persist DTR client configuration: {0}", ((Throwable)((Object)e)).getMessage());
            this.LOCATION.traceThrowableT(300, msg, (Throwable)((Object)e));
            throw new FatalConfigurationUpdateException(msg, (Throwable)((Object)e));
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Update Configuration failed, failed to persist DTR client configuration: {0}", e.getMessage());
            this.LOCATION.traceThrowableT(300, msg, (Throwable)e);
            throw new FatalConfigurationUpdateException(msg, e);
        }
    }

    public String describe() {
        return "Saves the changes applied to the DTR client configuration.";
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof ClientConfigurationSaveAction;
    }

    public int hashCode() {
        return 37 * super.hashCode() + this.getClass().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

