/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl.syncdb;

import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import com.sap.tc.devconf.impl.syncdb.ChangeType;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.DCSyncDeltaEntry;
import com.sap.tc.devconf.impl.syncdb.DCSyncEntry;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SyncDBDeltaManager
extends Initializable {
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$syncdb$SyncDBDeltaManager == null ? (class$com$sap$tc$devconf$impl$syncdb$SyncDBDeltaManager = SyncDBDeltaManager.class$("com.sap.tc.devconf.impl.syncdb.SyncDBDeltaManager")) : class$com$sap$tc$devconf$impl$syncdb$SyncDBDeltaManager));
    private static final String suffix = ".synclog";
    private String configuration;
    private String rootFolder;
    private HashMap changedEntries = new HashMap();
    private ComponentSyncDB syncdb;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$syncdb$SyncDBDeltaManager;

    public SyncDBDeltaManager(ComponentSyncDB syncdb, String configuration, String rootFolder) {
        this.configuration = configuration;
        this.rootFolder = rootFolder;
        this.syncdb = syncdb;
    }

    void notifyEntryDeleted(DCSyncEntry entry) {
    }

    void notifyEntryCreated(DCSyncEntry entry) {
    }

    void notifEntryModified(DCSyncEntry entry) {
    }

    protected boolean endTag(String name) throws SAXException {
        return false;
    }

    protected void startTag(String name, Attributes attributes) throws SAXException {
    }

    public void serialize() {
        if (this.changedEntries.isEmpty()) {
            return;
        }
        try {
            Iterator it = this.changedEntries.keySet().iterator();
            File file = this.getNextSaveFile();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            XMLWriter writer = new XMLWriter((OutputStream)out);
            writer.beginDocument();
            writer.writeRootTag("component-syncdb-delta");
            writer.writeTag("timestamp", Long.toString(System.currentTimeMillis()));
            while (it.hasNext()) {
                DCSyncEntry changedEntry = (DCSyncEntry)it.next();
                ChangeType changeType = (ChangeType)this.changedEntries.get(changedEntry);
                DCSyncDeltaEntry deltaEntry = new DCSyncDeltaEntry(changedEntry, changeType);
                deltaEntry.serialize(writer);
            }
            writer.endDocument();
            writer.serialize();
            this.changedEntries.clear();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not save  component sync db: " + e.getMessage());
        }
    }

    private File getNextSaveFile() {
        String name = this.configuration;
        File folder = new File(this.rootFolder);
        int separator = 46;
        String[] a = folder.list();
        int max = 0;
        int i = 0;
        while (i < a.length) {
            try {
                String prefix;
                int n;
                String s = a[i];
                if (s.endsWith(suffix) && (n = Integer.parseInt(prefix = s.substring(0, s.indexOf(separator)))) > max) {
                    max = n;
                }
            }
            catch (NumberFormatException e) {
                LOCATION.catching("getNextSaveFile", (Throwable)e);
            }
            ++i;
        }
        File file = new File(this.rootFolder, Integer.toString(max + 1) + suffix);
        return file;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

