/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl.syncdb;

import com.sap.tc.complib.xml.Attribute;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.XMLWriter;
import com.sap.tc.devconf.DCActivityState;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncDBDeltaManager;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.devconf.impl.syncdb.SyncState;
import com.sap.tc.devconf.impl.syncdb.VariantSyncEntry;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DCSyncEntry
extends Initializable
implements IDCSyncEntry {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$syncdb$DCSyncEntry == null ? (class$com$sap$tc$devconf$impl$syncdb$DCSyncEntry = DCSyncEntry.class$("com.sap.tc.devconf.impl.syncdb.DCSyncEntry")) : class$com$sap$tc$devconf$impl$syncdb$DCSyncEntry));
    private SyncMode m_syncMode = SyncMode.NOT_SYNCHED;
    private SyncState m_syncState = SyncState.UNKNOWN;
    private DCActivityState m_activityState = DCActivityState.NONE;
    private boolean m_dirty = false;
    private boolean m_broken = false;
    private Map m_variants;
    private SyncDBDeltaManager m_deltaManager;
    private boolean m_isLocallyInstalled = false;
    public static final String TAG_ENTRY_DATA = "data";
    public static final String TAG_SYNC_STATE = "state";
    public static final String TAG_SYNC_MODE = "mode";
    public static final String TAG_BN_SERVER_OLD = "bn-srv";
    public static final String TAG_BN_CDA_OLD = "bn-cda";
    public static final String TAG_VARIANT = "variant";
    public static final String TAG_DIRTY = "dirty";
    public static final String TAG_BROKEN = "broken";
    public static final String TAG_ACTIVITY_STATE = "activity";
    public static final String ATTR_VNT_NAME = "name";
    public static final String ATTR_VNT_BNR = "bn";
    public static final String ATTR_VNT_STATE = "state";
    private static final int STATE_SYNC_STATE = 3;
    private static final int STATE_SYNC_MODE = 4;
    private static final int STATE_BN_SERVER = 5;
    private static final int STATE_BN_CDA = 6;
    private static final int STATE_VARIANT = 7;
    private static final int STATE_FINAL = 8;
    private static final int STATE_ACTIVITY = 9;
    private static final int STATE_DIRTY = 10;
    private static final int STATE_BROKEN = 11;
    private String m_rootTag;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$syncdb$DCSyncEntry;

    private DCSyncEntry() {
    }

    protected DCSyncEntry(SyncDBDeltaManager deltaManager, boolean isNewlyCreated) {
        this.m_deltaManager = deltaManager;
        if (isNewlyCreated) {
            this.m_deltaManager.notifyEntryCreated(this);
        }
    }

    public void setState(SyncState state) {
        this.m_deltaManager.notifEntryModified(this);
        this.m_syncState = state;
    }

    public SyncState getState() {
        return this.m_syncState;
    }

    public void setMode(SyncMode mode) {
        this.m_deltaManager.notifEntryModified(this);
        this.m_syncMode = mode;
    }

    public SyncMode getMode() {
        return this.m_syncMode;
    }

    public DCActivityState getActivityState() {
        return this.m_activityState;
    }

    public void setActivityState(DCActivityState activityState) {
        this.m_activityState = activityState;
    }

    public boolean isSynched() {
        return !this.m_syncMode.equals(SyncMode.NOT_SYNCHED) && !this.m_syncMode.equals(SyncMode.LOCAL_ONLY);
    }

    public boolean isSynchedAsSource() {
        return this.m_syncMode.equals(SyncMode.SYNCHED_AS_ACTIVE_SOURCE) || this.m_syncMode.equals(SyncMode.SYNCHED_AS_INACTIVE_SOURCE);
    }

    public boolean isSyncedAsArchive() {
        return this.m_syncMode.equals(SyncMode.SYNCHED_AS_ARCHIVE);
    }

    public boolean isVariantUpToDate(String variant, long newBuildNumber) {
        return this.getBuildNumber(variant) == newBuildNumber;
    }

    public boolean isVariantUpToDate(String variant) {
        return this.getState(variant) == SyncState.UPTODATE;
    }

    public VariantSyncEntry addVariant(String variant, long buildNumber, SyncState state) throws IllegalStateException {
        VariantSyncEntry variantEntry;
        if (!this.isLocallyInstalled() && !this.isSyncedAsArchive()) {
            String m = "Cannot add a variant to sync entry for a DCthat is available as source";
            IllegalStateException e = new IllegalStateException(m);
            LOCATION.throwing("addVariant", (Throwable)e);
            throw e;
        }
        this.m_deltaManager.notifEntryModified(this);
        if (this.m_variants == null) {
            this.m_variants = new HashMap();
        }
        if ((variantEntry = (VariantSyncEntry)this.m_variants.get(variant)) == null) {
            variantEntry = new VariantSyncEntry(buildNumber, state);
            this.m_variants.put(variant, variantEntry);
        }
        return variantEntry;
    }

    public void removeVariant(String variant) {
        if (this.m_variants != null && this.m_variants.containsKey(variant)) {
            this.m_deltaManager.notifEntryModified(this);
            this.m_variants.remove(variant);
            if (this.m_syncMode == SyncMode.SYNCHED_AS_ARCHIVE) {
                if (this.m_variants.size() == 0) {
                    this.m_syncMode = SyncMode.NOT_SYNCHED;
                }
                this.m_syncState = SyncState.UNKNOWN;
            }
        }
    }

    public void removeVariants() {
        if (this.m_variants != null) {
            this.m_deltaManager.notifEntryModified(this);
            this.m_variants.clear();
        }
    }

    public List getVariantNames() {
        ArrayList<Object> list = null;
        list = this.m_variants != null ? new ArrayList(this.m_variants.keySet()) : new ArrayList();
        return list;
    }

    public long getBuildNumber(String variant) {
        VariantSyncEntry v;
        long buildNumber = ComponentSyncDB.NOT_SYNCED_BUILD_NUMBER;
        if (this.m_variants != null && (v = (VariantSyncEntry)this.m_variants.get(variant)) != null) {
            buildNumber = v.getBuildNumber();
        }
        return buildNumber;
    }

    public SyncState getState(String variant) {
        VariantSyncEntry v;
        SyncState state = SyncState.UNKNOWN;
        if (this.m_variants != null && (v = (VariantSyncEntry)this.m_variants.get(variant)) != null) {
            state = v.getState();
        }
        return state;
    }

    public void setBuildNumber(String variant, long buildNumber) {
        VariantSyncEntry v;
        if (this.m_variants == null) {
            this.m_variants = new HashMap();
        }
        if ((v = (VariantSyncEntry)this.m_variants.get(variant)) == null) {
            v = new VariantSyncEntry();
            this.m_variants.put(variant, v);
        }
        v.setBuildNumber(buildNumber);
        this.m_deltaManager.notifEntryModified(this);
    }

    public void setState(String variant, SyncState state) {
        VariantSyncEntry v;
        if (this.m_variants == null) {
            this.m_variants = new HashMap();
        }
        if ((v = (VariantSyncEntry)this.m_variants.get(variant)) == null) {
            v = new VariantSyncEntry();
            this.m_variants.put(variant, v);
        }
        v.setState(state);
        this.m_deltaManager.notifEntryModified(this);
    }

    public boolean isLocallyInstalled() {
        return this.m_isLocallyInstalled;
    }

    public boolean isLocalOnlySource() {
        return this.m_syncMode == SyncMode.LOCAL_ONLY && !this.m_isLocallyInstalled;
    }

    public void setIsLocallyInstalled(boolean isLocallyInstalled) {
        this.m_isLocallyInstalled = isLocallyInstalled;
    }

    public boolean isSynchedAsArchives(String variant) {
        if (this.isSyncedAsArchive()) {
            return this.getBuildNumber(variant) != ComponentSyncDB.NOT_SYNCED_BUILD_NUMBER;
        }
        return false;
    }

    public boolean isAvailable(String variant) {
        if (this.isSynchedAsSource()) {
            return true;
        }
        if (this.isLocalOnlySource()) {
            return true;
        }
        if (this.isLocallyInstalled()) {
            return true;
        }
        if (this.isSyncedAsArchive()) {
            return this.getBuildNumber(variant) != ComponentSyncDB.NOT_SYNCED_BUILD_NUMBER;
        }
        return this.m_variants.get(variant) != null;
    }

    protected void startTag(String tagName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                if (tagName.equals(TAG_ENTRY_DATA)) {
                    this.state = 10;
                    this.m_rootTag = tagName;
                    return;
                }
                throw new SAXException("unxepected tag<" + tagName + "> when expecting tag <" + TAG_ENTRY_DATA + ">");
            }
            case 10: {
                if (tagName.equals(TAG_DIRTY)) {
                    this.state = 10;
                    return;
                }
            }
            case 11: {
                if (tagName.equals(TAG_BROKEN)) {
                    this.state = 11;
                    return;
                }
            }
            case 3: {
                if (tagName.equals("state")) {
                    this.state = 3;
                    return;
                }
                throw new SAXException(this.getMissingTagMessage("state", this.m_rootTag));
            }
            case 4: {
                if (tagName.equals(TAG_SYNC_MODE)) {
                    this.state = 4;
                    return;
                }
                throw new SAXException(this.getMissingTagMessage(TAG_SYNC_MODE, this.m_rootTag));
            }
            case 9: {
                if (tagName.equals(TAG_ACTIVITY_STATE)) {
                    this.state = 9;
                    return;
                }
            }
            case 5: {
                if (tagName.equals(TAG_BN_SERVER_OLD)) {
                    this.state = 5;
                    return;
                }
            }
            case 6: {
                if (tagName.equals(TAG_BN_CDA_OLD)) {
                    this.state = 6;
                    return;
                }
            }
            case 7: {
                SyncState vntSyncState;
                long bn;
                if (!tagName.equals(TAG_VARIANT)) break;
                String vntName = attributes.getValue(ATTR_VNT_NAME);
                String vntBn = attributes.getValue(ATTR_VNT_BNR);
                String vntState = attributes.getValue("state");
                this.checkMandatoryAttribute(vntName, ATTR_VNT_NAME, tagName);
                this.checkMandatoryAttribute(vntBn, ATTR_VNT_BNR, tagName);
                this.checkMandatoryAttribute(vntState, "state", tagName);
                try {
                    bn = Long.parseLong(vntBn);
                }
                catch (NumberFormatException e) {
                    throw new SAXException("illegal attribute \"bn\" of <" + tagName + ">. value \"" + vntBn + "\" is not a number");
                }
                try {
                    vntSyncState = SyncState.fromString(vntState);
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException("illegal attribute \"state\" of <" + tagName + ">. value \"" + vntState + "\" is not a valid SyncState");
                }
                this.addVariant(vntName, bn, vntSyncState);
                this.state = 7;
                return;
            }
        }
        throw new SAXException("Internal Error: Unexpected state '" + this.state + "' while parsing DC syncdb entry ( current tag is <" + tagName + ">)");
    }

    protected void tagValue(char[] chars, int start, int length) {
        super.tagValue(chars, start, length);
    }

    protected boolean endTag(String tagName) throws SAXException {
        try {
            switch (this.state) {
                case 10: {
                    if (tagName.equals(TAG_DIRTY)) {
                        this.m_dirty = true;
                        return true;
                    }
                    break;
                }
                case 11: {
                    if (tagName.equals(TAG_BROKEN)) {
                        this.m_broken = true;
                        return true;
                    }
                    break;
                }
                case 3: {
                    if (tagName.equals("state")) {
                        this.m_syncState = SyncState.fromString(this.getStringValue(true));
                        this.state = 4;
                        return true;
                    }
                    break;
                }
                case 4: {
                    if (tagName.equals(TAG_SYNC_MODE)) {
                        this.m_syncMode = SyncMode.fromString(this.getStringValue(true));
                        this.state = 9;
                        return true;
                    }
                    break;
                }
                case 9: {
                    if (tagName.equals(TAG_ACTIVITY_STATE)) {
                        this.m_activityState = DCActivityState.fromString(this.getStringValue(true));
                        this.state = 5;
                        return true;
                    }
                }
                case 5: {
                    if (tagName.equals(TAG_BN_SERVER_OLD)) {
                        this.state = 6;
                        return true;
                    }
                }
                case 6: {
                    if (tagName.equals(TAG_BN_CDA_OLD)) {
                        this.state = 7;
                        return true;
                    }
                }
                case 7: {
                    if (tagName.equals(TAG_VARIANT)) {
                        this.state = 7;
                        return true;
                    }
                }
                case 8: {
                    if (tagName.equals(this.m_rootTag)) {
                        this.state = 8;
                        return false;
                    }
                    break;
                }
                default: {
                    throw new SAXException("Internal Error: Unexpected state '" + this.state + "' while parsing syncdb (end tag <" + tagName + ">)");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            String message = "Cannot read component sync DB entry. (end tag </" + tagName + ">)" + "\n  " + e.getMessage();
            throw new SAXException(message);
        }
        return true;
    }

    public void serialize(XMLWriter writer) {
        writer.beginTag(TAG_ENTRY_DATA);
        if (this.m_dirty) {
            writer.writeEmptyTag(TAG_DIRTY);
        }
        if (this.m_broken) {
            writer.writeEmptyTag(TAG_BROKEN);
        }
        writer.writeTag("state", this.m_syncState.toString());
        writer.writeTag(TAG_SYNC_MODE, this.m_syncMode.toString());
        if (this.m_activityState != DCActivityState.NONE) {
            writer.writeTag(TAG_ACTIVITY_STATE, this.m_activityState.toString());
        }
        if (this.m_variants != null && (this.isSyncedAsArchive() || this.isLocallyInstalled())) {
            Iterator iter = this.m_variants.keySet().iterator();
            while (iter.hasNext()) {
                String variantName = (String)iter.next();
                VariantSyncEntry variantEntry = (VariantSyncEntry)this.m_variants.get(variantName);
                String vntBuildNumber = Long.toString(variantEntry.getBuildNumber());
                String vntState = variantEntry.getState().toString();
                Attribute[] attrs = new Attribute[]{new Attribute(ATTR_VNT_NAME, variantName), new Attribute(ATTR_VNT_BNR, vntBuildNumber), new Attribute("state", vntState)};
                writer.writeEmptyTag(TAG_VARIANT, attrs);
            }
        }
        writer.endTag(TAG_ENTRY_DATA);
    }

    public boolean isSynchedAsArchives() {
        return this.m_syncMode == SyncMode.SYNCHED_AS_ARCHIVE;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public void setDirty(boolean dirty) {
        this.m_deltaManager.notifEntryModified(this);
        this.m_dirty = dirty;
    }

    public boolean isBroken() {
        return this.m_broken;
    }

    public void setBroken(boolean broken) {
        this.m_deltaManager.notifEntryModified(this);
        this.m_broken = broken;
    }

    public boolean isLocallyAvailableAsSource() {
        return this.isLocalOnlySource() || this.isSynchedAsSource();
    }

    public boolean isLocallyAvailableAsArchives() {
        return this.isLocallyInstalled() || this.isSyncedAsArchive();
    }

    public boolean isLocallyAvailable() {
        return this.isLocallyAvailableAsSource() || this.isLocallyAvailableAsArchives();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

