/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl.syncdb;

import com.sap.tc.cbs.util.ChainedRuntimeException;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.xml.Initializable;
import com.sap.tc.complib.xml.ParserAdapter;
import com.sap.tc.complib.xml.XMLWriter;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.syncdb.DCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncDBDeltaManager;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.devconf.impl.syncdb.SyncState;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ComponentSyncDB
extends Initializable {
    private static final Location LOCATION = Location.getLocation((String)(class$com$sap$tc$devconf$impl$syncdb$ComponentSyncDB == null ? (class$com$sap$tc$devconf$impl$syncdb$ComponentSyncDB = ComponentSyncDB.class$("com.sap.tc.devconf.impl.syncdb.ComponentSyncDB")) : class$com$sap$tc$devconf$impl$syncdb$ComponentSyncDB).getName());
    public static long NOT_SYNCED_BUILD_NUMBER = -1L;
    public static long IN_PROGRESS_BUILD_NUMBER = -2L;
    public static long GUARANTEED_TO_BE_OUTDATED = -3L;
    private static final String suffix = ".syncdb";
    private com.sap.tc.complib.DevelopmentConfiguration m_configuration;
    private HashMap m_entries = null;
    private HashMap m_index = null;
    private File m_file;
    private SyncDBDeltaManager m_deltaManager;
    private boolean m_localEntriesInitialized = false;
    DevelopmentConfiguration m_devconf;
    public static final String TAG_SYNCDB = "dc-syncdb";
    public static final String TAG_ROOT = "root";
    public static final String TAG_CONFIG_NAME = "config";
    public static final String TAG_ENTRY = "entry";
    public static final String TAG_ENTRY_KEY = "key";
    private static final int STATE_ROOT = 3;
    private static final int STATE_CONFIG = 4;
    private static final int STATE_ENTRY = 5;
    private static final int STATE_ENTRY_KEY = 6;
    private static final int STATE_ENTRY_DATA = 7;
    private static final int STATE_ENTRY_CHILD = 8;
    private static final int STATE_SYNCDB_FINAL = 9;
    private String rootTag;
    private DCSyncEntry parserEntryChild = null;
    private String parserCurrentKey = null;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$syncdb$ComponentSyncDB;

    public ComponentSyncDB(String rootFolder, com.sap.tc.complib.DevelopmentConfiguration configuration, Category logCategory) {
        this(rootFolder, configuration);
    }

    public ComponentSyncDB(String rootFolder, com.sap.tc.complib.DevelopmentConfiguration configuration) {
        this.m_configuration = configuration;
        this.m_file = new File(rootFolder, suffix);
        this.m_deltaManager = new SyncDBDeltaManager(this, configuration.getName(), rootFolder);
    }

    public ComponentSyncDB(String rootFolder, DevelopmentConfiguration configuration, Category logCategory) {
        this(rootFolder, configuration);
    }

    public ComponentSyncDB(String rootFolder, DevelopmentConfiguration configuration) {
        this.m_devconf = configuration;
        this.m_configuration = configuration.getConfigurationData();
        this.m_file = new File(rootFolder, suffix);
        this.m_deltaManager = new SyncDBDeltaManager(this, this.m_configuration.getName(), rootFolder);
    }

    public SyncState getSyncState(DevelopmentComponentRef ref) {
        return this.getSyncState(ref.getCompartment(), ref.getVendor(), ref.getName());
    }

    public SyncState getSyncState(String compartment, String vendor, String name) {
        return this.getSyncState(compartment, vendor, name, null);
    }

    public SyncState getSyncState(String compartment, String vendor, String name, String buildVariant) {
        DCSyncEntry entry = this._getEntry(compartment, name, vendor);
        if (entry == null) {
            return SyncState.UNKNOWN;
        }
        if (this.m_devconf == null) {
            String thisMethod = "getSyncState(IDCSyncEntry)";
            String msg = "INTERNAL ERROR: cannot get state of archive DC. DevelopmentConfiguration instance (devconf) not initialized in DC syncdb object.";
            IllegalStateException e = new IllegalStateException(msg);
            LOCATION.infoT(thisMethod, msg);
            LOCATION.throwing(thisMethod, (Throwable)e);
            throw e;
        }
        SyncState entryState = entry.getState();
        if (entry.isSynchedAsArchives()) {
            if (buildVariant == null) {
                buildVariant = this.m_devconf._getDefaultBuildVariant(compartment);
            }
            entryState = entry.getState(buildVariant);
        }
        return entryState;
    }

    void serialize() {
        String thisMethod = "serialize()";
        try {
            FileOutputStream out = new FileOutputStream(this.m_file);
            XMLWriter writer = new XMLWriter((OutputStream)out);
            this.serialize(writer);
            writer.serialize();
            out.close();
        }
        catch (Exception e) {
            String message = "Could not save  component sync-DB";
            throw new ChainedRuntimeException(message + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void save() throws ChainedRuntimeException {
        this.serialize();
    }

    public String getCompartmentFor(String name, String vendor) throws ChainedRuntimeException {
        String thisMethod = "getCompartmentFor(String name, String vendor)";
        LOCATION.debugT(thisMethod, "name: {0}, vendor: {1}", new Object[]{name, vendor});
        if (this.m_entries == null) {
            this.initialize();
        }
        return (String)this.m_index.get(this.keyOf(name, vendor));
    }

    public IDCSyncEntry getEntry(String name, String vendor) throws ChainedRuntimeException {
        if (this.m_entries == null) {
            this.initialize();
        }
        DCSyncEntry entry = null;
        String compartmentID = this.getCompartmentFor(name, vendor);
        if (compartmentID != null) {
            entry = this.getEntry(this.keyOf(compartmentID, name, vendor));
        }
        return entry;
    }

    public IDCSyncEntry getEntry(DevelopmentComponent component) {
        return this.getEntry(component.getName(), component.getVendor());
    }

    public IDCSyncEntry getEntry(IDevelopmentComponentRef ref) {
        return this._getEntry(ref);
    }

    public IDCSyncEntry getEntry(String compartmentID, String name, String vendor) {
        return this._getEntry(compartmentID, name, vendor);
    }

    public IDCSyncEntry getEntry(Compartment compartment, DevelopmentComponent component) {
        return this.getEntry(compartment.getName(), component.getName(), component.getVendor());
    }

    public IDCSyncEntry createEntry(String compartmentID, String name, String vendor) {
        if (this.m_entries == null) {
            this.initialize();
        }
        return this._createEntry(compartmentID, name, vendor);
    }

    public IDCSyncEntry createEntry(String compartmentID, String name, String vendor, SyncState state, SyncMode mode) {
        if (this.m_entries == null) {
            this.initialize();
        }
        DCSyncEntry entry = this._createEntry(compartmentID, name, vendor);
        entry.setMode(mode);
        entry.setState(state);
        return entry;
    }

    private DCSyncEntry createLocalEntry(String compartmentID, String name, String vendor) {
        DCSyncEntry entry = this._createEntry(compartmentID, name, vendor);
        entry.setIsLocallyInstalled(true);
        entry.setMode(SyncMode.LOCAL_ONLY);
        entry.setState(SyncState.INSTALLED);
        return entry;
    }

    private DCSyncEntry _createEntry(String compartmentID, String name, String vendor) {
        String key = this.keyOf(compartmentID, name, vendor);
        DCSyncEntry entry = this.getEntry(key);
        if (entry != null) {
            IllegalStateException ex = new IllegalStateException("Entry already exists.");
            LOCATION.throwing("_createEntry", (Throwable)ex);
            throw ex;
        }
        entry = new DCSyncEntry(this.m_deltaManager, true);
        this.m_entries.put(key, entry);
        this.addToIndex(compartmentID, name, vendor);
        return entry;
    }

    public IDCSyncEntry createEntry(Compartment compartment, DevelopmentComponent component) {
        return this.createEntry(compartment.getName(), component.getName(), component.getVendor());
    }

    public void removeEntry(String compartmentID, String name, String vendor) {
        if (this.m_entries == null) {
            this.initialize();
        }
        this.m_entries.remove(this.keyOf(compartmentID, name, vendor));
        this.removeFromIndex(compartmentID, name, vendor);
    }

    public void removeEntry(Compartment compartment, DevelopmentComponent component) {
        this.removeEntry(compartment.getName(), component.getName(), component.getVendor());
    }

    public Set getEntriesKeySet() {
        if (this.m_entries == null) {
            this.initialize();
        }
        return this.m_entries.keySet();
    }

    public Collection getEntries() {
        if (this.m_entries == null) {
            this.initialize();
        }
        return this.m_entries.values();
    }

    private void initialize() throws ChainedRuntimeException {
        String thisMethod = "initialize()";
        this.m_entries = new HashMap();
        FileInputStream in = null;
        this.m_index = new HashMap();
        try {
            Map compartments = this.m_configuration.getCompartments();
            if (this.m_file.exists() && this.m_file.length() > 0L) {
                LOCATION.debugT(thisMethod, "Reading component syncdb from file \"{0}\"", new Object[]{this.m_file});
                in = new FileInputStream(this.m_file);
                ParserAdapter parser = new ParserAdapter((Initializable)this);
                parser.parse((InputStream)in);
                if (compartments != null) {
                    Iterator iter = this.m_entries.keySet().iterator();
                    while (iter.hasNext()) {
                        String compartmentID;
                        Compartment compartment;
                        String key = (String)iter.next();
                        int n = key.indexOf(58);
                        if (n == -1 || (compartment = (Compartment)compartments.get(compartmentID = key.substring(0, n))) == null || !compartment.IsDefaultCompartment()) continue;
                        this.m_index.put(key.substring(n + 1), compartmentID);
                    }
                }
            } else {
                LOCATION.debugT(thisMethod, "No component syncdb file found. Starting from scratch.");
            }
        }
        catch (FileNotFoundException ex) {
            throw new ChainedRuntimeException("Cannot initialize component sync db: " + ex.getMessage(), (Throwable)ex);
        }
        catch (SAXException ex) {
            throw new ChainedRuntimeException("Cannot initialize component sync db: " + ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ChainedRuntimeException("Cannot initialize component sync db: " + ex.getMessage(), (Throwable)ex);
        }
        this.initializeLocalEntries();
    }

    public DevelopmentComponentRef getDCFromKey(String key) {
        DevelopmentComponentRef ref = null;
        int n = key.indexOf(58);
        int n2 = key.indexOf(58, n + 1);
        if (n != -1 && n2 != -1) {
            String compartmentName = key.substring(0, n);
            String dcName = key.substring(n + 1, n2);
            String dcVendor = key.substring(n2 + 1);
            ref = new DevelopmentComponentRef(dcName, dcVendor, compartmentName);
        }
        return ref;
    }

    public void removeEntriesForCompartment(String compartmentName) {
        if (this.m_entries == null) {
            this.initialize();
        }
        String prefix = compartmentName + ":";
        Iterator it = this.m_entries.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(prefix)) continue;
            it.remove();
            DevelopmentComponentRef ref = this.getDCFromKey(key);
            this.removeFromIndex(compartmentName, ref.getName(), ref.getVendor());
        }
    }

    private DCSyncEntry getEntry(String key) {
        return (DCSyncEntry)this.m_entries.get(key);
    }

    private void removeFromIndex(String compartmentID, String name, String vendor) {
        String id = this.getCompartmentFor(name, vendor);
        if (id != null && id.equals(compartmentID)) {
            this.m_index.remove(this.keyOf(name, vendor));
        }
    }

    private void addToIndex(String compartmentID, String name, String vendor) {
        Compartment compartment;
        Map compartments = this.m_configuration.getCompartments();
        if (compartments != null && (compartment = (Compartment)compartments.get(compartmentID)) != null && compartment.IsDefaultCompartment()) {
            this.m_index.put(this.keyOf(name, vendor), compartmentID);
        }
    }

    private String keyOf(String name, String vendor) {
        StringBuffer sb = new StringBuffer(name);
        sb.append(':').append(vendor);
        return sb.toString();
    }

    private String keyOf(String compartmentID, String name, String vendor) {
        StringBuffer sb = new StringBuffer(compartmentID.length() + name.length() + vendor.length() + 2);
        sb.append(compartmentID).append(':').append(name).append(':').append(vendor);
        return sb.toString();
    }

    protected void tagValue(char[] chars, int start, int length) {
        switch (this.state) {
            case 8: {
                this.parserEntryChild.tagValue(chars, start, length);
                return;
            }
        }
        super.tagValue(chars, start, length);
    }

    protected void startTag(String tagName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                if (tagName.equals(TAG_SYNCDB)) {
                    this.state = 3;
                    this.rootTag = tagName;
                    return;
                }
                throw new SAXException("root tag expected <dc-syncdb>");
            }
            case 3: {
                if (tagName.equals(TAG_ROOT)) {
                    this.state = 3;
                    return;
                }
                throw new SAXException(this.getMissingTagMessage(TAG_ROOT, this.rootTag));
            }
            case 4: {
                if (tagName.equals(TAG_CONFIG_NAME)) {
                    this.state = 4;
                    return;
                }
                throw new SAXException(this.getMissingTagMessage(TAG_CONFIG_NAME, this.rootTag));
            }
            case 6: {
                if (tagName.equals(TAG_ENTRY_KEY)) {
                    this.state = 6;
                    return;
                }
                throw new SAXException(this.getMissingTagMessage(TAG_ENTRY_KEY, TAG_ENTRY));
            }
            case 7: {
                if (tagName.equals("data")) {
                    this.state = 8;
                    this.parserEntryChild = new DCSyncEntry(this.m_deltaManager, false);
                    this.parserEntryChild.startTag(tagName, attributes);
                    return;
                }
                throw new SAXException(this.getMissingTagMessage("data", TAG_ENTRY));
            }
            case 8: {
                this.parserEntryChild.startTag(tagName, attributes);
                return;
            }
            case 5: {
                if (tagName.equals(TAG_ENTRY)) {
                    this.state = 6;
                    return;
                }
                throw new SAXException("Unexpected illegal tag <" + tagName + "> when expecting <" + TAG_ENTRY + ">  or </" + this.rootTag + ">");
            }
            case 9: {
                throw new SAXException("Unexpected illegal tag <" + tagName + "> when expecting closing </" + this.rootTag + ">");
            }
        }
        throw new SAXException("Internal Error: Unexpected state '" + this.state + "' while parsing syncdb");
    }

    protected boolean endTag(String tagName) throws SAXException {
        switch (this.state) {
            case 3: {
                if (tagName.equals(TAG_ROOT)) {
                    this.getStringValue();
                    this.state = 4;
                    return true;
                }
                throw new IllegalStateException("Closing tag <" + tagName + "> found when waituing for </" + TAG_ROOT + ">");
            }
            case 4: {
                if (tagName.equals(TAG_CONFIG_NAME)) {
                    String confname = this.getStringValue(true);
                    if (!this.m_configuration.getName().equals(confname)) {
                        throw new IllegalStateException("Syncdb belongs to different configuration. syncdb: " + confname + " current: " + this.m_configuration.getName());
                    }
                    this.state = 5;
                    return true;
                }
                throw new IllegalStateException("Closing tag <" + tagName + "> found when waituing for </" + TAG_CONFIG_NAME + ">");
            }
            case 6: {
                if (tagName.equals(TAG_ENTRY_KEY)) {
                    this.parserCurrentKey = this.getStringValue(true);
                    this.state = 7;
                    return false;
                }
                throw new SAXException("Unexpected closing tag <" + tagName + "> found when waiting for <" + TAG_ENTRY_KEY + ">");
            }
            case 8: {
                if (this.parserEntryChild.endTag(tagName)) {
                    return true;
                }
                this.state = 5;
                return true;
            }
            case 5: {
                if (tagName.equals(TAG_ENTRY)) {
                    this.m_entries.put(this.parserCurrentKey, this.parserEntryChild);
                    this.parserCurrentKey = null;
                    this.parserEntryChild = null;
                    return true;
                }
            }
            case 9: {
                if (tagName.equals(this.rootTag)) {
                    this.state = 9;
                    return false;
                }
                throw new SAXException("Unexpected closing tag </" + tagName + "> found when waiting for </" + this.rootTag + ">");
            }
        }
        throw new SAXException("Internal Error: Unexpected state '" + this.state + "' while parsing syncdb");
    }

    void serialize(XMLWriter writer) {
        if (this.m_entries == null) {
            this.initialize();
        }
        writer.beginDocument();
        writer.writeRootTag(TAG_SYNCDB);
        writer.writeTag(TAG_ROOT, this.m_file.getPath());
        writer.writeTag(TAG_CONFIG_NAME, this.m_configuration.getName());
        if (this.m_entries != null) {
            Iterator iter = this.m_entries.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                DCSyncEntry entry = (DCSyncEntry)this.m_entries.get(key);
                if (entry.isLocallyInstalled()) continue;
                writer.beginTag(TAG_ENTRY);
                writer.writeTag(TAG_ENTRY_KEY, key);
                entry.serialize(writer);
                writer.endTag(TAG_ENTRY);
            }
        }
        writer.endDocument();
    }

    public void assureLocalEntries() {
        if (this.m_entries != null) {
            this.initializeLocalEntries();
        }
    }

    private void initializeLocalEntries() throws ChainedRuntimeException, IllegalArgumentException {
        if (!this.m_localEntriesInitialized) {
            Map compartments = this.m_configuration.getCompartments();
            if (compartments != null) {
                Iterator it = compartments.values().iterator();
                while (it.hasNext()) {
                    Compartment compartment = (Compartment)it.next();
                    if (!compartment.hasLocalArchivesOnly()) continue;
                    this.initializeLocalEntries(compartment);
                }
            }
            this.m_localEntriesInitialized = true;
        }
    }

    private void initializeLocalEntries(Compartment compartment) throws ChainedRuntimeException, IllegalArgumentException {
        String thisMethod = "initializeLocalEntries()";
        if (this.m_devconf == null) {
            throw new IllegalStateException("INTERNAL ERROR: Cannot read list of components for local compartment. Development configuration instance (devconf) not initialized.");
        }
        try {
            List dcNodes = this.m_devconf.getTopLevelDCsForLocalCompartment(compartment);
            Iterator it = dcNodes.iterator();
            while (it.hasNext()) {
                IDevelopmentComponentNode node = (IDevelopmentComponentNode)it.next();
                String name = node.getName();
                String vendor = node.getVendor();
                String compartmentName = compartment.getName();
                if (this.getEntry(this.keyOf(compartmentName, name, vendor)) != null) continue;
                this.createLocalEntry(compartmentName, name, vendor);
            }
        }
        catch (DevConfigException e) {
            String msg = "Initializing DC syncDB for locally installed components failed for compartment \"" + compartment.getName() + "\"";
            throw new ChainedRuntimeException(msg, (Throwable)((Object)e));
        }
    }

    private DCSyncEntry _getEntry(IDevelopmentComponentRef ref) {
        return this._getEntry(ref.getCompartment(), ref.getName(), ref.getVendor());
    }

    private DCSyncEntry _getEntry(String compartmentID, String name, String vendor) {
        if (this.m_entries == null) {
            this.initialize();
        }
        return this.getEntry(this.keyOf(compartmentID, name, vendor));
    }

    public void retainEntriesFromCompartment(String compartmentName, Set valuesToRetain) {
        if (this.m_entries == null) {
            this.initialize();
        }
        Iterator entryIterator = this.m_entries.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(compartmentName) || valuesToRetain.contains(entry.getValue())) continue;
            entryIterator.remove();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

