/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl.cache;

import com.sap.tc.devconf.impl.DCProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class DCProxyMap {
    private Map m_map = new HashMap();

    DCProxyMap() {
    }

    public DCProxy get(String compartment, String vendor, String name) {
        return (DCProxy)this.m_map.get(this.getProxyMapKey(compartment, vendor, name));
    }

    public void put(DCProxy proxy) {
        this.m_map.put(this.getProxyMapKey(proxy.getCompartment().getName(), proxy.getVendor(), proxy.getName()), proxy);
    }

    public void remove(DCProxy proxy) {
        this.m_map.remove(this.getProxyMapKey(proxy.getCompartment().getName(), proxy.getVendor(), proxy.getName()));
    }

    public void remove(String compartment, String vendor, String name) {
        this.m_map.remove(this.getProxyMapKey(compartment, vendor, name));
    }

    public boolean contains(DCProxy proxy) {
        return this.m_map.values().contains(proxy);
    }

    public boolean contains(String compartment, String vendor, String name) {
        String key = this.getProxyMapKey(compartment, vendor, name);
        return this.m_map.keySet().contains(key);
    }

    public void removeAll(boolean invalidate) {
        if (invalidate) {
            ArrayList proxies = new ArrayList(this.m_map.values());
            this.m_map.clear();
            Iterator it = proxies.iterator();
            while (it.hasNext()) {
                DCProxy proxy = (DCProxy)it.next();
                if (!proxy.isValidInstance()) continue;
                proxy.invalidate();
            }
        }
    }

    public Iterator getDCIterator() {
        return this.m_map.values().iterator();
    }

    public Collection getDCs() {
        return this.m_map.values();
    }

    private String getProxyMapKey(String compartmentName, String dcVendor, String dcName) {
        return compartmentName + "|" + dcVendor + "|" + dcName;
    }
}

