/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl.cache;

import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.cache.DCProxyMap;
import com.sap.tc.logging.Location;
import java.util.Iterator;

public class DCProxyCache {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$cache$DCProxyCache == null ? (class$com$sap$tc$devconf$impl$cache$DCProxyCache = DCProxyCache.class$("com.sap.tc.devconf.impl.cache.DCProxyCache")) : class$com$sap$tc$devconf$impl$cache$DCProxyCache));
    public static final int CACHE_LOCAL = 0;
    public static final int CACHE_ACTIVE = 1;
    public static final int CACHE_INACTIVE = 2;
    public static final int NUMBER_CACHES = 3;
    private DCProxyMap m_localCache = new DCProxyMap();
    private DCProxyMap m_activeRemoteCache = new DCProxyMap();
    private DCProxyMap m_inactiveRemoteCache = new DCProxyMap();
    DCProxyMap[] m_caches = new DCProxyMap[]{this.m_localCache, this.m_activeRemoteCache, this.m_inactiveRemoteCache};
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$cache$DCProxyCache;

    public DCProxy getDCProxyLocal(String compartmentName, String dcVendor, String dcName) {
        return this.m_localCache.get(compartmentName, dcVendor, dcName);
    }

    public DCProxy getDCProxy(String compartmentName, String dcVendor, String dcName, boolean inactive) {
        DCProxy proxy = this.m_localCache.get(compartmentName, dcVendor, dcName);
        if (proxy != null && proxy.isRepresentingActiveState() == inactive) {
            proxy = null;
        }
        if (proxy == null) {
            proxy = inactive ? this.m_inactiveRemoteCache.get(compartmentName, dcVendor, dcName) : this.m_activeRemoteCache.get(compartmentName, dcVendor, dcName);
        }
        return proxy;
    }

    public DCProxy getDCProxyFromRemoteCache(String compartmentName, String dcVendor, String dcName, boolean inactive) {
        DCProxy proxy = inactive ? this.m_inactiveRemoteCache.get(compartmentName, dcVendor, dcName) : this.m_activeRemoteCache.get(compartmentName, dcVendor, dcName);
        return proxy;
    }

    public DCProxy getDCProxyLocalOrActiveOrInactive(String compartmentName, String dcVendor, String dcName) {
        DCProxy proxy = this.m_localCache.get(compartmentName, dcVendor, dcName);
        if (proxy == null) {
            proxy = this.m_activeRemoteCache.get(compartmentName, dcVendor, dcName);
        }
        if (proxy == null) {
            proxy = this.m_inactiveRemoteCache.get(compartmentName, dcVendor, dcName);
        }
        return proxy;
    }

    public DCProxy getDCProxyLocalOrActive(String compartmentName, String dcVendor, String dcName) {
        DCProxy proxy = this.m_localCache.get(compartmentName, dcVendor, dcName);
        if (proxy == null) {
            proxy = this.m_activeRemoteCache.get(compartmentName, dcVendor, dcName);
        }
        return proxy;
    }

    public void put(DCProxy proxy) {
        DCProxy inactiveProxy;
        DCProxy activeProxy;
        DCNodeSyncMode mode = proxy.getDCSyncMode();
        if (mode == DCNodeSyncMode.LOCAL_ONLY) {
            this.m_localCache.put(proxy);
            return;
        }
        if (proxy.isRepresentingActiveState()) {
            activeProxy = proxy;
            inactiveProxy = this.getDCProxy(proxy.getCompartment().getName(), proxy.getVendor(), proxy.getName(), true);
        } else {
            activeProxy = this.getDCProxy(proxy.getCompartment().getName(), proxy.getVendor(), proxy.getName(), false);
            inactiveProxy = proxy;
        }
        if (mode == DCNodeSyncMode.SYNCHED_AS_ACTIVE_SOURCE || mode == DCNodeSyncMode.SYNCHED_AS_ARCHIVE) {
            if (inactiveProxy != null) {
                this.ensureNotInLocalCache(inactiveProxy);
                this.m_inactiveRemoteCache.put(inactiveProxy);
            }
            if (activeProxy != null) {
                this.m_activeRemoteCache.remove(activeProxy);
                this.m_localCache.put(activeProxy);
            }
        } else if (mode == DCNodeSyncMode.SYNCHED_AS_INACTIVE_SOURCE) {
            if (activeProxy != null) {
                this.ensureNotInLocalCache(activeProxy);
                this.m_inactiveRemoteCache.put(activeProxy);
            }
            if (inactiveProxy != null) {
                this.m_inactiveRemoteCache.remove(inactiveProxy);
                this.m_localCache.put(inactiveProxy);
            }
        } else {
            this.m_localCache.remove(proxy);
            if (inactiveProxy != null) {
                this.m_inactiveRemoteCache.put(inactiveProxy);
            }
            if (activeProxy != null) {
                this.m_activeRemoteCache.put(activeProxy);
            }
        }
    }

    private void ensureNotInLocalCache(DCProxy proxy) {
        DCProxy cachedProxy;
        if (proxy != null && (cachedProxy = this.m_localCache.get(proxy.getCompartment().getName(), proxy.getVendor(), proxy.getName())) != null && cachedProxy.isRepresentingActiveState() == proxy.isRepresentingActiveState()) {
            this.m_localCache.remove(proxy);
        }
    }

    public void remove(String compartment, String vendor, String name, boolean inactive, boolean doInavlidate) {
        DCProxy proxy = this.m_localCache.get(compartment, vendor, name);
        if (proxy != null && proxy.isRepresentingActiveState() != inactive) {
            this.m_localCache.remove(proxy);
            if (doInavlidate) {
                proxy.invalidate();
            }
            return;
        }
        DCProxyMap cache = inactive ? this.m_inactiveRemoteCache : this.m_activeRemoteCache;
        proxy = cache.get(compartment, vendor, name);
        if (proxy != null) {
            cache.remove(proxy);
            if (doInavlidate) {
                proxy.invalidate();
            }
            return;
        }
    }

    public void clearCache(boolean doInvalidate) {
        int i = 0;
        while (i < 3) {
            this.clearCachePartition(i, doInvalidate);
            ++i;
        }
    }

    public void clearLocalCache(boolean doInvalidate) {
        this.clearCachePartition(0, doInvalidate);
    }

    public void clearRemoteActiveCache(boolean doInvalidate) {
        this.clearCachePartition(1, doInvalidate);
    }

    public void clearRemoteInactiveCache(boolean doInvalidate) {
        this.clearCachePartition(2, doInvalidate);
    }

    private void clearCachePartition(int partition, boolean doInvalidate) throws IllegalArgumentException {
        if (partition >= 3 || partition <= -1) {
            String m = "Internal error: Attempt to non-exsiting DC Proxy cache partition: " + partition;
            throw new IllegalArgumentException(m);
        }
        DCProxyMap cache = this.m_caches[partition];
        cache.removeAll(doInvalidate);
    }

    public void debugLogContent() {
        if (LOCATION.beLogged(100)) {
            DCProxy dc;
            String m = "\n local cache: ";
            Iterator iter = this.m_localCache.getDCs().iterator();
            while (iter.hasNext()) {
                dc = (DCProxy)iter.next();
                m = m + "\n      " + dc + ":" + (dc.isRepresentingActiveState() ? "active" : "inactive");
            }
            m = m + "\n\n active remote cache: ";
            iter = this.m_activeRemoteCache.getDCs().iterator();
            while (iter.hasNext()) {
                dc = (DCProxy)iter.next();
                m = m + "\n      " + dc + ":" + (dc.isRepresentingActiveState() ? "active" : "inactive");
            }
            m = m + "\n\n inactive remote cache: ";
            iter = this.m_inactiveRemoteCache.getDCs().iterator();
            while (iter.hasNext()) {
                dc = (DCProxy)iter.next();
                m = m + "\n      " + dc + ":" + (dc.isRepresentingActiveState() ? "active" : "inactive");
            }
            LOCATION.debugT("debugLogContent", "Cache Content: " + m);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

