/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Repository;
import com.sap.tc.devconf.CheckoutException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.NoRemoteFolderItemException;
import com.sap.tc.devconf.RemoteResourceNotAFileException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.ConfigUtils;
import com.sap.tc.devconf.impl.DTRClientErrorMapper;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.exceptions.ClientLibraryException;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.config.IBuildServer;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Set;

public class VFSHandler {
    private static Location LOCATION = Location.getLocation((String)"com.sap.tc.devconf.impl.VFSHandler");
    private IClient m_client;
    private IConfiguration m_configuration;
    DevelopmentConfiguration m_devconf;

    private VFSHandler() {
    }

    public VFSHandler(IConfiguration conf, IClient cd, DevelopmentConfiguration devconf) {
        this.m_configuration = conf;
        this.m_client = cd;
        this.m_devconf = devconf;
    }

    public IBuildServer findOrCreateBuildServer(String buildServerUrl) throws SyncException {
        String methodStr = "findOrCreateBuildServer(String)";
        LOCATION.debugT(methodStr, "buildServerUrl {0} ", new Object[]{buildServerUrl});
        ILogicalSystem system = this.m_client.getLogicalSystem();
        IBuildServer server = system.getBuildServer(buildServerUrl);
        if (server == null) {
            try {
                server = system.addBuildServer(buildServerUrl, null, null);
                this.saveConfigurationSettings();
            }
            catch (MalformedURLException e) {
                throw new SyncException("Adding repository server entry failed. Malformed URL: " + buildServerUrl + ":" + e.getMessage(), e, 15);
            }
            catch (IOException e) {
                throw new SyncException("Failed to save DTR client configuration. IOException: " + e.getMessage(), e, 100);
            }
        }
        return server;
    }

    public IBuildServer _findOrCreateBuildServer(String buildServerUrl) throws IOException {
        ILogicalSystem system;
        IBuildServer server;
        if (LOCATION.beLogged(100)) {
            String methodStr = "findOrCreateBuildServer(String)";
            LOCATION.debugT(methodStr, "buildServerUrl {0} ", new Object[]{buildServerUrl});
        }
        if ((server = (system = this.m_client.getLogicalSystem()).getBuildServer(buildServerUrl)) == null) {
            server = system.addBuildServer(buildServerUrl, null, null);
            this.saveConfigurationSettings();
        }
        return server;
    }

    public IBuildServer findBuildServer(String buildServerUrl) throws SyncException {
        if (LOCATION.beLogged(100)) {
            String methodStr = "findBuildServer(String)";
            LOCATION.debugT(methodStr, "buildServerUrl {0} ", new Object[]{buildServerUrl});
        }
        ILogicalSystem system = this.m_client.getLogicalSystem();
        IBuildServer server = system.getBuildServer(buildServerUrl);
        return server;
    }

    public IRepositoryServer findOrCreateRepositoryServer(Repository repository) throws SyncException {
        ConfigUtils cutil = new ConfigUtils();
        return cutil.findOrCreateRepositoryServer(this.m_configuration, this.m_client, repository, this.m_devconf.getConnectionContext());
    }

    public IMountPoint findOrCreateMountPoint(String mpID, IRepositoryServer server, String localDCroot, String remoteDCpath) throws SyncException {
        IMountPoint mp;
        String methodStr = "findOrCreateMountPoint(String, String, String, String)";
        LOCATION.debugT(methodStr, "mpID: {0}, serverName: {1}, localDCroot: {2}, remoteDCpath: {3}", new Object[]{mpID, server.getUrl(), localDCroot, remoteDCpath});
        try {
            mp = this.m_client.getMountPointForLocalPath(mpID);
            if (mp == null && (mp = this.m_client.createMountPoint(server, remoteDCpath, localDCroot)) != null) {
                this.saveConfigurationSettings();
            }
        }
        catch (IOException e) {
            throw new SyncException("Failed to save DTR configuration after creating mount point for local root " + localDCroot + " : " + e.getMessage(), e, 28);
        }
        return mp;
    }

    public void checkRemotePath(IRepositoryServer server, String path) throws SyncException {
        String methodStr = "checkRemotePath(RepositoryServer, String)";
        LOCATION.debugT(methodStr, "server: {0}, path: {1}", new Object[]{server, path});
        String url = Util.concatenatePath((String)server.getUrl(), (String)path, (char)'/');
        try {
            if (null == this.getFolderItemByURL(url)) {
                String msg = "check failed for remote path in DTR for URL: " + url + "(DTR client returns null)";
                throw new SyncException(msg, null, 113);
            }
        }
        catch (VfsException e) {
            String msg = "Repository server access error for  \"" + url + "\"";
            throw DTRClientErrorMapper.toSyncException(msg, (ClientLibraryException)e);
        }
    }

    public IVfsFolderItem getFolderItemForLocalPath(String path) throws VfsException {
        String methodStr = "getFolderItemForLocalPath(String)";
        LOCATION.debugT(methodStr, "Determine folder item for local path " + path);
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
        return manager.getFolderItem(path);
    }

    public void syncLocalPath(String path) throws SyncException {
        this.syncLocalPath(path, false);
    }

    public void syncLocalPath(String path, boolean forcedSync) throws SyncException {
        block5: {
            String methodStr = "syncLocalPath(String)";
            LOCATION.debugT(methodStr, "Syncronize local path " + path);
            try {
                IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
                IVfsFolderItem folderItem = manager.getFolderItem(path);
                if (folderItem != null) {
                    if (!forcedSync) {
                        folderItem.sync();
                    } else {
                        folderItem.syncForce();
                    }
                    break block5;
                }
                throw new SyncException("Unable to sync local path \"" + path + "\" from DTR. DTR client layer cannot locate the resource on the server. (VFS returned null as folder Item)", null, 113);
            }
            catch (VfsException e) {
                throw DTRClientErrorMapper.toSyncException("Unable to sync file or folder.", (ClientLibraryException)e);
            }
        }
    }

    public void removeLocalPath(String path) throws SyncException {
        String methodStr = "removeLocalPath(String)";
        LOCATION.debugT(methodStr, "Remove local path " + path);
        IVfsFolderItem folderItem = null;
        try {
            IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
            folderItem = manager.getFolderItem(path);
        }
        catch (VfsException e) {
            String msg = "Unable to remove local file or folder. Error when asking for folder item  \"" + path + "\"";
            throw DTRClientErrorMapper.toSyncException(msg, (ClientLibraryException)e);
        }
        if (folderItem == null) {
            LOCATION.infoT(methodStr, "could not get folder item for \"" + path + "\" (IVfsFolderItem is null).Ignoring.");
        } else {
            try {
                folderItem.removeFromClient();
            }
            catch (VfsException e) {
                String msg = "Unable to file or folder \"" + path + "\" from client.";
                throw DTRClientErrorMapper.toSyncException(msg, (ClientLibraryException)e);
            }
        }
    }

    boolean isItemDeletedOnServer(String path) throws SyncException {
        boolean isDeleted = false;
        try {
            IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
            IVfsFolderItem folderItem = manager.getFolderItem(path);
            if (folderItem != null) {
                isDeleted = this.isDeletedOnServer(folderItem);
            }
        }
        catch (VfsException e) {
            String msg = "Unable to check if file \"" + path + "\" is deleted on server (DTR client error).";
            throw DTRClientErrorMapper.toSyncException(msg, (ClientLibraryException)e);
        }
        return isDeleted;
    }

    private boolean isDeletedOnServer(IVfsFolderItem folderItem) throws VfsException {
        boolean deleted = false;
        IVfsActivityRecordedFolderItem arfItem = folderItem.asActivityRecordedFolderItem();
        if (arfItem == null) {
            String msg = "VFS Error. Unable to get IVfsActivityRecordedFolderItem for  \"" + folderItem.getLocalPath() + "\"";
            throw new IllegalStateException(msg);
        }
        if (arfItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT && arfItem.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
            arfItem.refreshAndGetVersion();
            IVfsVersion v = arfItem.getActiveVersion();
            deleted = v == null || v.isDeleted();
        }
        return deleted;
    }

    boolean isItemLocalOnly(String path) throws SyncException {
        String methodStr = "isItemLocalOnly(String)";
        IVfsFolderItem folderItem = null;
        boolean isLocalOnly = false;
        try {
            IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
            folderItem = manager.getFolderItem(path);
        }
        catch (VfsException e) {
            String msg = "Unable to determine sync state of file. Failed to get folder item  for \"" + path + "\"";
            throw DTRClientErrorMapper.toSyncException(msg, (ClientLibraryException)e);
        }
        if (folderItem != null) {
            isLocalOnly = this.isItemLocalOnly(folderItem);
        }
        return isLocalOnly;
    }

    boolean isItemLocalOnly(IVfsFolderItem folderItem) throws SyncException {
        IVfsFile vfsFile;
        boolean localOnly = folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY;
        VfsFolderItemActivityState actState = folderItem.asActivityRecordedFolderItem().getActivityState();
        boolean bl = localOnly = localOnly && actState == VfsFolderItemActivityState.NOT_CHECKED_OUT;
        if (localOnly && (vfsFile = folderItem.asFile()) != null) {
            localOnly = !vfsFile.hasLocalRemoteNameClash();
        }
        return localOnly;
    }

    public IVfsActivity createAndCheckoutFolders(IVfsActivity activity, String[] paths, Set addedItems) throws CheckoutException {
        String methodStr = "createAndCheckoutFolders(IVfsActivity, String[])";
        LOCATION.debugT(methodStr, "activity: {0}, paths: {1}", new Object[]{activity, paths});
        try {
            IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
            int i = 0;
            i = 0;
            while (i < paths.length) {
                IVfsActivityRecordedFolderItem arfItem;
                IVfsFolderItem folderItem;
                File file = new File(paths[i]);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if ((folderItem = manager.getFolderItem(paths[i])) != null && folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && (arfItem = folderItem.asActivityRecordedFolderItem()) != null) {
                    if (activity == null) {
                        activity = arfItem.getWorkspace().getDefaultActivity();
                    }
                    try {
                        arfItem.createAndCheckout(activity);
                        addedItems.add(arfItem);
                    }
                    catch (VfsException e) {
                        throw new CheckoutException("Unable to checkout folder.DTR client error: " + e.getMessage(), e, 1, paths[i]);
                    }
                }
                ++i;
            }
        }
        catch (VfsException e) {
            throw new CheckoutException("Unable to create and checkout resources. DTR client error: " + e.getMessage(), e, 5);
        }
        return activity;
    }

    public IVfsActivity addNewFilesToActivity(IVfsActivity activity, String[] filePaths, Set addedItems) throws SyncException {
        try {
            IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
            int i = 0;
            while (i < filePaths.length) {
                IVfsActivityRecordedFolderItem arfItem;
                IVfsFolderItem folderItem;
                File file = new File(filePaths[i]);
                if (file.exists() && (folderItem = manager.getFolderItem(filePaths[i])) != null && folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY && (arfItem = folderItem.asActivityRecordedFolderItem()) != null) {
                    if (activity == null) {
                        activity = arfItem.getWorkspace().getDefaultActivity();
                        addedItems.add(arfItem);
                    }
                    arfItem.createAndCheckout(activity);
                    addedItems.add(arfItem);
                }
                ++i;
            }
        }
        catch (VfsException e) {
            throw DTRClientErrorMapper.toSyncException("Adding files to activity failed with DTR client error: " + e.getMessage(), (ClientLibraryException)e);
        }
        return activity;
    }

    public void revertFilesFromActivity(Set itemsToRevert) throws VfsException {
        Iterator items = itemsToRevert.iterator();
        while (items.hasNext()) {
            IVfsActivityRecordedFolderItem item = (IVfsActivityRecordedFolderItem)items.next();
            if (item.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) continue;
            item.uncheckout();
        }
    }

    /*
     * Unable to fully structure code
     */
    public IVfsActivity checkoutFiles(IVfsActivity activity, String[] filePaths, Set addedItems) throws CheckoutException {
        methodStr = "checkoutFiles(IVfsActivity, String[])";
        VFSHandler.LOCATION.debugT(methodStr, "activity: {0}, file paths: {1}", new Object[]{activity, filePaths});
        try {
            manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
            i = 0;
            i = 0;
            while (i < filePaths.length) {
                file = new File(filePaths[i]);
                if (file.exists() && (folderItem = manager.getFolderItem(filePaths[i])) != null && (arfItem = folderItem.asActivityRecordedFolderItem()) != null) {
                    if (arfItem.getActivityState() == VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                        if (activity == null) {
                            activity = arfItem.getWorkspace().getDefaultActivity();
                        }
                        try {
                            arfItem.checkOutForEdit(activity);
                            if (addedItems == null) ** GOTO lbl25
                            addedItems.add(arfItem);
                        }
                        catch (VfsException e) {
                            msg = "Unable to checkout file.";
                            throw new CheckoutException(msg + ": " + e.getMessage(), e, 1, filePaths[i]);
                        }
                    } else if (arfItem.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                        throw new CheckoutException("Cannot checkout file. File already checked out for delete!", null, 2, filePaths[i]);
                    }
                }
lbl25:
                // 6 sources

                ++i;
            }
        }
        catch (VfsException e) {
            throw new CheckoutException("Checkout failed with DTR client error: " + e.getMessage(), e, 0);
        }
        return activity;
    }

    public IVfsWorkspace findWorkspace(String absremotepath) throws SyncException {
        IVersionedFileSystemManager manager;
        String methodStr = "findWorkspace(String)";
        LOCATION.debugT(methodStr, "absremotepath: {0}", new Object[]{absremotepath});
        try {
            manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
        }
        catch (VfsException e) {
            throw new SyncException("DTR client error. Could not get VFS manager : " + e.getMessage(), e);
        }
        IVfsWorkspace[] workspaces = manager.getWorkspaces();
        int numofws = workspaces.length;
        int i = 0;
        while (i < numofws) {
            IVfsWorkspace workspace = workspaces[i];
            if (workspace.getAbsoluteRemotePath().equals(absremotepath)) {
                return workspaces[i];
            }
            ++i;
        }
        return null;
    }

    public String getConfigurationInfo() {
        StringBuffer sb = new StringBuffer();
        String nl = System.getProperty("line.separator");
        if (nl.equals("")) {
            nl = "\r\n";
        }
        IVfsContext context = this.m_client.getContext();
        String[] s = context.getAbsoluteLocalPathsOfMountPoints();
        int i = 0;
        while (i < s.length) {
            sb.append("AbsoluteLocalPathsOfMountPoints: ").append(s[i]);
            sb.append(nl);
            ++i;
        }
        sb.append("VFS client active context: ").append(nl);
        sb.append("  client def name: ").append(this.m_client.getName()).append(nl);
        sb.append("  absolute local root: ");
        sb.append(this.m_client.getAbsoluteLocalRoot()).append(nl);
        Iterator it = this.m_client.mountPoints();
        while (it.hasNext()) {
            sb.append("  Mount Point(s): ").append(nl);
            IMountPoint mp = (IMountPoint)it.next();
            sb.append("    mount point relative local root: ");
            sb.append(mp.getRelativeLocalRoot()).append(nl);
            sb.append("    mount point relative remote root: ");
            sb.append(mp.getRelativeRemoteRoot()).append(nl);
            sb.append("    Related Repository Server:").append(nl);
            IRepositoryServer r = mp.getRepositoryServer();
            if (r == null) continue;
            sb.append("      absolute remote roor: ");
            sb.append(r.getAbsoluteRemoteRoot()).append(nl);
            sb.append("      connection template ID: ");
            sb.append(r.getConnectionTemplateId()).append(nl);
            sb.append("      URL: ").append(r.getUrl()).append(nl);
            sb.append(nl);
        }
        return sb.toString();
    }

    public boolean checkFileInVfsFolder(IVfsGenericFolder folder, String fileName) throws VfsException {
        IVfsFolderItem item;
        String browsePath;
        String methodStr = "checkFileInVfsFolder(IVfsGenericFolder, String)";
        LOCATION.debugT(methodStr, "folder: {0}, fileName {1}", new Object[]{folder, fileName});
        IVfsContext context = this.m_client.getContext();
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
        String urlString = Util.concatenatePath((String)folder.getUrl(), (String)fileName, (char)'/');
        IVfsRemoteLocator remoteLocator = context.getRemoteLocatorFromUrl(urlString);
        if (remoteLocator != null && (browsePath = manager.getCurrentContext().getBrowsePath(remoteLocator)) != null && (item = manager.getFolderItemByBrowsePath(browsePath)) != null) {
            return item.asFile() != null;
        }
        return false;
    }

    public InputStream getFileStreamForURL(String urlString) throws VfsException, DevConfigException {
        String methodStr = "getFileStreamFromVfsFolder(String)";
        LOCATION.debugT(methodStr, "url: {0}", new Object[]{urlString});
        IVfsContext context = this.m_client.getContext();
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
        IVfsRemoteLocator remoteLocator = context.getRemoteLocatorFromUrl(urlString);
        if (remoteLocator != null) {
            String browsePath = manager.getCurrentContext().getBrowsePath(remoteLocator);
            if (browsePath != null) {
                IVfsFolderItem item = manager.getFolderItemByBrowsePath(browsePath);
                if (item != null) {
                    IVfsFile file = item.asFile();
                    if (file != null) {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        file.temporaryGetContent((OutputStream)os);
                        return new ByteArrayInputStream(os.toByteArray());
                    }
                    String msg = "could not get VFS File from DTR client for browse path: " + browsePath + "(url: " + urlString + ")";
                    throw new RemoteResourceNotAFileException(msg, urlString);
                }
                String msg = "could not get folder item from DTR client for :" + browsePath;
                throw new NoRemoteFolderItemException(msg, urlString);
            }
            String msg = "could not get browse path from DTR client for locator :" + remoteLocator;
            throw new DevConfigException(msg);
        }
        String msg = "could not get remote locator from DTR client for :" + urlString;
        throw new DevConfigException(msg);
    }

    public InputStream getFileStreamFromVfsFolder(IVfsGenericFolder folder, String fileName) throws VfsException, DevConfigException {
        String methodStr = "getFileStreamFromVfsFolder(IVfsGenericFolder, String)";
        LOCATION.debugT(methodStr, "folder: {0}, fileName {1}", new Object[]{folder, fileName});
        IVfsContext context = this.m_client.getContext();
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
        String urlString = folder.getUrl() + fileName;
        IVfsRemoteLocator remoteLocator = context.getRemoteLocatorFromUrl(urlString);
        if (remoteLocator != null) {
            String browsePath = manager.getCurrentContext().getBrowsePath(remoteLocator);
            if (browsePath != null) {
                IVfsFolderItem item = manager.getFolderItemByBrowsePath(browsePath);
                if (item != null) {
                    IVfsFile file = item.asFile();
                    if (file != null) {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        file.temporaryGetContent((OutputStream)os);
                        return new ByteArrayInputStream(os.toByteArray());
                    }
                    String msg = "could not get VFS File from DTR client for :" + browsePath;
                    throw new DevConfigException(msg);
                }
                String msg = "could not get folder item from DTR client for :" + browsePath;
                throw new DevConfigException(msg);
            }
            String msg = "could not get browse path from DTR client for locator :" + remoteLocator;
            throw new DevConfigException(msg);
        }
        String msg = "could not get remote locator from DTR client for :" + urlString;
        throw new DevConfigException(msg);
    }

    public IVfsFolder getSubFolder(IVfsFolder parentFolder, String subFolderName) throws VfsException {
        parentFolder.refreshFolderItems();
        IVfsFolderItem[] items = parentFolder.getFolderItems();
        int i = 0;
        while (i < items.length) {
            IVfsFolderItem item = items[i];
            if (item.getName().equals(subFolderName)) {
                return item.asFolder();
            }
            ++i;
        }
        return null;
    }

    public IVfsFolder getSubFolderFromVfsFolder(IVfsGenericFolder parentFolder, String folderName) throws VfsException, DevConfigException {
        String methodStr = "getSubFolderFromVfsFolder(IVfsGenericFolder, String)";
        LOCATION.debugT(methodStr, "folder: {0}, folderName {1}", new Object[]{parentFolder, folderName});
        IVfsContext context = this.m_client.getContext();
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
        String urlString = parentFolder.getUrl() + folderName;
        IVfsRemoteLocator remoteLocator = context.getRemoteLocatorFromUrl(urlString);
        if (remoteLocator == null) {
            throw new DevConfigException("Could not get remote locator (DTR client returned null) for URL :" + urlString);
        }
        String browsePath = manager.getCurrentContext().getBrowsePath(remoteLocator);
        if (browsePath == null) {
            throw new DevConfigException("Could not get browse path (DTR client returned null) for remoteLocator :" + remoteLocator);
        }
        IVfsFolderItem item = manager.getFolderItemByBrowsePath(browsePath);
        if (item == null) {
            throw new NoRemoteFolderItemException("Could not get VFS folder item (DTR client returned null) for browsePath :" + browsePath, urlString);
        }
        return item.asFolder();
    }

    public IVfsWorkspace getWorkspaceByUrl(String wsURL) throws VfsException {
        String methodStr = "getWorkspaceByUrl(String)";
        LOCATION.debugT(methodStr, "wsURL: {0}", new Object[]{wsURL});
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)this.m_client.getContext());
        return manager.getWorkspaceByUrl(wsURL);
    }

    public void saveConfigurationSettings() throws IOException {
        this.m_configuration.saveAll();
    }

    public IVfsFolderItem getFolderItemByURL(String urlString) throws VfsException {
        String browsePath;
        IVfsContext context = this.m_client.getContext();
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
        IVfsRemoteLocator remoteLocator = context.getRemoteLocatorFromUrl(urlString);
        if (remoteLocator != null && (browsePath = context.getBrowsePath(remoteLocator)) != null) {
            return manager.getFolderItemByBrowsePath(browsePath);
        }
        return null;
    }

    public void removeMountPointForLocalPath(String localPath) throws VfsException, IOException {
        IMountPoint mp = null;
        mp = this.m_client.getMountPointForLocalPath(localPath);
        if (mp != null) {
            this.removeMountPoint(mp);
        }
    }

    public void removeMountPoint(IMountPoint mp) throws VfsException, IOException {
        IMountPoint[] mparray = new IMountPoint[]{mp};
        this.m_client.deleteMountPoints(mparray);
        this.saveConfigurationSettings();
    }

    public void removeMountPoints(IMountPoint[] mparray) throws VfsException, IOException {
        this.m_client.deleteMountPoints(mparray);
        this.saveConfigurationSettings();
    }

    public boolean isSomethingCheckedOutUnderLocalPath(String localPath) throws VfsException {
        IVfsContext context = this.m_client.getContext();
        IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
        IVfsFolderItem folderItem = manager.getFolderItem(localPath);
        if (folderItem != null && folderItem.asFolder() != null) {
            return manager.isSomethingCheckedOutUnderFolder(folderItem.asFolder());
        }
        return false;
    }
}

