/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SourceUnpacker {
    private static final String SOURCE_FOLDER = "src/";
    private static final String SOURCE_ARCHIVE_FILE_NAME = "src.zip";
    private static final String SOURCE_ARCHIVE_NAME = "/src.zip";
    private static final int MIN_NAME_LENGTH = "/src.zip".length() + "src/".length() + 1;
    private static final char SEPARATOR_ZIP = '/';
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$SourceUnpacker == null ? (class$com$sap$tc$devconf$impl$SourceUnpacker = SourceUnpacker.class$("com.sap.tc.devconf.impl.SourceUnpacker")) : class$com$sap$tc$devconf$impl$SourceUnpacker));
    private static final int BUF_SIZE = 8192;
    private byte[] buf = new byte[8192];
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$SourceUnpacker;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File[] unzipSourceArchives(File archiveFile, File targetFolder) throws IOException {
        ArrayList<File> filesWritten;
        long bytesWritten;
        String thisMethod;
        block8: {
            thisMethod = "unzipSourceArchives";
            LOCATION.debugT(thisMethod, "unpack sources from \"{0}\" to  folder \"{1}\"", new Object[]{archiveFile, targetFolder});
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(archiveFile));
            bytesWritten = 0L;
            filesWritten = new ArrayList<File>();
            try {
                ZipEntry entry = null;
                block2: while (true) {
                    String technologyName;
                    int nextSeparatorPos;
                    int posSuffix;
                    String name;
                    if ((entry = zipStream.getNextEntry()) == null) {
                        Object var21_18 = null;
                        if (zipStream == null) break block8;
                        break;
                    }
                    if (entry.isDirectory() || (name = entry.getName()).length() < MIN_NAME_LENGTH || !name.startsWith(SOURCE_FOLDER) || (posSuffix = name.lastIndexOf(SOURCE_ARCHIVE_NAME)) != name.length() - SOURCE_ARCHIVE_NAME.length() || (nextSeparatorPos = name.indexOf(47, SOURCE_FOLDER.length())) != posSuffix || (technologyName = name.substring(SOURCE_FOLDER.length(), posSuffix)).length() == 0) continue;
                    LOCATION.debugT(thisMethod, "found source archive \"{0}\"", new Object[]{name});
                    String unpackTargetFolderName = targetFolder.getCanonicalPath() + File.separator + technologyName;
                    File unpackTargetFolder = new File(unpackTargetFolderName);
                    if (!unpackTargetFolder.exists()) {
                        unpackTargetFolder.mkdirs();
                    }
                    File targetFile = new File(unpackTargetFolderName + File.separator + SOURCE_ARCHIVE_FILE_NAME);
                    FileOutputStream dest = new FileOutputStream(targetFile);
                    long bytesWrittenforFile = 0L;
                    int cnt = -1;
                    while (true) {
                        if ((cnt = zipStream.read(this.buf)) <= 0) {
                            dest.close();
                            filesWritten.add(targetFile);
                            bytesWritten += bytesWrittenforFile;
                            LOCATION.debugT(thisMethod, "{0} bytes written to \"{1}\"", new Object[]{new Long(bytesWrittenforFile), targetFile});
                            continue block2;
                        }
                        dest.write(this.buf, 0, cnt);
                        bytesWrittenforFile += (long)cnt;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var21_19 = null;
                if (zipStream != null) {
                    zipStream.close();
                }
                throw throwable;
            }
            zipStream.close();
        }
        LOCATION.debugT(thisMethod, "Total of {0} bytes written to {1} files.", new Object[]{new Long(bytesWritten), new Integer(filesWritten.size())});
        return filesWritten.toArray(new File[filesWritten.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

