/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IDCRef;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.SoftwareComponent;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.ISoftwareComponentNode;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.NoSourceStateException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DevConfFileSystemLayout;
import com.sap.tc.devconf.impl.DevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.NameVendorPair;
import com.sap.tc.devconf.impl.RepositoryLayout;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.List;

class SoftwareComponentNode
implements ISoftwareComponentNode {
    private static final Location LOCATION = Location.getLocation((String)"com.sap.tc.devconf.impl.ISoftwareComponentNode");
    private DevelopmentConfiguration m_configuration;
    private Compartment m_compartmentObj;
    private boolean m_isActive;
    private SoftwareComponent m_softwareComponent;
    private List m_children;

    private SoftwareComponentNode() {
    }

    public SoftwareComponentNode(DevelopmentConfiguration devConf, Compartment compartmentObj, boolean isActive) throws DevConfigException {
        if (!isActive && !compartmentObj.hasInactiveSourceState()) {
            String message = "inactive SC Node requested for compartment that has no inactive source. Compartment: '" + compartmentObj.getName() + "'";
            throw new NoSourceStateException(message, compartmentObj.getName());
        }
        this.m_configuration = devConf;
        this.m_compartmentObj = compartmentObj;
        this.m_isActive = isActive;
    }

    public SoftwareComponent getSoftwareComponent() throws RepositoryAccessException, InvalidDefinitionException {
        LOCATION.infoT("getSoftwareComponent", "deprecated method called. SC objects no longer exist, returning null");
        return null;
    }

    public List getChildren() throws RepositoryAccessException {
        String methodStr = "getChildren()";
        LOCATION.debugT(methodStr, "getting children of scNode " + this);
        if (this.m_children != null) {
            return this.m_children;
        }
        if (this.m_configuration.isDTRAccessDisabledForSC(this.m_compartmentObj)) {
            LOCATION.debugT(methodStr, "Creation of non-local components was disabled for compartment \"{0}\" Returning empty List.", new Object[]{this.m_compartmentObj.getName()});
            this.m_children = new ArrayList();
            return this.m_children;
        }
        if (this.m_compartmentObj.hasLocalArchivesOnly()) {
            try {
                this.m_children = this.getChildrenForLocalArchiveCompartment();
                return this.m_children;
            }
            catch (DevConfigException e) {
                String msg = "Cannot load preinstalled components from file system. (compartment: \"" + this.m_compartmentObj.getName() + "\")";
                throw new RepositoryAccessException(msg, (Throwable)((Object)e));
            }
        }
        if (this.m_configuration.isLocalOnlyMode()) {
            LOCATION.debugT(methodStr, "Configuration is in local only mode: returning empty node list for active SC node of compartment \"{0}\".", new Object[]{this.m_compartmentObj.getName()});
            this.m_children = new ArrayList();
            return this.m_children;
        }
        if (this.m_isActive && !this.m_compartmentObj.isLocal() && this.m_configuration.isWithBuildServer() && !this.m_compartmentObj.hasSourceState()) {
            this.m_children = this.getChildrenFromBuildServer();
            this.updateDCNodesArchiveSyncState(this.m_children);
            return this.m_children;
        }
        if (this.m_compartmentObj.hasSourceState()) {
            this.m_children = this.getChildrenFromDTR();
            if (this.m_isActive && this.m_configuration.isWithBuildServer()) {
                this.updateDCNodesArchiveSyncState(this.m_children);
            }
            return this.m_children;
        }
        LOCATION.debugT(methodStr, "No archive state and no source state configured for compartment " + this.m_compartmentObj.getName() + " of configuration " + this.m_configuration.getName() + ": returning empty node list");
        this.m_children = new ArrayList();
        return this.m_children;
    }

    public void refresh() {
        LOCATION.debugT("refresh", "resetting SC node information");
        this.m_softwareComponent = null;
        this.m_children = null;
    }

    DevelopmentConfiguration getDevelopmentConfiguration() {
        return this.m_configuration;
    }

    String getCompartmentID() {
        return this.m_compartmentObj.getName();
    }

    IVfsGenericFolder getWorkspaceFolder() throws RepositoryAccessException {
        IVfsGenericFolder folder = null;
        try {
            IVfsWorkspace ws = this.m_configuration.getWorkspaceFromCompartmentID(this.m_compartmentObj.getName(), this.m_isActive);
            if (ws != null) {
                folder = ws.asGenericFolder();
            }
        }
        catch (DevConfigException e) {
            String msg = "Cannot get DTR workspace object for " + (this.m_isActive ? "active" : "inactive") + " source code in compartment  " + this.m_compartmentObj.getName();
            throw new RepositoryAccessException(msg, (Throwable)((Object)e));
        }
        return folder;
    }

    boolean getIsActive() {
        return this.m_isActive;
    }

    public boolean modificationAllowed() {
        if (!this.m_compartmentObj.isModificationAllowed()) {
            return false;
        }
        if (this.m_compartmentObj.isLocal()) {
            return true;
        }
        return !this.m_isActive || this.m_compartmentObj.getSourceState().isLocationChangeable();
    }

    public String toString() {
        return super.toString() + " ( compartment " + this.m_compartmentObj.getName() + ", " + (this.m_isActive ? "active" : "inactive");
    }

    public boolean isLocal() {
        return this.m_compartmentObj.isLocal();
    }

    private VFSHandler vfsHandler() {
        return this.m_configuration.getVFSHandler();
    }

    List getChildrenFromDTR() throws RepositoryAccessException {
        String methodStr = "getChildrenFromDTR()";
        LOCATION.debugT(methodStr, "trying to get SC children from DTR");
        ArrayList<DevelopmentComponentNode> list = new ArrayList<DevelopmentComponentNode>();
        try {
            LOCATION.debugT(methodStr, "getting SC root folder");
            RepositoryLayout rLayout = new RepositoryLayout();
            String topLevelSCsRemotePath = rLayout.calculateRemoteSCRoot(this.m_compartmentObj.getScVendor(), this.m_compartmentObj.getScName()) + "TopLevelDCs";
            String url = Util.concatenatePath((String)this.getWorkspaceFolder().getUrl(), (String)topLevelSCsRemotePath, (char)'/');
            IVfsFolderItem topLevelDcsFolderItem = this.vfsHandler().getFolderItemByURL(url);
            if (topLevelDcsFolderItem != null) {
                IVfsFolder topLevelDcsFolder = topLevelDcsFolderItem.asFolder();
                topLevelDcsFolder.refreshFolderItems();
                LOCATION.debugT(methodStr, "getting items of top-level folder");
                IVfsFolderItem[] items = topLevelDcsFolder.getFolderItems();
                if (items == null) {
                    LOCATION.debugT(methodStr, "folder items: null object returned by VFS");
                } else {
                    LOCATION.debugT(methodStr, "folder items found: {0}", new Object[]{new Integer(items.length)});
                    int i = 0;
                    while (i < items.length) {
                        String name = items[i].getDisplayName();
                        NameVendorPair dcref = DevConfFileSystemLayout.parseDCRefFilename(name);
                        if (dcref != null) {
                            LOCATION.debugT("creating node for DC " + dcref);
                            DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_configuration, this.m_compartmentObj.getName(), dcref.vendor, dcref.name, this.m_isActive);
                            list.add(node);
                        }
                        ++i;
                    }
                }
            } else {
                LOCATION.infoT(methodStr, "Could not get folder item from DTR client layer for URL {0}", new Object[]{url});
            }
        }
        catch (VfsException e) {
            String msg = "DTR client error: " + e.getMessage();
            throw new RepositoryAccessException(msg, e);
        }
        return list;
    }

    List getChildrenFromBuildServer() throws RepositoryAccessException {
        IDCRef[] dcList;
        String methodStr = "getChildrenFromBuildServer()";
        LOCATION.debugT(methodStr, "trying to get SC children from build server");
        ArrayList<DevelopmentComponentNode> list = new ArrayList<DevelopmentComponentNode>();
        try {
            IBuildSpace buildSpace = this.m_configuration._getBuildSpaceProxy();
            dcList = buildSpace.listToplevelDCs(this.m_compartmentObj.getName());
        }
        catch (CommunicationException e) {
            String msg = "Could not read top level DCs from build server: " + e.getMessage();
            throw new RepositoryAccessException(msg, e);
        }
        catch (CBSServerException e) {
            String msg = "Could not read top level DCs from build server: " + e.getMessage();
            throw new RepositoryAccessException(msg, e);
        }
        catch (DevConfigException e) {
            String msg = "Could not read top level DCs from build server: " + ((Throwable)((Object)e)).getMessage();
            throw new RepositoryAccessException(msg, (Throwable)((Object)e));
        }
        int k = 0;
        while (k < dcList.length) {
            IDCRef dc = dcList[k];
            DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_configuration, this.m_compartmentObj.getName(), dc.getVendor(), dc.getName(), this.m_isActive);
            list.add(node);
            ++k;
        }
        return list;
    }

    List getChildrenForLocalArchiveCompartment() throws DevConfigException {
        ArrayList list;
        String methodStr = "getChildrenForLocalArchiveCompartment";
        if (this.m_isActive) {
            list = this.m_configuration.getTopLevelDCsForLocalCompartment(this.m_compartmentObj);
        } else {
            LOCATION.debugT(methodStr, "Compartment {1} of configuration {0} is configured as local: returning empty cildren list for inactive state", new Object[]{this.m_configuration.getName(), this.m_compartmentObj.getName()});
            list = new ArrayList();
        }
        return list;
    }

    private void updateDCNodesArchiveSyncState(List nodes) {
        String thisMethod = "updateChildArchiveSyncState";
        try {
            this.m_configuration.refreshSyncStateOfNodesSynchedAsArchives(this.m_compartmentObj.getName(), nodes);
        }
        catch (SyncException e) {
            LOCATION.traceThrowableT(300, thisMethod, "Could not update synch state of child nodes of " + this, (Throwable)((Object)e));
            String m = "Could not update synch state of child nodes. Error: " + ((Throwable)((Object)e)).getMessage();
            DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_configuration, this.m_compartmentObj.getName(), this.m_compartmentObj.getScVendor(), "SC " + this.m_compartmentObj.getScName(), this.m_isActive);
            this.m_configuration.sendDCMessage(node, "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, m);
        }
        catch (DevConfigException e) {
            LOCATION.traceThrowableT(300, thisMethod, "Could not update synch state of child nodes of {0}", new Object[]{this}, (Throwable)((Object)e));
            String m = "Could not update synch state of child nodes. Error: " + ((Throwable)((Object)e)).getMessage();
            DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_configuration, this.m_compartmentObj.getName(), this.m_compartmentObj.getScVendor(), "SC " + this.m_compartmentObj.getScName(), this.m_isActive);
            this.m_configuration.sendDCMessage(node, "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, m);
        }
    }
}

