/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.provider.SCInputProvider;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.RepositoryLayout;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.IOException;
import java.io.InputStream;

class SCRepositoryInputProvider
implements SCInputProvider {
    public static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$SCRepositoryInputProvider == null ? (class$com$sap$tc$devconf$impl$SCRepositoryInputProvider = SCRepositoryInputProvider.class$("com.sap.tc.devconf.impl.SCRepositoryInputProvider")) : class$com$sap$tc$devconf$impl$SCRepositoryInputProvider));
    private DevelopmentConfiguration m_devConf;
    private IVfsGenericFolder m_wsRootFolder;
    private IVfsFolder m_compRootFolder;
    private String m_scVendor;
    private String m_scName;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$SCRepositoryInputProvider;

    private SCRepositoryInputProvider() {
    }

    public SCRepositoryInputProvider(DevelopmentConfiguration devConf, IVfsGenericFolder rootFolder, String scVendor, String scName) throws VfsException, DevConfigException {
        this.m_devConf = devConf;
        this.m_wsRootFolder = rootFolder;
        this.m_scVendor = scVendor;
        this.m_scName = scName;
        this.m_compRootFolder = this.getComponentRootFolder();
    }

    public void releaseStream(InputStream reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOCATION.catching("releaseStream", (Throwable)e);
            }
        }
    }

    public InputStream getStreamForSC() throws ProviderException {
        return this.getStreamInFolder(this.m_compRootFolder, ".scdef");
    }

    public boolean isValid() {
        return this.m_compRootFolder != null;
    }

    private InputStream getStreamInFolder(IVfsFolder folder, String fileName) throws ProviderException {
        if (folder != null) {
            try {
                return this.vfsHandler().getFileStreamFromVfsFolder((IVfsGenericFolder)folder, fileName);
            }
            catch (VfsException e) {
                throw new ProviderException("Could not get input stream for VFS folder. DTR client error: " + e.getMessage(), (Throwable)e);
            }
            catch (DevConfigException e) {
                throw new ProviderException("Could not get input stream for VFS folder. DTR client error: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
        }
        return null;
    }

    private IVfsFolder getComponentRootFolder() throws VfsException, DevConfigException {
        RepositoryLayout rLayout = new RepositoryLayout();
        return this.vfsHandler().getSubFolderFromVfsFolder(this.m_wsRootFolder, rLayout.calculateRemoteSCRoot(this.m_scVendor, this.m_scName));
    }

    private VFSHandler vfsHandler() {
        return this.m_devConf.getVFSHandler();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

