/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.complib.namecheck.NameChecker;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.PPRef;
import com.sap.tc.logging.Location;

public class RepositoryLayout {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$RepositoryLayout == null ? (class$com$sap$tc$devconf$impl$RepositoryLayout = RepositoryLayout.class$("com.sap.tc.devconf.impl.RepositoryLayout")) : class$com$sap$tc$devconf$impl$RepositoryLayout));
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$RepositoryLayout;

    public String calculateRemoteSCRoot(String scVendor, String scName) {
        return "SCs/" + scVendor + "/" + scName + "/_comp/";
    }

    public String calculateRemoteDCRoot(String dcVendor, String dcName) {
        return "DCs/" + dcVendor + "/" + dcName + "/_comp/";
    }

    public String calculateRemoteDefFolder(String dcVendor, String dcName) {
        return "DCs/" + dcVendor + "/" + dcName + "/_comp/" + "def" + "/";
    }

    public String calculateRemotePPDefinitionFile(String dcVendor, String dcName, String ppName) {
        return "DCs/" + dcVendor + "/" + dcName + "/_comp/" + "def" + "/" + ppName + ".pp";
    }

    public DevelopmentComponentRef parseDCName(String dcDefPath) {
        String dcdefSuffix = ".dcdef";
        if (!dcDefPath.endsWith(dcdefSuffix)) {
            return null;
        }
        String dcFolder = dcDefPath.substring(0, dcDefPath.length() - dcdefSuffix.length());
        return this.parseDCNameFromDcFolder(dcFolder);
    }

    public PPRef parsePPName(String ppPath) {
        int prefixLength;
        String ppSuffix = ".pp";
        String defFolderName = "def";
        if (!ppPath.endsWith(ppSuffix)) {
            return null;
        }
        int lastSlashPos = ppPath.lastIndexOf(47);
        if (lastSlashPos < (prefixLength = 5 + "_comp".length() + defFolderName.length())) {
            return null;
        }
        int nameStart = lastSlashPos + 1;
        int nameEnd = ppPath.length() - ppSuffix.length();
        if (nameStart >= nameEnd) {
            return null;
        }
        String ppName = ppPath.substring(nameStart, nameEnd);
        try {
            NameChecker.checkPublicPartName((String)ppName);
        }
        catch (NameCheckException e) {
            LOCATION.catching("parsePPName", (Throwable)e);
            return null;
        }
        String compFolderPath = ppPath.substring(0, lastSlashPos - defFolderName.length());
        DevelopmentComponentRef dcRef = this.parseDCNameFromDcFolder(compFolderPath);
        if (dcRef == null) {
            return null;
        }
        return new PPRef(dcRef, ppName);
    }

    DevelopmentComponentRef parseDCNameFromDcFolder(String path) {
        String compartment;
        String prefixDCs = "DCs/";
        String prefixCompartments = "Compartments/";
        if (path.startsWith(prefixDCs)) {
            path = path.substring(prefixDCs.length());
            compartment = null;
        } else if (path.startsWith(prefixCompartments)) {
            int firstSlashPos = (path = path.substring(prefixCompartments.length())).indexOf(47);
            if (firstSlashPos < 1 || firstSlashPos == path.length() - 1) {
                return null;
            }
            compartment = path.substring(0, firstSlashPos);
            path = path.substring(firstSlashPos + 1);
        } else {
            return null;
        }
        String compSuffix = "/_comp/";
        if (!path.endsWith(compSuffix) && !path.endsWith(compSuffix = "/_comp")) {
            return null;
        }
        int firstSlashPos = (path = path.substring(0, path.length() - compSuffix.length())).indexOf(47);
        if (firstSlashPos < 1 || firstSlashPos == path.length() - 1) {
            return null;
        }
        String vendor = path.substring(0, firstSlashPos);
        String name = path.substring(firstSlashPos + 1);
        try {
            NameChecker.checkComponentName((String)name);
            NameChecker.checkVendorName((String)vendor);
        }
        catch (NameCheckException e) {
            LOCATION.catching("parseDCNameFromDcFolder", (Throwable)e);
            return null;
        }
        return new DevelopmentComponentRef(name, vendor, compartment);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

