/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.DCActivityState;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.devconf.impl.syncdb.SyncState;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RemoteStateSynchronizer {
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$RemoteStateSynchronizer == null ? (class$com$sap$tc$devconf$impl$RemoteStateSynchronizer = RemoteStateSynchronizer.class$("com.sap.tc.devconf.impl.RemoteStateSynchronizer")) : class$com$sap$tc$devconf$impl$RemoteStateSynchronizer));
    private DevelopmentConfiguration m_config;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$RemoteStateSynchronizer;

    public RemoteStateSynchronizer(DevelopmentConfiguration config) {
        this.m_config = config;
    }

    public void reconcileSyncDBWithVFs() {
        String thisMethod = "reconcileSyncDBWithVFs()";
        ComponentSyncDB syncdb = this.getDCSyncdb();
        Iterator keys = syncdb.getEntriesKeySet().iterator();
        HashMap snycedArchivesMap = new HashMap();
        while (keys.hasNext()) {
            IVfsActivityRecordedFolderItem arItem;
            String msg;
            IVfsFolderItem dcdefItem;
            String dcVendor;
            String dcName;
            String key = (String)keys.next();
            DevelopmentComponentRef ref = syncdb.getDCFromKey(key);
            String compartmentName = ref.getCompartment();
            IDCSyncEntry entry = syncdb.getEntry(compartmentName, dcName = ref.getName(), dcVendor = ref.getVendor());
            if (entry.isLocallyInstalled()) continue;
            if (entry.getActivityState() == DCActivityState.CHECKED_OUT_FOR_CREATE) {
                dcdefItem = this.getDCDefFolderItem(ref);
                if (dcdefItem == null) {
                    msg = "Found component " + ref + " in DC syndb but did not get a folder item! IGNORING it";
                    LOCATION.infoT(thisMethod, msg);
                    continue;
                }
                IVfsActivityRecordedFolderItem arItem2 = dcdefItem.asActivityRecordedFolderItem();
                if (arItem2.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_CREATE) continue;
                if (arItem2.getActivityState() == VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE) {
                    String m = "Found component " + ref + " in DC syndb as CHECKED_OUT_FOR_CREATE but CHECKED_OUT_FOR_DELETE in VFS";
                    LOCATION.infoT(thisMethod, m);
                    return;
                }
                VfsFolderItemLocationState lstate = dcdefItem.getLocationState();
                if (lstate == VfsFolderItemLocationState.LOCAL_ONLY) {
                    this.creationReverted(ref, entry);
                    continue;
                }
                if (lstate == VfsFolderItemLocationState.SERVER_ONLY) {
                    SyncState oldState = this.m_config.getSyncState(ref);
                    SyncMode oldMode = entry.getMode();
                    SyncState newState = SyncState.UNKNOWN;
                    SyncMode newMode = SyncMode.NOT_SYNCHED;
                    entry.setMode(newMode);
                    entry.setState(newState);
                    this.creationCheckedIn(ref, entry);
                    String compartment = ref.getCompartment();
                    String vendor = ref.getVendor();
                    String name = ref.getName();
                    boolean active = DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.fromSyncMode(newMode), this.m_config.getCompartmentObject(compartment));
                    this.m_config.notifyDCSyncStateChanged(compartment, vendor, name, oldState, newState, active);
                    this.m_config.notifyDCSyncModeChanged(compartment, vendor, name, oldMode, newMode, active);
                    this.m_config.notifyDCChanged(compartment, vendor, name, active);
                    continue;
                }
                this.creationCheckedIn(ref, entry);
                continue;
            }
            if (entry.getActivityState() == DCActivityState.CHECKED_OUT_FOR_DELETE) {
                msg = "INTERNAL ERROR: Unexpected State  \"CHECKED_OUT_FOR_DELETE\" found in DC syncdb (not supported yet).";
                IllegalStateException e = new IllegalStateException(msg);
                LOCATION.throwing(thisMethod, (Throwable)e);
                throw e;
            }
            if (!entry.isSynchedAsSource()) continue;
            dcdefItem = this.getDCDefFolderItem(ref);
            if (dcdefItem == null) {
                LOCATION.infoT(thisMethod, "could not get a folder item for dcdef file of {0} althogh it is marked to be synched as source code.", new Object[]{ref});
                continue;
            }
            VfsFolderItemLocationState lstate = dcdefItem.getLocationState();
            if (lstate != VfsFolderItemLocationState.SERVER_ONLY || (arItem = dcdefItem.asActivityRecordedFolderItem()) == null || arItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) continue;
            this.synchedSourceNowServerOnly(ref, entry);
        }
    }

    public void reconcileSyncDBWithBuildServer() throws SyncException {
        List compList = this.m_config.getCompartmentObjects();
        if (compList == null) {
            return;
        }
        Iterator it = compList.iterator();
        while (it.hasNext()) {
            Map variantMap;
            Compartment comp = (Compartment)it.next();
            if (comp.isLocal() || (variantMap = comp.getBuildVariants()) == null) continue;
            Iterator vnts = variantMap.keySet().iterator();
            while (vnts.hasNext()) {
                String vnt = (String)vnts.next();
                this.m_config.refreshArchiveSyncState(comp, vnt);
            }
        }
    }

    IVfsFolderItem getDCDefFolderItem(DevelopmentComponentRef ref) {
        String thisMethod = "getDCDefFolderItem()";
        IVfsFolderItem folderItem = null;
        FileSystemLayout fsLayout = new FileSystemLayout(this.m_config, ref.getCompartment(), ref.getVendor(), ref.getName());
        String path = fsLayout.getComponentDefinitionFile();
        VFSHandler vfsHandler = this.m_config.getVFSHandler();
        if (vfsHandler != null) {
            try {
                folderItem = vfsHandler.getFolderItemForLocalPath(path);
            }
            catch (VfsException e) {
                LOCATION.catching(thisMethod, (Throwable)e);
                String m = "caught VFS exception when trying to get folder item for " + path + ". Exception is: \n" + Util.printStackTraceToString((Throwable)e);
                LOCATION.infoT(thisMethod, m);
            }
        }
        if (folderItem == null && LOCATION.beLogged(100)) {
            LOCATION.debugT(thisMethod, "could not get VFSFolderItem for local path \"" + path + "\". returning null ");
        }
        return folderItem;
    }

    void creationReverted(DevelopmentComponentRef ref, IDCSyncEntry syncDBEntry) {
        String thisMethod = "creationReverted()";
        SyncState oldDCSyncState = this.m_config.getSyncState(ref);
        SyncMode oldMode = syncDBEntry.getMode();
        DCActivityState oldDCActState = syncDBEntry.getActivityState();
        DCActivityState newDCActState = DCActivityState.NONE;
        SyncMode newMode = SyncMode.LOCAL_ONLY;
        SyncState newSyncState = SyncState._getLocalSourceSyncState();
        LOCATION.debugT(thisMethod, "detected that creation was reverted. Updating dc syncdb entry to (mode|sync State|activity) : " + newMode + "|" + newSyncState + "|" + newDCActState + ")");
        syncDBEntry.setActivityState(newDCActState);
        syncDBEntry.setState(newSyncState);
        syncDBEntry.setMode(newMode);
        this.getDCSyncdb().save();
        String compartment = ref.getCompartment();
        String vendor = ref.getVendor();
        String name = ref.getName();
        boolean active = DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.fromSyncMode(newMode), this.m_config.getCompartmentObject(compartment));
        this.m_config.notifyDCSyncStateChanged(compartment, vendor, name, oldDCSyncState, newSyncState, active);
        this.m_config.notifyDCSyncModeChanged(compartment, vendor, name, oldMode, newMode, active);
        this.m_config.notifyDCActivityStateChanged(compartment, vendor, name, oldDCActState, newDCActState, active);
        this.m_config.notifyDCChanged(compartment, vendor, name, active);
    }

    public void creationCheckedIn(DevelopmentComponentRef ref, IDCSyncEntry syncDBEntry) {
        String thisMethod = "creationChecekedIn()";
        SyncState oldDCSyncState = this.m_config.getSyncState(ref);
        DCActivityState oldDCActState = syncDBEntry.getActivityState();
        DCActivityState newDCActState = DCActivityState.NONE;
        newDCActState = DCActivityState.NONE;
        LOCATION.debugT(thisMethod, "detected that creation was reverted. Updating dc syncdb entry to (mode|sync State|activity) : " + newDCActState + "|" + oldDCSyncState + "|" + oldDCActState + ")");
        syncDBEntry.setActivityState(newDCActState);
        this.getDCSyncdb().save();
        String compartment = ref.getCompartment();
        String vendor = ref.getVendor();
        String name = ref.getName();
        boolean active = DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.fromSyncMode(syncDBEntry.getMode()), this.m_config.getCompartmentObject(compartment));
        this.m_config.notifyDCActivityStateChanged(compartment, vendor, name, oldDCActState, newDCActState, active);
        this.m_config.notifyDCChanged(compartment, vendor, name, active);
    }

    public void synchedSourceNowServerOnly(DevelopmentComponentRef ref, IDCSyncEntry syncDBEntry) {
        String thisMethod = "synchedSourceNowServerOnly()";
        String localDCRoot = this.m_config.getDevConfFSL().getAbsoluteDCRoot(ref.getCompartment(), ref.getVendor(), ref.getName());
        String dcdefFile = localDCRoot + ".dcdef";
        try {
            this.m_config.getVFSHandler().syncLocalPath(dcdefFile);
            String m = "Resynched missing DC definition file \"" + dcdefFile + "\"";
            LOCATION.infoT(thisMethod, m);
            String compartment = ref.getCompartment();
            String vendor = ref.getVendor();
            String name = ref.getName();
            boolean active = DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.fromSyncMode(syncDBEntry.getMode()), this.m_config.getCompartmentObject(compartment));
            this.m_config.sendDCMessage(new DevelopmentComponentNode(this.m_config, compartment, vendor, name, active), "", DCMessageType.INFO, DCEventType.SOURCE_SYNCED, m);
        }
        catch (SyncException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            LOCATION.infoT(thisMethod, "Failed to resync missing DC definition file {0} : {1}", new Object[]{dcdefFile, ((Throwable)((Object)e)).getMessage()});
        }
    }

    public void synchedSourceNowLocalOnly(DevelopmentComponentRef ref, IDCSyncEntry syncDBEntry) {
        String thisMethod = "synchedSourceNowLocalOnly()";
        SyncMode oldDCMode = syncDBEntry.getMode();
        SyncState oldDCState = this.m_config.getSyncState(ref);
        SyncMode newDCMode = SyncMode.LOCAL_ONLY;
        SyncState newDCState = SyncState.UNKNOWN;
        syncDBEntry.setMode(newDCMode);
        syncDBEntry.setState(newDCState);
        this.getDCSyncdb().save();
        LOCATION.debugT(thisMethod, "VFS reports decdef for \"" + ref + "\"is LOCAL_ONLY for synced dC. Updated DC syncdb entry to (mode|sync State) : " + newDCMode + "|" + newDCState + ")");
        String compartment = ref.getCompartment();
        String vendor = ref.getVendor();
        String name = ref.getName();
        boolean active = DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.fromSyncMode(newDCMode), this.m_config.getCompartmentObject(compartment));
        this.m_config.notifyDCSyncStateChanged(compartment, vendor, name, oldDCState, newDCState, active);
        this.m_config.notifyDCSyncModeChanged(compartment, vendor, name, oldDCMode, newDCMode, active);
        this.m_config.notifyDCChanged(compartment, vendor, name, active);
    }

    private ComponentSyncDB getDCSyncdb() {
        return this.m_config.getComponentSyncDB();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

