/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.IOException;
import java.io.InputStream;

public class PPRepositoryInputProvider
implements PPInputProvider {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$PPRepositoryInputProvider == null ? (class$com$sap$tc$devconf$impl$PPRepositoryInputProvider = PPRepositoryInputProvider.class$("com.sap.tc.devconf.impl.PPRepositoryInputProvider")) : class$com$sap$tc$devconf$impl$PPRepositoryInputProvider));
    private String m_ppName;
    private DevelopmentConfiguration m_devConf;
    private String m_defFolderURL;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$PPRepositoryInputProvider;

    private PPRepositoryInputProvider() {
    }

    public PPRepositoryInputProvider(String ppName, DevelopmentConfiguration devConf, String remoteDefFolderURL) {
        this.m_ppName = ppName;
        this.m_devConf = devConf;
        this.m_defFolderURL = remoteDefFolderURL;
    }

    public InputStream getStreamForPublicPart() throws ProviderException {
        String url = this.m_defFolderURL + this.m_ppName + ".pp";
        try {
            return this.m_devConf.getVFSHandler().getFileStreamForURL(url);
        }
        catch (VfsException e) {
            throw new ProviderException("Could not read public part definition \"" + url + "\" from repository: " + e.getMessage(), (Throwable)e);
        }
        catch (DevConfigException e) {
            throw new ProviderException("Could not read public part definition \"" + url + "\" from repository: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }

    public void releaseStream(InputStream stream) {
        String thisMethod = "releaseStream";
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                String msg = "Error closing input stream for  public part \"" + this.m_ppName + "\"(" + e.getMessage() + ").";
                LOCATION.traceThrowableT(300, thisMethod, msg, (Throwable)e);
            }
        }
    }

    private VFSHandler vfsHandler() {
        return this.m_devConf.getVFSHandler();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

