/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.provider.PPOutputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PPFileOutputProvider
implements PPOutputProvider {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$PPFileOutputProvider == null ? (class$com$sap$tc$devconf$impl$PPFileOutputProvider = PPFileOutputProvider.class$("com.sap.tc.devconf.impl.PPFileOutputProvider")) : class$com$sap$tc$devconf$impl$PPFileOutputProvider));
    private DevelopmentConfiguration m_devConf;
    private String m_ppName;
    private FileSystemLayout m_fsLayout;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$PPFileOutputProvider;

    private PPFileOutputProvider() {
    }

    public PPFileOutputProvider(DevelopmentConfiguration devConf, String ppName, FileSystemLayout fsLayout) {
        this.m_devConf = devConf;
        this.m_ppName = ppName;
        this.m_fsLayout = fsLayout;
    }

    public OutputStream getStreamForPublicPart() throws ProviderException {
        File file = new File(this.m_fsLayout.getPublicPartDefinitionFile(this.m_ppName));
        return this.getStream(file);
    }

    public void releaseStream(OutputStream stream) {
        String thisMethod = "releaseStream";
        try {
            stream.close();
        }
        catch (IOException e) {
            String msg = "Error closing public part output stream for \"" + this.m_ppName + "\"(" + e.getMessage() + ").";
            LOCATION.traceThrowableT(300, thisMethod, msg, (Throwable)e);
        }
    }

    private OutputStream getStream(File file) throws ProviderException {
        FileOutputStream writer;
        try {
            file.createNewFile();
            writer = new FileOutputStream(file);
        }
        catch (Exception ex) {
            String msg = "Cannot open or create file for write access: " + file.getAbsolutePath() + "(" + ex.getMessage() + ").";
            throw new ProviderException(msg, (Throwable)ex);
        }
        return writer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

