/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.provider.PPInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class PPFileInputProvider
implements PPInputProvider {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$PPFileInputProvider == null ? (class$com$sap$tc$devconf$impl$PPFileInputProvider = PPFileInputProvider.class$("com.sap.tc.devconf.impl.PPFileInputProvider")) : class$com$sap$tc$devconf$impl$PPFileInputProvider));
    private DevelopmentConfiguration m_devConf;
    private String m_ppName;
    private FileSystemLayout m_fsLayout;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$PPFileInputProvider;

    private PPFileInputProvider() {
    }

    public PPFileInputProvider(DevelopmentConfiguration devConf, String ppName, FileSystemLayout fsLayout) {
        this.m_devConf = devConf;
        this.m_ppName = ppName;
        this.m_fsLayout = fsLayout;
    }

    public void releaseStream(InputStream reader) {
        String thisMethod = "releaseStream";
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOCATION.catching(thisMethod, (Throwable)e);
                LOCATION.infoT(thisMethod, "Ingoring error while closing public part input stream for {0}: {1}.", new Object[]{this.m_ppName, e.getMessage()});
            }
        }
    }

    public InputStream getStreamForPublicPart() throws ProviderException {
        File file = new File(this.m_fsLayout.getPublicPartDefinitionFile(this.m_ppName));
        return this.getStream(file);
    }

    private InputStream getStream(File file) throws ProviderException {
        FileInputStream reader = null;
        if (file.exists()) {
            try {
                reader = new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                String msg = "Cannot open file for read access: " + file.getAbsolutePath() + "(" + ex.getMessage() + ").";
                throw new ProviderException(msg, (Throwable)ex);
            }
        }
        return reader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

