/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.impl.DevConfFileSystemLayout;
import com.sap.tc.devconf.impl.DevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.NameVendorPair;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

public class LocalSCNode {
    private DevelopmentConfiguration m_config;
    private Compartment m_compartment;
    private List m_topLevelDCNodeList;

    public LocalSCNode(DevelopmentConfiguration config, Compartment compartment) {
        this.m_config = config;
        this.m_compartment = compartment;
        this.initializeTopLevelDCNodeList();
    }

    public List getTopLevelDCNodeList(boolean refresh) {
        if (refresh) {
            this.initializeTopLevelDCNodeList();
        }
        return this.m_topLevelDCNodeList;
    }

    private void initializeTopLevelDCNodeList() {
        this.m_topLevelDCNodeList = new ArrayList();
        String topLevelDCRootPath = this.m_config.getDevConfFSL().getAbsoluteTopLevelDCsRoot(this.m_compartment.getName());
        File topLevelDCRootFolder = new File(topLevelDCRootPath);
        File[] dcRefFiles = topLevelDCRootFolder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".dcref");
            }
        });
        if (dcRefFiles != null) {
            int i = 0;
            while (i < dcRefFiles.length) {
                File dcRefFile = dcRefFiles[i];
                NameVendorPair dcref = DevConfFileSystemLayout.parseDCRefFilename(dcRefFile.getName());
                if (dcref != null) {
                    DevelopmentComponentNode node = new DevelopmentComponentNode(this.m_config, this.m_compartment.getName(), dcref.vendor, dcref.name, true);
                    this.m_topLevelDCNodeList.add(node);
                }
                ++i;
            }
        }
    }
}

