/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.impl.DCFileInputProvider;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.devconf.impl.RepositoryLayout;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.devconf.impl.syncdb.SyncState;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LocalDCScanner {
    public static final String ARCHIVE_MARKER_FILE_NAME = ".installed";
    private static Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$devconf$impl$LocalDCScanner == null ? (class$com$sap$tc$devconf$impl$LocalDCScanner = LocalDCScanner.class$("com.sap.tc.devconf.impl.LocalDCScanner")) : class$com$sap$tc$devconf$impl$LocalDCScanner));
    private static final String SEPARATOR = File.separator;
    private static final String NL = System.getProperty("line.separator") == null ? "\n" : System.getProperty("line.separator");
    private DevelopmentConfiguration m_config;
    private File m_archiveMarkerFile;
    static /* synthetic */ Class class$com$sap$tc$devconf$impl$LocalDCScanner;

    public LocalDCScanner(DevelopmentConfiguration config) {
        this.m_config = config;
        this.m_archiveMarkerFile = new File(Util.concatenatePath((String)this.m_config.getConfigurationRootFolder(), (String)ARCHIVE_MARKER_FILE_NAME, (char)File.separatorChar));
    }

    public void refreshSyncDBForLocalDCs() throws DevConfigException {
        String thisMethod = "refreshSyncDBForLocalDCs";
        if (!this.m_config.isLocalOnlyMode()) {
            String m = "Internal Error: operation " + thisMethod + " is only allowed for local configurations.";
            throw new DevConfigException(m);
        }
        Compartment srcComp = null;
        Map compMap = this.m_config.getConfigurationData().getCompartments();
        if (compMap == null) {
            return;
        }
        Iterator it = compMap.values().iterator();
        while (it.hasNext()) {
            Compartment comp = (Compartment)it.next();
            if (!comp.hasLocalSourceStateOnly()) continue;
            srcComp = comp;
            break;
        }
        if (srcComp == null) {
            return;
        }
        String dcsFolderPath = this.m_config.getConfigurationRootFolder() + "DCs";
        HashSet syncdbEntryList = new HashSet();
        File dcsFolder = new File(dcsFolderPath);
        Set archiveDCkeys = this.readArchiveDCFile();
        if (dcsFolder.exists()) {
            this.scanForDCs(dcsFolder, srcComp.getName(), syncdbEntryList, archiveDCkeys);
        }
        this.m_config.getComponentSyncDB().retainEntriesFromCompartment(srcComp.getName(), syncdbEntryList);
        this.m_config.getComponentSyncDB().save();
    }

    /*
     * WARNING - void declaration
     */
    private Set readArchiveDCFile() throws DevConfigException {
        String thisMethod = "readArchiveDCFile";
        HashSet<String> result = new HashSet<String>();
        if (!this.m_archiveMarkerFile.isFile()) {
            return result;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.m_archiveMarkerFile));
            while ((line = reader.readLine()) != null) {
                void var4_5;
                result.add(var4_5.trim());
            }
            return result;
        }
        catch (FileNotFoundException e) {
            LOCATION.traceThrowableT(300, thisMethod, (Throwable)e);
            throw new DevConfigException("Failed to read installed DCs file: " + this.m_archiveMarkerFile.getAbsolutePath() + " : " + e.getMessage());
        }
        catch (IOException e) {
            LOCATION.traceThrowableT(300, thisMethod, (Throwable)e);
            throw new DevConfigException("Failed to read installed DCs file: " + this.m_archiveMarkerFile.getAbsolutePath() + " : " + e.getMessage());
        }
    }

    private void scanForDCs(File file, String sourceCodeCompartmentName, Set syncdbEntryList, Set archiveDCkeys) {
        if (file.isDirectory()) {
            if (file.getName().equals("_comp")) {
                this.handleDCCandidate(file, sourceCodeCompartmentName, syncdbEntryList, archiveDCkeys);
            } else {
                File[] childFolders = file.listFiles(new FileFilter(){

                    public boolean accept(File aFile) {
                        return aFile.isDirectory();
                    }
                });
                if (childFolders != null) {
                    int i = 0;
                    while (i < childFolders.length) {
                        this.scanForDCs(childFolders[i], sourceCodeCompartmentName, syncdbEntryList, archiveDCkeys);
                        ++i;
                    }
                }
            }
        }
    }

    private void handleDCCandidate(File folder, String sourceCodeCompartmentName, Set syncdbEntryList, Set archiveDCkeys) {
        String thisMethod = "handleDCCandidate()";
        File dcdefFile = new File(folder.getAbsolutePath() + SEPARATOR + ".dcdef");
        if (dcdefFile.exists()) {
            boolean dcValid;
            RepositoryLayout rl;
            DevelopmentComponentRef ref;
            String prefix = this.m_config.getConfigurationRootFolder();
            String relPath = dcdefFile.getAbsolutePath().substring(prefix.length());
            if (File.separatorChar != '/') {
                relPath = relPath.replace(File.separatorChar, '/');
            }
            if ((ref = (rl = new RepositoryLayout()).parseDCName(relPath)) == null) {
                LOCATION.debugT(thisMethod, "Path \"{0}\" cannot be a DC definition pathname. Ignoring it", new Object[]{dcdefFile.getAbsolutePath()});
                return;
            }
            if (ref.getCompartment() != null) {
                return;
            }
            boolean created = false;
            DevelopmentComponent dc = null;
            try {
                DCFileInputProvider provider = new DCFileInputProvider(this.m_config, sourceCodeCompartmentName, ref.getVendor(), ref.getName());
                dc = ComponentFactory.initialize((DCInputProvider)provider);
                dcValid = dc != null && dc.getName().equalsIgnoreCase(ref.getName()) && dc.getVendor().equalsIgnoreCase(ref.getVendor());
            }
            catch (Exception e) {
                LOCATION.catching("unsync", (Throwable)e);
                dcValid = false;
            }
            if (!dcValid) {
                LOCATION.infoT("File \"{0}\" does not contain a valid DC definition. Ignoring it", new Object[]{dcdefFile.getAbsolutePath()});
            } else {
                SyncState newSyncState;
                IDCSyncEntry entry = this.m_config.getComponentSyncDB().getEntry(sourceCodeCompartmentName, dc.getName(), dc.getVendor());
                if (entry == null) {
                    entry = this.m_config.getComponentSyncDB().createEntry(sourceCodeCompartmentName, dc.getName(), dc.getVendor());
                    created = true;
                } else {
                    SyncState syncState;
                    if (entry.getMode() != SyncMode.LOCAL_ONLY) {
                        LOCATION.infoT(thisMethod, "Found incompatible sync mode in dc syncdb for DC in local only compartment.{0}DC vendor/name {1}/{2} compartment {3} mode in syncdb {4}", new Object[]{NL, dc.getVendor(), dc.getName(), sourceCodeCompartmentName, entry.getMode()});
                    }
                    if ((syncState = this.m_config.getComponentSyncDB().getSyncState(sourceCodeCompartmentName, dc.getVendor(), dc.getName())) == SyncState.UNKNOWN) {
                        LOCATION.debugT(thisMethod, "DC in local only compartment found in syncdb.{0}   DC vendor/name {1}/{2} compartment {3} state in syncdb {4}", new Object[]{NL, dc.getVendor(), dc.getName(), sourceCodeCompartmentName, syncState});
                    } else if (syncState == SyncState.INSTALLED) {
                        LOCATION.debugT(thisMethod, "Found installed DC in local only compartment in syncdb.{0}   DC vendor/name {1}/{2} compartment {3} state in syncdb {4}", new Object[]{NL, dc.getVendor(), dc.getName(), sourceCodeCompartmentName, syncState});
                    } else {
                        LOCATION.infoT(thisMethod, "Found incompatible sync state in dc syncdb for DC in local only compartment.{0}   DC vendor/name {1}/{2} compartment {3} state in syncdb {4}", new Object[]{NL, dc.getVendor(), dc.getName(), sourceCodeCompartmentName, syncState});
                    }
                }
                String key = ref.getName() + ":" + ref.getVendor();
                if (archiveDCkeys.contains(key)) {
                    newSyncState = SyncState.INSTALLED;
                    entry.setDirty(false);
                    entry.setBroken(false);
                } else {
                    newSyncState = SyncState.UNKNOWN;
                    if (created) {
                        entry.setDirty(true);
                        entry.setBroken(false);
                    }
                }
                entry.setMode(SyncMode.LOCAL_ONLY);
                entry.setState(newSyncState);
                syncdbEntryList.add(entry);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

