/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.buildutility.MD5Util;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.PPReference;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;

public class FileSystemLayout {
    public static final String COMPARTMENTS_FOLDER_NAME = "Compartments";
    public static final String GEN_FOLDER_NAME = "gen";
    public static final String TEST_FOLDER_NAME = "test";
    public static final String DEF_FOLDER_NAME = "def";
    public static final String CONFIG_FOLDER_NAME = "cfg";
    public static final String SOURCE_FOLDER_NAME = "src";
    public static final String TOP_LEVEL_DCS_FOLDER_NAME = "TopLevelDCs";
    public static final String PUBLIC_FOLDER_NAME = "public";
    public static final String LOG_RESULT_FOLDER_NAME = "logs";
    public static final String DEPLOY_RESULT_FOLDER_NAME = "deploy";
    public static final String TEST_RESULT_FOLDER_NAME = "test";
    public static final String PUBLIC_RESULT_FOLDER_NAME = "public";
    public static final String LOCALIZATION_FOLDER_NAME = "l10n";
    public static final String ETC_RESULT_FOLDER_NAME = "etc";
    public static final String DOC_RESULT_FOLDER_NAME = "doc";
    public static final String IDE_RESULT_FOLDER_NAME = "ide";
    public static final String TEMP_RESULT_FOLDER_NAME = "temp";
    public static final String LOG_FOLDER_NAME = "logs";
    public static final String TEMP_BUILD_ROOT_NAME = "t";
    public static final String PACKAGES_FOLDER_NAME = "packages";
    public static final String DC_DEF_FILE_NAME = ".dcdef";
    public static final String PUBLIC_PART_SUFFIX = ".pp";
    public static final String SDA_FILE_SUFFIX = ".sda";
    public static final String BUILD_LOG_FILE_NAME = "build.log";
    private static final String SRC_SUFFIX = "src";
    public static final String PACKAGE_FILE_SUFFIX = ".package";
    public static final String SEPARATOR = File.separator;
    private DevelopmentConfiguration m_devConf;
    private String m_compartmentID;
    private String m_dcVendor;
    private String m_dcName;
    static final Location LOCATION = Location.getLocation((String)"com.sap.tc.devconf.impl.FileSystemLayout");

    private FileSystemLayout() {
    }

    public FileSystemLayout(DevelopmentConfiguration devConf, String compartmentID, String dcVendor, String dcName) {
        this.m_devConf = devConf;
        this.m_dcVendor = dcVendor;
        this.m_dcName = dcName;
        this.m_compartmentID = compartmentID;
    }

    public String getVariantRootFolder(String buildVariant) {
        return this.getRootFolder() + GEN_FOLDER_NAME + SEPARATOR + buildVariant + SEPARATOR;
    }

    public String getVariantSourceFolder(String buildVariant) {
        return this.getRootFolder() + GEN_FOLDER_NAME + SEPARATOR + buildVariant + SEPARATOR + "src";
    }

    public String getDeployRootFolder(String buildVariant) {
        return this.getRootFolder() + GEN_FOLDER_NAME + SEPARATOR + buildVariant + SEPARATOR + DEPLOY_RESULT_FOLDER_NAME;
    }

    public String getDefaultSDAFileName(String buildVariant) {
        return this.getDeployRootFolder(buildVariant) + SEPARATOR + this.m_dcVendor + "~" + Util.replaceSlashWithTilde((String)this.m_dcName) + SDA_FILE_SUFFIX;
    }

    public String getBuildLogFile(String buildVariant) {
        return this.getBuildLogFolder(buildVariant) + BUILD_LOG_FILE_NAME;
    }

    public String getBuildLogFolder(String buildVariant) {
        return this.getRootFolder() + GEN_FOLDER_NAME + SEPARATOR + buildVariant + SEPARATOR + "logs" + SEPARATOR;
    }

    public String getPublicPartRootFolder(String buildVariant, String ppName) {
        return this.getRootFolder() + GEN_FOLDER_NAME + SEPARATOR + buildVariant + SEPARATOR + "public" + SEPARATOR + ppName + SEPARATOR;
    }

    public String getRootFolder() {
        return this.m_devConf.getDevConfFSL().getAbsoluteDCRoot(this.m_compartmentID, this.m_dcVendor, this.m_dcName);
    }

    public String getDefFolder() {
        return this.getRootFolder() + DEF_FOLDER_NAME + SEPARATOR;
    }

    public String getUsedPublicPartRootFolder(String buildVariant, PPReference ppRef) {
        String thisMethod = "getUsedPublicPartRootFolder(String,PPReference)";
        String usedCompartment = this.m_devConf.getCompartmentIDFromDCReference(this.m_compartmentID, ppRef.getComponent());
        if (usedCompartment == null) {
            String message = "Used public part " + ppRef.getName() + " of " + ppRef.getComponent().getVendor() + "/" + ppRef.getComponent().getName() + " neither synched nor available locally. (Not found in component sync DB)";
            IllegalStateException ex = new IllegalStateException(message);
            LOCATION.throwing(thisMethod, (Throwable)ex);
            throw ex;
        }
        String usedVariant = this.m_devConf.getUsedBuildVariant(this.m_compartmentID, usedCompartment, buildVariant);
        if (usedVariant == null) {
            String message = "Cannot determine used variant for used compartment " + usedCompartment + ". Using variant: " + buildVariant + " using compartment: " + this.m_compartmentID;
            IllegalStateException ex = new IllegalStateException(message);
            LOCATION.throwing(thisMethod, (Throwable)ex);
            throw ex;
        }
        return this.m_devConf.getDevConfFSL().getAbsoluteDCRoot(usedCompartment, ppRef.getComponent().getVendor(), ppRef.getComponent().getName()) + GEN_FOLDER_NAME + SEPARATOR + usedVariant + SEPARATOR + "public" + SEPARATOR + ppRef.getName() + SEPARATOR;
    }

    public String getLocaleRootFolder(String buildVariant, String locale) {
        return this.getVariantRootFolder(buildVariant) + LOCALIZATION_FOLDER_NAME + SEPARATOR + locale + SEPARATOR + GEN_FOLDER_NAME + SEPARATOR;
    }

    public String getLocaleSourceRootFolder(String locale) {
        return this.getRootFolder() + LOCALIZATION_FOLDER_NAME + SEPARATOR + locale + SEPARATOR;
    }

    public String getComponentDefinitionFile() {
        return this.getRootFolder() + DC_DEF_FILE_NAME;
    }

    public String getPublicPartDefinitionFile(String ppName) {
        return this.getRootFolder() + FileSystemLayout.getPublicPartDefFileRelative(ppName);
    }

    public String[] getDefaultFolders() {
        String[] paths = new String[4];
        String localDCpath = this.getRootFolder();
        paths[0] = localDCpath + CONFIG_FOLDER_NAME;
        paths[1] = localDCpath + DEF_FOLDER_NAME;
        paths[2] = localDCpath + "src";
        paths[3] = localDCpath + "test";
        return paths;
    }

    public static String getPublicPartDefFileRelative(String ppName) {
        return DEF_FOLDER_NAME + SEPARATOR + ppName + PUBLIC_PART_SUFFIX;
    }

    public String getTempVariantGenFolder(String buildVariant) {
        String rootPath = Util.concatenatePath((String)this.m_devConf.getConfigurationRootFolder(), (String)TEMP_BUILD_ROOT_NAME, (char)File.separatorChar);
        return Util.concatenatePath((String)rootPath, (String)this.getDCBVHash(this.m_dcVendor, this.m_dcName, buildVariant), (char)File.separatorChar);
    }

    public String[] getReservedPackageNames() {
        return this.getPackageNames(this.getPackagesFolder());
    }

    private String getPackagesFolder() {
        return this.getRootFolder() + DEF_FOLDER_NAME + SEPARATOR + PACKAGES_FOLDER_NAME + SEPARATOR;
    }

    private String getDCBVHash(String dcvendor, String dcname, String buildVariant) {
        return MD5Util.getMD5asHexString((String)(dcvendor + "#" + dcname + "#" + buildVariant));
    }

    private String[] getPackageNames(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            return new String[0];
        }
        File[] files = folder.listFiles();
        ArrayList<String> list = new ArrayList<String>(files.length);
        int i = 0;
        while (i < files.length) {
            String filename = files[i].getName();
            int pos = filename.lastIndexOf(PACKAGE_FILE_SUFFIX);
            if (pos > -1 && pos + PACKAGE_FILE_SUFFIX.length() == filename.length()) {
                list.add(filename.substring(0, pos));
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }
}

