/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildtool.JarHandler;
import com.sap.tc.cbs.client.CBSFactory;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IDCRef;
import com.sap.tc.cbs.client.IDCVariantState;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.InternalServerException;
import com.sap.tc.cbs.client.error.UnknownBuildSpaceException;
import com.sap.tc.cbs.client.error.UnknownDCException;
import com.sap.tc.cbs.client.impl.DCRef;
import com.sap.tc.cbs.util.ChainedException;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.complib.BuildVariant;
import com.sap.tc.complib.Compartment;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.ConfigurationException;
import com.sap.tc.complib.ConfigurationFactory;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.Repository;
import com.sap.tc.complib.SourceState;
import com.sap.tc.complib.namecheck.NameCheckException;
import com.sap.tc.complib.namecheck.NameChecker;
import com.sap.tc.complib.provider.ConfigurationInputProvider;
import com.sap.tc.complib.provider.DCInputProvider;
import com.sap.tc.complib.provider.DCOutputProvider;
import com.sap.tc.complib.provider.FileConfigInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.devconf.CheckoutException;
import com.sap.tc.devconf.ConfigNotLocalException;
import com.sap.tc.devconf.ConnectionContext;
import com.sap.tc.devconf.CreateException;
import com.sap.tc.devconf.DCActivityState;
import com.sap.tc.devconf.DCEventType;
import com.sap.tc.devconf.DCMessageType;
import com.sap.tc.devconf.DCName;
import com.sap.tc.devconf.DCNodeSyncMode;
import com.sap.tc.devconf.DCNodeSyncState;
import com.sap.tc.devconf.DCNotFoundException;
import com.sap.tc.devconf.DCUsageFilter;
import com.sap.tc.devconf.DevConfUtil;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.DevconfInconsistencyException;
import com.sap.tc.devconf.DevconfModeException;
import com.sap.tc.devconf.DevelopmentConfigurationFactory;
import com.sap.tc.devconf.IConnectionContext;
import com.sap.tc.devconf.IDCNodeResult;
import com.sap.tc.devconf.IDCOperationHandler;
import com.sap.tc.devconf.IDCOperationResult;
import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDCProxyResult;
import com.sap.tc.devconf.IDCUnsyncResult;
import com.sap.tc.devconf.IDCVariantContext;
import com.sap.tc.devconf.IDevConfListener;
import com.sap.tc.devconf.IDevelopmentComponentNode;
import com.sap.tc.devconf.IDevelopmentComponentRef;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.IUsedDCFoundHandler;
import com.sap.tc.devconf.InvalidDefinitionException;
import com.sap.tc.devconf.LocalOnlyException;
import com.sap.tc.devconf.NoBuildServerDefinedException;
import com.sap.tc.devconf.OfflineException;
import com.sap.tc.devconf.RemovalException;
import com.sap.tc.devconf.RepositoryAccessException;
import com.sap.tc.devconf.SyncException;
import com.sap.tc.devconf.impl.CBSHandler;
import com.sap.tc.devconf.impl.CompartmentNode;
import com.sap.tc.devconf.impl.ConfigUtils;
import com.sap.tc.devconf.impl.DCArchivePoolInputProvider;
import com.sap.tc.devconf.impl.DCDependenciesManager;
import com.sap.tc.devconf.impl.DCDependencyChecker;
import com.sap.tc.devconf.impl.DCFileInputProvider;
import com.sap.tc.devconf.impl.DCFileOutputProvider;
import com.sap.tc.devconf.impl.DCMessage;
import com.sap.tc.devconf.impl.DCNodeResult;
import com.sap.tc.devconf.impl.DCOperationResult;
import com.sap.tc.devconf.impl.DCProxy;
import com.sap.tc.devconf.impl.DCProxyResult;
import com.sap.tc.devconf.impl.DCUnsyncResult;
import com.sap.tc.devconf.impl.DCVariantContext;
import com.sap.tc.devconf.impl.DTRClientErrorMapper;
import com.sap.tc.devconf.impl.DcVfsListener;
import com.sap.tc.devconf.impl.DcVfsListenerHandler;
import com.sap.tc.devconf.impl.DebugTrace;
import com.sap.tc.devconf.impl.DevConfFileMonitor;
import com.sap.tc.devconf.impl.DevConfFileSystemLayout;
import com.sap.tc.devconf.impl.DevelopmentComponentInfo;
import com.sap.tc.devconf.impl.DevelopmentComponentNode;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;
import com.sap.tc.devconf.impl.DevelopmentComponentStateRef;
import com.sap.tc.devconf.impl.FileSystemLayout;
import com.sap.tc.devconf.impl.LocalDCScanner;
import com.sap.tc.devconf.impl.LocalSCNode;
import com.sap.tc.devconf.impl.RepositoryLayout;
import com.sap.tc.devconf.impl.SourceUnpacker;
import com.sap.tc.devconf.impl.VFSHandler;
import com.sap.tc.devconf.impl.cache.DCProxyCache;
import com.sap.tc.devconf.impl.syncdb.ComponentSyncDB;
import com.sap.tc.devconf.impl.syncdb.IDCSyncEntry;
import com.sap.tc.devconf.impl.syncdb.SyncMode;
import com.sap.tc.devconf.impl.syncdb.SyncState;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.exceptions.ClientLibraryException;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItemListener;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.config.IBuildServer;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.config.IServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.KeyStoreException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;

public class DevelopmentConfiguration
implements IDevelopmentConfiguration {
    static final Location LOCATION = Location.getLocation((String)"com.sap.tc.devconf.impl.DevelopmentConfiguration");
    static int DC_NOT_AVAILABLE_LOCALLY = 0;
    static int DC_AVAILABLE_AS_SOURCE = 1;
    static int DC_AVAILABLE_AS_ARCHIVES = 2;
    static final String DC_TYPE_DUMMY = "initial";
    static final String DC_TYPE_VENDOR_DUMMY = "initial";
    static final String confDefPrefix = "DevConf at ";
    private static final String NL = System.getProperty("line.separator");
    private final String m_configRootDir;
    private com.sap.tc.complib.DevelopmentConfiguration m_devconfObject;
    private final IConfiguration m_dtrConfiguration;
    private final IClient m_dtrClientDef;
    private SourceUnpacker m_sourceUnpacker;
    private final VFSHandler m_vfsHandler;
    private IBuildSpace m_buildSpaceProxy = null;
    Set m_devconfListeners = new HashSet();
    private String m_localArchiveRootFolder = null;
    private ComponentSyncDB m_componentSyncDB;
    private DCProxyCache m_dcProxyCache;
    private RepositoryLayout m_repositoryLayout;
    private DevConfFileSystemLayout m_devConfFileSystemLayout;
    private DevConfOperationMode m_operationMode;
    private ConfigUtils m_configUtils;
    private Map m_defaultBuildVariants;
    private Map localSCNodeMap;
    private CBSFactory m_cbsFactory = null;
    private IConnectionContext m_connectionContext = null;
    private JarHandler m_jarHandler;
    private DevelopmentComponentRef m_componentInWork = null;
    private LocalDCScanner m_localDCScanner;
    private boolean m_loginRequired;
    private DcVfsListenerHandler m_vfsListenerHandler;
    private final DCDependenciesManager m_dependenciesManager;
    private boolean m_doNotUseCBSevenIfConfigured = false;
    List m_compartmentNodes = null;
    Set m_disabledCompartments = new HashSet();
    private boolean m_deleted = false;
    private final DCDependencyChecker m_dependencyChecker;

    public DevelopmentConfiguration(IConfiguration configuration, IClient clientdef, com.sap.tc.complib.DevelopmentConfiguration devconf, String confrootdir, DevConfOperationMode operationMode, IConnectionContext connectionContext, String localArchiveRootFolder, boolean doNotUseCBSevenIfConfigured) throws RepositoryAccessException {
        String thisMethod = "DevelopmentConfiguration(...)";
        this.m_configRootDir = confrootdir;
        this.m_devconfObject = devconf;
        this.m_dtrConfiguration = configuration;
        this.m_dtrClientDef = clientdef;
        this.m_connectionContext = connectionContext;
        this.m_operationMode = operationMode;
        this.m_doNotUseCBSevenIfConfigured = doNotUseCBSevenIfConfigured;
        this.m_dependencyChecker = new DCDependencyChecker();
        this.m_dependenciesManager = new DCDependenciesManager(this);
        this.m_configUtils = new ConfigUtils();
        this.m_repositoryLayout = new RepositoryLayout();
        this.m_localArchiveRootFolder = localArchiveRootFolder;
        this.m_devConfFileSystemLayout = new DevConfFileSystemLayout(this);
        this.m_dcProxyCache = new DCProxyCache();
        this.m_componentSyncDB = new ComponentSyncDB(confrootdir, this);
        this.m_vfsListenerHandler = new DcVfsListenerHandler(this);
        this.m_loginRequired = this._isLoginRequired();
        this.m_vfsHandler = new VFSHandler(this.m_dtrConfiguration, this.m_dtrClientDef, this);
        if (LOCATION.beLogged(100)) {
            String msg = "called with\n    clientdef   \t\t\t  :" + (clientdef == null ? null : clientdef.getName()) + "\n    devconf     \t\t\t  :" + (devconf == null ? null : devconf.getName()) + "\n    config rootfolder\t  :" + confrootdir + "\n    operationMode \t\t  :" + operationMode.toString() + "\n    localArchiveRootFolder :" + localArchiveRootFolder;
            LOCATION.debugT(thisMethod, msg);
        }
        if (!this.isLocalConfiguration()) {
            this.initVFSListener();
        }
        if (this.m_operationMode != DevConfOperationMode.LOCAL_ONLY && !this.isLocalConfiguration()) {
            try {
                this.createMountPointsForSCs();
            }
            catch (SyncException e) {
                throw new RepositoryAccessException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
        }
        this.initializeDefaultVariants();
        this.m_localDCScanner = new LocalDCScanner(this);
        if (this.isLocalConfiguration()) {
            try {
                this.m_localDCScanner.refreshSyncDBForLocalDCs();
            }
            catch (DevConfigException e) {
                LOCATION.catching(thisMethod, (Throwable)((Object)e));
            }
        }
    }

    private void initVFSListener() throws RepositoryAccessException {
        if (this.m_dtrClientDef == null) {
            LOCATION.infoT("initVFSListener", "DTRclient refernce is null for config {0} in {1}", new Object[]{this.getName(), this.getConfigurationRootFolder()});
            return;
        }
        IVfsContext context = this.m_dtrClientDef.getContext();
        if (VersionedFileSystemFactory.hasVersionedFileSystemManager((IVfsContext)context)) {
            try {
                IVersionedFileSystemManager manager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)context);
                manager.addFolderItemListener((IVfsFolderItemListener)DcVfsListener.getInstance());
            }
            catch (VfsException e) {
                throw new RepositoryAccessException(e.getMessage(), e);
            }
        }
    }

    public void setDefaultBuildVariant(String compartmentName, String buildVariant) throws DevConfigException {
        String thisMethod = "setDefaultBuildVariant(String,String)";
        LOCATION.debugT(thisMethod, "setting default build variant {0} for compartment {1}", new Object[]{compartmentName, buildVariant});
        try {
            this._setDefaultBuildVariant(compartmentName, buildVariant);
        }
        catch (DevconfInconsistencyException e) {
            String msg = "Cannot set feault build variant. Illegal arguments: " + ((Throwable)((Object)e)).getMessage();
            throw new DevConfigException(msg, (Throwable)((Object)e));
        }
    }

    void _setDefaultBuildVariant(String compartmentName, String buildVariant) throws DevconfInconsistencyException {
        String thisMethod = "_setDefaultBuildVariant(String,String)";
        Compartment compartment = this.getCompartmentObject(compartmentName);
        Map variants = compartment.getBuildVariants();
        if (variants == null) {
            String msg = "No build variants defined for compartment: " + compartmentName;
            throw new DevconfInconsistencyException(msg);
        }
        BuildVariant variantObj = (BuildVariant)variants.get(buildVariant);
        if (variantObj == null) {
            String msg = "Build variant \"" + buildVariant + "\" not defined for compartment: \"" + compartmentName + "\"";
            throw new DevconfInconsistencyException(msg);
        }
        LOCATION.debugT(thisMethod, "verified that build variant exists", new Object[]{compartmentName, buildVariant});
        HashSet<String> visitedCompartments = new HashSet<String>();
        visitedCompartments.add(compartmentName);
        if (this.m_defaultBuildVariants == null) {
            this.m_defaultBuildVariants = new HashMap();
        }
        this.m_defaultBuildVariants.put(compartmentName, buildVariant);
        LOCATION.debugT(thisMethod, "put build variant into default variant map", new Object[]{compartmentName, buildVariant});
        Map mapping = variantObj.getVariantMapping();
        if (mapping != null) {
            Iterator usedCompartments = mapping.keySet().iterator();
            while (usedCompartments.hasNext()) {
                String usedCompartment = (String)usedCompartments.next();
                if (visitedCompartments.contains(usedCompartment)) continue;
                String usedVariant = (String)mapping.get(usedCompartment);
                LOCATION.debugT(thisMethod, "propagating default build variant update from compartment {0} to compartment {1}", new Object[]{compartmentName, usedCompartment});
                this._setDefaultBuildVariant(usedCompartment, usedVariant, visitedCompartments);
            }
        }
    }

    public void _setDefaultBuildVariant(String compartmentName, String buildVariant, Set visitedCompartments) {
        String thisMethod = "_setDefaultBuildVariant(String,String,Set)";
        Compartment compartment = this.getCompartmentObject(compartmentName);
        Map variants = compartment.getBuildVariants();
        LOCATION.debugT(thisMethod, "setting default build variant {0} for compartment {1}", new Object[]{compartmentName, buildVariant});
        if (variants == null) {
            String msg = "Internal Error: mapped build variant \"" + buildVariant + "\" not defined for compartment: \"" + compartmentName + "\"";
            throw new DevconfInconsistencyException(msg);
        }
        BuildVariant variantObj = (BuildVariant)variants.get(buildVariant);
        if (variantObj == null) {
            String msg = "Internal Error: mapped build variant \"" + buildVariant + "\" not defined for compartment: \"" + compartmentName + "\"";
            throw new DevconfInconsistencyException(msg);
        }
        LOCATION.debugT(thisMethod, "verified that build variant exists", new Object[]{compartmentName, buildVariant});
        if (this.m_defaultBuildVariants == null) {
            this.m_defaultBuildVariants = new HashMap();
        }
        this.m_defaultBuildVariants.put(compartmentName, buildVariant);
        LOCATION.debugT(thisMethod, "put build variant into default variant map", new Object[]{compartmentName, buildVariant});
        visitedCompartments.add(compartmentName);
        Map mapping = variantObj.getVariantMapping();
        if (mapping != null) {
            Iterator usedCompartments = mapping.keySet().iterator();
            while (usedCompartments.hasNext()) {
                String usedCompartment = (String)usedCompartments.next();
                if (visitedCompartments.contains(usedCompartment)) continue;
                String usedVariant = (String)mapping.get(usedCompartment);
                LOCATION.debugT(thisMethod, "propagating default build variant update from compartment {0} to compartment {1}", new Object[]{compartmentName, usedCompartment});
                this._setDefaultBuildVariant(usedCompartment, usedVariant, visitedCompartments);
            }
        }
    }

    public String getDefaultBuildVariant(String compartmentName) throws DevConfigException {
        try {
            return this._getDefaultBuildVariant(compartmentName);
        }
        catch (DevconfInconsistencyException e) {
            throw new DevConfigException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
    }

    public String _getDefaultBuildVariant(String compartmentName) throws DevconfInconsistencyException {
        String thisMethod = "_getDefaultBuildVariant(String)";
        LOCATION.debugT(thisMethod, "trying to get default build variant for compartment " + compartmentName);
        LOCATION.debugT(thisMethod, "verifying that compartment exists");
        Map compartments = this.m_devconfObject.getCompartments();
        if (compartments == null) {
            String msg = "No compartments defined for this configuration";
            throw new DevconfInconsistencyException(msg);
        }
        if (!compartments.keySet().contains(compartmentName)) {
            String msg = "Illegal value for 'compartment parameter. Specified compartment: \"" + compartmentName + "\" does not exist in configuration \"" + this.getName() + "\"";
            throw new DevconfInconsistencyException(msg);
        }
        if (this.m_defaultBuildVariants == null) {
            String msg = "No default build variants defined for this configuration";
            throw new DevconfInconsistencyException(msg);
        }
        String variant = (String)this.m_defaultBuildVariants.get(compartmentName);
        if (variant == null) {
            throw new DevconfInconsistencyException("No default build variant defined for specified compartment: \"" + compartmentName + "\"");
        }
        LOCATION.debugT(thisMethod, "found build variant " + variant);
        return variant;
    }

    public void refreshArchiveSyncState() throws SyncException {
        String thisMethod = "refreshArchiveSyncState()";
        Map comps = this.m_devconfObject.getCompartments();
        if (comps == null) {
            return;
        }
        Iterator compartments = comps.values().iterator();
        while (compartments.hasNext()) {
            Compartment comp = (Compartment)compartments.next();
            String defaultVariant = (String)this.m_defaultBuildVariants.get(comp.getName());
            if (defaultVariant == null) {
                String msg = "Internal Error: default build variant \"" + defaultVariant + "\" not defined for compartment: \"" + comp.getName() + "\"";
                throw new SyncException(msg, null, 17);
            }
            this.refreshArchiveSyncState(comp, defaultVariant);
        }
    }

    public IDCProxy createComponent(String compartmentName, String dcVendor, String dcName, IVfsActivity activity) throws SyncException, CreateException, CheckoutException, NameCheckException {
        return this.createComponent(compartmentName, dcVendor, dcName, null, null, activity);
    }

    public IDCProxy createComponent(String compartmentName, String dcVendor, String dcName, String parentVendor, String parentName, IVfsActivity activity) throws SyncException, CreateException, CheckoutException, NameCheckException {
        String methodStr = "createComponent()";
        LOCATION.debugT(methodStr, "compartmentName: {0}, dcVendor: {1}, dcName: {2}parentVendor: {3}, parentName: {4}, activity: {5}", new Object[]{compartmentName, dcVendor, dcName, parentVendor, parentName, activity});
        if (this.isInOfflineMode()) {
            String msg = "Cannot create non-local component when in offline mode";
            throw new SyncException(msg, null, 22);
        }
        if (this.m_componentInWork != null) {
            String m = "Internal Error: another create process seems to be already running for component " + this.m_componentInWork;
            throw new CreateException(m, null, -1);
        }
        DCProxy parentProxy = null;
        boolean parentModified = false;
        boolean parentBecameDirty = false;
        try {
            DCProxy dCProxy;
            block40: {
                this.setComponentInWork(new DevelopmentComponentRef(dcName, dcVendor, compartmentName));
                boolean isTopLevel = parentVendor == null || parentName == null;
                FileSystemLayout fsLayout = new FileSystemLayout(this, compartmentName, dcVendor, dcName);
                this.checkCreateComponentConditions(compartmentName, dcVendor, dcName, parentVendor, parentName);
                Compartment compartment = this.getCompartmentObject(compartmentName);
                boolean useInactiveWorkspace = compartment.hasInactiveSourceState();
                if (!this.findOrCreateMountPointForDC(compartmentName, dcVendor, dcName, useInactiveWorkspace, true)) {
                    String msg = "cannot  find or create VFS mount point";
                    throw new SyncException(msg, null, -1, compartmentName, dcName, dcVendor);
                }
                boolean successfullyFinished = false;
                HashSet addedItems = new HashSet();
                IDCSyncEntry entry = null;
                boolean parentCheckedOutByUs = false;
                try {
                    DevelopmentComponent component = null;
                    String[] paths = fsLayout.getDefaultFolders();
                    activity = this.m_vfsHandler.createAndCheckoutFolders(activity, paths, addedItems);
                    String[] filePaths = new String[]{fsLayout.getComponentDefinitionFile()};
                    DCFileOutputProvider provider = new DCFileOutputProvider(this, compartmentName, dcVendor, dcName);
                    component = ComponentFactory.createDevelopmentComponent((String)dcName, (String)dcVendor, (ComponentType)this.getInitialDCType());
                    if (!isTopLevel) {
                        component.setEnclosingComponent(new DCReference(parentName, parentVendor));
                    }
                    try {
                        ComponentFactory.serialize((DevelopmentComponent)component, (DCOutputProvider)provider);
                    }
                    catch (IOException e) {
                        String message = "Failed to save component definition: " + e.getMessage();
                        throw new CreateException(message, e, 4);
                    }
                    catch (ProviderException e) {
                        String message = "Failed to save component definition:  " + e.getMessage();
                        throw new CreateException(message, e, 4);
                    }
                    this.m_vfsHandler.addNewFilesToActivity(activity, filePaths, addedItems);
                    if (isTopLevel) {
                        this.addTopLevelComponentEntry(compartmentName, dcVendor, dcName, activity, addedItems);
                    } else {
                        try {
                            parentProxy = this._getDCProxyLocalOrActive(compartmentName, parentVendor, parentName);
                        }
                        catch (DevConfigException e) {
                            String msg = "could not find the parent component \"" + parentVendor + "/" + parentName + "\" in compartment \"" + compartmentName + "\"";
                            throw new CreateException(msg, (Throwable)((Object)e), 2);
                        }
                        parentCheckedOutByUs = parentProxy.checkoutDefinition(activity, addedItems);
                        parentProxy.addChildDC(dcVendor, dcName);
                        parentModified = true;
                        try {
                            parentProxy._serializeDefinition();
                            parentBecameDirty = this.markDCasDirty(parentProxy, true, false);
                        }
                        catch (DevConfigException e) {
                            String msg = "Error updating parent definition: " + ((Throwable)((Object)e)).getMessage();
                            throw new CreateException(msg, (Throwable)((Object)e), 4);
                        }
                    }
                    try {
                        this.m_dtrConfiguration.saveAll();
                    }
                    catch (IOException e) {
                        String msg = "Error updating DTR client definition: " + e.getMessage();
                        throw new CreateException(msg, e, 4);
                    }
                    SyncMode syncMode = useInactiveWorkspace ? SyncMode.SYNCHED_AS_INACTIVE_SOURCE : SyncMode.SYNCHED_AS_ACTIVE_SOURCE;
                    entry = this.m_componentSyncDB.createEntry(compartmentName, dcName, dcVendor, SyncState._getLocalSourceSyncState(), syncMode);
                    entry.setActivityState(DCActivityState.CHECKED_OUT_FOR_CREATE);
                    entry.setDirty(true);
                    this.m_componentSyncDB.save();
                    DCProxy proxy = null;
                    try {
                        proxy = DCProxy.createDCProxyLocally(this, compartmentName, dcVendor, dcName);
                    }
                    catch (DevConfigException e) {
                        String msg = "Failed to initialize DC proxy from file after creation: " + ((Throwable)((Object)e)).getMessage();
                        throw new CreateException(msg, (Throwable)((Object)e), 4);
                    }
                    successfullyFinished = true;
                    HashSet<DevelopmentComponentNode> dirtyDCsSet = new HashSet<DevelopmentComponentNode>();
                    dirtyDCsSet.add(proxy._toNode());
                    if (parentBecameDirty && parentProxy != null) {
                        dirtyDCsSet.add(parentProxy._toNode());
                    }
                    this.notifyDCCreated(proxy);
                    this.notifyDCsDirty(dirtyDCsSet);
                    dCProxy = proxy;
                    Object var28_42 = null;
                    if (successfullyFinished) break block40;
                }
                catch (Throwable throwable) {
                    Object var28_43 = null;
                    if (!successfullyFinished) {
                        try {
                            this.m_vfsHandler.revertFilesFromActivity(addedItems);
                            if (entry != null) {
                                this.m_componentSyncDB.removeEntry(compartmentName, dcName, dcVendor);
                                this.m_componentSyncDB.save();
                            }
                            this.getDcProxyCache().remove(compartmentName, dcVendor, dcName, useInactiveWorkspace, false);
                            if (parentProxy != null && parentModified) {
                                if (parentCheckedOutByUs) {
                                    parentProxy.reloadDefinition();
                                } else {
                                    parentProxy.removeChildDC(dcVendor, dcName);
                                    parentProxy._serializeDefinition();
                                }
                                parentModified = false;
                            }
                        }
                        catch (VfsException e) {
                            LOCATION.catching(methodStr, (Throwable)e);
                            LOCATION.infoT(methodStr, "DC creation failed. Caught VfsException during cleanup, ignoring it {0}", new Object[]{e.getMessage()});
                        }
                        catch (DevConfigException e) {
                            LOCATION.catching(methodStr, (Throwable)((Object)e));
                            LOCATION.infoT(methodStr, "DC creation failed. Caught DevConfigException during cleanup, ignoring it {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
                        }
                        catch (RepositoryAccessException e) {
                            LOCATION.catching(methodStr, (Throwable)((Object)e));
                            LOCATION.infoT(methodStr, "DC creation failed. Caught RepositoryAccessException during cleanup, ignoring it {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
                        }
                        catch (InvalidDefinitionException e) {
                            LOCATION.catching(methodStr, (Throwable)((Object)e));
                            LOCATION.infoT(methodStr, "DC creation failed. Caught InvalidDefinitionException during cleanup, ignoring it {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
                        }
                    }
                    throw throwable;
                }
                try {
                    this.m_vfsHandler.revertFilesFromActivity(addedItems);
                    if (entry != null) {
                        this.m_componentSyncDB.removeEntry(compartmentName, dcName, dcVendor);
                        this.m_componentSyncDB.save();
                    }
                    this.getDcProxyCache().remove(compartmentName, dcVendor, dcName, useInactiveWorkspace, false);
                    if (parentProxy != null && parentModified) {
                        if (parentCheckedOutByUs) {
                            parentProxy.reloadDefinition();
                        } else {
                            parentProxy.removeChildDC(dcVendor, dcName);
                            parentProxy._serializeDefinition();
                        }
                        parentModified = false;
                    }
                }
                catch (VfsException e) {
                    LOCATION.catching(methodStr, (Throwable)e);
                    LOCATION.infoT(methodStr, "DC creation failed. Caught VfsException during cleanup, ignoring it {0}", new Object[]{e.getMessage()});
                }
                catch (DevConfigException e) {
                    LOCATION.catching(methodStr, (Throwable)((Object)e));
                    LOCATION.infoT(methodStr, "DC creation failed. Caught DevConfigException during cleanup, ignoring it {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
                }
                catch (RepositoryAccessException e) {
                    LOCATION.catching(methodStr, (Throwable)((Object)e));
                    LOCATION.infoT(methodStr, "DC creation failed. Caught RepositoryAccessException during cleanup, ignoring it {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
                }
                catch (InvalidDefinitionException e) {
                    LOCATION.catching(methodStr, (Throwable)((Object)e));
                    LOCATION.infoT(methodStr, "DC creation failed. Caught InvalidDefinitionException during cleanup, ignoring it {0}", new Object[]{((Throwable)((Object)e)).getMessage()});
                    {
                    }
                }
            }
            Object var34_52 = null;
            this.setComponentInWork(null);
            return dCProxy;
        }
        catch (Throwable throwable) {
            Object var34_53 = null;
            this.setComponentInWork(null);
            throw throwable;
        }
    }

    public void checkCreateComponentConditions(String compartmentName, String dcVendor, String dcName, String parentVendor, String parentName) throws SyncException, CreateException, CheckoutException, NameCheckException {
        IVfsActivityRecordedFolderItem arfItem;
        IVfsFolderItem dcDefFileItem;
        String dcdefURL;
        Compartment compartment;
        String methodStr = "checkCreateComponentConditions()";
        boolean isTopLevel = parentVendor == null || parentName == null;
        DCProxy parentProxy = null;
        FileSystemLayout fsLayout = new FileSystemLayout(this, compartmentName, dcVendor, dcName);
        if (this.isLocalConfiguration()) {
            String msg = "Cannot create a non-local component in a local-only configuration.";
            throw new CreateException(msg, null, 5);
        }
        if (!this.createDCAllowedForCompartment(compartmentName)) {
            throw new CreateException("Creation not allowed.", null, 5);
        }
        try {
            compartment = this.getCompartmentObject(compartmentName);
        }
        catch (DevconfInconsistencyException e) {
            String msg = "Illegal 'compartment' argument. Unknown compartment: " + compartmentName;
            throw new SyncException(msg, (Throwable)((Object)e), 25);
        }
        if (this.isDTRAccessDisabledForSC(compartment)) {
            String msg = "Creation of non-local components was disabled for compartment \"" + compartmentName + "\" because of authorization problems.";
            throw new CreateException(msg, null, 5);
        }
        NameChecker.checkCompartmentName((String)compartmentName);
        NameChecker.checkComponentName((String)dcName);
        NameChecker.checkVendorName((String)dcVendor);
        if (this.isDCAvailableLocally(compartmentName, dcVendor, dcName)) {
            String msg = "Component \"" + dcVendor + "/" + dcName + "\" already exists  in compartment \"" + compartmentName + "\"";
            throw new CreateException(msg, null, 1);
        }
        File dcdef = new File(fsLayout.getComponentDefinitionFile());
        if (dcdef.exists()) {
            String msg = "Component \"" + dcVendor + "/" + dcName + "\" seems to exist already. Component definition file found: " + dcdef.getAbsolutePath();
            throw new CreateException(msg, null, 1);
        }
        boolean fromInactive = this.getCompartmentObject(compartmentName).hasInactiveSourceState();
        try {
            String wsurl = this.getWorkspaceURL(compartmentName, !fromInactive);
            String relativeDCDef = this.getComponentDefinitionFile(this.m_devConfFileSystemLayout.getRelativeDCRoot(compartmentName, dcVendor, dcName));
            dcdefURL = Util.concatenatePath((String)wsurl, (String)relativeDCDef.replace('\\', '/'), (char)'/');
        }
        catch (DevConfigException e) {
            throw new SyncException("Internal Error: Cannot construct workspace URL for compartment : " + compartmentName + " (" + ((Throwable)((Object)e)).getMessage() + ")", (Throwable)((Object)e));
        }
        try {
            dcDefFileItem = this.m_vfsHandler.getFolderItemByURL(dcdefURL);
        }
        catch (VfsException e) {
            String m = "failed to check existence of DC remotely for  " + dcdefURL;
            throw DTRClientErrorMapper.toSyncException(m, (ClientLibraryException)e);
        }
        if (dcDefFileItem != null && (arfItem = dcDefFileItem.asActivityRecordedFolderItem()) != null && !arfItem.isDeleted()) {
            VfsFolderItemActivityState aState = arfItem.getActivityState();
            if (aState != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                String msg = "Component \"" + dcVendor + "/" + dcName + "\" seems to already exist. \"" + compartmentName + "\"" + NL + "DC definition file is checked out in state: " + aState + NL + "file:  " + dcdef.getAbsolutePath() + " URL: " + dcdefURL;
                throw new CreateException(msg, null, 1);
            }
            VfsFolderItemLocationState lstate = arfItem.getLocationState();
            if (lstate == VfsFolderItemLocationState.SERVER_ONLY) {
                String msg = "Component \"" + dcVendor + "/" + dcName + "\" already exists remotely in compartment \"" + compartmentName + "\"";
                throw new CreateException(msg, null, 1);
            }
        }
        if (!isTopLevel) {
            try {
                parentProxy = this._getDCProxyLocalOrActive(compartmentName, parentVendor, parentName);
            }
            catch (DevConfigException e) {
                String msg = "could not find the parent component \"" + parentVendor + "/" + parentName + "\" in compartment \"" + compartmentName + "\"";
                throw new CreateException(msg, (Throwable)((Object)e), 2);
            }
            if (parentProxy.getDCSyncMode() == DCNodeSyncMode.NOT_SYNCHED) {
                fromInactive = parentProxy.getCompartment().hasInactiveSourceState();
                LOCATION.debugT(methodStr, "Parent " + parentProxy + " is not synched. Trying to sync it.");
                parentProxy.syncAsSources(fromInactive, false);
                parentProxy.assertNotDeleted("Cannot create child component. Parent component seems to be already deleted.");
            } else {
                String msg;
                if (parentProxy.getDCSyncMode() == DCNodeSyncMode.LOCAL_ONLY) {
                    msg = "cannot create non-local component because parent component ( " + parentProxy.getVendor() + "/" + parentProxy.getName() + ")is local-only.";
                    throw new CreateException(msg, null, 3);
                }
                if (parentProxy.isSynchedAsModifiableSource()) {
                    String msg2;
                    parentProxy.assertNotDeleted("Cannot create child component. Parent component seems to be already deleted.");
                    String parentDefFile = parentProxy.getDefinitionPath();
                    IVfsFolderItem parentDCdefFolderItem = null;
                    try {
                        parentDCdefFolderItem = this.m_vfsHandler.getFolderItemForLocalPath(parentDefFile);
                    }
                    catch (VfsException e) {
                        String msg3 = "Cannot determine if parent dcdef file can be checked out: \"" + parentDefFile + "\"(" + e.getMessage() + ")";
                        throw new CheckoutException(msg3, null, 5, parentDefFile);
                    }
                    if (parentDCdefFolderItem == null) {
                        msg2 = "Cannot determine if parent dcdef file can be checked out: \"" + parentDefFile + "\"(VFS folder item is null)";
                        throw new CheckoutException(msg2, null, 5, parentDefFile);
                    }
                    if (parentDCdefFolderItem.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_FORMER) {
                        msg2 = "DC definition of parent DC " + parentProxy + " cannot be checked out (SYNCED_TO_FORMER).\n Make sure the parent DC is synched to the latest version.";
                        throw new CheckoutException(msg2, null, 4, parentDefFile);
                    }
                } else {
                    msg = "Parent component \"" + parentProxy.getVendor() + "/" + parentProxy.getName() + "\" must be synced as modifiable source. Current sync mode is " + parentProxy.getDCSyncMode();
                    throw new CreateException(msg, null, 3);
                }
            }
        }
    }

    public IDCProxy createLocalComponent(String compartmentName, String dcVendor, String dcName) throws SyncException, CreateException, NameCheckException {
        return this.createLocalComponent(compartmentName, dcVendor, dcName, null, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public IDCProxy createLocalComponent(String compartmentName, String dcVendor, String dcName, String parentVendor, String parentName) throws SyncException, CreateException, NameCheckException {
        block35: {
            block37: {
                methodStr = "createLocalComponent(String compartmentName,String dcVendor,String dcName,String parentVendor,String parentName)";
                DevelopmentConfiguration.LOCATION.debugT(methodStr, "compartmentName: {0}, dcVendor: {1}, dcName: {2}parentVendor: {3}, parentName: {4}", new Object[]{compartmentName, dcVendor, dcName, parentVendor, parentName});
                entry = null;
                proxy = null;
                parentProxy = null;
                parentBecameDirty = false;
                isTopLevel = parentVendor == null || parentName == null;
                fsLayout = new FileSystemLayout(this, compartmentName, dcVendor, dcName);
                this.checkCreateLocalComponentConditions(compartmentName, dcVendor, dcName, parentVendor, parentName);
                component = null;
                success = false;
                createdFiles = new HashSet<File>();
                paths = fsLayout.getDefaultFolders();
                i = 0;
                while (i < paths.length) {
                    file = new File(paths[i]);
                    isNew = file.exists();
                    file.mkdirs();
                    if (isNew) {
                        createdFiles.add(file);
                    }
                    ++i;
                }
                provider = new DCFileOutputProvider(this, compartmentName, dcVendor, dcName);
                component = ComponentFactory.createDevelopmentComponent((String)dcName, (String)dcVendor, (ComponentType)this.getInitialDCType());
                if (!isTopLevel) {
                    component.setEnclosingComponent(new DCReference(parentName, parentVendor));
                }
                try {
                    ComponentFactory.serialize((DevelopmentComponent)component, (DCOutputProvider)provider);
                }
                catch (IOException e) {
                    throw new CreateException("Error updating component definition: " + e.getMessage(), e, 4);
                }
                catch (ProviderException e) {
                    throw new CreateException("Error updating component definition: " + e.getMessage(), e, 4);
                }
                if (isTopLevel) {
                    this.insertTopLevelComponentEntry(compartmentName, dcVendor, dcName);
                } else {
                    try {
                        parentProxy = this._getDCProxyLocally(compartmentName, parentVendor, parentName);
                    }
                    catch (DevConfigException e) {
                        msg = "Creation failed. Cannot find parent component \"" + parentVendor + "/" + parentName + "\":" + e.getMessage();
                        throw new CreateException(msg, (Throwable)e, 2);
                    }
                    try {
                        parentProxy.addChildDC(dcVendor, dcName);
                        parentProxy._serializeDefinition();
                        parentBecameDirty = this.markDCasDirty(parentProxy, false, false);
                    }
                    catch (DevConfigException e) {
                        throw new CreateException("Error adding DC to the parent: " + e.getMessage(), (Throwable)e, 4);
                    }
                }
                entry = this.m_componentSyncDB.createEntry(compartmentName, dcName, dcVendor, SyncState._getLocalSourceSyncState(), SyncMode.LOCAL_ONLY);
                entry.setDirty(true);
                this.m_componentSyncDB.save();
                try {
                    proxy = DCProxy.createDCProxyLocally(this, compartmentName, dcVendor, dcName);
                }
                catch (DevConfigException e) {
                    throw new CreateException("Failed to initialize DC proxy from file after creation", (Throwable)e, 4);
                }
                success = true;
                dirtyDCsSet = new HashSet<DevelopmentComponentNode>();
                dirtyDCsSet.add(proxy._toNode());
                if (parentBecameDirty && parentProxy != null) {
                    dirtyDCsSet.add(parentProxy._toNode());
                }
                this.notifyDCsDirty(dirtyDCsSet);
                this.notifyDCCreated(proxy);
                var22_27 = null;
                if (success) break block35;
                try {
                    if (isTopLevel) {
                        this.removeTopLevelComponentEntry(compartmentName, dcVendor, dcName);
                    } else if (parentProxy != null) {
                        parentProxy.removeChildDC(dcVendor, dcName);
                        parentProxy._serializeDefinition();
                    }
                }
                catch (RemovalException e) {
                    DevelopmentConfiguration.LOCATION.catching(methodStr, (Throwable)e);
                    DevelopmentConfiguration.LOCATION.infoT(methodStr, "DC Creation failed. Caught exception during cleanup: " + e.getMessage());
                }
                catch (DevConfigException e /* !! */ ) {
                    DevelopmentConfiguration.LOCATION.catching(methodStr, (Throwable)e /* !! */ );
                    DevelopmentConfiguration.LOCATION.infoT(methodStr, "DC Creation failed. Caught exception during cleanup: " + e /* !! */ .getMessage());
                }
                delFileIter = createdFiles.iterator();
                while (delFileIter.hasNext()) {
                    try {
                        f = (File)delFileIter.next();
                        if (!f.exists()) continue;
                        f.delete();
                    }
                    catch (SecurityException e /* !! */ ) {
                        DevelopmentConfiguration.LOCATION.catching(methodStr, (Throwable)e /* !! */ );
                        DevelopmentConfiguration.LOCATION.infoT(methodStr, "DC Creation failed (access denied) during cleanup: " + e /* !! */ .getMessage());
                    }
                }
                if (entry != null) {
                    this.m_componentSyncDB.removeEntry(compartmentName, dcName, dcVendor);
                    this.m_componentSyncDB.save();
                }
                break block35;
                catch (Throwable var21_33) {
                    var22_28 = null;
                    if (success) break block37;
                    try {
                        if (isTopLevel) {
                            this.removeTopLevelComponentEntry(compartmentName, dcVendor, dcName);
                        } else if (parentProxy != null) {
                            parentProxy.removeChildDC(dcVendor, dcName);
                            parentProxy._serializeDefinition();
                        }
                    }
                    catch (RemovalException e) {
                        DevelopmentConfiguration.LOCATION.catching(methodStr, (Throwable)e);
                        DevelopmentConfiguration.LOCATION.infoT(methodStr, "DC Creation failed. Caught exception during cleanup: " + e.getMessage());
                    }
                    catch (DevConfigException e /* !! */ ) {
                        DevelopmentConfiguration.LOCATION.catching(methodStr, (Throwable)e /* !! */ );
                        DevelopmentConfiguration.LOCATION.infoT(methodStr, "DC Creation failed. Caught exception during cleanup: " + e /* !! */ .getMessage());
                    }
                    delFileIter = createdFiles.iterator();
                    ** while (delFileIter.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        f = (File)delFileIter.next();
                        if (!f.exists()) continue;
                        f.delete();
                    }
                    catch (SecurityException e /* !! */ ) {
                        DevelopmentConfiguration.LOCATION.catching(methodStr, (Throwable)e /* !! */ );
                        DevelopmentConfiguration.LOCATION.infoT(methodStr, "DC Creation failed (access denied) during cleanup: " + e /* !! */ .getMessage());
                    }
                    continue;
                }
lbl150:
                // 1 sources

                if (entry != null) {
                    this.m_componentSyncDB.removeEntry(compartmentName, dcName, dcVendor);
                    this.m_componentSyncDB.save();
                }
            }
            throw var21_33;
        }
        return proxy;
    }

    public void checkCreateLocalComponentConditions(String compartmentName, String dcVendor, String dcName, String parentVendor, String parentName) throws SyncException, CreateException, NameCheckException {
        File dcdef;
        boolean isTopLevel = parentVendor == null || parentName == null;
        DCProxy parentProxy = null;
        FileSystemLayout fsLayout = new FileSystemLayout(this, compartmentName, dcVendor, dcName);
        if (!this.createDCAllowedForCompartment(compartmentName)) {
            String m = "Creation of components is not allowed in compartment \"" + compartmentName + "\"";
            throw new CreateException(m, null, 5);
        }
        NameChecker.checkCompartmentName((String)compartmentName);
        NameChecker.checkComponentName((String)dcName);
        NameChecker.checkVendorName((String)dcVendor);
        if (this.isDCAvailableLocally(compartmentName, dcVendor, dcName)) {
            String msg = "Component \"" + dcVendor + "/" + dcName + "\" already exists in compartment \"" + compartmentName + "\"";
            throw new CreateException(msg, null, 1);
        }
        if (!isTopLevel) {
            try {
                parentProxy = this._getDCProxyLocalOrActive(compartmentName, parentVendor, parentName);
            }
            catch (DevConfigException e) {
                String msg = "could not find the parent component \"" + parentVendor + "/" + parentName + "\" in compartment \"" + compartmentName + "\"";
                throw new CreateException(msg, (Throwable)((Object)e), 2);
            }
            if (!parentProxy.isLocalOnly()) {
                String msg = "The parent of a new local-only component must also be local-only. parent is " + parentProxy + ". sync mode: " + parentProxy.getDCSyncMode();
                throw new CreateException(msg, null, 3);
            }
        }
        if ((dcdef = new File(fsLayout.getComponentDefinitionFile())).exists()) {
            throw new CreateException("Creation not allowed, component definition file \"" + dcdef.getAbsolutePath() + "\" already exists.", null, 1);
        }
    }

    public IDCProxy copyLocalComponent(String sourceRoot, String compartmentName, String dcVendor, String dcName) throws CreateException, FileNotFoundException, IOException {
        String methodStr = "copyLocalComponent(String sourceRoot,String compartmentName,String dcVendor,String dcName)";
        LOCATION.debugT(methodStr, "sourceRoot: {0}, compartmentName: {1}, dcVendor: {2}dcName: {3}", new Object[]{sourceRoot, compartmentName, dcVendor, dcName});
        DCProxy proxy = null;
        if (this.isDCAvailableLocally(compartmentName, dcVendor, dcName)) {
            throw new CreateException("Component \"" + dcVendor + "\"" + dcName + "\" already exists", null, 1);
        }
        String localDCroot = this.m_devConfFileSystemLayout.getRelativeDCRoot(compartmentName, dcVendor, dcName);
        String localDCpath = this.m_configRootDir + localDCroot;
        Util.copyFolderContent((String)(sourceRoot + localDCroot), (String)localDCpath);
        this.m_componentSyncDB.createEntry(compartmentName, dcName, dcVendor, SyncState._getLocalSourceSyncState(), SyncMode.LOCAL_ONLY);
        this.m_componentSyncDB.save();
        try {
            proxy = DCProxy.createDCProxyLocally(this, compartmentName, dcVendor, dcName);
        }
        catch (DevConfigException e) {
            throw new CreateException("copying DC failed. Could not initialize copy from file", null, 4);
        }
        return proxy;
    }

    public IDCProxy importComponentFromArchive(String compartmentName, String dcVendor, String dcName, InputStream source) throws CreateException, IOException, ZipException {
        String methodStr = "importComponentFromArchive(String compartmentName,String dcVendor,String dcName,InputStream source)";
        LOCATION.debugT(methodStr, "compartmentName: {0}, dcVendor: {1}, dcName: {2}source: {3}", new Object[]{compartmentName, dcVendor, dcName, source});
        DCProxy proxy = null;
        if (this.isDCAvailableLocally(compartmentName, dcVendor, dcName)) {
            throw new CreateException("Component \"" + dcVendor + "\"" + dcName + "\" already exists", null, 1);
        }
        this.m_componentSyncDB.createEntry(compartmentName, dcName, dcVendor, SyncState._getLocalSourceSyncState(), SyncMode.LOCAL_ONLY);
        this.m_componentSyncDB.save();
        try {
            proxy = DCProxy.createDCProxyFromArchive(this, compartmentName, dcVendor, dcName, source);
        }
        catch (DevConfigException e) {
            throw new CreateException("Failed to read component data from archive.", null, 4);
        }
        return proxy;
    }

    public IDCProxy createComponent(String scVendor, String scName, String dcVendor, String dcName, String parentVendor, String parentName, IVfsActivity activity) throws SyncException, CreateException, CheckoutException, NameCheckException {
        String compartmentID = this.getCompartmentNameFromSCName(scVendor, scName);
        if (compartmentID != null) {
            return this.createComponent(compartmentID, dcVendor, dcName, parentVendor, parentName, activity);
        }
        return null;
    }

    public IDCProxy createLocalComponent(String scVendor, String scName, String dcVendor, String dcName) throws SyncException, CreateException, NameCheckException {
        return this.createLocalComponent(scVendor, scName, dcVendor, dcName, null, null);
    }

    public IDCProxy createLocalComponent(String scVendor, String scName, String dcVendor, String dcName, String parentVendor, String parentName) throws SyncException, CreateException, NameCheckException {
        String compartmentID = this.getCompartmentNameFromSCName(scVendor, scName);
        if (compartmentID != null) {
            return this.createLocalComponent(compartmentID, dcVendor, dcName, parentVendor, parentName);
        }
        return null;
    }

    public IDCProxy createComponent(String scVendor, String scName, String dcVendor, String dcName, IVfsActivity activity) throws SyncException, CreateException, CheckoutException, NameCheckException {
        return this.createComponent(scVendor, scName, dcVendor, dcName, null, null, activity);
    }

    public IDevelopmentComponentInfo getDevelopmentComponentInfo(String compartmentID, String dcVendor, String dcName, String variantName) throws ChainedException {
        String methodStr = "getDevelopmentComponentInfo()";
        LOCATION.debugT(methodStr, "compartmentID: {0}, dcVendor: {1}, dcName: {2}, variantName: {3}", new Object[]{compartmentID, dcVendor, dcName, variantName});
        DevelopmentComponentInfo info = null;
        try {
            DevelopmentComponent component = ComponentFactory.initialize((DCInputProvider)new DCFileInputProvider(this, compartmentID, dcVendor, dcName));
            info = new DevelopmentComponentInfo(this, compartmentID, component, variantName);
        }
        catch (ProviderException e) {
            String m = "Failed to read component definition for \"" + compartmentID + ":" + dcVendor + "/" + dcName + "\":" + e.getMessage();
            throw new ChainedException(m, (Throwable)e);
        }
        catch (IOException e) {
            String m = "IO error parsing error occurred when reading component definition for \"" + compartmentID + ":" + dcVendor + "/" + dcName + "\":" + e.getMessage();
            throw new ChainedException(m, (Throwable)e);
        }
        catch (XMLException e) {
            String m = "XML parsing error occurred when reading component definition for \"" + compartmentID + ":" + dcVendor + "/" + dcName + "\":" + e.getMessage();
            throw new ChainedException(m, (Throwable)e);
        }
        return info;
    }

    public IDCProxy getDCProxy(String scVendor, String scName, String dcVendor, String dcName) {
        String thisMethod = "getDCProxy(String,String,String,String)";
        LOCATION.debugT(thisMethod, "scVendor: {0}, scName: {1}, dcVendor: {2}, dcName: {3}", new Object[]{scVendor, scName, dcVendor, dcName});
        String compartmentID = this.getCompartmentNameFromSCName(scVendor, scName);
        LOCATION.debugT(thisMethod, "found compartment: " + compartmentID);
        if (compartmentID != null) {
            return this.getDCProxy(compartmentID, dcVendor, dcName);
        }
        String m = "could not get DC proxy. compartment not found. DC: " + compartmentID + ":" + dcVendor + "/" + dcName;
        LOCATION.infoT(thisMethod, m);
        DevelopmentComponentNode node = new DevelopmentComponentNode(this, compartmentID, dcVendor, dcName, true);
        this.sendDCMessage(node, "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, m);
        return null;
    }

    public IDCProxy getDCProxy(String scVendor, String scName, String dcVendor, String dcName, boolean fromActiveWorkspace) {
        String thisMethod = "getDCProxy(String ,String ,String ,String ,boolean )";
        LOCATION.debugT(thisMethod, "scVendor: {0}, scName: {1}, dcVendor: {2}, dcName: {3},fromActiveWorkspace: {4}", new Object[]{scVendor, scName, dcVendor, dcName, new Boolean(fromActiveWorkspace)});
        String compartmentID = this.getCompartmentNameFromSCName(scVendor, scName);
        if (compartmentID != null) {
            try {
                return this._getDCProxy(compartmentID, dcVendor, dcName, fromActiveWorkspace);
            }
            catch (DevConfigException e) {
                LOCATION.catching(thisMethod, (Throwable)((Object)e));
                this.sendDCMessage(new DevelopmentComponentNode(this, compartmentID, dcVendor, dcName, true), "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, ((Throwable)((Object)e)).getMessage());
                return null;
            }
        }
        String m = "could not get DC proxy. compartment not found. DC: " + compartmentID + ":" + dcVendor + "/" + dcName;
        LOCATION.infoT(thisMethod, m);
        DevelopmentComponentNode node = new DevelopmentComponentNode(this, compartmentID, dcVendor, dcName, true);
        this.sendDCMessage(node, "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, m);
        return null;
    }

    public IDCProxy getDCProxy(String compartmentID, String dcVendor, String dcName) {
        try {
            return this._getDCProxyLocalOrActive(compartmentID, dcVendor, dcName);
        }
        catch (DevConfigException e) {
            LOCATION.catching("getDCProxy", (Throwable)((Object)e));
            this.sendDCMessage(new DevelopmentComponentNode(this, compartmentID, dcVendor, dcName, true), "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, ((Throwable)((Object)e)).getMessage());
            return null;
        }
    }

    public IDCProxy getDCProxy(String compartmentID, String dcVendor, String dcName, boolean fromActiveWorkspace) {
        try {
            return this._getDCProxy(compartmentID, dcVendor, dcName, fromActiveWorkspace);
        }
        catch (DevConfigException e) {
            LOCATION.catching("getDCProxy", (Throwable)((Object)e));
            this.sendDCMessage(new DevelopmentComponentNode(this, compartmentID, dcVendor, dcName, fromActiveWorkspace), "", DCMessageType.ERROR, DCEventType.GENERIC_DC_EVENT, ((Throwable)((Object)e)).getMessage());
            return null;
        }
    }

    public IDCProxy getUsedDCProxy(String referencingCompartment, DCReference dcref) throws SyncException {
        return this.getUsedDCProxy(referencingCompartment, dcref, false);
    }

    public IDCProxy getUsedDCProxy(String referencingCompartment, DCReference dcref, boolean searchRemoteInactive) throws SyncException {
        String thisMethod = "getUsedDCProxy(String referencingCompartment,DCReference dcref)";
        DCProxy proxy = null;
        String dcName = dcref.getName();
        String dcVendor = dcref.getVendor();
        String msg = "getUsedDCProxy called with parameters: this configuration {0}referenced DC vendor: {1}, referenced DC Name: {2}, referenced DC SCAlias: {3}searchRemoteInactive: {4}";
        LOCATION.debugT(thisMethod, msg, new Object[]{this.getName(), dcVendor, dcName, dcref.getSCAlias(), new Boolean(searchRemoteInactive)});
        String usedCompartment = null;
        usedCompartment = this.findCompartmentIDFromDCReference(referencingCompartment, dcref, searchRemoteInactive);
        if (usedCompartment == null) {
            String message = "Cannot find compartment of used component: " + dcVendor + ":" + dcName;
            throw new SyncException(message, null, 11, "<UNKNOWN>", dcName, dcVendor);
        }
        DevConfigException ex = null;
        try {
            proxy = this._getDCProxyLocalOrActive(usedCompartment, dcVendor, dcName);
        }
        catch (DevConfigException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            ex = e;
        }
        Compartment c = this.getCompartmentObject(usedCompartment);
        try {
            if (c.hasInactiveSourceState()) {
                proxy = this._getDCProxy(usedCompartment, dcVendor, dcName, false);
            }
        }
        catch (DevConfigException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            ex = e;
        }
        if (proxy == null) {
            String message = "Cannot get proxy for used component: " + dcVendor + ":" + dcName + "in compartment " + usedCompartment;
            throw new SyncException(message, (Throwable)((Object)ex), 11, usedCompartment, dcName, dcVendor);
        }
        return proxy;
    }

    public DevelopmentComponentNode getUsedDCNode(String referencingCompartment, DCReference dcref, boolean searchRemoteInactive) throws SyncException {
        String thisMethod = "getUsedDCNode()";
        String dcName = dcref.getName();
        String dcVendor = dcref.getVendor();
        String msg = "getUsedDCNode called with parameters: this configuration {0}referenced DC vendor: {1}, referenced DC Name: {2}, referenced DC SCAlias: {3}searchRemoteInactive: {4}";
        LOCATION.debugT(thisMethod, msg, new Object[]{this.getName(), dcVendor, dcName, dcref.getSCAlias(), new Boolean(searchRemoteInactive)});
        DevelopmentComponentStateRef ref = this.findDCState(referencingCompartment, dcref, searchRemoteInactive);
        if (ref == null) {
            String message = "Cannot find compartment of used component: " + dcVendor + ":" + dcName;
            throw new SyncException(message, null, 11, "<UNKNOWN>", dcName, dcVendor);
        }
        DevelopmentComponentNode node = new DevelopmentComponentNode(this, ref.getCompartment(), dcVendor, dcName, ref.isActive());
        return node;
    }

    public ComponentSyncDB getComponentSyncDB() {
        return this.m_componentSyncDB;
    }

    public List getCompartments() {
        ArrayList list = new ArrayList();
        Map compartmentMap = this.m_devconfObject.getCompartments();
        if (compartmentMap != null) {
            Set compartments = compartmentMap.keySet();
            list.addAll(compartments);
        }
        return list;
    }

    public List getCompartmentNodes() {
        if (this.m_compartmentNodes == null) {
            this.initializeCompartmentNodes();
        }
        return this.m_compartmentNodes;
    }

    public List getDevelopmentComponentNodes() {
        return this.getDevelopmentComponentNodes(false);
    }

    public List listLocallyAvailableDCs(String compartmentName) {
        LinkedList<IDevelopmentComponentNode> result = new LinkedList<IDevelopmentComponentNode>();
        List dcs = this.getDevelopmentComponentNodes();
        Iterator iter = dcs.iterator();
        while (iter.hasNext()) {
            IDevelopmentComponentNode dc = (IDevelopmentComponentNode)iter.next();
            if (!dc.getCompartmentName().equals(compartmentName)) continue;
            result.add(dc);
        }
        return result;
    }

    public IDCNodeResult getDevelopmentComponentNodesWithRefresh() {
        String thisMethod = "getDevelopmentComponentNodesWithRefresh";
        List list = this.getDevelopmentComponentNodes(false);
        Iterator it = list.iterator();
        LinkedList<ChainedException> exceptions = new LinkedList<ChainedException>();
        HashSet<DevelopmentComponentNode> nodes = new HashSet<DevelopmentComponentNode>();
        while (it.hasNext()) {
            DevelopmentComponentNode node = (DevelopmentComponentNode)it.next();
            nodes.add(node);
            DCProxy proxy = this.m_dcProxyCache.getDCProxyLocal(node.getCompartmentName(), node.getVendor(), node.getName());
            if (proxy == null) continue;
            try {
                proxy._reloadDefinition(false);
            }
            catch (DevConfigException e) {
                LOCATION.traceThrowableT(300, thisMethod, "Error when reloading component {0}", new Object[]{proxy}, (Throwable)((Object)e));
                exceptions.add(e);
            }
            catch (RepositoryAccessException e) {
                LOCATION.traceThrowableT(300, thisMethod, "Error when reloading component {0}", new Object[]{proxy}, (Throwable)((Object)e));
                exceptions.add(e);
            }
            catch (InvalidDefinitionException e) {
                LOCATION.traceThrowableT(300, thisMethod, "Error when reloading component {0}", new Object[]{proxy}, (Throwable)((Object)e));
                exceptions.add(e);
            }
        }
        return new DCNodeResult(nodes, exceptions);
    }

    public List getDevelopmentComponentNodes(boolean onlyIfDirty) {
        String thisMethod = "getDevelopmentComponentNodes()";
        ArrayList<DevelopmentComponentNode> list = new ArrayList<DevelopmentComponentNode>();
        Iterator iter = this.m_componentSyncDB.getEntriesKeySet().iterator();
        while (iter.hasNext()) {
            String dcVendor;
            String dcName;
            String key = (String)iter.next();
            DevelopmentComponentRef ref = this.m_componentSyncDB.getDCFromKey(key);
            if (ref == null) {
                IllegalStateException ex = new IllegalStateException("Unexpected state encountered when listing local DCs: no syncdb index entry found for key " + key);
                LOCATION.throwing(thisMethod, (Throwable)ex);
                throw ex;
            }
            String compartmentName = ref.getCompartment();
            IDCSyncEntry entry = this.m_componentSyncDB.getEntry(compartmentName, dcName = ref.getName(), dcVendor = ref.getVendor());
            if (entry == null) {
                IllegalStateException ex = new IllegalStateException("Unexpected state encountered when listing local DCs: no syncdb entry entry found for " + ref + " with key " + key);
                LOCATION.throwing(thisMethod, (Throwable)ex);
                throw ex;
            }
            if (entry.getMode().equals(SyncMode.NOT_SYNCHED)) {
                LOCATION.debugT(thisMethod, "skipping DC {0}. Found in syncdb but excluded because not synched", new Object[]{ref});
                continue;
            }
            if (onlyIfDirty && !entry.isDirty()) {
                LOCATION.debugT(thisMethod, "skipping DC {0}. Found in syncdb but excluded because not dirty (filter set for dirty DCs only)", new Object[]{ref});
                continue;
            }
            DCNodeSyncMode mode = DCNodeSyncMode.fromSyncMode(entry.getMode());
            Compartment compartment = this.getCompartmentObject(compartmentName);
            boolean isActive = DCProxy._isLocallyAvailableStateActive(mode, compartment);
            DevelopmentComponentNode node = new DevelopmentComponentNode(this, compartmentName, dcVendor, dcName, isActive);
            list.add(node);
        }
        return list;
    }

    public Set getLocalDCProxies(boolean onlyIfDirty, boolean onlySource, boolean onlyArchives) throws DevConfigException {
        HashSet<DCProxy> proxies = new HashSet<DCProxy>();
        Iterator iter = this.m_componentSyncDB.getEntriesKeySet().iterator();
        while (iter.hasNext()) {
            String dcVendor;
            String dcName;
            String compartmentName;
            IDCSyncEntry entry;
            String key = (String)iter.next();
            DevelopmentComponentRef ref = this.m_componentSyncDB.getDCFromKey(key);
            if (ref == null || (entry = this.m_componentSyncDB.getEntry(compartmentName = ref.getCompartment(), dcName = ref.getName(), dcVendor = ref.getVendor())) == null || entry.getMode().equals(SyncMode.NOT_SYNCHED) || onlyIfDirty && !entry.isDirty() || onlySource && !entry.isLocallyAvailableAsSource() || onlyArchives && !entry.isLocallyAvailableAsArchives()) continue;
            DCProxy proxy = this._getDCProxyLocally(compartmentName, dcVendor, dcName);
            proxies.add(proxy);
        }
        return proxies;
    }

    public com.sap.tc.complib.DevelopmentConfiguration getConfigurationData() {
        return this.m_devconfObject;
    }

    public List getCompartmentObjects() {
        ArrayList<Compartment> list = new ArrayList<Compartment>();
        Map compartmentMap = this.m_devconfObject.getCompartments();
        if (compartmentMap != null) {
            Iterator iter = compartmentMap.values().iterator();
            while (iter.hasNext()) {
                Compartment compartment = (Compartment)iter.next();
                list.add(compartment);
            }
        }
        return list;
    }

    public String getConfigurationRootFolder() {
        return this.m_configRootDir;
    }

    public List getAllowedBuildVariants(String compartment1, String buildVariant1, String compartment2) throws DevConfigException {
        return DevConfUtil.getAllowedBuildVariants(this.getDevConfObject(), buildVariant1, compartment1, compartment2);
    }

    public boolean isUsing(String compartment1, String compartment2) throws DevConfigException {
        return DevConfUtil.isUsing(this.getDevConfObject(), compartment1, compartment2);
    }

    public IClient getDTRClient() throws OfflineException {
        String thisMethod = "getDTRClient()";
        if (this.isLocalConfiguration()) {
            String m = "Illegal attempt to find the DTR client for local-only configuration " + this.getName();
            throw new OfflineException(m);
        }
        LOCATION.debugT(thisMethod, "getting DTR Client for dev conf {0} in folder {1}. returning client: {2}", new Object[]{this.getName(), this.getConfigurationRootFolder(), this.m_dtrClientDef == null ? null : this.m_dtrClientDef.getName()});
        return this.m_dtrClientDef;
    }

    IClient getClientDef() {
        return this.m_dtrClientDef;
    }

    String getCompartmentNameFromSCName(String scVendor, String scName) {
        String compartmentName = null;
        Compartment compartment = this.m_devconfObject.getDefaultCompartmentForSC(scVendor, scName);
        if (compartment != null) {
            compartmentName = compartment.getName();
        }
        return compartmentName;
    }

    String getCompartmentIDFromDCReference(String usingCompartment, DCReference dcRef) {
        String thisMethod = "getCompartmentIDFromDCReference(String usingCompartment, DCReference dcRef)";
        LOCATION.debugT(thisMethod, "usingCompartment: {0}, dcRef: {1}", new Object[]{usingCompartment, dcRef});
        if (dcRef.getSCAlias() != null) {
            return this.getCompartmentForSCAlias(usingCompartment, dcRef.getSCAlias());
        }
        return this.m_componentSyncDB.getCompartmentFor(dcRef.getName(), dcRef.getVendor());
    }

    String findCompartmentIDFromDCReference(String usingCompartment, DCReference dcRef) throws SyncException {
        return this.findCompartmentIDFromDCReference(usingCompartment, dcRef, false);
    }

    String findCompartmentIDFromDCReference(String usingCompartment, DCReference dcRef, boolean searchRemoteInactive) throws SyncException {
        if (LOCATION.beLogged(100)) {
            String thisMethod = "findCompartmentIDFromDCReference(String usingCompartment, DCReference dcRef)";
            LOCATION.debugT(thisMethod, "usingCompartment: {0}, dcRef: {1}", new Object[]{usingCompartment, dcRef});
        }
        if (dcRef.getSCAlias() != null) {
            return this.getCompartmentForSCAlias(usingCompartment, dcRef.getSCAlias());
        }
        DevelopmentComponentStateRef ref = this.findDCState(dcRef.getVendor(), dcRef.getName(), searchRemoteInactive);
        if (ref != null) {
            return ref.getCompartment();
        }
        return null;
    }

    DevelopmentComponentStateRef findDCState(String usingCompartment, DCReference dcRef, boolean searchRemoteInactive) throws SyncException {
        if (LOCATION.beLogged(100)) {
            String thisMethod = "findDCState(String usingCompartment, DCReference dcRef)";
            LOCATION.debugT(thisMethod, "usingCompartment: {0}, dcRef: {1}", new Object[]{usingCompartment, dcRef});
        }
        DevelopmentComponentStateRef ref = null;
        if (dcRef.getSCAlias() != null) {
            String compartment;
            try {
                compartment = this.getCompartmentForSCAliasChecked(usingCompartment, dcRef.getSCAlias());
            }
            catch (ConfigurationException e) {
                throw new SyncException("Bad SC Alias Mapping for alias " + dcRef.getSCAlias() + "from compartment " + usingCompartment + ": " + e.getMessage(), e, 36);
            }
            ref = new DevelopmentComponentStateRef(dcRef.getName(), dcRef.getVendor(), compartment, true);
        } else {
            ref = this.findDCState(dcRef.getVendor(), dcRef.getName(), searchRemoteInactive);
        }
        return ref;
    }

    DevelopmentComponentStateRef findDCState(String dcVendor, String dcName, boolean searchRemoteInactive) throws SyncException {
        String thisMethod = "findDCState(String usingCompartment, DCReference dcRef)";
        LOCATION.debugT(thisMethod, "usingCompartment: dcVendor: {0} dcName: {1}", new Object[]{dcVendor, dcName});
        if (!this.isValidNameVendorPair(dcVendor, dcName)) {
            return null;
        }
        DevelopmentComponentStateRef ref = null;
        String id = this.m_componentSyncDB.getCompartmentFor(dcName, dcVendor);
        if (id != null) {
            IDCSyncEntry entry = this.m_componentSyncDB.getEntry(dcName, dcVendor);
            if (entry == null) {
                String m = "Internal Error: DC unexpectedly not found in DC Syncdb: \"" + dcVendor + "/" + dcName + "\"";
                SyncException e = new SyncException(m, null, -1, id, dcVendor, dcName);
                LOCATION.debugT(thisMethod, m);
                throw e;
            }
            SyncMode mode = entry.getMode();
            boolean active = DCProxy._isLocallyAvailableStateActive(DCNodeSyncMode.fromSyncMode(mode), this.getCompartmentObject(id));
            ref = new DevelopmentComponentStateRef(dcName, dcVendor, id, active);
        } else {
            if (this.isInOfflineMode()) {
                String m = "cannot determine compartement of component \"" + dcVendor + "/" + dcName + "\". Not available locally and not online";
                throw new SyncException(m, null, 22, "UNKNOWN", dcVendor, dcName);
            }
            LOCATION.infoT(thisMethod, "Could not find compartment in DC syncdb. Searching on servers");
            boolean askedCBSAlready = false;
            if (this.isWithBuildServer()) {
                IBuildSpace bs = null;
                try {
                    try {
                        bs = this._getBuildSpaceProxy();
                    }
                    catch (NoBuildServerDefinedException e) {
                        String msg = "Cannot get compartment name from CBS. No CBS defined: " + ((Throwable)((Object)e)).getMessage();
                        throw new SyncException(msg, (Throwable)((Object)e), 11, "", dcName, dcVendor);
                    }
                    catch (OfflineException e) {
                        String msg = "Cannot get compartment name from CBS. Configuration not in online mode: " + ((Throwable)((Object)e)).getMessage();
                        throw new SyncException(msg, (Throwable)((Object)e), 11, "", dcName, dcVendor);
                    }
                    catch (DevConfigException e1) {
                        String message = ((Throwable)((Object)e1)).getMessage();
                        Object innerException = e1.getCause();
                        if (innerException == null) {
                            innerException = e1;
                        }
                        throw new SyncException(message, (Throwable)innerException, 43);
                    }
                    id = bs.getCompartment(dcVendor, dcName);
                }
                catch (UnknownDCException e) {
                    LOCATION.catching(thisMethod, (Throwable)e);
                    String msg = "Component " + dcVendor + "/" + dcName + " is not existing on the build server";
                    if (searchRemoteInactive) {
                        LOCATION.debugT(thisMethod, "{0}.Searching inactive state and ignore error: {1}", new Object[]{msg, e.getMessage()});
                        askedCBSAlready = true;
                    }
                    throw new SyncException(msg, e, 11, "UNKNOWN", dcName, dcVendor);
                }
                catch (UnknownBuildSpaceException e) {
                    String msg = "Cannot find used component " + dcVendor + "/" + dcName + " build space unknown on server: " + e.getMessage();
                    throw new SyncException(msg, e, 11, "", dcName, dcVendor);
                }
                catch (AuthorizationException e) {
                    String msg = "Cannot find used component " + dcVendor + "/" + dcName + ". Missing authorization on build server: " + e.getMessage();
                    throw new SyncException(msg, e, 11, "", dcName, dcVendor);
                }
                catch (InternalServerException e) {
                    String msg = "Cannot find used component " + dcVendor + "/" + dcName + ".Internal server error on build server: " + e.getMessage();
                    throw new SyncException(msg, e, 11, "", dcName, dcVendor);
                }
                catch (CBSServerException e) {
                    String msg = "Failed to get compartment name. CBS reports error: " + e.getMessage();
                    throw new SyncException(msg, e, 11, "", dcName, dcVendor);
                }
                catch (CommunicationException e) {
                    String msg = "Failed to get compartment name from CBS. Communication error." + e.getMessage();
                    throw new SyncException(msg, e, 11, "", dcName, dcVendor);
                }
            }
            if (id != null) {
                ref = new DevelopmentComponentStateRef(dcName, dcVendor, id, true);
            } else {
                LOCATION.infoT(thisMethod, "no CBS specified.Searching in repository workspaces");
                boolean inactive = askedCBSAlready;
                id = this.findCompartmentForDCInRepository(dcVendor, dcName, id, inactive);
                if (id != null) {
                    ref = new DevelopmentComponentStateRef(dcName, dcVendor, id, !inactive);
                }
            }
        }
        return ref;
    }

    private String findCompartmentForDCInRepository(String dcVendor, String dcName, String id, boolean onlyInactiveState) throws SyncException {
        String thisMethod = "findCompartmentForDCInRepository()";
        Map compartmentMap = this.m_devconfObject.getCompartments();
        if (compartmentMap == null) {
            String msg = "Configuration contains no compartments.";
            throw new SyncException(msg, null, 25);
        }
        Iterator it = compartmentMap.values().iterator();
        while (it.hasNext()) {
            Compartment compartment = (Compartment)it.next();
            if (!compartment.hasSourceState() || !compartment.IsDefaultCompartment() || onlyInactiveState && !compartment.hasInactiveSourceState()) continue;
            SourceState sourceState = compartment.getSourceState();
            String location = onlyInactiveState ? ConfigUtils.getInactiveLocation(sourceState) : ConfigUtils.getLocation(sourceState);
            String remotePath = this.m_repositoryLayout.calculateRemoteDCRoot(dcVendor, dcName);
            String urlString = Util.concatenatePath((String)sourceState.getRepository().getURL(), (String)location, (char)'/');
            urlString = Util.concatenatePath((String)urlString, (String)remotePath, (char)'/');
            LOCATION.debugT(thisMethod, "Searching for DC {0}/{1} in compartment {2} using URL {3} ", new Object[]{dcVendor, dcName, compartment.getName(), urlString});
            try {
                if (this.m_vfsHandler.getFolderItemByURL(urlString) == null) continue;
                LOCATION.debugT(thisMethod, "DC found in compartment (getFolderItemByURL) " + compartment.getName());
                id = compartment.getName();
                break;
            }
            catch (VfsException e) {
                String message = "Cannot find compartment for DC " + dcVendor + "/" + dcName + NL + "  Caught VFS error when searching in repository with url " + urlString;
                throw new SyncException(message, e, 100);
            }
        }
        return id;
    }

    IBuildSpace _getBuildSpaceProxy() throws DevConfigException {
        String thisMessage = "_getBuildSpaceProxy()";
        if (this.m_buildSpaceProxy != null) {
            return this.m_buildSpaceProxy;
        }
        if (!this.isWithBuildServer()) {
            String m = "Illegal attempt to get a build space proxy, but no build server is defined for configuration " + this.getName();
            throw new NoBuildServerDefinedException(m);
        }
        if (this.isInOfflineMode()) {
            String m = "Illegal attempt to get a build space proxy in offline mode " + this.getName();
            throw new OfflineException(m);
        }
        DevelopmentConfigurationFactory f = DevelopmentConfigurationFactory.getInstance();
        LOCATION.infoT(thisMessage, "No build space proxy found in online mode (null). Try to recover ...");
        f.initializeBuildSpaceProxy(this, this.m_connectionContext);
        return this.m_buildSpaceProxy;
    }

    public String getName() {
        return this.m_devconfObject.getName();
    }

    String getCompartmentForSCAliasChecked(String compartmentName, String scAlias) throws ConfigurationException {
        LOCATION.debugT("getCompartmentForSCAlias()", "compartmentName: {0}, scAlias: {1}", new Object[]{compartmentName, scAlias});
        String targetCompartmentName = null;
        Compartment compartment = this.m_devconfObject.getCompartmentByAlias(compartmentName, scAlias);
        targetCompartmentName = compartment.getName();
        return targetCompartmentName;
    }

    String getCompartmentForSCAlias(String compartmentName, String scAlias) {
        String methodStr = "getCompartmentForSCAlias(String compartmentName, String scAlias)";
        LOCATION.debugT("getCompartmentForSCAlias", "compartmentName: {0}, scAlias: {1}", new Object[]{compartmentName, scAlias});
        String targetCompartmentName = null;
        try {
            Compartment compartment = this.m_devconfObject.getCompartmentByAlias(compartmentName, scAlias);
            targetCompartmentName = compartment.getName();
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(300, methodStr, "failed to get compartment for SC alias \"{0}\". Using compartment is \"{1}\"", new Object[]{scAlias, compartmentName}, (Throwable)e);
        }
        return targetCompartmentName;
    }

    String getUsedBuildVariant(String usingCompartment, String usedCompartment, String buildVariant) {
        return DevConfUtil.getUsedBuildVariant(this.getDevConfObject(), usingCompartment, usedCompartment, buildVariant);
    }

    List getUsingBuildVariants(String usingCompartment, String usedCompartment, String usedBuildVariant) throws DevConfigException {
        return DevConfUtil.getUsingBuildVariants(this.getDevConfObject(), usingCompartment, usedCompartment, usedBuildVariant);
    }

    public IVfsWorkspace getWorkspaceOfCompartment(String compartmentName, boolean isActive) throws RepositoryAccessException, DevConfigException {
        return this.getWorkspaceFromCompartmentID(compartmentName, isActive);
    }

    IVfsWorkspace getWorkspaceFromCompartmentID(String compartmentID, boolean isActive) throws RepositoryAccessException, DevConfigException {
        String thisMethod = "getWorkspaceFromCompartmentID(String compartmentID, boolean isActive))";
        LOCATION.debugT(thisMethod, "compartmentID: {0}, isActive: {1}", new Object[]{compartmentID, new Boolean(isActive)});
        IVfsWorkspace ws = null;
        String fullUrl = this.getWorkspaceURL(compartmentID, isActive);
        try {
            ws = this.m_vfsHandler.getWorkspaceByUrl(fullUrl);
            if (ws == null) {
                String msg = "cannot get VFS workspace (vfs returned null) for URL " + fullUrl;
                throw new DevConfigException(msg);
            }
            return ws;
        }
        catch (VfsException e) {
            throw new RepositoryAccessException("Exception getting workspace by URL:" + e.getMessage(), e);
        }
    }

    String getWorkspaceURL(String compartmentID, boolean isActive) throws DevConfigException {
        String thisMethod = "getWorkspaceURL()";
        SourceState s = this.getSourceState(compartmentID);
        if (s == null) {
            String msg = "compartment " + compartmentID + " has no source state!";
            throw new DevConfigException(msg);
        }
        String url = this.getRepositoryURL(s);
        LOCATION.debugT(thisMethod, "getting workspace in repository: " + url);
        String wsname = this.getWorkspaceName(s, !isActive, compartmentID);
        LOCATION.debugT(thisMethod, "found workspace : " + wsname);
        String fullUrl = Util.concatenatePath((String)url, (String)wsname, (char)'/');
        return fullUrl;
    }

    public VFSHandler getVFSHandler() {
        return this.m_vfsHandler;
    }

    public DevConfFileSystemLayout getDevConfFSL() {
        return this.m_devConfFileSystemLayout;
    }

    public String getBuildServer() {
        return this.m_devconfObject.getBuildServer();
    }

    public IBuildSpace getBuildSpace() {
        return this.m_buildSpaceProxy;
    }

    public void setBuildSpace(IBuildSpace buildSpace) {
        this.m_buildSpaceProxy = buildSpace;
    }

    public boolean isWithBuildServer() {
        return this.getBuildServer() != null && !this.m_doNotUseCBSevenIfConfigured && this.m_operationMode != DevConfOperationMode.LOCAL_ONLY;
    }

    com.sap.tc.complib.DevelopmentConfiguration getDevConfObject() {
        return this.m_devconfObject;
    }

    String getWorkspaceName(SourceState sourceState, boolean forDevelopment, String compartmentName) throws DevConfigException {
        String wsname;
        String thisMethod = "getWorkspaceName(SourceState sourceState,boolean forDevelopment,String compartmentName)";
        LOCATION.debugT(thisMethod, "sourceState: {0}, forDevelopment: {1}, compartmentName: {2}", new Object[]{sourceState, new Boolean(forDevelopment), compartmentName});
        if (forDevelopment) {
            if (sourceState.getType() != 0) {
                String message = "Getting name of workspace for development failed. There is no inactive workspace configured for compartment " + compartmentName;
                throw new DevConfigException(message);
            }
            wsname = ConfigUtils.getInactiveLocation(sourceState);
            if (wsname == null) {
                String message = "Getting name workspace name failed. There is no such workspace configured for compartment " + compartmentName;
                throw new DevConfigException(message);
            }
        } else {
            wsname = ConfigUtils.getLocation(sourceState);
            if (wsname == null) {
                String message = "Getting name workspace name failed. There is no such workspace configured for compartment " + compartmentName;
                throw new DevConfigException(message);
            }
        }
        return wsname;
    }

    SourceState getSourceState(String compartmentName) {
        Compartment compartment = this.getCompartmentObject(compartmentName);
        SourceState result = compartment.getSourceState();
        return result;
    }

    Compartment getCompartmentObject(String name) throws DevconfInconsistencyException {
        Map compartments = this.m_devconfObject.getCompartments();
        if (compartments == null) {
            throw new DevconfInconsistencyException("compartment " + name + " does not exist");
        }
        Compartment compartment = (Compartment)compartments.get(name);
        if (compartment == null) {
            throw new DevconfInconsistencyException("compartment " + name + " does not exist");
        }
        return compartment;
    }

    private String getRepositoryURL(SourceState s) {
        Repository rep = s.getRepository();
        String url = rep.getURL();
        return url;
    }

    boolean isDCAvailableLocally(String compartmentID, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return !syncEntry.getMode().equals(SyncMode.NOT_SYNCHED);
    }

    boolean isDCAvailableLocallyAsSource(String compartmentID, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        Compartment comp = this.getCompartmentObject(compartmentID);
        SyncMode mode = syncEntry.getMode();
        SyncState state = this.getSyncState(compartmentID, dcVendor, dcName);
        return mode.equals(SyncMode.SYNCHED_AS_ACTIVE_SOURCE) || mode.equals(SyncMode.SYNCHED_AS_INACTIVE_SOURCE) || mode.equals(SyncMode.SYNCHED_AS_ARCHIVE) && comp.isModificationAllowed() && comp.getSourceState().isLocationChangeable() || mode.equals(SyncMode.LOCAL_ONLY) && !state.equals(SyncState.INSTALLED);
    }

    int getLocalAvailability(String compartmentID, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry;
        if (LOCATION.beLogged(100)) {
            String thisMethod = "getLocalAvailability()";
            LOCATION.debugT(thisMethod, "compartmentID: {0} dcVendor: {0} dcName: {0}", new Object[]{compartmentID, dcVendor, dcName});
        }
        if ((syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor)) == null) {
            return DC_NOT_AVAILABLE_LOCALLY;
        }
        SyncMode mode = syncEntry.getMode();
        int result = DC_NOT_AVAILABLE_LOCALLY;
        if (mode.equals(SyncMode.LOCAL_ONLY)) {
            SyncState state = this.getSyncState(compartmentID, dcVendor, dcName);
            result = state == SyncState.INSTALLED ? DC_AVAILABLE_AS_ARCHIVES : DC_AVAILABLE_AS_SOURCE;
        } else if (mode.equals(SyncMode.NOT_SYNCHED)) {
            result = DC_NOT_AVAILABLE_LOCALLY;
        } else if (mode.equals(SyncMode.SYNCHED_AS_ACTIVE_SOURCE)) {
            result = DC_AVAILABLE_AS_SOURCE;
        } else if (mode.equals(SyncMode.SYNCHED_AS_INACTIVE_SOURCE)) {
            result = DC_AVAILABLE_AS_SOURCE;
        } else if (mode.equals(SyncMode.SYNCHED_AS_ARCHIVE)) {
            result = DC_AVAILABLE_AS_ARCHIVES;
        }
        return result;
    }

    boolean isDCInstalledAsArchives(String compartmentID, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return syncEntry.getMode().equals(SyncMode.LOCAL_ONLY) && this.getSyncState(compartmentID, dcVendor, dcName).equals(SyncState.INSTALLED);
    }

    boolean isDCLocalOnly(String compartmentID, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return syncEntry.getMode().equals(SyncMode.LOCAL_ONLY);
    }

    boolean isDCSynced(String compartmentID, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return !syncEntry.getMode().equals(SyncMode.NOT_SYNCHED) && !syncEntry.getMode().equals(SyncMode.LOCAL_ONLY);
    }

    boolean isVariantAvailable(String compartmentID, String dcVendor, String dcName, String buildVariant) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return syncEntry.isAvailable(buildVariant);
    }

    boolean isDCSyncedAsSource(String compartmentID, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return syncEntry.getMode().equals(SyncMode.SYNCHED_AS_ACTIVE_SOURCE) || syncEntry.getMode().equals(SyncMode.SYNCHED_AS_INACTIVE_SOURCE);
    }

    boolean isDCSyncedAsArchive(String compartmentID, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentID, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return syncEntry.getMode() == SyncMode.SYNCHED_AS_ARCHIVE;
    }

    void removeMountPointForDC(String compartmentName, String dcVendor, String dcName) throws SyncException {
        String methodStr = "removeMountPointForDC(String compartmentName, String dcVendor, String dcName)";
        LOCATION.debugT(methodStr, "compartmentName: {0}, dcVendor: {1}, dcName: {2}", new Object[]{compartmentName, dcVendor, dcName});
        String localDCroot = this.m_devConfFileSystemLayout.getRelativeDCRoot(compartmentName, dcVendor, dcName);
        String localDCpath = this.m_configRootDir + localDCroot;
        try {
            this.m_vfsHandler.removeMountPointForLocalPath(localDCpath);
        }
        catch (IOException e) {
            throw new SyncException("Unable to save DTR configuration settings after removing mount point:" + e.getMessage(), e, 112);
        }
        catch (VfsException e) {
            throw DTRClientErrorMapper.toSyncException("Unable to remove DTR mount point for \"" + localDCroot + "\"", (ClientLibraryException)e);
        }
    }

    void removeMountPoints(IMountPoint[] mps) throws SyncException {
        try {
            this.m_vfsHandler.removeMountPoints(mps);
        }
        catch (IOException e) {
            throw new SyncException("Unable to save DTR configuration settings after removing mount points:" + e.getMessage(), e, 112);
        }
        catch (VfsException e) {
            throw DTRClientErrorMapper.toSyncException("Failed to remove DTR mount points", (ClientLibraryException)e);
        }
    }

    void removeMountPoint(IMountPoint mp) throws SyncException {
        try {
            this.m_vfsHandler.removeMountPoint(mp);
        }
        catch (IOException e) {
            throw new SyncException("Unable to save DTR configuration settings after removing mount point:" + e.getMessage(), e, 112);
        }
        catch (VfsException e) {
            throw DTRClientErrorMapper.toSyncException("Unable to remove DTR mount point \"" + mp.getRelativeLocalRoot() + "\"", (ClientLibraryException)e);
        }
    }

    public IMountPoint getMountPointForDC(String compartmentName, String dcVendor, String dcName) throws SyncException {
        String localDCpath = this.m_devConfFileSystemLayout.getAbsoluteDCRoot(compartmentName, dcVendor, dcName);
        return this.m_dtrClientDef.getMountPointForLocalPath(localDCpath);
    }

    boolean findOrCreateMountPointForDC(String compartmentName, String dcVendor, String dcName, boolean inactive, boolean forceCreation) throws SyncException {
        String remoteDCpath;
        IMountPoint mp = null;
        String methodStr = "findOrCreateMountPointForDC(String compartmentName, String dcVendor, String dcName, boolean forDevelopment, boolean forceCreation)";
        LOCATION.debugT(methodStr, "compartmentName: {0}, dcVendor: {1}, dcName: {2}, inactive: {3}, forceCreation: {4}", new Object[]{compartmentName, dcVendor, dcName, new Boolean(inactive), new Boolean(forceCreation)});
        SourceState sourceState = this.getSourceState(compartmentName);
        if (sourceState == null) {
            String msg = "No source state availablefor compartment " + compartmentName;
            throw new SyncException(msg, null, 6);
        }
        Repository reposInfo = sourceState.getRepository();
        String localDCroot = this.m_devConfFileSystemLayout.getRelativeDCRoot(compartmentName, dcVendor, dcName);
        String localDCpath = this.m_configRootDir + localDCroot;
        String remoteDCroot = this.m_repositoryLayout.calculateRemoteDCRoot(dcVendor, dcName);
        try {
            remoteDCpath = Util.concatenatePath((String)this.getWorkspaceName(sourceState, inactive, compartmentName), (String)remoteDCroot, (char)'/');
        }
        catch (DevConfigException e) {
            String m = "cannot construct remote path for " + remoteDCroot + ". Cannot determine workspace name: " + ((Throwable)((Object)e)).getMessage();
            throw new SyncException(m, (Throwable)((Object)e), 42);
        }
        IRepositoryServer server = this.m_vfsHandler.findOrCreateRepositoryServer(reposInfo);
        if (server != null) {
            mp = this.m_dtrClientDef.getMountPointForLocalPath(localDCpath);
            if (mp != null && !mp.getRelativeRemoteRoot().equals(remoteDCpath)) {
                try {
                    if (this.m_vfsHandler.isSomethingCheckedOutUnderLocalPath(localDCpath)) {
                        throw new SyncException("Some source for development component are checked out", null);
                    }
                    this.m_vfsHandler.removeLocalPath(localDCpath);
                    this.m_vfsHandler.removeMountPointForLocalPath(localDCpath);
                    mp = null;
                }
                catch (IOException e) {
                    throw new SyncException("Unable to save DTR configuration settings after removing mount point:" + e.getMessage(), e, 112);
                }
                catch (VfsException e) {
                    throw DTRClientErrorMapper.toSyncException("Unable to remove DTR mount point \"" + localDCpath + "\"", (ClientLibraryException)e);
                }
            }
            if (mp == null) {
                mp = this.m_vfsHandler.findOrCreateMountPoint(localDCpath, server, localDCroot, remoteDCpath);
            }
            if (mp != null) {
                try {
                    mp.assureLocalPathExists();
                }
                catch (com.tssap.dtr.client.lib.vfs.config.ConfigurationException e) {
                    String msg = "Unable to create local path \"" + localDCroot + "\"for component moint point";
                    throw DTRClientErrorMapper.toSyncException(msg, (ClientLibraryException)e);
                }
            }
            if (mp != null && forceCreation) {
                try {
                    mp.assureRemotePathExists();
                }
                catch (com.tssap.dtr.client.lib.vfs.config.ConfigurationException e) {
                    String msg = "Unable to create remote path \"" + remoteDCpath + "\" for component moint point";
                    throw DTRClientErrorMapper.toSyncException(msg, (ClientLibraryException)e);
                }
            }
            this.m_vfsHandler.checkRemotePath(server, remoteDCpath);
        }
        return mp != null;
    }

    boolean findOrCreateMountPointForSC(String compartmentName, boolean useInactiveWorkspace) throws SyncException {
        IMountPoint mp = null;
        Compartment compartment = this.getCompartmentObject(compartmentName);
        String methodStr = "findOrCreateMountPointForSC(String compartmentName)";
        LOCATION.debugT(methodStr, "compartmentName: {0}", new Object[]{compartmentName});
        try {
            SourceState sourceState = this.getSourceState(compartmentName);
            Repository reposInfo = sourceState.getRepository();
            String localSCroot = this.m_devConfFileSystemLayout.getRelativeSCRoot(compartmentName);
            String localSCpath = this.m_configRootDir + localSCroot;
            String remoteSCroot = this.m_repositoryLayout.calculateRemoteSCRoot(compartment.getScVendor(), compartment.getScName());
            String remoteSCpath = Util.concatenatePath((String)this.getWorkspaceName(sourceState, useInactiveWorkspace, compartmentName), (String)remoteSCroot, (char)'/');
            IRepositoryServer server = this.m_vfsHandler.findOrCreateRepositoryServer(reposInfo);
            if (server != null && (mp = this.m_dtrClientDef.getMountPointForLocalPath(localSCpath)) == null && (mp = this.m_vfsHandler.findOrCreateMountPoint(localSCpath, server, localSCroot, remoteSCpath)) != null) {
                String toplevelDCsPath = Util.concatenatePath((String)remoteSCpath, (String)"TopLevelDCs", (char)'/');
                if (!toplevelDCsPath.endsWith("/")) {
                    toplevelDCsPath = toplevelDCsPath + "/";
                }
                mp.getRepositoryServer().assureRemotePathExists(toplevelDCsPath);
                mp.assureLocalPathExists();
            }
        }
        catch (com.tssap.dtr.client.lib.vfs.config.ConfigurationException e) {
            throw DTRClientErrorMapper.toSyncException("Could not create mountpoint for SC in compartment " + compartmentName, (ClientLibraryException)e);
        }
        catch (DevConfigException e) {
            String message = "Could not create mountpoint for SC in compartment " + compartmentName + ": " + ((Throwable)((Object)e)).getMessage();
            throw new SyncException(message, (Throwable)((Object)e), 42);
        }
        return mp != null;
    }

    boolean findOrCreateMountPointForSC(String compartmentName) throws SyncException {
        return this.findOrCreateMountPointForSC(compartmentName, true);
    }

    public DCNodeSyncMode calculateSyncModeForDC(String compartmentName, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentName, dcName, dcVendor);
        if (syncEntry == null) {
            return DCNodeSyncMode.NOT_SYNCHED;
        }
        SyncMode s = syncEntry.getMode();
        return DCNodeSyncMode.fromSyncMode(s);
    }

    public DCActivityState getActivityStateForDC(String compartmentName, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentName, dcName, dcVendor);
        if (syncEntry == null) {
            return DCActivityState.NONE;
        }
        return syncEntry.getActivityState();
    }

    public DCNodeSyncState calculateSyncStateForDC(String compartmentName, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentName, dcName, dcVendor);
        if (syncEntry == null) {
            return DCNodeSyncState.UNKNOWN;
        }
        SyncState s = this.getSyncState(compartmentName, dcVendor, dcName);
        return DCNodeSyncState.fromSyncState(s);
    }

    String concatenatePath(String part1, String part2, char separator) {
        String result = part1.charAt(part1.length() - 1) == separator ? part1 + part2 : part1 + separator + part2;
        return result;
    }

    String[] getDefaultFolders(String localDCpath) {
        String[] paths = new String[]{localDCpath + "cfg", localDCpath + "def", localDCpath + "src", localDCpath + "test"};
        return paths;
    }

    String getComponentDefinitionFile(String localDCpath) {
        return localDCpath + ".dcdef";
    }

    void addTopLevelComponentEntry(String compartmentName, String dcVendor, String dcName, IVfsActivity activity, Set addedItems) throws SyncException, CheckoutException, CreateException {
        String methodStr = "addTopLevelComponentEntry(String compartmentName, String dcVendor, String dcName, IVfsActivity activity)";
        LOCATION.debugT(methodStr, "compartmentName: {0}, dcVendor: {1}, dcName: {2}, activity: {3}", new Object[]{compartmentName, dcVendor, dcName, activity});
        String folderName = this.m_devConfFileSystemLayout.getAbsoluteTopLevelDCsRoot(compartmentName);
        Compartment compartment = this.getCompartmentObject(compartmentName);
        boolean useInactiveWorkspace = compartment.hasInactiveSourceState();
        if (this.findOrCreateMountPointForSC(compartmentName, useInactiveWorkspace)) {
            this.m_vfsHandler.syncLocalPath(this.m_devConfFileSystemLayout.getAbsoluteSCRoot(compartmentName));
            try {
                File file = new File(folderName + this.m_devConfFileSystemLayout.calculateTopLevelDCRefFileName(dcVendor, dcName));
                String[] paths = new String[]{folderName};
                activity = this.m_vfsHandler.createAndCheckoutFolders(activity, paths, addedItems);
                if (!file.exists()) {
                    file.createNewFile();
                }
                String[] filePaths = new String[]{file.getCanonicalPath()};
                activity = this.m_vfsHandler.addNewFilesToActivity(activity, filePaths, addedItems);
            }
            catch (IOException e) {
                throw new CreateException("Failed to add reference into list of top level DCs of the software component: " + e.getMessage(), e, 4);
            }
        }
    }

    void insertTopLevelComponentEntry(String compartmentName, String dcVendor, String dcName) throws CreateException {
        String methodStr = "insertTopLevelComponentEntry()";
        String folderName = this.m_devConfFileSystemLayout.getAbsoluteTopLevelDCsRoot(compartmentName);
        File folder = new File(folderName);
        File file = new File(folderName + this.m_devConfFileSystemLayout.calculateTopLevelDCRefFileName(dcVendor, dcName));
        try {
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            String m = "Error creating top level DC entry in SC folder. Cannot create file \"" + file + "\": " + e.getMessage();
            throw new CreateException(m, e, 4);
        }
    }

    void removeTopLevelComponentEntry(String compartmentName, String dcVendor, String dcName) throws RemovalException {
        String methodStr = "removeTopLevelComponentEntry()";
        String folderName = this.m_devConfFileSystemLayout.getAbsoluteTopLevelDCsRoot(compartmentName);
        File folder = new File(folderName);
        File file = new File(folderName + this.m_devConfFileSystemLayout.calculateTopLevelDCRefFileName(dcVendor, dcName));
        try {
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
        }
        catch (SecurityException e) {
            String m = "Error removing top level DC entry from SC folder. Cannot remove file \"" + file + "\": " + e.getMessage();
            throw new RemovalException(m, e, 4);
        }
    }

    boolean createDCAllowedForCompartment(String compartmentName) {
        Compartment compartment = this.getCompartmentObject(compartmentName);
        return compartment.isModificationAllowed();
    }

    DevelopmentComponent initializeDCFromBuildServer(String compartmentName, String dcVendor, String dcName) throws DevConfigException {
        DevelopmentComponent dc;
        String thisMethod = "initializeDCFromBuildServer(String,String,String)";
        LOCATION.debugT(thisMethod, "compartment:{0} dcVendor:{1} dcName: {2}\t\t", new Object[]{compartmentName, dcName, dcVendor});
        if (!this.isWithBuildServer()) {
            String msg = "no build server defined for configuration " + this.getName();
            throw new NoBuildServerDefinedException(msg);
        }
        String buildVariant = this.getDefaultBuildVariant(compartmentName);
        try {
            DCArchivePoolInputProvider provider = new DCArchivePoolInputProvider(this, compartmentName, dcVendor, dcName, buildVariant);
            dc = ComponentFactory.initialize((DCInputProvider)provider, (boolean)true);
        }
        catch (IOException e) {
            String msg = "Failed to read DC definition files: IO Error " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
        catch (XMLException e) {
            String msg = "Failed to read DC definition files: XML Error: " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
        catch (ProviderException e) {
            String msg = "Failed to read DC definition files: DC input provider error: ";
            Throwable innerEx = e.getCause();
            msg = innerEx != null ? msg + innerEx.getMessage() : msg + e.getMessage();
            throw new DevConfigException(msg, e);
        }
        return dc;
    }

    private void createMountPointsForSCs() throws SyncException {
        String thisMethod = "createMountPointsForSCs()";
        Map comps = this.m_devconfObject.getCompartments();
        if (comps != null) {
            Iterator iter = comps.values().iterator();
            while (iter.hasNext()) {
                Compartment comp = (Compartment)iter.next();
                if (!comp.isModificationAllowed()) continue;
                boolean forInactiveWorkspace = comp.hasInactiveSourceState();
                try {
                    this.findOrCreateMountPointForSC(comp.getName(), forInactiveWorkspace);
                    this.enableDTRAccessForSC(comp);
                }
                catch (SyncException e) {
                    LOCATION.catching(thisMethod, (Throwable)((Object)e));
                    if (e.getErrorCode() == 403) {
                        String m = "User is not authorized to mount or create SC Folder for " + comp.getName() + ". Disabling the compartment for remote access.";
                        LOCATION.infoT(thisMethod, m);
                        this.disableDTRAccessForSC(comp);
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    private void disableDTRAccessForSC(Compartment comp) {
        this.m_disabledCompartments.add(comp);
    }

    private void enableDTRAccessForSC(Compartment comp) {
        this.m_disabledCompartments.remove(comp);
    }

    public boolean isDTRAccessDisabledForSC(Compartment comp) {
        return this.m_disabledCompartments.contains(comp);
    }

    private void initializeDefaultVariants() {
        String thisMethod = "initializeDefaultVariants()";
        this.m_defaultBuildVariants = new HashMap();
        Map comps = this.m_devconfObject.getCompartments();
        if (comps != null) {
            Iterator it = comps.values().iterator();
            while (it.hasNext()) {
                Map vMap;
                Compartment comp = (Compartment)it.next();
                if (this.m_defaultBuildVariants.keySet().contains(comp.getName()) || (vMap = comp.getBuildVariants()) == null) continue;
                Collection variants = vMap.values();
                if (variants.size() == 1) {
                    String variantName = (String)vMap.keySet().iterator().next();
                    this._setDefaultBuildVariant(comp.getName(), variantName);
                    continue;
                }
                LOCATION.infoT(thisMethod, "could not initialize default variant for " + comp.getName() + ". More than 1 variant is defined");
            }
        }
    }

    public boolean isLocalOnlyMode() {
        return this.m_operationMode == DevConfOperationMode.LOCAL_ONLY;
    }

    public void upgradeFromLocalOnlyModeToNormal(IConfiguration configuration, IClient clientdef, IConnectionContext connectionContext, String localArchiveRoot) throws RepositoryAccessException {
        String thisMethod = "upgradeFromLocalOnlyModeToNormal";
        this.assureMoveLocalOnlyModeToNormalAllowed(configuration, clientdef, localArchiveRoot);
        boolean success = true;
        if (this.m_operationMode == DevConfOperationMode.NORMAL) {
            return;
        }
        try {
            success = false;
            this.m_localArchiveRootFolder = localArchiveRoot;
            this.m_operationMode = DevConfOperationMode.NORMAL;
            this.m_repositoryLayout = new RepositoryLayout();
            this.m_devConfFileSystemLayout = new DevConfFileSystemLayout(this);
            try {
                if (this.m_dtrConfiguration != null) {
                    this.m_dtrConfiguration.setMasterLogin(connectionContext.getUserName(), connectionContext.getPassword(), connectionContext.getServerCertsKeystore(), connectionContext.getClientCertsKeystore());
                }
            }
            catch (KeyStoreException e) {
                throw new RepositoryAccessException(e.getMessage(), e);
            }
            try {
                this.createMountPointsForSCs();
            }
            catch (SyncException e) {
                throw new RepositoryAccessException(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
            this.m_connectionContext = connectionContext;
            success = true;
            Object var9_9 = null;
            if (!success && this.m_operationMode == DevConfOperationMode.NORMAL) {
                this.m_operationMode = DevConfOperationMode.LOCAL_ONLY;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!success && this.m_operationMode == DevConfOperationMode.NORMAL) {
                this.m_operationMode = DevConfOperationMode.LOCAL_ONLY;
            }
            throw throwable;
        }
    }

    public void assureMoveLocalOnlyModeToNormalAllowed(IConfiguration configuration, IClient clientdef, String localArchiveFolder) throws DevconfModeException {
        if (this.m_operationMode == DevConfOperationMode.NORMAL) {
            String message = "Cannot move to local only mode .Configuration is already used in normal operation mode.";
            throw new DevconfModeException(message);
        }
        this.assurePropertyUpdateAllowed(configuration, clientdef, localArchiveFolder);
    }

    public void updateProperties(IConnectionContext connectionConetxt, String localArchiveRootFolder) throws DevconfModeException, KeyStoreException, DevConfigException {
        this.assurePropertyUpdateAllowed(localArchiveRootFolder);
        this.setConnectionContext(connectionConetxt);
        this.m_localArchiveRootFolder = localArchiveRootFolder;
    }

    void setConnectionContext(IConnectionContext connectionContext) throws DevconfModeException, KeyStoreException, DevConfigException {
        if (this.m_connectionContext != null && this.m_operationMode != DevConfOperationMode.LOCAL_ONLY && connectionContext != null && !this.m_connectionContext.equals(connectionContext)) {
            this.m_connectionContext = connectionContext;
            if (this.isWithBuildServer()) {
                this._getBuildSpaceProxy().getBuildServer().setCredentials(connectionContext.getUserName(), connectionContext.getPassword(), connectionContext.getServerCertsKeystore(), connectionContext.getClientCertsKeystore());
            }
            if (this.m_dtrConfiguration != null) {
                this.m_dtrConfiguration.setMasterLogin(connectionContext.getUserName(), connectionContext.getPassword(), connectionContext.getServerCertsKeystore(), connectionContext.getClientCertsKeystore());
            }
        } else {
            this.m_connectionContext = connectionContext;
        }
    }

    public void assurePropertyUpdateAllowed(IConfiguration configuration, IClient clientdef, String localArchiveRootFolder) throws DevconfModeException {
        String thisMethod = "assurePropertyUpdateAllowed";
        this.assurePropertyUpdateAllowed(localArchiveRootFolder);
        String message = "Illegal attempt to update properties of existing configuration: ";
        if (this.m_dtrConfiguration != null && configuration != null && !configuration.equals(this.m_dtrConfiguration)) {
            String oldConf = this.m_dtrConfiguration.getConfigFolder().getAbsolutePath();
            String newConf = configuration.getConfigFolder().getAbsolutePath();
            message = message + "\n cannot switch to different DTR configuration. Old: " + oldConf + ", new: " + newConf;
            throw new DevconfModeException(message);
        }
        if (this.m_dtrClientDef != null && clientdef != null && !this.m_dtrClientDef.equals(clientdef)) {
            String oldCli = this.m_dtrClientDef.getName();
            String newCli = clientdef.getName();
            message = message + "\n cannot switch  to different DTR client. Old: " + oldCli + ", new: " + newCli;
            throw new DevconfModeException(message);
        }
    }

    public void assurePropertyUpdateAllowed(String localArchiveRootFolder) throws DevconfModeException {
        if (this.m_localArchiveRootFolder != null && !this.m_localArchiveRootFolder.equals(localArchiveRootFolder)) {
            String message = "Illegal attempt to update properties of existing configuration: cannot switch to different local archive root folder.";
            throw new DevconfModeException(message);
        }
    }

    public void goToLocalOnlyMode() {
        if (this.m_operationMode == DevConfOperationMode.LOCAL_ONLY) {
            LOCATION.infoT("upgradeFromLocalOnlyModeToNormal", "explicit switch to local mode while already in local mode");
        }
        this.m_operationMode = DevConfOperationMode.LOCAL_ONLY;
        this.m_repositoryLayout = null;
        this.m_buildSpaceProxy = null;
        this.m_dcProxyCache.clearRemoteActiveCache(true);
        this.m_dcProxyCache.clearRemoteInactiveCache(true);
    }

    public String getLocalArchiveRootFolder() {
        return this.m_localArchiveRootFolder;
    }

    public String[] getRepositoryServerURLs() {
        ArrayList<String> list = new ArrayList<String>();
        List compartments = this.getCompartmentObjects();
        Iterator it = compartments.iterator();
        while (it.hasNext()) {
            Repository repository;
            Compartment compartment = (Compartment)it.next();
            SourceState srcState = compartment.getSourceState();
            if (srcState == null || (repository = srcState.getRepository()) == null) continue;
            list.add(repository.getURL());
        }
        String[] arrayServerNames = new String[list.size()];
        it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            arrayServerNames[i] = (String)it.next();
            ++i;
        }
        return arrayServerNames;
    }

    public String[] getWorkspaceURLs() {
        ArrayList<String> list = new ArrayList<String>();
        List compartments = this.getCompartmentObjects();
        Iterator it = compartments.iterator();
        while (it.hasNext()) {
            String url;
            Repository repository;
            Compartment compartment = (Compartment)it.next();
            SourceState srcState = compartment.getSourceState();
            if (srcState == null || (repository = srcState.getRepository()) == null) continue;
            String repositoryURL = repository.getURL();
            String location = ConfigUtils.getLocation(srcState);
            if (location != null) {
                url = Util.concatenatePath((String)repositoryURL, (String)location, (char)'/');
                list.add(url);
            }
            if ((location = ConfigUtils.getInactiveLocation(srcState)) == null) continue;
            url = Util.concatenatePath((String)repositoryURL, (String)location, (char)'/');
            list.add(url);
        }
        String[] arrayWsURLs = new String[list.size()];
        it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            arrayWsURLs[i] = (String)it.next();
            ++i;
        }
        return arrayWsURLs;
    }

    public List getTopLevelDCsForLocalCompartment(Compartment compartment) throws DevConfigException {
        LocalSCNode localSCNode;
        String thisMethod = "getTopLevelDCsForLocalCompartment()";
        LOCATION.debugT(thisMethod, "getting top-level components for local compartment +\"" + compartment.getName() + "\"");
        if (!compartment.hasLocalArchivesOnly()) {
            String msg = "Illegal compartment argument: compartment is not local";
            throw new LocalOnlyException(msg);
        }
        if (this.localSCNodeMap == null) {
            this.localSCNodeMap = new HashMap();
            localSCNode = new LocalSCNode(this, compartment);
            this.localSCNodeMap.put(compartment, localSCNode);
        } else {
            localSCNode = (LocalSCNode)this.localSCNodeMap.get(compartment);
            if (localSCNode == null) {
                localSCNode = new LocalSCNode(this, compartment);
                this.localSCNodeMap.put(compartment, localSCNode);
            }
        }
        return localSCNode.getTopLevelDCNodeList(false);
    }

    public DCProxy _getDCProxyLocalOrActive(String compartmentID, String dcVendor, String dcName) throws DevConfigException {
        DCProxy proxy = this.isDCAvailableLocally(compartmentID, dcVendor, dcName) ? this._getDCProxyLocally(compartmentID, dcVendor, dcName) : this._getDCProxy(compartmentID, dcVendor, dcName, true);
        return proxy;
    }

    public DCProxy _getDCProxy(String compartmentID, String dcVendor, String dcName, boolean fromActiveWorkspace) throws DevConfigException {
        String thisMethod = "getDCProxy(String ,String ,String , boolean )";
        DCProxy proxy = this.m_dcProxyCache.getDCProxy(compartmentID, dcVendor, dcName, !fromActiveWorkspace);
        if (proxy == null) {
            LOCATION.debugT(thisMethod, "Trying to load DC proxy from remote server.");
            proxy = DCProxy.createDCProxy(this, compartmentID, dcVendor, dcName, fromActiveWorkspace);
        }
        return proxy;
    }

    public DCProxy _getDCProxyLocally(String compartmentName, String dcVendor, String dcName) throws DevConfigException {
        String thisMethod = "getDCProxy(String compartmentID,String dcVendor,String dcName, boolean fromActiveWorkspace)";
        DCProxy proxy = this.m_dcProxyCache.getDCProxyLocal(compartmentName, dcVendor, dcName);
        if (proxy == null) {
            LOCATION.debugT(thisMethod, "loading proxy for locally available DC");
            proxy = DCProxy.createDCProxyLocally(this, compartmentName, dcVendor, dcName);
            if (proxy == null) {
                String m = "could not find DC locally : " + compartmentName + ":" + dcVendor + "/" + dcName;
                throw new DCNotFoundException(m, new DevelopmentComponentRef(dcName, dcVendor, compartmentName), null);
            }
        }
        return proxy;
    }

    public void notifyDCdeleted(String compartment, String vendor, String name, boolean inactive) {
        Iterator listeners = this.m_devconfListeners.iterator();
        while (listeners.hasNext()) {
            IDevConfListener listener = (IDevConfListener)listeners.next();
            DevelopmentComponentNode node = new DevelopmentComponentNode(this, compartment, vendor, name, !inactive);
            String thisMethod = "notifyDCActivityStateChanged";
            LOCATION.debugT(thisMethod, "calling IDevConfListener");
            listener.onDCDeleted(node);
            LOCATION.debugT(thisMethod, "sucessfully called IDevConfListener");
        }
    }

    public void notifyDCCreated(DCProxy proxy) {
        Iterator listeners = this.m_devconfListeners.iterator();
        while (listeners.hasNext()) {
            IDevConfListener listener = (IDevConfListener)listeners.next();
            DevelopmentComponentNode node = proxy._toNode();
            String thisMethod = "notifyDCActivityStateChanged";
            LOCATION.debugT(thisMethod, "calling IDevConfListener");
            listener.onDCCreated(node);
            LOCATION.debugT(thisMethod, "sucessfully called IDevConfListener");
        }
    }

    public void sendDCMessage(DCProxy dc, String buildVariant, DCMessageType messageType, DCEventType eventType, String messageText, boolean active) {
        DevelopmentComponentNode node = new DevelopmentComponentNode(this, dc.getCompartment().getName(), dc.getVendor(), dc.getName(), active);
        this.sendDCMessage(node, buildVariant, messageType, eventType, messageText);
    }

    public void sendDCMessage(IDevelopmentComponentNode node, String buildVariant, DCMessageType messageType, DCEventType eventType, String messageText) {
        DCMessage message = new DCMessage(eventType, messageType, messageText, node, buildVariant);
        Iterator listeners = this.m_devconfListeners.iterator();
        while (listeners.hasNext()) {
            IDevConfListener listener = (IDevConfListener)listeners.next();
            String thisMethod = "notifyDCActivityStateChanged";
            LOCATION.debugT(thisMethod, "calling IDevConfListener");
            listener.dcMessage(message);
            LOCATION.debugT(thisMethod, "called IDevConfListener");
        }
    }

    public void notifyDCSyncModeChanged(String compartment, String vendor, String name, SyncMode oldMode, SyncMode newMode, boolean isActive) {
        DCNodeSyncMode newDCMode;
        DCNodeSyncMode oldDCMode = DCNodeSyncMode.fromSyncMode(oldMode);
        if (oldDCMode != (newDCMode = DCNodeSyncMode.fromSyncMode(newMode))) {
            this.notifyDCSyncModeChanged(compartment, vendor, name, oldDCMode, newDCMode, isActive);
        }
    }

    public void notifyDCSyncModeChanged(String compartment, String vendor, String name, DCNodeSyncMode oldMode, DCNodeSyncMode newMode, boolean isActive) {
        if (oldMode == newMode) {
            return;
        }
        DevelopmentComponentNode dcNode = new DevelopmentComponentNode(this, compartment, vendor, name, isActive);
        Iterator listeners = this.m_devconfListeners.iterator();
        while (listeners.hasNext()) {
            IDevConfListener listener = (IDevConfListener)listeners.next();
            String thisMethod = "notifyDCActivityStateChanged";
            LOCATION.debugT(thisMethod, "calling IDevConfListener");
            listener.onDCSyncModeChanged(dcNode, oldMode);
            LOCATION.debugT(thisMethod, "successfully called IDevConfListener");
        }
    }

    public void notifyDCChanged(String compartment, String vendor, String name, boolean isActive) {
        DevelopmentComponentNode dcNode = new DevelopmentComponentNode(this, compartment, vendor, name, isActive);
        Iterator listeners = this.m_devconfListeners.iterator();
        while (listeners.hasNext()) {
            long elapsed;
            Object var12_10;
            IDevConfListener listener = (IDevConfListener)listeners.next();
            long start = System.currentTimeMillis();
            try {
                String thisMethod = "notifyDCActivityStateChanged";
                LOCATION.debugT(thisMethod, "calling IDevConfListener");
                listener.onDCChanged(dcNode);
                LOCATION.debugT(thisMethod, "sucessfully called IDevConfListener");
                var12_10 = null;
            }
            catch (Throwable throwable) {
                var12_10 = null;
                elapsed = System.currentTimeMillis() - start;
                LogUtil.logElapsedTime((long)elapsed, (String)("IDevConfListener.onDCChanged called on " + listener));
                throw throwable;
            }
            elapsed = System.currentTimeMillis() - start;
            LogUtil.logElapsedTime((long)elapsed, (String)("IDevConfListener.onDCChanged called on " + listener));
            {
            }
        }
    }

    public void notifyDCSyncStateChanged(String compartment, String vendor, String name, SyncState oldState, SyncState newState, boolean isActive) {
        DCNodeSyncState newDCState;
        DCNodeSyncState oldDCState = DCNodeSyncState.fromSyncState(oldState);
        if (oldDCState != (newDCState = DCNodeSyncState.fromSyncState(newState))) {
            this.notifyDCSyncStateChanged(compartment, vendor, name, oldDCState, newDCState, isActive);
        }
    }

    public void notifyDCSyncStateChanged(String compartment, String vendor, String name, DCNodeSyncState oldState, DCNodeSyncState newState, boolean isActive) {
        if (oldState == newState) {
            return;
        }
        if (oldState == newState) {
            return;
        }
        DevelopmentComponentNode dcNode = new DevelopmentComponentNode(this, compartment, vendor, name, isActive);
        Iterator listeners = this.m_devconfListeners.iterator();
        while (listeners.hasNext()) {
            IDevConfListener listener = (IDevConfListener)listeners.next();
            String thisMethod = "notifyDCActivityStateChanged";
            LOCATION.debugT(thisMethod, "calling IDevConfListener");
            listener.onDCSyncStateChanged(dcNode, oldState);
            LOCATION.debugT(thisMethod, "successfully called IDevConfListener");
        }
    }

    public void notifyDCActivityStateChanged(String compartment, String vendor, String name, DCActivityState oldState, DCActivityState newState, boolean isActive) {
        if (oldState == newState) {
            return;
        }
        DevelopmentComponentNode dcNode = new DevelopmentComponentNode(this, compartment, vendor, name, isActive);
        Iterator listeners = this.m_devconfListeners.iterator();
        while (listeners.hasNext()) {
            IDevConfListener listener = (IDevConfListener)listeners.next();
            String thisMethod = "notifyDCActivityStateChanged";
            LOCATION.debugT(thisMethod, "calling IDevConfListener");
            listener.onDCActivityStateChanged(dcNode, oldState);
            LOCATION.debugT(thisMethod, "sucessfully called IDevConfListener");
        }
    }

    DCProxy _getDCProxyLocalOrActive(String dcVendor, String dcName) throws DevConfigException {
        String thisMethod = "getDCProxy(String compartmentID,String dcVendor,String dcName) ";
        LOCATION.debugT(thisMethod, " dcVendor: {0}, dcName: {1}", new Object[]{dcVendor, dcName});
        String compartmentID = null;
        try {
            DevelopmentComponentStateRef ref = this.findDCState(dcVendor, dcName, false);
            if (ref != null) {
                compartmentID = ref.getCompartment();
            }
        }
        catch (SyncException e) {
            String message = "could not determine compartment of DC " + dcVendor + "/" + dcName;
            throw new DevConfigException(message, (Throwable)((Object)e));
        }
        if (compartmentID == null) {
            String message = "could not determine compartment of DC " + dcVendor + "/" + dcName;
            throw new DevConfigException(message);
        }
        return this._getDCProxyLocalOrActive(compartmentID, dcVendor, dcName);
    }

    public String getUser() {
        return this.m_connectionContext == null ? null : this.m_connectionContext.getUserName();
    }

    public String getPassword() {
        return this.m_connectionContext == null ? null : this.m_connectionContext.getPassword();
    }

    public boolean isInOfflineMode() {
        return this.m_operationMode == DevConfOperationMode.LOCAL_ONLY;
    }

    void setLocalArchiveRootFolder(String localArchiveRootFolder) {
        this.m_localArchiveRootFolder = localArchiveRootFolder;
    }

    void assertOnlineMode() throws OfflineException {
        if (this.isInOfflineMode()) {
            throw new OfflineException();
        }
    }

    JarHandler getJarHandler() {
        if (this.m_jarHandler == null) {
            this.m_jarHandler = new JarHandler();
        }
        return this.m_jarHandler;
    }

    public int pingDTRServer(String serverURL, int maxRepeats, int millisToWaitForResponse, String user, String password, String dtrConfigFolder) {
        LOCATION.debugT("pingLocation", "Deprecated empty method  called");
        return 2;
    }

    public int pingDTRServer(String serverURL, int maxRepeats, int millisToWaitForResponse, IConnectionContext connectionContext, String dtrConfigFolder) {
        return this.pingDTRPath(serverURL, null, maxRepeats, millisToWaitForResponse, connectionContext, dtrConfigFolder);
    }

    private int pingDTRPath(String serverURL, String pingPath, int maxRepeats, int millisToWaitForResponse, IConnectionContext connectionContext, String dtrConfigFolder) {
        String thisMethod = "pingDTRPath";
        IConnectionTemplate connectionTemplate = null;
        ConfigUtils confutil = new ConfigUtils();
        try {
            IRepositoryServer server;
            IClient dtrclient = this.findClient(dtrConfigFolder);
            if (dtrclient != null && (server = dtrclient.getLogicalSystem().getRepositoryServer(serverURL)) != null) {
                connectionTemplate = confutil.getConnectionTemplate((IServer)server, connectionContext);
            }
        }
        catch (DevConfigException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            LOCATION.debugT(thisMethod, "could not find requested server " + serverURL + ". creating new connection template. (" + ((Throwable)((Object)e)).getMessage() + ")");
        }
        if (connectionTemplate == null) {
            return confutil.pingPath(serverURL, pingPath, maxRepeats, millisToWaitForResponse, connectionContext);
        }
        return confutil.pingPath(pingPath, connectionTemplate);
    }

    public void registerDevConfListener(IDevConfListener listener) {
        this.m_devconfListeners.add(listener);
    }

    public void unRegisterDevConfListener(IDevConfListener listener) {
        this.m_devconfListeners.remove(listener);
    }

    public int pingDTRServer(String serverURL, int maxRepeats, int millisToWaitForResponse, String user, String password) {
        return this.pingDTRServer(serverURL, maxRepeats, millisToWaitForResponse, new ConnectionContext(user, password, null, null), null);
    }

    public int pingDTRServer(String serverURL, int maxRepeats, int millisToWaitForResponse, IConnectionContext connectionContext) {
        return this.pingDTRPath(serverURL, null, maxRepeats, millisToWaitForResponse, connectionContext, null);
    }

    public int pingLocation(String compartment, int maxRepeats, int millisToWaitForResponse, String user, String password, boolean inactive) throws DevConfigException {
        LOCATION.infoT("pingLocation", "Deprecated empty method  called");
        return 2;
    }

    public int pingLocation(String compartment, int maxRepeats, int millisToWaitForResponse, String user, String password, boolean inactive, String dtrConfigFolder) throws DevConfigException {
        LOCATION.infoT("pingLocation", "Deprecated empty method  called");
        return 2;
    }

    public int pingBuildServer(int maxRepeats, int millisToWaitForResponse, IConnectionContext connectionContext) throws DevConfigException {
        return this.pingBuildServer(maxRepeats, millisToWaitForResponse, connectionContext, null);
    }

    public int pingBuildServer(int maxRepeats, int millisToWaitForResponse, String user, String password, String dtrConfFolder) throws DevConfigException {
        LOCATION.infoT("pingBuildServer(int,int,String,String,String)", "Deprecated empty method called");
        return 2;
    }

    public int pingBuildServer(int maxRepeats, int millisToWaitForResponse, String user, String password) throws DevConfigException {
        return this.pingBuildServer(maxRepeats, millisToWaitForResponse, new ConnectionContext(user, password, null, null), null);
    }

    public int pingBuildServer(int maxRepeats, int millisToWaitForResponse, IConnectionContext connectionContext, String dtrConfFolder) throws DevConfigException {
        String msg;
        String thisMethod = "pingBuildServer()";
        String buildServerURL = this.getBuildServer();
        if (buildServerURL == null) {
            String msg2 = "Cannot ping build server. No build server is defined in the development configuration";
            throw new NoBuildServerDefinedException(msg2);
        }
        int connectTimeout = millisToWaitForResponse;
        int readTimeout = millisToWaitForResponse;
        IClient dtrclient = null;
        com.sap.tc.cbs.client.IBuildServer buildServer = null;
        try {
            dtrclient = this.findClient(dtrConfFolder);
            IBuildServer vfsBuildServer = null;
            if (dtrclient != null) {
                vfsBuildServer = dtrclient.getLogicalSystem().getBuildServer(buildServerURL);
            }
            if (vfsBuildServer == null) {
                msg = "Cannot get build server connection parameters from DTR configuration. using default settings";
                LOCATION.debugT(thisMethod, msg);
                buildServer = this.m_configUtils.getBuildServerProxy(buildServerURL, connectionContext);
            } else {
                IConnectionTemplate tmpl = this.m_configUtils.getConnectionTemplate((IServer)vfsBuildServer);
                connectTimeout = tmpl.getSocketConnectTimeout();
                readTimeout = tmpl.getSocketReadTimeout();
                buildServer = this.m_configUtils.getBuildServerProxy(vfsBuildServer, connectionContext);
            }
        }
        catch (DevConfigException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            msg = "No client found, pinging CBS with default values ";
            LOCATION.debugT(thisMethod, msg);
            buildServer = this.m_configUtils.getBuildServerProxy(buildServerURL, connectionContext);
        }
        try {
            buildServer.ping(maxRepeats, connectTimeout, readTimeout);
            return 0;
        }
        catch (AuthorizationException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            return 1;
        }
        catch (CommunicationException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            return 2;
        }
    }

    public int pingBuildSpace(String user, String password) throws DevConfigException {
        return this.pingBuildSpace(new ConnectionContext(user, password, null, null), null);
    }

    public int pingBuildSpace(String user, String password, String dtrConfFolder) throws DevConfigException {
        LOCATION.infoT("pingBuildSpace", "Deprecated empty method  called");
        return 2;
    }

    public int pingBuildSpace(IConnectionContext connectionContext) throws DevConfigException {
        return this.pingBuildSpace(connectionContext, null);
    }

    public int pingBuildSpace(IConnectionContext connectionContext, String dtrConfFolder) throws DevConfigException {
        String msg;
        String thisMethod = "pingBuildSpace()";
        ConfigUtils confutil = new ConfigUtils();
        if (!this.isInOfflineMode()) {
            if (!this.isWithBuildServer()) {
                String msg2 = "Cannot ping build space. Development configuration is without build server.";
                throw new NoBuildServerDefinedException(msg2);
            }
            IBuildSpace bsproxy = this._getBuildSpaceProxy();
            return confutil.pingBuildSpace(bsproxy);
        }
        String buildServerURL = this.getBuildServer();
        if (buildServerURL == null) {
            String msg3 = "Cannot ping build space. No build server is defined in the development configuration";
            throw new NoBuildServerDefinedException(msg3);
        }
        IClient dtrclient = null;
        com.sap.tc.cbs.client.IBuildServer buildServer = null;
        try {
            dtrclient = this.findClient(dtrConfFolder);
            buildServer = this.m_configUtils.getBuildServerProxy(dtrclient, buildServerURL, connectionContext);
        }
        catch (DevConfigException e) {
            LOCATION.catching(thisMethod, (Throwable)((Object)e));
            msg = "No client found, pinging CBS with default values ";
            LOCATION.debugT(thisMethod, msg);
            buildServer = this.m_configUtils.getBuildServerProxy(buildServerURL, connectionContext);
        }
        try {
            IBuildSpace bs = buildServer.getBuildSpace(this.getName());
            return confutil.pingBuildSpace(bs);
        }
        catch (IllegalStateException e) {
            msg = "Internal Error when trying to connect to build server \"" + buildServerURL + "\": " + e.getMessage();
            throw new DevConfigException(msg, e);
        }
    }

    public SyncState getSyncState(String compartment, String vendor, String name, String buildVariant) {
        return this.m_componentSyncDB.getSyncState(compartment, vendor, name, buildVariant);
    }

    public SyncState getSyncState(String compartment, String vendor, String name) {
        return this.m_componentSyncDB.getSyncState(compartment, vendor, name);
    }

    public SyncState getSyncState(DevelopmentComponentRef ref) {
        return this.m_componentSyncDB.getSyncState(ref);
    }

    public DevelopmentComponentRef getComponentInWork() {
        return this.m_componentInWork;
    }

    public boolean isLocalConfiguration() {
        return this.m_devconfObject.isLocal();
    }

    public void refreshLocalDCsList() throws DevConfigException {
        if (!this.isLocalConfiguration()) {
            String message = "Internal error: Illegal attempt to refresh local DC list for non-local configuration \"" + this.getName() + "\"";
            throw new ConfigNotLocalException(message);
        }
        this.m_localDCScanner.refreshSyncDBForLocalDCs();
    }

    public boolean hasBuildServer() {
        return this.getBuildServer() != null;
    }

    public boolean hasCMS() {
        return this.getCMS() != null;
    }

    public boolean hasNameServer() {
        return this.getNameServer() != null;
    }

    public String getCMS() {
        return this.m_devconfObject.getCMS();
    }

    public String getNameServer() {
        return this.m_devconfObject.getNameServer();
    }

    public boolean isLoginRequired() {
        return this.m_loginRequired;
    }

    private IClient findClient(String dtrConfFolder) {
        String thisMethod = "getClient()";
        if (this.m_dtrClientDef != null) {
            return this.m_dtrClientDef;
        }
        IConfiguration dtrconf = ConfigUtils.getConfiguration(dtrConfFolder);
        if (dtrconf == null) {
            if (LOCATION.beLogged(100)) {
                String msg = dtrConfFolder == null ? "Cannot find dtr configuration in default folder" : "Cannot find dtr configuration in folder " + dtrConfFolder;
                LOCATION.debugT(thisMethod, msg + ". Returning null");
            }
            return null;
        }
        IClient dtrclient = ConfigUtils.findClient(dtrconf, this.m_configRootDir);
        if (dtrclient == null) {
            if (LOCATION.beLogged(100)) {
                String msg = dtrConfFolder == null ? "Cannot find dtr client definition  for root \"" + this.m_configRootDir + "\" in default DTR configuration folder" : "Cannot find dtr client definition  for root \"" + this.m_configRootDir + "\" in DTR configuration folder " + dtrConfFolder;
                LOCATION.debugT(thisMethod, msg + ". Returning null");
            }
            return null;
        }
        return dtrclient;
    }

    String getLocationRelativePathByURL(String url) {
        String path = null;
        String thisMethod = "getCompartmentByWorkspce";
        Map compartments = this.m_devconfObject.getCompartments();
        if (compartments == null) {
            String m = "cannot get relative path  for \"" + url + "\". No compartments defined in configuration";
            DebugTrace e = new DebugTrace(m);
            LOCATION.debugT(thisMethod, m + " ignoring and NOT throwing exception:\n" + Util.printStackTraceToString((Throwable)e));
            return null;
        }
        Iterator it = compartments.values().iterator();
        while (it.hasNext()) {
            String repURL;
            Repository rep;
            Compartment comp = (Compartment)it.next();
            SourceState s = comp.getSourceState();
            if (s == null || (rep = s.getRepository()) == null || (repURL = rep.getURL()) == null) continue;
            String locURL = ConfigUtils.getInactiveLocation(s);
            if (locURL != null && url.startsWith(locURL = Util.concatenatePath((String)repURL, (String)locURL, (char)'/'))) {
                path = url.substring(locURL.length());
                break;
            }
            locURL = ConfigUtils.getLocation(s);
            if (locURL == null || !url.startsWith(locURL = Util.concatenatePath((String)repURL, (String)locURL, (char)'/'))) continue;
            path = url.substring(locURL.length());
            break;
        }
        return path;
    }

    Compartment getCompartmentByWorkspace(IVfsWorkspace workspace) throws DevConfigException {
        String wsurl;
        String thisMethod = "getCompartmentByWorkspce";
        Compartment retVal = null;
        try {
            wsurl = ConfigUtils.assureTrailingSlash(workspace.getUrl());
        }
        catch (VfsException e) {
            String m = "cannot get URL for workspace. DTR client error: " + e.getMessage();
            throw new DevConfigException(m, e);
        }
        Map compartments = this.m_devconfObject.getCompartments();
        if (compartments == null) {
            String m = "cannot get compartmnet for workspace \"" + wsurl + "\". No compartmnets defined";
            DebugTrace e = new DebugTrace(m);
            LOCATION.debugT(thisMethod, m + " ignoring and NOT throwing:\n" + Util.printStackTraceToString((Throwable)e));
            return null;
        }
        Iterator it = compartments.values().iterator();
        while (it.hasNext()) {
            String repURL;
            Repository rep;
            Compartment comp = (Compartment)it.next();
            SourceState s = comp.getSourceState();
            if (s == null || (rep = s.getRepository()) == null || (repURL = rep.getURL()) == null) continue;
            String locURL = ConfigUtils.getInactiveLocation(s);
            if (locURL != null && (locURL = Util.concatenatePath((String)repURL, (String)locURL, (char)'/')).equals(wsurl)) {
                retVal = comp;
                break;
            }
            locURL = ConfigUtils.getLocation(s);
            if (locURL == null || !(locURL = Util.concatenatePath((String)repURL, (String)locURL, (char)'/')).equals(wsurl)) continue;
            retVal = comp;
            break;
        }
        return retVal;
    }

    public List listNodesWhereSomethingIsCheckedOut() throws VfsException, IOException, DevConfigException {
        List list = this.getDevelopmentComponentNodes();
        ArrayList<IDevelopmentComponentNode> resultList = new ArrayList<IDevelopmentComponentNode>();
        int i = 0;
        i = 0;
        while (i < list.size()) {
            IDCProxy dc;
            IDevelopmentComponentNode dnode = (IDevelopmentComponentNode)list.get(i);
            if (dnode.hasSourceState() && (dc = dnode.getDCProxy()).getDCSyncState() != DCNodeSyncState.INSTALLED && dc.isAnythingCheckedOut()) {
                resultList.add(dnode);
            }
            ++i;
        }
        return resultList;
    }

    void refreshArchiveSyncState(Compartment compartment, String buildVariant) throws SyncException {
        this.listOutdatedSynchedArchives(compartment, buildVariant);
    }

    List listOutdatedSynchedArchives(Compartment compartment, String buildVariant) throws SyncException {
        String thisMethod = "_refreshArchiveSyncState(Compartment)";
        if (this.isInOfflineMode()) {
            String m = "Cannot refresh sync state of archives. Operation is not allowed in offline mode";
            throw new SyncException(m, null, 22);
        }
        if (!this.isWithBuildServer()) {
            String m = "Cannot refresh sync state of archives. Configuration is without build server.";
            throw new SyncException(m, null, 16);
        }
        Iterator entryKeys = this.m_componentSyncDB.getEntriesKeySet().iterator();
        String compartmentName = compartment.getName();
        ArrayList<IDCRef> syncList = new ArrayList<IDCRef>();
        while (entryKeys.hasNext()) {
            IDCSyncEntry entry;
            String entryKey = (String)entryKeys.next();
            DevelopmentComponentRef ref = this.m_componentSyncDB.getDCFromKey(entryKey);
            if (!compartmentName.equals(ref.getCompartment()) || (entry = this.m_componentSyncDB.getEntry(ref)) == null || entry.getMode() != SyncMode.SYNCHED_AS_ARCHIVE) continue;
            syncList.add(this.getCBSFactory().createComponentRef(ref.getVendor(), ref.getName()));
        }
        return this.listOutdatedSynchedArchives(buildVariant, compartmentName, syncList);
    }

    void refreshSyncStateOfNodesSynchedAsArchives(String compartmentName, List nodes) throws SyncException, DevConfigException {
        if (nodes == null) {
            return;
        }
        ArrayList<IDCRef> toBeRefreshedDCs = new ArrayList<IDCRef>();
        Iterator nodeIterator = nodes.iterator();
        while (nodeIterator.hasNext()) {
            DevelopmentComponentNode node = (DevelopmentComponentNode)nodeIterator.next();
            if (!node.getCompartmentName().equals(compartmentName) || node.getNodeSyncMode() != DCNodeSyncMode.SYNCHED_AS_ARCHIVE) continue;
            toBeRefreshedDCs.add(this.getCBSFactory().createComponentRef(node.getVendor(), node.getName()));
        }
        if (!toBeRefreshedDCs.isEmpty()) {
            this.listOutdatedSynchedArchives(this.getDefaultBuildVariant(compartmentName), compartmentName, toBeRefreshedDCs);
        }
    }

    private List listOutdatedSynchedArchives(String buildVariant, String compartmentName, List dcrefList) throws SyncException {
        IDCVariantState[] variantStates;
        ArrayList<DevelopmentComponentNode> outdatedList = new ArrayList<DevelopmentComponentNode>();
        if (dcrefList.size() == 0) {
            return outdatedList;
        }
        IDCRef[] dcrefs = new IDCRef[dcrefList.size()];
        Iterator dcs = dcrefList.iterator();
        int i = 0;
        while (dcs.hasNext()) {
            dcrefs[i] = (IDCRef)dcs.next();
            ++i;
        }
        String m = "Cannot update synchronization state of archives. ";
        IBuildSpace bs = null;
        try {
            bs = this._getBuildSpaceProxy();
            variantStates = bs.listDCVariantStates(compartmentName, buildVariant, dcrefs);
        }
        catch (CBSServerException e) {
            LOCATION.catching("listOutdatedSynchedArchives", (Throwable)e);
            if (bs != null) {
                throw CBSHandler.asSyncException(e, m, bs.getName());
            }
            throw CBSHandler.asSyncException(e, m);
        }
        catch (DevConfigException e) {
            if (e.getCause() instanceof SyncException) {
                throw (SyncException)((Object)e.getCause());
            }
            throw new SyncException(m + ": " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e), 43);
        }
        catch (CommunicationException e) {
            throw CBSHandler.asSyncException(e, m);
        }
        if (variantStates != null) {
            int k = 0;
            while (k < variantStates.length) {
                IDCVariantState s = variantStates[k];
                IDCRef dcref = s.getDCRef();
                long buildnumber = s.getVariantBuildNumber();
                IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentName, dcref.getName(), dcref.getVendor());
                if (syncEntry != null && syncEntry.isSynchedAsArchives(buildVariant)) {
                    SyncState newState;
                    SyncState oldState = this.getSyncState(compartmentName, dcref.getVendor(), dcref.getName(), buildVariant);
                    if (syncEntry.isVariantUpToDate(buildVariant, buildnumber)) {
                        newState = SyncState.UPTODATE;
                    } else {
                        newState = SyncState.OUTDATED;
                        outdatedList.add(new DevelopmentComponentNode(this, compartmentName, dcref.getVendor(), dcref.getName(), true));
                    }
                    if (!oldState.equals(newState)) {
                        syncEntry.setState(buildVariant, newState);
                        this.notifyDCSyncStateChanged(compartmentName, dcref.getVendor(), dcref.getName(), oldState, newState, true);
                        this.notifyDCChanged(compartmentName, dcref.getVendor(), dcref.getName(), true);
                    }
                }
                ++k;
            }
            this.m_componentSyncDB.save();
        }
        return outdatedList;
    }

    private CBSFactory getCBSFactory() {
        if (this.m_cbsFactory == null) {
            this.m_cbsFactory = new CBSFactory();
        }
        return this.m_cbsFactory;
    }

    private boolean hasRepository() {
        if (this.isLocalConfiguration()) {
            return false;
        }
        Map compMap = this.m_devconfObject.getCompartments();
        if (compMap == null) {
            return false;
        }
        Iterator it = compMap.values().iterator();
        while (it.hasNext()) {
            SourceState s = ((Compartment)it.next()).getSourceState();
            if (s == null || s.isLocal()) continue;
            return true;
        }
        return false;
    }

    private boolean _isLoginRequired() {
        return this.hasRepository() || this.hasBuildServer() || this.hasCMS() || this.hasNameServer();
    }

    private ComponentType getInitialDCType() {
        return new ComponentType("initial", "initial");
    }

    public DcVfsListenerHandler getVFSListenerHandler() {
        return this.m_vfsListenerHandler;
    }

    public void refreshProxyCache(String compartmentName, String dcVendor, String dcName, boolean inactive) throws DevConfigException {
        String thisMethod = "refreshProxyCache";
        DCProxy proxy = this.m_dcProxyCache.getDCProxyLocal(compartmentName, dcVendor, dcName);
        if (proxy != null && proxy.isRepresentingActiveState() != inactive) {
            try {
                proxy.reloadDefinition();
                proxy.reloadPPDefinition(null);
            }
            catch (RepositoryAccessException e) {
                String m = "Could not reload component meta data from local files. " + ((Throwable)((Object)e)).getMessage();
                throw new DevConfigException(m, (Throwable)((Object)e));
            }
            catch (InvalidDefinitionException e) {
                String m = "Could not reload component meta data from local files. " + ((Throwable)((Object)e)).getMessage();
                throw new DevConfigException(m, (Throwable)((Object)e));
            }
        } else {
            proxy = this.m_dcProxyCache.getDCProxyFromRemoteCache(compartmentName, dcVendor, dcName, inactive);
            if (proxy == null) {
                return;
            }
        }
        if (inactive) {
            this.m_dcProxyCache.clearRemoteInactiveCache(true);
        } else {
            this.m_dcProxyCache.clearRemoteActiveCache(true);
        }
    }

    public DCProxyCache getDcProxyCache() {
        return this.m_dcProxyCache;
    }

    void adjustProxyCacheAfterDCStateChange(String compartment, String vendor, String name, boolean wasInactive) {
        DCProxy dcProxy = this.m_dcProxyCache.getDCProxy(compartment, vendor, name, wasInactive);
        if (dcProxy != null) {
            this.m_dcProxyCache.put(dcProxy);
        }
    }

    public void setComponentInWork(DevelopmentComponentRef ref) {
        if (this.m_componentInWork != null && ref != null) {
            String thisMethod = "setComponentInWork";
            String m = "Internal error: attempt to set DC as curent component in work to " + ref + " while DC " + this.m_componentInWork + " is still current.";
            IllegalStateException ex = new IllegalStateException(m);
            LOCATION.throwing(thisMethod, (Throwable)ex);
            throw ex;
        }
        this.m_componentInWork = ref;
    }

    public IDCProxy[] getBuildOrderOfDCsAvailableAsSource(boolean ignoreErrors) throws SyncException, DevConfigException {
        return this.getDependenciesManager().getBuildOrderOfDCsAvailableAsSource(ignoreErrors);
    }

    public IDCProxyResult getBuildOrderOfDCNodes(Collection nodes) throws DevConfigException {
        ArrayList exceptions = new ArrayList();
        List dclist = this.getDependenciesManager()._computeBuildOrderOfDCs(nodes, exceptions);
        HashSet dcProxSet = new HashSet();
        dcProxSet.addAll(dclist);
        return new DCProxyResult(dcProxSet, exceptions);
    }

    DCDependenciesManager getDependenciesManager() {
        return this.m_dependenciesManager;
    }

    public File getBuildLogFile(String compartment, String dcVendor, String dcName, String buildVariant) {
        FileSystemLayout fs = new FileSystemLayout(this, compartment, dcVendor, dcName);
        return new File(fs.getBuildLogFile(buildVariant));
    }

    public IDCProxy getDCProxyLocallyOrActive(String scVendor, String scName, String dcVendor, String dcName) throws DevConfigException {
        String thisMethod = "getDCProxyActiveOrLocally()";
        LOCATION.debugT(thisMethod, "scVendor: {0}, scName: {1}, dcVendor: {2}, dcName: {3}", new Object[]{scVendor, scName, dcVendor, dcName});
        String compartmentID = this.getCompartmentNameFromSCName(scVendor, scName);
        LOCATION.debugT(thisMethod, "found compartment: " + compartmentID);
        if (compartmentID != null) {
            return this._getDCProxyLocalOrActive(compartmentID, dcVendor, dcName);
        }
        String m = "could not get DC proxy. compartment not found. DC: " + compartmentID + ":" + dcVendor + "/" + dcName;
        throw new DevConfigException(m);
    }

    public IDCProxy getDCProxyLocallyOrActive(String compartmentID, String dcVendor, String dcName) throws DevConfigException {
        return this._getDCProxyLocalOrActive(compartmentID, dcVendor, dcName);
    }

    public IDCProxy getDCProxyLocally(String compartmentID, String dcVendor, String dcName) throws DevConfigException {
        return this._getDCProxyLocally(compartmentID, dcVendor, dcName);
    }

    public IDCProxy getDevelopmentComponentProxy(String compartmentID, String dcVendor, String dcName, boolean active) throws DevConfigException {
        return this._getDCProxy(compartmentID, dcVendor, dcName, active);
    }

    public IDCProxy getDevelopmentComponentProxy(String scVendor, String scName, String dcVendor, String dcName, boolean active) throws DevConfigException {
        String thisMethod = "getDevelopmentComponentProxy()";
        LOCATION.debugT(thisMethod, "scVendor: {0}, scName: {1}, dcVendor: {2}, dcName: {3}, active: {4}", new Object[]{scVendor, scName, dcVendor, dcName, active ? "true" : "false"});
        String compartmentID = this.getCompartmentNameFromSCName(scVendor, scName);
        LOCATION.debugT(thisMethod, "found compartment: " + compartmentID);
        if (compartmentID != null) {
            return this._getDCProxy(compartmentID, dcVendor, dcName, active);
        }
        String m = "could not get DC proxy. compartment not found. DC: " + compartmentID + ":" + dcVendor + "/" + dcName;
        throw new DevConfigException(m);
    }

    private void initializeCompartmentNodes() {
        this.m_compartmentNodes = new ArrayList();
        Map compartmentMap = this.m_devconfObject.getCompartments();
        if (compartmentMap != null) {
            Iterator iter = compartmentMap.values().iterator();
            while (iter.hasNext()) {
                Compartment compartment = (Compartment)iter.next();
                this.m_compartmentNodes.add(new CompartmentNode(this, compartment));
            }
        }
    }

    public String getCBSwebUiURL() throws DevConfigException {
        String url;
        String thisMethod = "getCBSwebUiURL";
        if (this.m_buildSpaceProxy != null) {
            url = this.m_buildSpaceProxy.getBuildServer().getWebUIUrl();
        } else {
            String cbsServerUrl = this.m_devconfObject.getBuildServer();
            if (cbsServerUrl == null) {
                String msg = "Cannot get CBS web ui URL. No CBS is defined for this configuration.";
                throw new DevConfigException(msg);
            }
            try {
                URL urlObject = new URL(cbsServerUrl);
                url = urlObject.getProtocol() + "://" + urlObject.getHost() + ":" + urlObject.getPort() + "/" + "webdynpro/dispatcher/sap.com/tc.CBS.WebUI/WebUI";
            }
            catch (MalformedURLException e) {
                String msg = " Malformed CBS URL in configuration: " + cbsServerUrl + " : " + e.getMessage();
                throw new DevConfigException(msg, e);
            }
        }
        return url;
    }

    public boolean isDCDirty(String compartmentName, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentName, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return syncEntry.isDirty();
    }

    public boolean isDCBroken(String compartmentName, String dcVendor, String dcName) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentName, dcName, dcVendor);
        if (syncEntry == null) {
            return false;
        }
        return syncEntry.isBroken();
    }

    public List getNodesForDirtyDCs() {
        return this.getDevelopmentComponentNodes(true);
    }

    private boolean isValidNameVendorPair(String dcVendor, String dcName) {
        String thisMethod = "isValidNameVendorPair";
        if (dcName == null || dcName.length() == 0) {
            LOCATION.debugT(thisMethod, "Illegal DC reference found. DC name is not specified.");
            return false;
        }
        if (dcVendor == null || dcVendor.length() == 0) {
            LOCATION.debugT(thisMethod, "Illegal DC reference found. DC vendor is not specified.");
            return false;
        }
        return true;
    }

    public void handleLocalDCDefFileChanged(DevelopmentComponentRef dcref, int changeType, String filePath) {
        String thisMethod = "handleLocalDCDefFileChanged";
        if (changeType == 0) {
            LOCATION.infoT(thisMethod, "Cannot handle removed DCs. Skip event that DC definition file was removed: {0}", new Object[]{filePath});
        } else if (changeType == 1) {
            LOCATION.debugT(thisMethod, "Received event that DC definition file for {0} was modified: {1}", new Object[]{dcref, filePath});
            try {
                DCProxy p = this._getDCProxyLocally(dcref.getCompartment(), dcref.getVendor(), dcref.getName());
                p._reloadDefinition(true);
                p.markUsingDCsDirty(true, true);
            }
            catch (DevConfigException e) {
                LOCATION.catching(thisMethod, (Throwable)((Object)e));
                LOCATION.errorT(thisMethod, "Could not reload definition of DC {0}: {1}. Ingnoring it.", new Object[]{dcref, ((Throwable)((Object)e)).getMessage()});
            }
            catch (RepositoryAccessException e) {
                LOCATION.catching(thisMethod, (Throwable)((Object)e));
                LOCATION.errorT(thisMethod, "Could not reload definition of DC {0}: {1}. Ingnoring it.", new Object[]{dcref, ((Throwable)((Object)e)).getMessage()});
            }
            catch (InvalidDefinitionException e) {
                LOCATION.catching(thisMethod, (Throwable)((Object)e));
                LOCATION.errorT(thisMethod, "Could not reload invalid definition of DC {0} from file {1}. Error: {2}. Ingnoring it.", new Object[]{dcref, filePath, ((Throwable)((Object)e)).getMessage()});
            }
        } else {
            LOCATION.infoT(thisMethod, "Received event that definition file '{1}' for DC '{0}' was changed with unknown change type {2}. Ignoring it.", new Object[]{dcref, filePath, Integer.toString(changeType)});
        }
    }

    public void handleLocalPPFileChanged(DevelopmentComponentRef dcref, String publicPartName, int changeType, String filePath) {
        String thisMethod = "handleLocalPPFileChanged";
        try {
            DCProxy p = this._getDCProxyLocally(dcref.getCompartment(), dcref.getVendor(), dcref.getName());
            if (changeType == 0) {
                Map ppMap = p.getComponent().getPublicParts();
                if (ppMap != null) {
                    ppMap.remove(publicPartName);
                }
                p.markUsingDCsDirty(true, false);
            } else if (changeType == 1) {
                p._reloadPPDefinition(publicPartName, true);
                p.markUsingDCsDirty(true, false);
            } else {
                LOCATION.infoT(thisMethod, "Received event that file '{1}' with public part '{3}' for DC '{0}' was changed with unknown change type {2}. Ignoring it.", new Object[]{dcref, filePath, Integer.toString(changeType), publicPartName});
            }
        }
        catch (DevConfigException e) {
            LOCATION.traceThrowableT(300, thisMethod, "Could not reload definition of public part {2} of dC {0}: {1}. Ingnoring it.", new Object[]{dcref, ((Throwable)((Object)e)).getMessage(), publicPartName}, (Throwable)((Object)e));
        }
        catch (RepositoryAccessException e) {
            LOCATION.traceThrowableT(300, thisMethod, "Could not reload definition of public part {2} of DC {0}: {1}. Ingnoring it.", new Object[]{dcref, ((Throwable)((Object)e)).getMessage(), publicPartName}, (Throwable)((Object)e));
        }
    }

    public Set markDCsClean(IDevelopmentComponentNode[] dcs, boolean doSave, boolean doNotify) throws DevConfigException {
        return this.setDCsDirtyFlags(dcs, false, doSave, doNotify);
    }

    public boolean markDCasClean(DCProxy dc, boolean doSave, boolean doNotify) throws DevConfigException {
        return !this.markDCsClean(new DevelopmentComponentNode[]{new DevelopmentComponentNode(dc)}, doSave, doNotify).isEmpty();
    }

    public boolean markDCasDirty(DCProxy dc, boolean doSave, boolean doNotify) throws DevConfigException {
        return this.markDCasDirty(new DevelopmentComponentNode(dc), doSave, doNotify);
    }

    public boolean markDCasDirty(IDevelopmentComponentNode dc, boolean doSave, boolean doNotify) throws DevConfigException {
        IDevelopmentComponentNode[] dcs = new IDevelopmentComponentNode[]{dc};
        return !this.markDCsDirty(dcs, doSave, doNotify).isEmpty();
    }

    public Set markDCsDirty(IDevelopmentComponentNode[] dcs, boolean doSave, boolean doNotify) throws DevConfigException {
        return this.setDCsDirtyFlags(dcs, true, doSave, doNotify);
    }

    public Set setDCsDirtyFlags(IDevelopmentComponentNode[] dcs, boolean dirty, boolean doSave, boolean doNotify) throws DevConfigException {
        String thisMethod = "markDCsDirty";
        HashSet<IDevelopmentComponentNode> resultSet = new HashSet<IDevelopmentComponentNode>();
        ComponentSyncDB syncDB = this.getComponentSyncDB();
        int i = 0;
        while (i < dcs.length) {
            IDevelopmentComponentNode node = dcs[i];
            IDCSyncEntry entry = syncDB.getEntry(node.getCompartmentName(), node.getName(), node.getVendor());
            if (entry != null && entry.isDirty() != dirty && (entry.isSynchedAsSource() || entry.isLocalOnlySource())) {
                entry.setDirty(dirty);
                LOCATION.debugT(thisMethod, "set dirty flag for DC {0} to {1}", new Object[]{node, new Boolean(dirty)});
                resultSet.add(node);
            }
            ++i;
        }
        if (doSave && !resultSet.isEmpty()) {
            syncDB.save();
        }
        if (doNotify && !resultSet.isEmpty()) {
            if (dirty) {
                this.notifyDCsDirty(resultSet);
            } else {
                this.notifyDCsClean(resultSet);
            }
        }
        return resultSet;
    }

    public void notifyDCsDirty(Set dcSet) {
        if (!dcSet.isEmpty()) {
            DevelopmentComponentNode[] dcrefs = new DevelopmentComponentNode[dcSet.size()];
            this.notifyDCsDirty(dcSet.toArray(dcrefs));
        }
    }

    public void notifyDCsClean(Set dcSet) {
        if (!dcSet.isEmpty()) {
            IDevelopmentComponentNode[] dcrefs = new IDevelopmentComponentNode[dcSet.size()];
            this.notifyDCsClean(dcSet.toArray(dcrefs));
        }
    }

    public void notifyDCClean(DCProxy dc) {
        this.notifyDCsBuildStatusChanged(new IDevelopmentComponentNode[]{dc._toNode()});
    }

    public void notifyDCClean(IDevelopmentComponentNode dc) {
        this.notifyDCsBuildStatusChanged(new IDevelopmentComponentNode[]{dc});
    }

    public void notifyDCsClean(IDevelopmentComponentNode[] dcs) {
        this.notifyDCsBuildStatusChanged(dcs);
    }

    public void notifyDCsDirty(IDevelopmentComponentNode[] dcs) {
        this.notifyDCsBuildStatusChanged(dcs);
    }

    public void notifyDCsBuildStatusChanged(Set dcSet) {
        if (!dcSet.isEmpty()) {
            IDevelopmentComponentNode[] dcrefs = new IDevelopmentComponentNode[dcSet.size()];
            this.notifyDCsBuildStatusChanged(dcSet.toArray(dcrefs));
        }
    }

    public void notifyDCsBuildStatusChanged(IDevelopmentComponentNode[] dcs) {
        Iterator listeners = this.m_devconfListeners.iterator();
        while (listeners.hasNext()) {
            IDevConfListener listener = (IDevConfListener)listeners.next();
            String thisMethod = "notifyDCActivityStateChanged";
            LOCATION.debugT(thisMethod, "calling IDevConfListener");
            listener.onDCsBuildStatusChanged(dcs);
            LOCATION.debugT(thisMethod, "sucessfully called IDevConfListener");
        }
    }

    public DevConfFileMonitor.Mode setFileMonitorMode(DevConfFileMonitor.Mode mode) {
        DevConfFileMonitor fileMonitor = this._getFileMonitor();
        return fileMonitor.setMode(mode);
    }

    private DevConfFileMonitor _getFileMonitor() {
        return (DevConfFileMonitor)DevelopmentConfigurationFactory.getInstance().getFileMonitor();
    }

    public void notifyDCDirty(DCProxy proxy) {
        this.notifyDCsDirty(new DevelopmentComponentNode[]{new DevelopmentComponentNode(proxy)});
    }

    public void notifyDCDirty(DevelopmentComponentNode node) {
        this.notifyDCsDirty(new DevelopmentComponentNode[]{node});
    }

    public void unsync(String compartment, String vendor, String name) throws SyncException {
        Compartment compartmentObj;
        try {
            compartmentObj = this.getCompartmentObject(compartment);
        }
        catch (DevconfInconsistencyException e) {
            throw new SyncException("Compartment " + compartment + " does not exist in configuration " + this.getName(), (Throwable)((Object)e), 25);
        }
        this.unsync(compartmentObj, vendor, name);
    }

    public void unsync(Compartment compartment, String vendor, String name) throws SyncException {
        this.unsync(compartment, vendor, name, true);
    }

    public void unsync(Compartment compartment, String vendor, String name, boolean removeMountpoint) throws SyncException {
        String compartmentName = compartment.getName();
        DCProxy proxy = this._getProxyExistingOrLightweight(compartmentName, vendor, name);
        proxy.unsync(removeMountpoint);
    }

    private DCProxy _getProxyExistingOrLightweight(String compartmentName, String vendor, String name) {
        DCProxy proxy = this.m_dcProxyCache.getDCProxyLocalOrActive(compartmentName, vendor, name);
        if (proxy == null && (proxy = this.m_dcProxyCache.getDCProxyFromRemoteCache(compartmentName, vendor, name, true)) == null) {
            proxy = DCProxy.createLightweightDCProxy(this, compartmentName, vendor, name);
        }
        return proxy;
    }

    public DCNodeSyncMode getComponentSyncMode(IDevelopmentComponentRef dc) {
        return this.calculateSyncModeForDC(dc.getCompartment(), dc.getVendor(), dc.getName());
    }

    public DCNodeSyncMode getComponentSyncMode(String compartment, String dcVendor, String dcName) {
        return this.calculateSyncModeForDC(compartment, dcVendor, dcName);
    }

    public void syncAsArchives(String compartment, String vendor, String name, String buildVariant, boolean forcedSync) throws SyncException {
        DCProxy dc = this._getProxyExistingOrLightweight(compartment, vendor, name);
        dc.syncAsArchives(buildVariant, forcedSync);
    }

    public void syncAsSources(String compartment, String vendor, String name, boolean inactive, boolean forcedSync) throws SyncException {
        DCProxy dc = this._getProxyExistingOrLightweight(compartment, vendor, name);
        dc.syncAsSources(inactive, forcedSync);
    }

    public DCNodeSyncState calculateSyncStateForDC(String compartmentName, String dcVendor, String dcName, String buildVariant) {
        IDCSyncEntry syncEntry = this.m_componentSyncDB.getEntry(compartmentName, dcName, dcVendor);
        if (syncEntry == null) {
            return DCNodeSyncState.UNKNOWN;
        }
        SyncState s = syncEntry.getState(buildVariant);
        return DCNodeSyncState.fromSyncState(s);
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public void markDeleted() {
        this.m_deleted = true;
    }

    public DCDependencyChecker getDependencyChecker() {
        return this.m_dependencyChecker;
    }

    public IDCNodeResult listRecursivelyUsedNodes(IDevelopmentComponentNode[] usingNodes, DCUsageFilter filter, boolean searchRemoteInactive) {
        return this.m_dependenciesManager.listRecursivelyUsedDCNodes(usingNodes, filter, searchRemoteInactive);
    }

    public IDCUnsyncResult unsync(IDevelopmentComponentNode[] dcs, IDCOperationHandler handler) {
        ArrayList<IMountPoint> mountPoints = new ArrayList<IMountPoint>();
        IDCOperationResult[] operationResults = new IDCOperationResult[dcs.length];
        DCUnsyncResult resultObject = new DCUnsyncResult(operationResults);
        boolean stopped = false;
        int i = 0;
        while (i < dcs.length) {
            IDevelopmentComponentNode dc = dcs[i];
            DCOperationResult result = new DCOperationResult(dc, IDCOperationResult.Type.UNSNYC);
            operationResults[i] = result;
            if (!stopped) {
                try {
                    if (dc.isSynchedAsSource()) {
                        IMountPoint mp = this.getMountPointForDC(dc.getCompartmentName(), dc.getVendor(), dc.getName());
                        this.unsync(dc.getCompartment(), dc.getVendor(), dc.getName(), false);
                        mountPoints.add(mp);
                        result.setStatus(IDCOperationResult.Status.OK);
                    } else if (dc.isSynchedAsArchives()) {
                        this.unsync(dc.getCompartment(), dc.getVendor(), dc.getName(), false);
                        result.setStatus(IDCOperationResult.Status.OK);
                    } else {
                        result.setStatus(IDCOperationResult.Status.SKIPPED);
                    }
                    result.setException(null);
                }
                catch (SyncException e) {
                    result.setStatus(IDCOperationResult.Status.EXCEPTION);
                    result.setException((Exception)((Object)e));
                }
                stopped = handler.onOperationFinished(result);
            }
            ++i;
        }
        if (mountPoints.isEmpty()) {
            resultObject.setRemoveMountpointException(null);
            resultObject.setRemoveMountpointsSuccessful(true);
        } else {
            IMountPoint[] mparray = new IMountPoint[mountPoints.size()];
            Iterator mpIter = ((AbstractList)mountPoints).iterator();
            int i2 = 0;
            while (mpIter.hasNext()) {
                IMountPoint mp;
                mparray[i2] = mp = (IMountPoint)mpIter.next();
                ++i2;
            }
            try {
                this.removeMountPoints(mparray);
                resultObject.setRemoveMountpointException(null);
                resultObject.setRemoveMountpointsSuccessful(true);
            }
            catch (SyncException e) {
                resultObject.setRemoveMountpointException(e);
                resultObject.setRemoveMountpointsSuccessful(false);
            }
        }
        return resultObject;
    }

    public SourceUnpacker getSourceUnpacker() {
        if (this.m_sourceUnpacker == null) {
            this.m_sourceUnpacker = new SourceUnpacker();
        }
        return this.m_sourceUnpacker;
    }

    public boolean setDCBrokenFlag(boolean broken, DCProxy proxy, boolean doSave) {
        String thisMethod = "markDCasBroken";
        boolean changed = false;
        ComponentSyncDB syncDB = this.getComponentSyncDB();
        IDCSyncEntry entry = syncDB.getEntry(proxy.getCompartmentName(), proxy.getName(), proxy.getVendor());
        if (entry != null && entry.isBroken() != broken && (entry.isSynchedAsSource() || entry.isLocalOnlySource())) {
            entry.setBroken(broken);
            LOCATION.debugT(thisMethod, "set broken flag for DC {0} to {1}", new Object[]{proxy, new Boolean(broken)});
            changed = true;
        }
        if (doSave && changed) {
            this.m_componentSyncDB.save();
        }
        return changed;
    }

    public IConnectionContext getConnectionContext() {
        return this.m_connectionContext;
    }

    public List orderLocalDCsByDependencies(Collection dcnodes, boolean ignoreErrors, Collection exceptions, DCUsageFilter usageFilter) throws DevConfigException {
        return this.m_dependenciesManager.orderLocalDCsByDependencies(dcnodes, ignoreErrors, exceptions, usageFilter);
    }

    public File getVariantSourceFolder(String compartment, String dcVendor, String dcName, String buildVariant) {
        FileSystemLayout fs = new FileSystemLayout(this, compartment, dcVendor, dcName);
        return new File(fs.getVariantSourceFolder(buildVariant));
    }

    public File getBuildLogFolder(String compartment, String dcVendor, String dcName, String buildVariant) {
        FileSystemLayout fs = new FileSystemLayout(this, compartment, dcVendor, dcName);
        return new File(fs.getBuildLogFolder(buildVariant));
    }

    public Set getDCVariantContexts(String compartmentName, String buildVariant, DCName[] dcnames) throws DevConfigException, SyncException {
        if (this.isInOfflineMode()) {
            String m = "Illegal attempt to get componnet state from CBS in offline mode.";
            throw new SyncException(m, null, 22);
        }
        if (this.getBuildServer() == null) {
            String message = "Cannot get DC variant states from CBS. No build server specified in configuration " + this.getDevConfObject().getName();
            throw new SyncException(message, null, 9);
        }
        if (this.isLocalConfiguration()) {
            String m = "Synching as archives is not allowed. Configuration is local only.";
            throw new SyncException(m, null, 32);
        }
        HashSet<DCVariantContext> result = new HashSet<DCVariantContext>();
        IDCRef[] refs = new IDCRef[dcnames.length];
        int i = 0;
        while (i < dcnames.length) {
            DCName nameVendor = dcnames[i];
            refs[i] = new DCRef(nameVendor.getVendor(), nameVendor.getName());
            ++i;
        }
        IDCVariantState[] vntStates = null;
        try {
            vntStates = this.getBuildSpace().listDCVariantStates(compartmentName, buildVariant, refs);
        }
        catch (CommunicationException e) {
            throw CBSHandler.asSyncException(e, "Failed to get DC states from CBS.");
        }
        catch (CBSServerException e) {
            throw CBSHandler.asSyncException(e, "Failed to get DC states from CBS.");
        }
        if (dcnames.length == vntStates.length) {
            int i2 = 0;
            while (i2 < vntStates.length) {
                IDCVariantState state = vntStates[i2];
                DCVariantContext context = new DCVariantContext(compartmentName, state);
                result.add(context);
                ++i2;
            }
        } else {
            HashSet<DCName> requestedDcs = new HashSet<DCName>();
            int i3 = 0;
            while (i3 < dcnames.length) {
                requestedDcs.add(dcnames[i3]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < vntStates.length) {
                IDCVariantState state = vntStates[i4];
                DCVariantContext context = new DCVariantContext(compartmentName, state);
                result.add(context);
                requestedDcs.remove(new DCName(state.getDCRef().getName(), state.getDCRef().getVendor()));
                ++i4;
            }
            Iterator dciter = requestedDcs.iterator();
            while (dciter.hasNext()) {
                DCName dc = (DCName)dciter.next();
                DCVariantContext context = new DCVariantContext(new DevelopmentComponentRef(dc.getName(), dc.getVendor(), compartmentName));
                result.add(context);
            }
        }
        return result;
    }

    public void syncAsArchives(IDCVariantContext dcVariantContext, boolean forcedSync) throws SyncException, DevConfigException {
        DCVariantContext ctx = (DCVariantContext)dcVariantContext;
        if (!ctx.exists()) {
            throw new DCNotFoundException("Attempt to sync a DC as archives with an invalid IDCVariantContext (not existing on CBS).", ctx.getDcref(), null);
        }
        DCProxy proxy = this._getProxyExistingOrLightweight(ctx.getCompartment(), ctx.getDCVendor(), ctx.getDCName());
        proxy.syncAsArchives(ctx.getVariantState(), forcedSync);
    }

    public Set listUsedDCs(Set startDCs, IUsedDCFoundHandler foundDCHandler) throws DevConfigException {
        DCDependenciesManager depMgr = this.getDependenciesManager();
        return depMgr.listUsedNodes(startDCs, foundDCHandler);
    }

    public void _reloadDefinition() throws IOException, XMLException, ProviderException, ValidationException {
        com.sap.tc.complib.DevelopmentConfiguration devconfObject;
        FileConfigInputProvider inProvider = new FileConfigInputProvider(this.getConfigurationRootFolder(), ".confdef");
        this.m_devconfObject = devconfObject = ConfigurationFactory.initializeDevelopmentConfiguration((ConfigurationInputProvider)inProvider);
    }

    public static class DevConfOperationMode {
        private String m_mode;
        public static final DevConfOperationMode LOCAL_ONLY = new DevConfOperationMode("LOCAL_ONLY");
        public static final DevConfOperationMode NORMAL = new DevConfOperationMode("NORMAL");

        private DevConfOperationMode() {
        }

        DevConfOperationMode(String mode) {
            this.m_mode = mode;
        }

        public String toString() {
            return this.m_mode;
        }
    }
}

