/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.devconf.impl;

import com.sap.tc.devconf.IDCProxy;
import com.sap.tc.devconf.IDevelopmentComponentStateRef;
import com.sap.tc.devconf.impl.DevelopmentComponentRef;

public class DevelopmentComponentStateRef
extends DevelopmentComponentRef
implements IDevelopmentComponentStateRef {
    private boolean m_active;
    private static final String ACTIVE = "active";
    private static final String INACTIVE = "inactive";

    public DevelopmentComponentStateRef(String name, String vendor, String compartment, boolean active) {
        super(name, vendor, compartment);
        this.m_active = active;
    }

    public DevelopmentComponentStateRef(IDCProxy proxy) {
        super(proxy);
        this.m_active = proxy.isRepresentingActiveState();
    }

    public boolean isActive() {
        return this.m_active;
    }

    public String toString() {
        String state = this.m_active ? ACTIVE : INACTIVE;
        int length = this.getVendor().length() + this.getName().length() + this.getCompartment().length() + state.length() + 4;
        StringBuffer b = new StringBuffer(length);
        b.append(this.getVendor()).append('/').append(this.getName()).append('(').append(this.getCompartment()).append(',').append(state).append(')');
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DevelopmentComponentStateRef)) {
            return false;
        }
        return this._dataEqual((DevelopmentComponentStateRef)obj);
    }

    protected boolean _dataEqual(DevelopmentComponentStateRef ref) {
        return this.m_active == ref.m_active && super._dataEqual(ref);
    }

    public int hashCode() {
        int code = super.hashCode();
        code = 37 * code + (this.m_active ? 0 : 1);
        return code;
    }
}

